// Ten-Tec Graphic Interface Radio Control Program
// Pegasus Control GUI (c) 1999,2000 Ten-Tec Inc.
// The source code contained in this file and associated files is copyright Ten-Tec, Inc.

#include "Scale.h"
#include <float.h>
#include "cmainwin.h"
#include "bandobj.h"
extern CObList obBandList;
extern CFont m_TinyFont;

BEGIN_MESSAGE_MAP(CScale, CWnd)
	ON_WM_PAINT()
	ON_WM_CREATE()
	ON_WM_LBUTTONDBLCLK()
	ON_WM_MOUSEMOVE()
	ON_WM_LBUTTONDOWN()
END_MESSAGE_MAP()                

CScale::CScale()
{
}
        
CScale::Create(CRect sizepos, CWnd *PWnd,UINT nID,float scale=100)
{                   
m_fScaleRange=scale;
m_WindowSize=CRect(0,0,sizepos.right-sizepos.left,sizepos.bottom-sizepos.top);
m_cID=nID;
m_Zoom=1;
 return CWnd::Create(NULL,NULL,WS_CLIPSIBLINGS|WS_CHILD|WS_VISIBLE,sizepos,PWnd,nID,NULL);
} 


afx_msg int CScale::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	return 0;
}









afx_msg void CScale::OnPaint()
{
int count;

ldiv_t tenKHZmod;		// div_t stuctures for modulus calculations
ldiv_t fiftyKHZmod;	
ldiv_t hundredKHZmod;
ldiv_t oneMHZmod;
CBandObj* ePtr;			// pointer to band object
double startfreq,endfreq; // variables to hold band marker frequencies

CBitmap Meter;
CBrush brushFaceColor(RGB(0,0,0));
CBrush brushBodyColor(RGB(192,192,192));
CBrush brushBorderColor(RGB(0,0,0));


CPen penIndicatorColor(PS_SOLID,1,RGB(200,0,0));
CPen penMemoryIndicatorColor(PS_SOLID,1,RGB(255,0,0));
CPen penTickColor(PS_SOLID,1,RGB(0,192,0));
CPen penBandColor(PS_SOLID,1,RGB(92,92,0));

CPen penShadowColor(PS_SOLID,1,RGB(128,128,128));
CPen penMediumShadowColor(PS_SOLID,1,RGB(63,63,63));

CPen penMediumHighlightColor(PS_SOLID,1,RGB(192,192,192));
CPen penHighlightColor(PS_SOLID,1,RGB(255,255,255));


CPaintDC cDC(this);
CDC memDC;

memDC.CreateCompatibleDC(&cDC); 

CFont* pOldFont = memDC.SelectObject(&m_TinyFont);


CRect rcClip=m_WindowSize;

Meter.CreateDiscardableBitmap(&cDC,rcClip.right-rcClip.left,
								rcClip.bottom-rcClip.top);
memDC.SelectObject(&Meter);

CBrush* pOldBrush=memDC.SelectObject(&brushBodyColor);

memDC.SetBkMode(TRANSPARENT);
// get the area that needs to be erased
CPoint wSize=(rcClip.Width(),rcClip.Height());
CRect rcFront(rcClip.left+5,rcClip.top+5,rcClip.right-5,rcClip.bottom-(wSize.x/3));

memDC.FillRect(rcClip,&brushFaceColor);
// Shadow layer
memDC.SelectObject(&penShadowColor);
memDC.MoveTo(rcClip.left,rcClip.bottom-1);
memDC.LineTo(rcClip.left,rcClip.top);
memDC.LineTo(rcClip.right-1,rcClip.top);

memDC.SelectObject(&penMediumShadowColor);
memDC.MoveTo(rcClip.left+1,rcClip.bottom-2);
memDC.LineTo(rcClip.left+1,rcClip.top+1);
memDC.LineTo(rcClip.right-1,rcClip.top+1);

memDC.SelectObject(&penMediumHighlightColor);
memDC.MoveTo(rcClip.right-2,rcClip.top+1);
memDC.LineTo(rcClip.right-2,rcClip.bottom-2);
memDC.LineTo(rcClip.left+1,rcClip.bottom-2);

memDC.SelectObject(&penHighlightColor);
memDC.MoveTo(rcClip.right-1,rcClip.top);
memDC.LineTo(rcClip.right-1,rcClip.bottom-1);
memDC.LineTo(rcClip.left,rcClip.bottom-1);



memDC.SelectObject(&penTickColor);

CRect MeterArea(rcClip.left+2,(int) ((rcClip.bottom-rcClip.top)),rcClip.right-2,rcClip.bottom-4);


int half=MeterArea.bottom-(MeterArea.top/2);
int qtr=MeterArea.bottom-(MeterArea.top/4);
int eighth=MeterArea.bottom-(MeterArea.top/8);
int third=MeterArea.bottom-(MeterArea.top/3);


long sfreq=(long) (m_fCenterFrequency*(double)(1000.000*m_Zoom)+.5)-((int)MeterArea.right/2)+2;
long tfreq=sfreq;                                            
long ScaleStartFreq=sfreq;
long ScaleEndFreq=(long) sfreq+(int)MeterArea.right;
startfreq=0;
endfreq=0;
                                            

for(count=MeterArea.left;count<MeterArea.right;count++)
{
memDC.SelectObject(&penTickColor);
 
tenKHZmod=ldiv(sfreq,2);
fiftyKHZmod=ldiv(sfreq,50);
hundredKHZmod=ldiv(sfreq,10);
oneMHZmod=ldiv(sfreq,100);


if(!obBandList.IsEmpty())
{
	for(int i=0;i<(obBandList.GetCount());i++)
	{
	ePtr=(CBandObj*) obBandList.GetAt(obBandList.FindIndex(i));
		startfreq=((1000.00) * ePtr->StartFrequency);
		endfreq=((1000.00) * ePtr->EndFrequency);
	
		if(sfreq>startfreq && sfreq<endfreq)
		{
		memDC.SelectObject(&penBandColor);
		memDC.MoveTo(count,half);
		memDC.LineTo(count,eighth);
		}	
	}
}	




	memDC.SelectObject(&penTickColor);



if(tenKHZmod.rem==0)
	{
	memDC.MoveTo(count,eighth);
	memDC.LineTo(count,MeterArea.bottom);
    }

if(fiftyKHZmod.rem==0)
	{
 	memDC.MoveTo(count,third);
	memDC.LineTo(count,MeterArea.bottom);
    }

if(hundredKHZmod.rem==0)
	{
	memDC.MoveTo(count,qtr);
	memDC.LineTo(count,MeterArea.bottom);

    }

if(oneMHZmod.rem==0 && sfreq>0)
	{
  	memDC.MoveTo(count,half);
	memDC.LineTo(count,MeterArea.bottom);
	char csFreq[16];


	if(m_Zoom==1)sprintf(csFreq,"%2.1f",(float) sfreq/1000);
	if(m_Zoom==10)sprintf(csFreq,"%2.2f",(float) ((sfreq*m_Zoom)/1000)/(1000/m_Zoom));
	if(m_Zoom==100)sprintf(csFreq,"%2.3f",(float) ((sfreq*m_Zoom)/1000)/10000);


	CSize csSize;
	csSize=cDC.GetTextExtent(csFreq,strlen(csFreq));
	memDC.SetTextColor(RGB(190,190,190));
	
	memDC.DrawText(csFreq,strlen(csFreq),CRect(count-((int)csSize.cx/2),
												0,
												count+((int) csSize.cx/2),
                                                csSize.cy),
                                                DT_CENTER|DT_SINGLELINE|DT_TOP);

    }





sfreq++;
}                     





if(!obBandList.IsEmpty())
{
	for(int i=0;i<(obBandList.GetCount());i++)
	{
	ePtr=(CBandObj*) obBandList.GetAt(obBandList.FindIndex(i));
		startfreq=(1000.00 * ePtr->StartFrequency);
		endfreq=(1000.00 * ePtr->EndFrequency);
		csTempString=ePtr->BandName;

	if(startfreq>ScaleStartFreq || endfreq<ScaleEndFreq || ( ScaleStartFreq>startfreq && ScaleEndFreq<endfreq))
		{
		CSize LabelSize;
		LabelSize=cDC.GetTextExtent(csTempString,strlen(csTempString));
		memDC.SetTextColor(RGB(0,192,192));
	
		memDC.DrawText(csTempString,strlen(csTempString),CRect(MeterArea.left+(int)(startfreq-tfreq)-(LabelSize.cx/2),
												third-(LabelSize.cy/2),
												MeterArea.left+(int)(endfreq-tfreq)+( LabelSize.cx/2),
                                                third+LabelSize.cy/2),
                                                DT_CENTER|DT_SINGLELINE|DT_TOP);
		}		


	}

}


///////






memDC.SelectObject(&penIndicatorColor);
memDC.MoveTo(MeterArea.right/2,(int) MeterArea.bottom/2);
memDC.LineTo(MeterArea.right/2,MeterArea.bottom);



cDC.BitBlt(0,0,wSize.x,wSize.y,&memDC,0,0,SRCCOPY);



cDC.BitBlt(0,0,rcClip.right,rcClip.bottom,&memDC,0,0,SRCCOPY);
memDC.SelectObject(pOldFont);

return;



}


afx_msg void CScale::SetIndicator(double Value)
{
m_fCenterFrequency=Value;
Invalidate(FALSE);
return;
}


void CScale::SetScaleRange(float range)
{
m_fScaleRange=range;
Invalidate(FALSE);
}


void CScale::OnLButtonDblClk(UINT nFlags,CPoint point)
{
CRect rcClip=m_WindowSize;

CRect MeterArea(rcClip.left+2,(int) ((rcClip.bottom-rcClip.top)),rcClip.right-2,rcClip.bottom-4);
long sfreq=(long)(m_fCenterFrequency*(double)1000.00*m_Zoom)-((int)MeterArea.right/2);
double newfreq=(sfreq+point.x)/m_Zoom;
if(newfreq<0) newfreq=0.0;

m_PointFreq=newfreq;




GetOwner()->SendMessage(ID_POINTFREQ,(WPARAM) m_cID,(LPARAM) 0);

}

                    
                    
double CScale::GetPointFrequency()
{
return m_PointFreq;
}
                    
double CScale::GetIndicatorFrequency()
{
return m_fCenterFrequency;
}
                    
         
void CScale::OnLButtonDown(UINT nFlags,CPoint point)
{
m_pointX=point.x;	// save the x position for later moves
}

void CScale::OnMouseMove(UINT nFlags,CPoint point)
{
if(nFlags==MK_LBUTTON)
{
int diff=m_pointX-point.x;
double freq=m_fCenterFrequency*1000.00*m_Zoom;

m_fCenterFrequency=(double)((freq+diff)/(1000.0*m_Zoom));
m_pointX=point.x;

GetOwner()->PostMessage(ID_SLIDEFREQ,(WPARAM) m_cID,(LPARAM) 0);
}

else CWnd::OnMouseMove(nFlags,point);
}
         
         
void CScale::SetZoom(int zoom)
{
m_Zoom=zoom;
Invalidate(FALSE);
}
         