// Slider.cpp
// Sliding Encoder implementation

// Ten-Tec Graphic Interface Radio Control Program
// Pegasus Control GUI (c) 1999,2000 Ten-Tec Inc.
// The source code contained in this file and associated files is copyright Ten-Tec, Inc.


#include "Slider.h"
#include <math.h>
BEGIN_MESSAGE_MAP(CSlider,CWnd)
	ON_WM_PAINT()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_LBUTTONDBLCLK()
	ON_WM_MOUSEMOVE()
END_MESSAGE_MAP()



CSlider::CSlider()
{
m_KnobActive=TRUE;
m_Setting=0;
m_Min=0;
m_Max=10;
m_EnableSlider=TRUE;
}

CSlider::Create(CRect sizepos,CWnd *PWnd,UINT nID,int steps=8)
{

//Create Window and Save Parameters that will be needed later
m_ControlID=nID;
WindowSize=CRect(0,0,sizepos.right-sizepos.left,sizepos.bottom-sizepos.top);
ry=WindowSize.Height()-12;
CWnd::Create(NULL,NULL,WS_CHILD|WS_VISIBLE,sizepos,PWnd,nID,NULL);
// Create a Device Context and Bitmap for the knob core. This will be used later
// to create the full knob. This method helps to speed-up the knob drawing process

// Define the brushes & pens that will be used to draw the knob

brush1.CreateSolidBrush(RGB(128,128,128));
brush2.CreateSolidBrush(GetSysColor(COLOR_BTNSHADOW));
brush3.CreateSolidBrush(GetSysColor(COLOR_BTNSHADOW));

LinePen1.CreatePen(PS_SOLID,1,GetSysColor(COLOR_BTNSHADOW));
LinePen2.CreatePen(PS_SOLID,1,RGB(150,150,0));
LinePen3.CreatePen(PS_SOLID,1,GetSysColor(COLOR_BTNSHADOW));

LinePen4.CreatePen(PS_SOLID,1,RGB(130,130,130));
LinePen5.CreatePen(PS_SOLID,1,GetSysColor(COLOR_WINDOWFRAME));

LinePen6.CreatePen(PS_SOLID,1,GetSysColor(COLOR_BTNHIGHLIGHT));

return TRUE;

}


afx_msg void CSlider::OnPaint()
{

CPaintDC pDC(this);


CBitmap	bmKnob;
CDC memDC;
CRect rcClip;
rcClip=WindowSize;
CPen penShadowColor(PS_SOLID,1,RGB(128,128,128));
CPen penMediumShadowColor(PS_SOLID,1,RGB(63,63,63));

CPen penMediumHighlightColor(PS_SOLID,1,RGB(192,192,192));
CPen penHighlightColor(PS_SOLID,1,RGB(255,255,255));

memDC.CreateCompatibleDC(&pDC);
bmKnob.CreateDiscardableBitmap(&pDC,WindowSize.right-WindowSize.left,
                            WindowSize.bottom-WindowSize.top);

memDC.SelectObject(&bmKnob);

CBrush* pOldBrush=memDC.SelectObject(&brush2);
memDC.SelectStockObject(LTGRAY_BRUSH);
memDC.PatBlt(rcClip.left,rcClip.top,rcClip.Width(),rcClip.Height(),PATCOPY);


if(m_Point.y<(WindowSize.top+6)) m_Point.y=WindowSize.top+6;
if(m_Point.y>(WindowSize.bottom-6)) m_Point.y=WindowSize.bottom-6;

// Draw Window Border Highlights
CRect BoxRect;

BoxRect=WindowSize;
memDC.SelectStockObject(BLACK_PEN);
memDC.SelectObject(&penShadowColor);
memDC.MoveTo(BoxRect.left,BoxRect.bottom-1);
memDC.LineTo(BoxRect.left,BoxRect.top);
memDC.LineTo(BoxRect.right-1,BoxRect.top);

memDC.SelectObject(&penMediumShadowColor);
memDC.MoveTo(BoxRect.left+1,BoxRect.bottom-2);
memDC.LineTo(BoxRect.left+1,BoxRect.top+1);
memDC.LineTo(BoxRect.right-1,BoxRect.top+1);

memDC.SelectObject(&penMediumShadowColor);
memDC.MoveTo(BoxRect.right-2,BoxRect.top+1);
memDC.LineTo(BoxRect.right-2,BoxRect.bottom-2);
memDC.LineTo(BoxRect.left+1,BoxRect.bottom-2);

memDC.SelectObject(&penHighlightColor);
memDC.MoveTo(BoxRect.right-1,BoxRect.top);
memDC.LineTo(BoxRect.right-1,BoxRect.bottom-1);
memDC.LineTo(BoxRect.left,BoxRect.bottom-1);






memDC.SelectObject(&penMediumShadowColor);

for(int cnt=5;cnt<WindowSize.Height()-5;cnt+=(WindowSize.Height()/16))
{
memDC.MoveTo((rcClip.Width()/2)-2,cnt);
memDC.LineTo((rcClip.Width()/2)+2,cnt);
}



PointToSetting(m_Point);

CRect thumb(rcClip.left+2,m_Point.y-7,rcClip.right-3,m_Point.y+7);
memDC.FillRect(thumb,&brush1);


// Draw Thumb Control
memDC.SelectObject(&penMediumHighlightColor);
memDC.MoveTo(thumb.left,thumb.bottom-1);
memDC.LineTo(thumb.left,thumb.top);
memDC.LineTo(thumb.right-1,thumb.top);

memDC.SelectObject(&penShadowColor);
memDC.MoveTo(thumb.left+1,thumb.bottom-2);
memDC.LineTo(thumb.left+1,thumb.top+1);
memDC.LineTo(thumb.right-1,thumb.top+1);

memDC.SelectObject(&penMediumShadowColor);
memDC.MoveTo(thumb.right-2,thumb.top+1);
memDC.LineTo(thumb.right-2,thumb.bottom-2);
memDC.LineTo(thumb.left+1,thumb.bottom-2);

memDC.SelectObject(&penMediumShadowColor);
memDC.MoveTo(thumb.right-1,thumb.top);
memDC.LineTo(thumb.right-1,thumb.bottom-1);
memDC.LineTo(thumb.left,thumb.bottom-1);






memDC.SelectObject(pOldBrush);
pDC.BitBlt(0,0,WindowSize.right-WindowSize.left,
				WindowSize.bottom-WindowSize.top,&memDC,0,0,SRCCOPY);
memDC.DeleteDC();


}
	

afx_msg void CSlider::OnLButtonDown(UINT flags,CPoint point)
{ 

SetCapture();
m_Point=point;
Invalidate(FALSE);
PointToSetting(point);
if(m_Setting<6) m_Setting=0;
NotifyParentOfSetting();
}


int CSlider::PointToSetting(CPoint point)
{
double vy=((double)point.y-6)/(double)ry;

if(point.y<(WindowSize.top+6)) vy=0;
if(point.y>(WindowSize.bottom-6)) vy=1; 

m_Setting=(int)(m_Max-(vy*(range)));
if(m_Setting<0) m_Setting=0;
if(m_Min>m_Max)return ((int)(vy*(range)));	// if scale is small at top hi at bottom
else return m_Setting;
}


int CSlider::SettingToPoint(int setting)
{
double vy;
if(m_Min>m_Max) vy=6+((double) (setting/range))*ry;
else vy= 6+ry - ( (double) (setting/range)*ry);
return (int) vy;
}





afx_msg void CSlider::OnLButtonUp(UINT flags,CPoint point)
{
Invalidate(FALSE);
ReleaseCapture();
}


afx_msg void CSlider::OnMouseMove(UINT nFlags, CPoint point)
{
	CRect rect;
	GetClientRect(rect);
	if(!rect.PtInRect(point)) return;

if(nFlags && MK_LBUTTON)
{	
	m_Point=point;
	Invalidate(FALSE);
	PointToSetting(point);
	if(m_Setting<6) 
		{
		m_Setting=0;
		SettingToPoint(m_Setting);
		}		
	NotifyParentOfSetting();

}


}



afx_msg void CSlider::OnLButtonDblClk(UINT nFlags,CPoint point)
{
OnLButtonDown(nFlags,point);
}



void CSlider::SetEncoderState(BOOL state)
{
 m_KnobActive=state;
 return;
}

void CSlider::SetSliderLimits(int min,int max)
{
 
 m_Min=min;
 m_Max=max;
 range=(double)(m_Max-m_Min);
 Invalidate(FALSE);	
 return;
}

void CSlider::SetSliderPos(int val)
{
 m_Point=CPoint(m_Point.x,SettingToPoint(val));
 m_Setting=val;
 if(m_Setting<6) m_Setting=0;
 Invalidate(FALSE);	
 return;
}

int CSlider::GetSetting()
{
return m_Setting;
}

void CSlider::NotifyParentOfSetting()
{
GetOwner()->SendMessage(m_ControlID,(WPARAM) m_ControlID,(LPARAM) m_Setting);
}  

void CSlider::EnableSlider(BOOL bstate)
{
m_EnableSlider=bstate;
}
