// Encoder.H 
// Rotary Encoder header file
//

#ifndef _SLIDER_H_
#define _SLIDER_H_


#include <afxwin.h>
class CSlider:public CWnd
{
CPoint m_Point;
CBitmap bmKnob1;	// bitmap to store knob drawing into
CDC memDC1;
CBrush brush1,brush2,brush3;
CPen LinePen1,LinePen2,LinePen3,LinePen4,LinePen5,LinePen6;
BOOL m_KnobActive;
BOOL m_EnableSlider;
int m_Setting;
int m_Min,m_Max;
double ry;	//y range in bits
double range; // difference between min and max settings
UINT m_ControlID;
public:
	CSlider();
	afx_msg void OnPaint();
    BOOL Create(CRect sizepos,CWnd *PWnd,UINT nID,int steps);
	afx_msg void OnLButtonDown(UINT flags,CPoint where);
	afx_msg void OnLButtonUp(UINT flags,CPoint where);
	afx_msg void OnMouseMove(UINT nFlags,CPoint point);
	afx_msg void OnLButtonDblClk(UINT nFlags,CPoint point);
	void SetEncoderState(BOOL state);
	void CSlider::SetSliderLimits(int min,int max);
	void CSlider::SetSliderPos(int val);
	int CSlider::PointToSetting(CPoint point);
	int CSlider::SettingToPoint(int setting);
	void CSlider::NotifyParentOfSetting();
    int CSlider::GetSetting();
	void CSlider::EnableSlider(BOOL bstate);
protected:
	short m_MouseState;
	CRect WindowSize;

	DECLARE_MESSAGE_MAP()    

};

#endif	