// splashsc.cpp : implementation file

// Ten-Tec Graphic Interface Radio Control Program
// Pegasus Control GUI (c) 1999,2000 Ten-Tec Inc.
// The source code contained in this file and associated files is copyright Ten-Tec, Inc.


#include "stdafx.h"
#include "tttrx.h"
#include "splashsc.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSplashScreen

CSplashScreen::CSplashScreen()
{
}

CSplashScreen::~CSplashScreen()
{
}


BEGIN_MESSAGE_MAP(CSplashScreen, CWnd)
	//{{AFX_MSG_MAP(CSplashScreen)
	ON_WM_PAINT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CSplashScreen message handlers
BOOL CSplashScreen::Create()
{
BITMAP bm;
// load the bitmap
mSplashBitmap.LoadBitmap(IDB_SPLASH);
mSplashBitmap.GetObject(sizeof(BITMAP),&bm);

// center the splash window
int ScreenWidth=GetSystemMetrics(SM_CXSCREEN);
int ScreenHeight=GetSystemMetrics(SM_CYSCREEN);
int Top = (ScreenHeight-bm.bmHeight)/2;
int Left= (ScreenWidth-bm.bmWidth)/2;
// Create the window
return CWnd::CreateEx(WS_EX_TOPMOST,"AfxWnd","",WS_POPUP|WS_VISIBLE|WS_BORDER,Left,
	Top,bm.bmWidth,bm.bmHeight,NULL,NULL);
}

void CSplashScreen::OnPaint()
{
CPaintDC dc(this);
BITMAP bm;
CDC MemDC;

MemDC.CreateCompatibleDC(&dc);
CBitmap* pOldBitmap = MemDC.SelectObject(&mSplashBitmap);
mSplashBitmap.GetObject(sizeof(BITMAP),&bm);
dc.BitBlt(0,0,bm.bmWidth,bm.bmHeight,&MemDC,0,0,SRCCOPY);
MemDC.SelectObject(pOldBitmap);
}
	

