// statdlg.cpp : implementation file

// Ten-Tec Graphic Interface Radio Control Program
// Pegasus Control GUI (c) 1999,2000 Ten-Tec Inc.
// The source code contained in this file and associated files is copyright Ten-Tec, Inc.


#include "stdafx.h"
#include "tttrx.h"
#include "statdlg.h"
#include "station.h"
#include "EditStat.h"
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

#define VAR2CTRL FALSE
#define CTRL2VAR TRUE



/////////////////////////////////////////////////////////////////////////////
// CStationDialog dialog


CStationDialog::CStationDialog(CWnd* pParent) /*=NULL*/
	: CDialog(CStationDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(CStationDialog)
	m_MODE = "";
	m_NAME = "";
	m_FREQUENCY = 0;
	m_DataModified=FALSE;
	//}}AFX_DATA_INIT

//	m_obListPtr=NULL;
}

void CStationDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CStationDialog)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CStationDialog, CDialog)
	//{{AFX_MSG_MAP(CStationDialog)
	ON_UPDATE_COMMAND_UI(IDM_FILEOPEN,OnUpdateFileOpen)
	ON_UPDATE_COMMAND_UI(IDM_FILESAVE,OnUpdateFileSave)
	ON_UPDATE_COMMAND_UI(IDM_FILESAVEAS,OnUpdateFileSaveAs)
	ON_UPDATE_COMMAND_UI(IDM_FILECLOSE,OnUpdateFileClose)

	ON_LBN_SELCHANGE(IDC_STATIONLIST, OnSelchangeStationlist)
	ON_LBN_DBLCLK(IDC_STATIONLIST, OnDblclkStationlist)
	ON_EN_CHANGE(IDC_STATIONNAME, OnChangeStationname)
	ON_COMMAND(IDDELETE,DeleteStation)
	ON_COMMAND(IDEDIT,EditStationData)
	
	ON_WM_GETMINMAXINFO()
	ON_BN_CLICKED(IDC_FREQUENCYSORT, OnFrequencysort)
	ON_BN_CLICKED(IDC_STATIONSORT, OnStationsort)
	ON_BN_CLICKED(IDC_COUNTRYSORT, OnCountrysort)

	ON_COMMAND(IDM_FILEOPEN,OpenFile)
	ON_COMMAND(IDM_FILESAVEAS,SaveAsFile)
	ON_COMMAND(IDM_FILESAVE,SaveFile)
	ON_COMMAND(IDM_FILECLOSE,CloseFile)
	ON_COMMAND(IDNEW,AddStation)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CStationDialog message handlers

BOOL CStationDialog::OnInitDialog()
{
CDialog::OnInitDialog();

((CButton*)GetDlgItem(IDC_STATIONSORT))->SetCheck(1);  // forced to Station Sort on Opening
((CButton*)GetDlgItem(IDC_FREQUENCYSORT))->SetCheck(0);
((CButton*)GetDlgItem(IDC_AUTOTUNE))->SetCheck(0);

if (obPtr->GetCount()!=0) LoadListBox();


UpdateData(VAR2CTRL);
UpdateFileName();

return TRUE;
}





void CStationDialog::SetEntryAtIndex(int index)
{

CStation* ePtr=(CStation*) obPtr->GetAt(obPtr->FindIndex(index));
m_NAME=ePtr->Name;
m_FREQUENCY=ePtr->Frequency;
}


void CStationDialog::OnSelchangeStationlist()
{
int select=StationList().GetCurSel();
SetEntryAtIndex((int)(StationList().GetItemData(select))); // Get Oblist pointer from entry
UpdateData(VAR2CTRL);
if( ((CButton*)GetDlgItem(IDC_AUTOTUNE))->GetCheck() ) GetParent()->SendMessage(ID_MEMORYRECALL);
}

void CStationDialog::OnDblclkStationlist()
{

UpdateData(CTRL2VAR);
GetParent()->SendMessage(ID_MEMORYRECALL);
}

void CStationDialog::OnChangeStationname() 
{
	// TODO: Add your control notification handler code here
									
}

void CStationDialog::OnClose()
{
//	DestroyWindow();
	ShowWindow(SW_HIDE);
}
    
void CStationDialog::OnOK()
{
GetParent()->SendMessage(ID_MEMORYRECALL);
//CDialog::OnOK();
//  ShowWindow(SW_HIDE);
//	DestroyWindow();
}


BOOL CStationDialog::Create()
{
 return CDialog::Create(CStationDialog::IDD);    
}

void CStationDialog::PostNcDestroy()
{
// delete this;
}         

afx_msg void CStationDialog::OnGetMinMaxInfo(MINMAXINFO FAR* lpMMI)
{
}




void CStationDialog::NewStation()
{

UpdateData(VAR2CTRL);
}



void CStationDialog::LoadListBox()
{
if (obPtr->GetCount()==0) 
	{
	StationList().ResetContent();
	return;
	}

StationList().SetRedraw(FALSE);
StationList().ResetContent();

char LString[120];
int memcount=obPtr->GetCount();
int nIndex;
CButton* ssortPtr=(CButton*) GetDlgItem(IDC_STATIONSORT);
CButton* fsortPtr=(CButton*) GetDlgItem(IDC_FREQUENCYSORT);
CButton* csortPtr=(CButton*) GetDlgItem(IDC_COUNTRYSORT);


if(ssortPtr->GetCheck())
{
int tabs[3]={80,120,160};
StationList().SetTabStops(3,tabs);
}

if(fsortPtr->GetCheck())
{ 
int tabs[3]={40,120,160};
StationList().SetTabStops(3,tabs);
} 

if(csortPtr->GetCheck())
{ 
int tabs[3]={50,120,160};
StationList().SetTabStops(3,tabs);
} 



 
for(int i=0;i<memcount;i++)
{

CStation* ePtr=(CStation*) obPtr->GetAt(obPtr->FindIndex(i));

if(ssortPtr->GetCheck())
	sprintf(LString,"%-0.20s\t%.6f\t%s",(const char*)(ePtr->Name),ePtr->Frequency,ePtr->Country);
if(fsortPtr->GetCheck())
	sprintf(LString,"%09.6f\t%-0.20s\t%s",ePtr->Frequency,(const char*)(ePtr->Name),ePtr->Country);
if(csortPtr->GetCheck())
	sprintf(LString,"%-0.20s\t%-0.18s\t%.6f",(const char*)ePtr->Country,(const char*)(ePtr->Name),ePtr->Frequency);

nIndex=StationList().AddString(LString);
StationList().SetItemData(nIndex,(DWORD) i); // Save Index of item into object array along with item

}

StationList().SetCurSel(0);
SetEntryAtIndex(0);
StationList().SetRedraw(TRUE);
}




void CStationDialog::OnFrequencysort() 
{
((CButton*)GetDlgItem(IDC_STATIONSORT))->SetCheck(0);  
((CButton*)GetDlgItem(IDC_FREQUENCYSORT))->SetCheck(1);
((CButton*)GetDlgItem(IDC_COUNTRYSORT))->SetCheck(0);


LoadListBox();	
}

void CStationDialog::OnStationsort() 
{
((CButton*)GetDlgItem(IDC_STATIONSORT))->SetCheck(1);  
((CButton*)GetDlgItem(IDC_FREQUENCYSORT))->SetCheck(0);
((CButton*)GetDlgItem(IDC_COUNTRYSORT))->SetCheck(0);

LoadListBox();
}

void CStationDialog::OnCountrysort() 
{
((CButton*)GetDlgItem(IDC_STATIONSORT))->SetCheck(0);  
((CButton*)GetDlgItem(IDC_FREQUENCYSORT))->SetCheck(0);
((CButton*)GetDlgItem(IDC_COUNTRYSORT))->SetCheck(1);

LoadListBox();
}


void CStationDialog::OnAutoTune()
{
CButton* atPtr=(CButton*) GetDlgItem(IDC_AUTOTUNE);
if (atPtr->GetCheck())
	{
	 atPtr->SetCheck(0);
    }
else
	atPtr->SetCheck(1);
}



void CStationDialog::SaveAsFile()
{


CFileDialog FileDialog(FALSE,"rmf",NULL,OFN_OVERWRITEPROMPT,"Memory Files(*.rmf)|*.rmf|All files(*.*)|*.*||",this);

if(FileDialog.DoModal()==IDCANCEL) 
	{
	return;
    }
UpdateFileName();

TRY
{
CFile MemoryFile(FileDialog.GetPathName(),CFile::modeCreate|CFile::modeWrite);
CArchive MemArchive(&MemoryFile,CArchive::store);
//TRACE(">>>>> Radio Memory File Archive Prepared <<<<<");
MemArchive<< obPtr;
	MemArchive.Close();
	MemoryFile.Close();

}

CATCH(CFileException,e)
{
 if(e->m_cause == CFileException::accessDenied)
 	MessageBox("ERROR: Access to File Denied","CFileException",MB_OK);
}
END_CATCH

m_DataModified=FALSE;
}



void CStationDialog::OpenFile()
{
//TRACE("Reading Radio Memory File\n");

CFileDialog FileDialog(TRUE,"rmf",NULL,OFN_OVERWRITEPROMPT,"Memory Files(*.rmf)|*.rmf|All files(*.*)|*.*||",this);

if(FileDialog.DoModal()==IDCANCEL) 
	{
	return;
    }
UpdateFileName();

TRY
{
strFileName=FileDialog.GetPathName();
CFile MemoryFile(FileDialog.GetPathName(),CFile::modeRead);
CArchive MemArchive(&MemoryFile,CArchive::load);
//TRACE(">>>>> Radio Memory File Archive Load - Prepared <<<<<");
MemArchive >> obPtr;
	MemArchive.Close();
	MemoryFile.Close();
}

CATCH(CFileException,e)
{
 if(e->m_cause == CFileException::accessDenied)
 	MessageBox("ERROR: Access to File Denied","CFileException",MB_OK);
}
END_CATCH

#ifdef _DEBUG
afxDump.SetDepth(1);
afxDump<< &obPtr;
#endif

LoadListBox();
m_DataModified=FALSE;
}


void CStationDialog::DeleteStation()
{
int select=StationList().GetCurSel();	// Get Zero based index
POSITION obPos=obPtr->FindIndex( (int) StationList().GetItemData(select));
CStation* ePtr=(CStation*) obPtr->GetAt(obPos);
obPtr->RemoveAt(obPos);
delete ePtr;
m_DataModified=TRUE;
LoadListBox();
}


void CStationDialog::CloseFile()
{

POSITION pos=obPtr->GetHeadPosition();

while( pos != NULL)
{
	CStation *pObj = (CStation*) obPtr->GetNext(pos);
	delete pObj;
}

obPtr->RemoveAll();
strFileName="NONAME";
LoadListBox();
UpdateFileName();
m_DataModified=FALSE;
} 




void CStationDialog::SaveFile()
{
if(strFileName=="NONAME")
{
	CFileDialog FileDialog(FALSE,"rmf",NULL,OFN_OVERWRITEPROMPT,"Memory Files(*.rmf)|*.rmf|All files(*.*)|*.*||",this);

	if(FileDialog.DoModal()==IDCANCEL) 
	{
	return;
    }
strFileName=FileDialog.GetPathName();
}

CFile MemoryFile(strFileName,CFile::modeCreate|CFile::modeWrite);
CArchive MemArchive(&MemoryFile,CArchive::store);
MemArchive<< obPtr;
	MemArchive.Close();
	MemoryFile.Close();

//TRACE(">>>>> File Save  <<<<<");
m_DataModified=FALSE;
}

void CStationDialog::OnUpdateFileOpen(CCmdUI* pCmdUI)
{
 MessageBox("FILEOPEN UI","TEST",MB_OK);
}

void CStationDialog::OnUpdateFileSave(CCmdUI* pCmdUI)
{
 MessageBox("FILESAVE UI","TEST",MB_OK);
}
                                     
void CStationDialog::OnUpdateFileSaveAs(CCmdUI* pCmdUI)
{
 MessageBox("FILESAVEAS UI","TEST",MB_OK);
}

void CStationDialog::OnUpdateFileClose(CCmdUI* pCmdUI)
{
 MessageBox("FILECLOSE UI","TEST",MB_OK);
}


void CStationDialog::EditStationData()
{
 CEditStationDialog EditStation;
 int select=StationList().GetCurSel();	// Get Zero based index
 POSITION obPos=obPtr->FindIndex( (int) StationList().GetItemData(select));
 CStation* ePtr=(CStation*) obPtr->GetAt(obPos);
 EditStation.m_StationName=ePtr->Name;
 EditStation.m_StationFrequency=ePtr->Frequency;
// EditStation.m_StationBfo=ePtr->Bfo;
 EditStation.m_StationFilter=ePtr->Filter;
 EditStation.m_StationLanguage=ePtr->Language;
 EditStation.m_StationMode=ePtr->Mode;
 EditStation.m_StationCountry=ePtr->Country;
  
 if(EditStation.DoModal()==IDCANCEL) return;
 ePtr->Name=EditStation.m_StationName;
 ePtr->Frequency=EditStation.m_StationFrequency;
// ePtr->Bfo=EditStation.m_StationBfo;
 ePtr->Filter=EditStation.m_StationFilter;
 ePtr->Language=EditStation.m_StationLanguage;
 ePtr->Mode=EditStation.m_StationMode;
 ePtr->Country=EditStation.m_StationCountry;
  
 LoadListBox(); 
m_DataModified=TRUE;
}


void CStationDialog::AddStation()
{
 CEditStationDialog EditStation;

 if(EditStation.DoModal()==IDCANCEL) return;

CStation* station=new CStation;
//TRACE("CREATING CStation Object in CStationDialog\n");


 station->Name=EditStation.m_StationName;
 station->Frequency=EditStation.m_StationFrequency;
// station->Bfo=EditStation.m_StationBfo;
 station->Filter=EditStation.m_StationFilter;
 station->Language=EditStation.m_StationLanguage;
 station->Mode=EditStation.m_StationMode;
 station->Country=EditStation.m_StationCountry;

obPtr->AddTail(station);
LoadListBox(); 
m_DataModified=TRUE;
}

void CStationDialog::UpdateFileName()
{
if(strFileName=="NONAME" || !strFileName.IsEmpty())
{
 SetWindowText("Radio Memory");
}
else
{
CString tstring; 
tstring="Radio Memory "+strFileName;
 SetWindowText(tstring);
}
}