// statdlg.h : header file
//
#include "resource.h"
#include <afxwin.h>
#include <afx.h>
#define ID_MEMORYRECALL WM_USER+1
extern CObList obMemList;
extern CObList* obPtr;
extern CString strFileName;
extern BOOL m_DataModified;		// Modified File Flag

/////////////////////////////////////////////////////////////////////////////
// CStationDialog dialog

class CStationDialog : public CDialog
{
// Construction
public:
	CStationDialog(CWnd* pParent = NULL);	// standard constructor
	BOOL Create();
	afx_msg void OnGetMinMaxInfo(MINMAXINFO FAR* lpMMI);
// Dialog Data
	//{{AFX_DATA(CStationDialog)
	enum { IDD = IDD_STATIONDIALOG };
	CButton	m_OK;
	CButton	m_NEW;
	CButton	m_MAP;
	CButton	m_FIND;
	CButton	m_DELETE;
	CButton	m_CANCEL;
	//}}AFX_DATA



// Data Members
//CObList* m_obListPtr;
double m_FREQUENCY;
CString m_NAME;
CString m_MODE;
// Implementation

	// Inline Functions
	CListBox& StationList() 
		{return *(CListBox*) GetDlgItem(IDC_STATIONLIST);}

//	void SetObListPointer(CObList* obListPtr);
	void SetEntryAtIndex(int index);
	void CStationDialog::NewStation();
	void CStationDialog::LoadListBox();
	void CStationDialog::OpenFile();
	void CStationDialog::SaveAsFile();
	void CStationDialog::DeleteStation();
	void CStationDialog::CloseFile();
	void CStationDialog::SaveFile();
	void CStationDialog::EditStationData();
	void CStationDialog::AddStation();
	void CStationDialog::UpdateFileName();

protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
    virtual BOOL OnInitDialog();
	virtual void OnOK();
	virtual void OnClose();
	virtual void PostNcDestroy();
	// Generated message map functions
	//{{AFX_MSG(CStationDialog)
	afx_msg void OnSelchangeStationlist();
	afx_msg void OnDblclkStationlist();
	afx_msg void OnChangeStationname();
	afx_msg void OnFrequencysort();
	afx_msg void OnStationsort();
	afx_msg void OnCountrysort();
	afx_msg void OnAutoTune();

	afx_msg void OnUpdateFileOpen(CCmdUI* pCmdUI);
	afx_msg void OnUpdateFileSave(CCmdUI* pCmdUI);
	afx_msg void OnUpdateFileSaveAs(CCmdUI* pCmdUI);
	afx_msg void OnUpdateFileClose(CCmdUI* pCmdUI);

	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
