// stationw.cpp : implementation file

// Ten-Tec Graphic Interface Radio Control Program
// Pegasus Control GUI (c) 1999,2000 Ten-Tec Inc.
// The source code contained in this file and associated files is copyright Ten-Tec, Inc.


#include "stdafx.h"
#include "tttrx.h"
#include "stationw.h"
#include "station.h"
#include "EditStat.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CStationWnd

CStationWnd::CStationWnd()
{
	//{{AFX_DATA_INIT(CStationWnd)
	m_MODE = "";
	m_NAME = "";
	m_FREQUENCY = 0;
	m_DataModified=FALSE;
	m_Filter="";
	//}}AFX_DATA_INIT

}

CStationWnd::~CStationWnd()
{
}


BEGIN_MESSAGE_MAP(CStationWnd, CWnd)
	//{{AFX_MSG_MAP(CStationWnd)

	ON_LBN_SELCHANGE(IDC_STATIONLIST, OnSelchangeStationlist)
	ON_LBN_DBLCLK(IDC_STATIONLIST, OnDblclkStationlist)
	ON_EN_CHANGE(IDC_STATIONNAME, OnChangeStationname)
	ON_COMMAND(IDDELETE,DeleteStation)
	ON_COMMAND(IDEDIT,EditStationData)
	ON_COMMAND(IDCLOSE,OnCloseStationWnd)
	ON_COMMAND(IDC_AUTOTUNE,OnAutoTune)
	ON_COMMAND(IDTUNE,OnTuneButton)


	
	ON_BN_CLICKED(IDC_FREQUENCYSORT, OnFrequencysort)
	ON_BN_CLICKED(IDC_STATIONSORT, OnStationsort)
	ON_BN_CLICKED(IDC_COUNTRYSORT, OnCountrysort)

	ON_COMMAND(IDNEW,AddStation)

	ON_WM_CLOSE()
	ON_WM_CREATE()
	ON_WM_NCHITTEST()
	ON_WM_ERASEBKGND()
	ON_WM_CTLCOLOR()
	ON_WM_MOUSEACTIVATE()


	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CStationWnd message handlers


int CStationWnd::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	StationSortCheckBox.Create( "Station", WS_VISIBLE|BS_RADIOBUTTON|WS_CHILD, CRect(10,205,90,225), this, IDC_STATIONSORT);
	FrequencySortCheckBox.Create( "Frequency", WS_VISIBLE|BS_RADIOBUTTON|WS_CHILD, CRect(110,205,210,225), this, IDC_FREQUENCYSORT);
	CountrySortCheckBox.Create( "Country", WS_VISIBLE|BS_RADIOBUTTON|WS_CHILD, CRect(230,205,320,225), this, IDC_COUNTRYSORT);
	AutoTuneCheckBox.Create( "Auto Tune", WS_VISIBLE|BS_RADIOBUTTON|WS_CHILD, CRect(5,5,120,18), this, IDC_AUTOTUNE);
	StationListBox.Create( LBS_NOTIFY|WS_BORDER|WS_VISIBLE|LBS_SORT | LBS_USETABSTOPS | 
                    WS_VSCROLL | WS_TABSTOP|WS_CHILD, CRect(10,20,370,205), this, IDC_STATIONLIST );
	AddStationButton.Create("Add",WS_VISIBLE|BS_PUSHBUTTON | WS_CHILD,CRect(380,20,440,55),this,IDNEW);
	DeleteStationButton.Create("Delete",WS_VISIBLE|BS_PUSHBUTTON | WS_CHILD,CRect(380,65,440,100),this,IDDELETE);
//	FindStationButton.Create("Find",WS_VISIBLE|BS_PUSHBUTTON | WS_CHILD,CRect(380,110,440,145),this,IDFIND);
	TuneStationButton.Create("Tune",WS_VISIBLE|BS_PUSHBUTTON | WS_CHILD,CRect(380,110,440,145),this,IDTUNE);
	EditStationButton.Create("Edit",WS_VISIBLE|BS_PUSHBUTTON | WS_CHILD,CRect(380,155,440,190),this,IDEDIT);
	CloseWindowButton.Create("Close",WS_VISIBLE|BS_PUSHBUTTON |WS_CHILD,CRect(380,200,440,235),this,IDCLOSE);

((CButton*)GetDlgItem(IDC_STATIONSORT))->SetCheck(1);  // forced to Station Sort on Opening
((CButton*)GetDlgItem(IDC_FREQUENCYSORT))->SetCheck(0);
((CButton*)GetDlgItem(IDC_AUTOTUNE))->SetCheck(0);

if (obPtr->GetCount()!=0) LoadListBox();

UpdateFileName();
OnStationsort();	
	return 0;
}

UINT CStationWnd::OnNcHitTest(CPoint point) 
{
	UINT nHitTest = CWnd::OnNcHitTest(point);	
	if(nHitTest==HTCLIENT)
		{
		return(HTCAPTION);
		}
	return (nHitTest);
	
}

BOOL CStationWnd::OnEraseBkgnd(CDC* pDC)
{
	CBrush* pOldBrush=(CBrush*) pDC->SelectStockObject(LTGRAY_BRUSH);
	CPen* pOldPen=(CPen*) pDC->SelectStockObject(NULL_PEN);

	CBrush brushDarkGray(RGB(128,128,128));


	pDC->SetBkMode(OPAQUE);
	pDC->SetBkColor(RGB(192,192,192));

// get the area that needs to be erased
	CRect rcClip;									
	GetClientRect(rcClip);


// Fill client area witrh solid color first

	pDC->FillRect(rcClip,(CBrush*) pDC->SelectStockObject(GRAY_BRUSH));
	pDC->FillRect(rcClip,(CBrush*) pDC->SelectStockObject(GRAY_BRUSH));

// Unselect brush out of device context

pDC->SelectObject(pOldBrush);
pDC->SelectObject(pOldPen);

return TRUE;	
}

HBRUSH CStationWnd::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor)
{


	if(GetDlgItem(IDC_STATIONSORT) == pWnd 
				| GetDlgItem(IDC_FREQUENCYSORT)==pWnd
				| GetDlgItem(IDC_COUNTRYSORT)==pWnd
				| GetDlgItem(IDC_AUTOTUNE)==pWnd
					)




 	{
 		pDC->SetBkMode(TRANSPARENT);
 		pDC->SetTextColor(RGB(220,220,220));

		return (HBRUSH) GetStockObject(GRAY_BRUSH);
 	}


	return CWnd::OnCtlColor(pDC, pWnd, nCtlColor);
}

int CStationWnd::OnMouseActivate(CWnd* pDesktopWnd, UINT nHitTest, UINT message)
{
	BringWindowToTop();
	StationListBox.SetFocus();
	return TRUE;	

}


void CStationWnd::PostNcDestroy()
{
}         




void CStationWnd::LoadListBox()
{
if (obPtr->GetCount()==0) 
	{
	StationList().ResetContent();
	DeleteStationButton.EnableWindow(FALSE);
	FindStationButton.EnableWindow(FALSE);
	EditStationButton.EnableWindow(FALSE);
	TuneStationButton.EnableWindow(FALSE);
	return;
	}

	DeleteStationButton.EnableWindow(TRUE);
	FindStationButton.EnableWindow(TRUE);
	EditStationButton.EnableWindow(TRUE);
	TuneStationButton.EnableWindow(TRUE);


StationList().SetRedraw(FALSE);
StationList().ResetContent();

char LString[120];
int memcount=obPtr->GetCount();
int nIndex;
CButton* ssortPtr=(CButton*) GetDlgItem(IDC_STATIONSORT);
CButton* fsortPtr=(CButton*) GetDlgItem(IDC_FREQUENCYSORT);
CButton* csortPtr=(CButton*) GetDlgItem(IDC_COUNTRYSORT);


if(ssortPtr->GetCheck())
{
int tabs[3]={80,120,160};
StationList().SetTabStops(3,tabs);
}

if(fsortPtr->GetCheck())
{ 
int tabs[3]={40,120,160};
StationList().SetTabStops(3,tabs);
} 

if(csortPtr->GetCheck())
{ 
int tabs[3]={50,120,160};
StationList().SetTabStops(3,tabs);
} 

for(int i=0;i<memcount;i++)
{

CStation* ePtr=(CStation*) obPtr->GetAt(obPtr->FindIndex(i));

if(ssortPtr->GetCheck())
	sprintf(LString,"%-0.20s\t%.6f\t%s",(const char*)(ePtr->Name),ePtr->Frequency,ePtr->Country);
if(fsortPtr->GetCheck())
	sprintf(LString,"%09.6f\t%-0.20s\t%s",ePtr->Frequency,(const char*)(ePtr->Name),ePtr->Country);
if(csortPtr->GetCheck())
	sprintf(LString,"%-0.20s\t%-0.18s\t%.6f",(const char*)ePtr->Country,(const char*)(ePtr->Name),ePtr->Frequency);

nIndex=StationList().AddString(LString);
StationList().SetItemData(nIndex,(DWORD) i); // Save Index of item into object array along with item

}

StationList().SetCurSel(0);
SetEntryAtIndex(0);
StationList().SetRedraw(TRUE);
}



void CStationWnd::SetEntryAtIndex(int index)
{

CStation* ePtr=(CStation*) obPtr->GetAt(obPtr->FindIndex(index));
m_NAME=ePtr->Name;
m_FREQUENCY=ePtr->Frequency;
m_MODE=ePtr->Mode;
m_Filter=ePtr->Filter;
}
 
 void CStationWnd::NewStation()
{

}


void CStationWnd::DeleteStation()
{
int select=StationList().GetCurSel();	// Get Zero based index
POSITION obPos=obPtr->FindIndex( (int) StationList().GetItemData(select));
CStation* ePtr=(CStation*) obPtr->GetAt(obPos);
obPtr->RemoveAt(obPos);
delete ePtr;
m_DataModified=TRUE;
LoadListBox();
}

void CStationWnd::EditStationData()
{
 CEditStationDialog EditStation;
 int select=StationList().GetCurSel();	// Get Zero based index
 POSITION obPos=obPtr->FindIndex( (int) StationList().GetItemData(select));
 CStation* ePtr=(CStation*) obPtr->GetAt(obPos);
 EditStation.m_StationName=ePtr->Name;
 EditStation.m_StationFrequency=ePtr->Frequency;
 EditStation.m_StationFilter=ePtr->Filter;
 if(ePtr->Filter=="") ePtr->Filter="6000";

 EditStation.m_StationLanguage=ePtr->Language;
 EditStation.m_StationMode=ePtr->Mode;
 EditStation.m_StationCountry=ePtr->Country;
 EditStation.m_StationAddress=ePtr->Address;
 
  
 if(EditStation.DoModal()==IDCANCEL) return;
 ePtr->Name=EditStation.m_StationName;
 ePtr->Frequency=EditStation.m_StationFrequency;
// ePtr->Bfo=EditStation.m_StationBfo;
 ePtr->Filter=EditStation.m_StationFilter;
 ePtr->Language=EditStation.m_StationLanguage;
 ePtr->Mode=EditStation.m_StationMode;
 ePtr->Country=EditStation.m_StationCountry;
 ePtr->Address=EditStation.m_StationAddress;
  
 LoadListBox(); 
m_DataModified=TRUE;
}


void CStationWnd::AddStation()
{
 CEditStationDialog EditStation;

 if(EditStation.DoModal()==IDCANCEL) return;

CStation* station=new CStation;


 station->Name=EditStation.m_StationName;
 station->Frequency=EditStation.m_StationFrequency;
 station->Filter=EditStation.m_StationFilter;
 station->Language=EditStation.m_StationLanguage;
 station->Mode=EditStation.m_StationMode;
 station->Country=EditStation.m_StationCountry;
 station->Address=EditStation.m_StationAddress;


obPtr->AddTail(station);
LoadListBox(); 
m_DataModified=TRUE;
}

void CStationWnd::UpdateFileName()
{
if(strFileName=="NONAME" || !strFileName.IsEmpty())
{
 SetWindowText("Radio Memory");
}
else
{
CString tstring; 
tstring="Radio Memory "+strFileName;
 SetWindowText(tstring);
}
}


void CStationWnd::OnFrequencysort() 
{
((CButton*)GetDlgItem(IDC_STATIONSORT))->SetCheck(0);  
((CButton*)GetDlgItem(IDC_FREQUENCYSORT))->SetCheck(1);
((CButton*)GetDlgItem(IDC_COUNTRYSORT))->SetCheck(0);


LoadListBox();	
}

void CStationWnd::OnStationsort() 
{
((CButton*)GetDlgItem(IDC_STATIONSORT))->SetCheck(1);  
((CButton*)GetDlgItem(IDC_FREQUENCYSORT))->SetCheck(0);
((CButton*)GetDlgItem(IDC_COUNTRYSORT))->SetCheck(0);

LoadListBox();
}

void CStationWnd::OnCountrysort() 
{
((CButton*)GetDlgItem(IDC_STATIONSORT))->SetCheck(0);  
((CButton*)GetDlgItem(IDC_FREQUENCYSORT))->SetCheck(0);
((CButton*)GetDlgItem(IDC_COUNTRYSORT))->SetCheck(1);

LoadListBox();
}


void CStationWnd::OnAutoTune()
{
CButton* atPtr=(CButton*) GetDlgItem(IDC_AUTOTUNE);
if (atPtr->GetCheck())
	{
	 atPtr->SetCheck(0);
    }
else
	atPtr->SetCheck(1);
}


void CStationWnd::OnDblclkStationlist()
{

GetParentFrame()->SendMessage(ID_MEMORYRECALL);
}

void CStationWnd::OnChangeStationname() 
{
									
}

void CStationWnd::OnSelchangeStationlist()
{
int select=StationList().GetCurSel();
SetEntryAtIndex((int)(StationList().GetItemData(select))); // Get Oblist pointer from entry
if( ((CButton*)GetDlgItem(IDC_AUTOTUNE))->GetCheck() ) GetParentFrame()->SendMessage(ID_MEMORYRECALL);
}

void CStationWnd::OnCloseStationWnd()
{
 ShowWindow(SW_HIDE);
SetFocusToParent();
} 

void CStationWnd::SetFocusToParent()
{
	GetParent()->SetFocus();
    return;
}   


afx_msg void CStationWnd::OnSetFocus(CWnd* pOldWnd)
{


}


afx_msg void CStationWnd::OnTuneButton()
{
GetParentFrame()->SendMessage(ID_MEMORYRECALL);
}

afx_msg void CStationWnd::OnClose()
{
 ShowWindow(SW_HIDE);
}
 