// stationw.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// CStationWnd window
#define ID_MEMORYRECALL WM_USER+1
extern CObList obMemList;
extern CObList* obPtr;
extern CString strFileName;
extern BOOL m_DataModified;		// Modified File Flag

class CStationWnd : public CWnd
{
// Construction
public:
	CStationWnd();

// Attributes
public:
	CButton StationSortCheckBox;
	CButton FrequencySortCheckBox;
	CButton CountrySortCheckBox;
	CButton AutoTuneCheckBox;
	CListBox StationListBox;
	CButton AddStationButton;
	CButton DeleteStationButton;
	CButton FindStationButton;
	CButton CloseWindowButton;
	CButton EditStationButton;
	CButton TuneStationButton;

double m_FREQUENCY;
CString m_NAME;
CString m_MODE;
CString m_Filter;		
			
// Operations
public:

	// Inline Functions
	CListBox& StationList() 
		{return *(CListBox*) GetDlgItem(IDC_STATIONLIST);}
	afx_msg void OnClose();

	void SetEntryAtIndex(int index);
	void CStationWnd::NewStation();
	void CStationWnd::LoadListBox();
	void CStationWnd::DeleteStation();
	void CStationWnd::EditStationData();
	void CStationWnd::AddStation();
	void CStationWnd::UpdateFileName();
	void CStationWnd::OnCloseStationWnd();
	void CStationWnd::SetFocusToParent();



	// Generated message map functions
	//{{AFX_MSG(CStationWnd)
	afx_msg void OnSelchangeStationlist();
	afx_msg void OnDblclkStationlist();
	afx_msg void OnChangeStationname();
	afx_msg void OnFrequencysort();
	afx_msg void OnStationsort();
	afx_msg void OnCountrysort();
	afx_msg void OnAutoTune();

	afx_msg void OnUpdateFileOpen(CCmdUI* pCmdUI);
	afx_msg void OnUpdateFileSave(CCmdUI* pCmdUI);
	afx_msg void OnUpdateFileSaveAs(CCmdUI* pCmdUI);
	afx_msg void OnUpdateFileClose(CCmdUI* pCmdUI);
	afx_msg void OnSetFocus(CWnd* pOldWnd);
	afx_msg void OnTuneButton();



// Overrides
public:

// Implementation
public:
	virtual ~CStationWnd();
	virtual void PostNcDestroy();

	// Generated message map functions
protected:
	//{{AFX_MSG(CStationWnd)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg UINT OnNcHitTest(CPoint point);
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg HBRUSH OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor);
	afx_msg int OnMouseActivate(CWnd* pDesktopWnd, UINT nHitTest, UINT message);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
