// sweeppan.cpp : implementation file

// Ten-Tec Graphic Interface Radio Control Program
// Pegasus Control GUI (c) 1999,2000 Ten-Tec Inc.
// The source code contained in this file and associated files is copyright Ten-Tec, Inc.


#include "stdafx.h"
#include "tttrx.h"
#include "sweeppan.h"
#include "CMAINWIN.h"
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif
extern m_bSweepActive;
extern double m_SweepStartFreq;		// in Mhz
extern double m_SweepEndFreq;		// in Mhz
extern double m_SweepStepFreq;		// in hz			    
extern int m_SweepFilter;           // index number 1-5
extern double radio_freq;           // in MHz
extern filter FilterList_RX320[];

extern CFont m_SmallFont;
extern CFont m_MicroFont;

/////////////////////////////////////////////////////////////////////////////
// CSweepPanel

CSweepPanel::CSweepPanel()
{
}

CSweepPanel::~CSweepPanel()
{
}

BEGIN_MESSAGE_MAP(CSweepPanel, CWnd)
	//{{AFX_MSG_MAP(CSweepPanel)
	ON_WM_CREATE()
	ON_WM_ERASEBKGND()
	ON_WM_NCHITTEST()
	ON_WM_MOUSEACTIVATE()
	ON_WM_CTLCOLOR()
	ON_COMMAND(ID_SWEEPSTART,OnStartSweep)
	ON_COMMAND(ID_SWEEPSTOP,OnSweepStop)
	ON_EN_KILLFOCUS(IDC_SWEEPSTARTFREQ,OnChangeStartFreq)
	ON_CBN_SELCHANGE(ID_SWEEPSTYLECOMBO,OnSweepStyleChange)
	ON_CBN_SELCHANGE(ID_SWEEPFORMATCOMBO,OnSweepFormatChange)
	ON_CBN_SELCHANGE(ID_SWEEPFILTERCOMBO,OnSweepFilterChange)
	ON_CBN_SELCHANGE(ID_SWEEPWIDTHCOMBO,OnSweepWidthChange)
	ON_CBN_SELCHANGE(ID_SWEEPCENTERCOMBO,OnSweepCenterChange)
	ON_WM_CLOSE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSweepPanel message handlers


int CSweepPanel::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	
	CRect stbCRect(290,205,350,230);
 	StartButton.Create("Sweep",WS_CHILD|WS_VISIBLE|BS_PUSHBUTTON,stbCRect,this,ID_SWEEPSTART);
    StartButton.SetFont(&m_SmallFont);
    
	CRect stpbCRect(230,205,290,230);
 	StopButton.Create("Stop",WS_CHILD|WS_VISIBLE|BS_PUSHBUTTON,stpbCRect,this,ID_SWEEPSTOP);
	StopButton.SetFont(&m_SmallFont);


	CRect swpCRect(10,10,(lpCreateStruct->cx)-10,(lpCreateStruct->cy)-140);
	SweepWindow.Create(NULL,"SweepPanel",WS_VISIBLE|WS_CLIPSIBLINGS|WS_CHILD|WS_BORDER,swpCRect,this,ID_SWEEPWINDOW,NULL);
	SweepWindow.SetIndicator(3.9005);	

	SweepFormatComboBox.Create(WS_CHILD|WS_VISIBLE|CBS_DROPDOWNLIST,CRect(10,150,90,220),this,ID_SWEEPFORMATCOMBO);
	SweepFormatComboBox.AddString("Log");
	SweepFormatComboBox.AddString("Linear");
	SweepFormatComboBox.SetCurSel(0);
	SweepFormatComboBox.SetFont(&m_SmallFont);
	
	SweepFormatBox.Create("Format",SS_LEFT|WS_CHILD|WS_VISIBLE,CRect(10,130,80,145),this); 
    SweepFormatBox.SetFont(&m_SmallFont);

	SweepStyleComboBox.Create(WS_CHILD|WS_VISIBLE|CBS_DROPDOWNLIST,CRect(10,205,90,270),this,ID_SWEEPSTYLECOMBO);
	SweepStyleComboBox.AddString("Solid");
	SweepStyleComboBox.AddString("Line");
	SweepStyleComboBox.SetCurSel(0);
	SweepStyleComboBox.SetFont(&m_SmallFont);
	SweepStyleBox.Create("Style",SS_LEFT|WS_CHILD|WS_VISIBLE,CRect(10,185,80,205),this); 
	SweepStyleBox.SetFont(&m_SmallFont);

	StartFreqEditBox.Create( WS_CHILD|WS_VISIBLE|WS_BORDER|ES_AUTOHSCROLL, CRect(260,175,340,200),this, IDC_SWEEPSTARTFREQ);   
	StartFreqEditBox.SetFont(&m_SmallFont);
	char tstring[16];
	sprintf(tstring,"%09.6f",radio_freq);	
	StartFreqEditBox.SetWindowText(tstring);
    SweepWindow.barstyle=TRUE;
    SweepWindow.logformat=TRUE;
	SweepCenterBox.Create("Center Frequency",SS_LEFT|WS_CHILD|WS_VISIBLE,CRect(230,130,350,145),this); 
	SweepCenterBox.SetFont(&m_SmallFont);
	SweepCenterComboBox.Create(WS_CHILD|WS_VISIBLE|CBS_DROPDOWNLIST,CRect(230,150,350,220),this,ID_SWEEPCENTERCOMBO);
	SweepCenterComboBox.AddString("Track Receiver");
	SweepCenterComboBox.AddString("Manual Setting");
	SweepCenterComboBox.SetCurSel(0);
	SweepCenterComboBox.SetFont(&m_SmallFont);
	m_bSweepAutoCenter=TRUE;

	SweepFilterBox.Create("Filter",SS_LEFT|WS_CHILD|WS_VISIBLE,CRect(120,130,200,145),this); 
	SweepFilterBox.SetFont(&m_SmallFont);	
	SweepFilterComboBox.Create(WS_CHILD|WS_VISIBLE|CBS_DROPDOWNLIST,CRect(120,150,200,300),this,ID_SWEEPFILTERCOMBO);
    SweepFilterComboBox.SetFont(&m_SmallFont);
	SweepFilterComboBox.AddString("Auto");
	SweepFilterComboBox.AddString(FilterList_RX320[1].name);
	SweepFilterComboBox.AddString(FilterList_RX320[2].name);
	SweepFilterComboBox.AddString(FilterList_RX320[3].name);

	SweepFilterComboBox.AddString(FilterList_RX320[4].name);
	SweepFilterComboBox.AddString(FilterList_RX320[5].name);
	SweepFilterComboBox.SetCurSel(0);

	SweepWidthBox.Create("Range",SS_LEFT|WS_CHILD|WS_VISIBLE,CRect(120,185,200,210),this); 
	SweepWidthBox.SetFont(&m_SmallFont);

	SweepWidthComboBox.Create(WS_CHILD|WS_VISIBLE|CBS_DROPDOWNLIST,CRect(120,205,200,350),this,ID_SWEEPWIDTHCOMBO);
	SweepWidthComboBox.AddString("1.5 MHz");
	SweepWidthComboBox.AddString("750 kHz");
	SweepWidthComboBox.AddString("300 kHz");

	SweepWidthComboBox.AddString("150 kHz");
	SweepWidthComboBox.AddString("75 kHz");
	SweepWidthComboBox.AddString("30 KHz");
	SweepWidthComboBox.AddString("3 kHz");
	SweepWidthComboBox.SetFont(&m_SmallFont);
	SweepWidthComboBox.SetCurSel(2);

	StartButton.EnableWindow(TRUE);
	StopButton.EnableWindow(FALSE);
	StartFreqEditBox.ShowWindow(FALSE);
	
	return 0;
}

BOOL CSweepPanel::OnEraseBkgnd(CDC* pDC)
{

// create a brush

	CBrush* pOldBrush=(CBrush*) pDC->SelectStockObject(LTGRAY_BRUSH);
	CPen* pOldPen=(CPen*) pDC->SelectStockObject(NULL_PEN);

	CBrush brushDarkGray(RGB(128,128,128));


	pDC->SetBkMode(OPAQUE);
	pDC->SetBkColor(RGB(192,192,192));

// get the area that needs to be erased
	CRect rcClip;									
	GetClientRect(rcClip);


// Fill client area witrh solid color first

	pDC->FillRect(rcClip,(CBrush*) pDC->SelectStockObject(GRAY_BRUSH));
	pDC->FillRect(rcClip,(CBrush*) pDC->SelectStockObject(GRAY_BRUSH));

// Unselect brush out of device context

pDC->SelectObject(pOldBrush);
pDC->SelectObject(pOldPen);

return TRUE;	
	
}

UINT CSweepPanel::OnNcHitTest(CPoint point)
{
	UINT nHitTest = CWnd::OnNcHitTest(point);	
	if(nHitTest==HTCLIENT)
		{
		return(HTCAPTION);
		}
	return (nHitTest);

}

int CSweepPanel::OnMouseActivate(CWnd* pDesktopWnd, UINT nHitTest, UINT message)
{
	BringWindowToTop();
	return TRUE;	
}

// Signal Strength of Current Sweep Frequency Set By Main Window
void CSweepPanel::SweepPointResult(double sFreq,unsigned int Sig)
{
char tstring[32];
sprintf(tstring,"Freq %f Sig %u",sFreq,Sig);
SweepWindow.ShowPoint(sFreq,Sig);
}			
			

void CSweepPanel::OnStartSweep()
{
char fbuff[16];
double ftemp;
switch(SweepWidthComboBox.GetCurSel()+1)               // may overide m_SweepFilter later (see next block)
{
 case 1: m_SweepStepFreq=5000;m_SweepFilter=1;break;
 case 2: m_SweepStepFreq=2500;m_SweepFilter=2;break;
 case 3: m_SweepStepFreq=1000;m_SweepFilter=3;break;
 case 4: m_SweepStepFreq=500;m_SweepFilter=4;break;
 case 5: m_SweepStepFreq=250;m_SweepFilter=5;break;
 case 6: m_SweepStepFreq=100;m_SweepFilter=5;break;
 case 7: m_SweepStepFreq=10;m_SweepFilter=5;break;
} 
 


if(m_bSweepAutoCenter) 	m_SweepStartFreq=radio_freq-(150*(m_SweepStepFreq/1e6));
else 
{
StartFreqEditBox.GetWindowText(fbuff,16);
ftemp=atof(fbuff);
m_SweepStartFreq=ftemp-(150*(m_SweepStepFreq/1e6));
}


if( SweepFilterComboBox.GetCurSel()!=0)
{
m_SweepFilter=(SweepFilterComboBox.GetCurSel())+1;
}

SweepWindow.UpdateWindow();
GetParent()->SendMessage(WM_COMMAND,ID_STARTSWEEP,(LPARAM) 0);
StopButton.EnableWindow(TRUE);
StartButton.EnableWindow(FALSE);
SweepFilterComboBox.EnableWindow(FALSE);
SweepWidthComboBox.EnableWindow(FALSE);
SweepCenterComboBox.EnableWindow(FALSE);

}

void CSweepPanel::OnSweepStop()
{
m_bSweepActive=FALSE;
StartButton.EnableWindow(TRUE);
StopButton.EnableWindow(FALSE);
SweepFilterComboBox.EnableWindow(TRUE);
SweepWidthComboBox.EnableWindow(TRUE);
SweepCenterComboBox.EnableWindow(TRUE);

GetParent()->SendMessage(WM_COMMAND,ID_SWEEPSTOP,(LPARAM) 0);

} 

void CSweepPanel::SetIndicator(double freq)
{
SweepWindow.SetIndicator(freq);
if(SweepAutoCenterButton.GetCheck()) 	
{
}

}


HBRUSH CSweepPanel::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor)
{

  if((nCtlColor==CTLCOLOR_EDIT))

 	{
 		pDC->SetBkMode(OPAQUE);
 		pDC->SetTextColor(RGB(0,0,0));
		return (HBRUSH) GetStockObject(WHITE_BRUSH);
 	}


pDC->SetBkMode(TRANSPARENT);
pDC->SetTextColor(RGB(0,0,0));
return (HBRUSH) GetStockObject(GRAY_BRUSH);
}




void CSweepPanel::OnChangeStartFreq()
{
char fbuff[16];
double ftemp;
StartFreqEditBox.GetWindowText(fbuff,16);
ftemp=atof(fbuff);
if(ftemp>0.10 && ftemp<30.0) 
    {
	sprintf(fbuff,"%09.6f",ftemp);
	StartFreqEditBox.SetWindowText(fbuff);
    }
else
    {
    sprintf(fbuff,"%09.6f",radio_freq);
	StartFreqEditBox.SetWindowText(fbuff);
	}
}



void CSweepPanel::OnSweepFilterChange()
{
 SweepFilterComboBox.SetCurSel(SweepFilterComboBox.GetCurSel());
 SetFocusToParent();
}
 
void CSweepPanel::OnSweepWidthChange()
{
 SweepWidthComboBox.SetCurSel(SweepWidthComboBox.GetCurSel());
 SetFocusToParent();
}
 
void CSweepPanel::SetFocusToParent()
{
	GetParent()->SetFocus();
    return;
}   

void CSweepPanel::OnSweepStyleChange()
{
if(SweepStyleComboBox.GetCurSel()==0)
{
LineStyleButton.SetCheck(FALSE);
SolidStyleButton.SetCheck(TRUE);
SweepWindow.barstyle=TRUE;
SweepWindow.Invalidate(FALSE);
}
else
{
SolidStyleButton.SetCheck(FALSE);
LineStyleButton.SetCheck(TRUE);
SweepWindow.barstyle=FALSE;
SweepWindow.Invalidate(FALSE);
}
SetFocusToParent();

}

void CSweepPanel::OnSweepCenterChange()
{
if(SweepCenterComboBox.GetCurSel()==0)
{
m_bSweepAutoCenter=TRUE;	
StartFreqEditBox.ShowWindow(FALSE);
}
else
{
m_bSweepAutoCenter=FALSE;
StartFreqEditBox.ShowWindow(TRUE);

}

SetFocusToParent();

}





void CSweepPanel::OnSweepFormatChange()
{

if(SweepFormatComboBox.GetCurSel()==1)
{
LinearButton.SetCheck(TRUE);
LogButton.SetCheck(FALSE);
SweepWindow.logformat=FALSE;
SweepWindow.Invalidate(FALSE);
}
else
{
LinearButton.SetCheck(FALSE);
LogButton.SetCheck(TRUE);
SweepWindow.logformat=TRUE;
SweepWindow.Invalidate(FALSE);
}
SetFocusToParent();
}

void CSweepPanel::OnClose()
{
	ShowWindow(SW_HIDE);	
}
