// sweeppan.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// CSweepPanel window
#include "sweepwnd.h"
#include "cnum_ed.h"
#ifndef _SWEEPPAN_H_
#define _SWEEPPAM_H_

class CSweepPanel : public CWnd
{
// Construction
public:
	CSweepPanel();



// Attributes
public:
	CSweepWnd	SweepWindow;
	CButton	StartButton;
	CButton StopButton;
	CStatic SweepInfoBox;
	CButton LinearButton;		//linear display function
	CButton LogButton;			//log display function
	CStatic SweepFormatBox;
	CStatic SweepStyleBox;
	CButton LineStyleButton;
	CButton SolidStyleButton;
	CNumericEdit StartFreqEditBox;
	CComboBox SweepFilterComboBox;
	CStatic SweepFreqBox;
	CButton SweepManualCenterButton;
	CButton SweepAutoCenterButton;
	CStatic SweepFilterBox;
	CComboBox SweepWidthComboBox;
	CStatic SweepWidthBox;
	CStatic SweepCenterBox;

	CComboBox SweepFormatComboBox;
	CComboBox SweepStyleComboBox;	
	CComboBox SweepCenterComboBox;	

	BOOL m_bSweepAutoCenter;

    void OnSetLog();
    void OnSetLinear();
	void OnStartSweep();
	void OnSweepStop();
	void SetIndicator(double freq);
	void OnSetSolidStyle();
	void OnSetLineStyle();
	void OnChangeStartFreq();
	void OnSetAutoCenter();
	void OnSetManualCenter();
	void OnSweepFilterChange();
	void SetFocusToParent();
	void OnSweepWidthChange();

	void OnSweepStyleChange();
	void OnSweepFormatChange();
	void OnSweepCenterChange();


// Operations
public:
	void CSweepPanel::SweepPointResult(double sFreq,unsigned Sig);




// Implementation
public:
	virtual ~CSweepPanel();

protected:
	// Generated message map functions
	//{{AFX_MSG(CSweepPanel)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg UINT OnNcHitTest(CPoint point);
	afx_msg int OnMouseActivate(CWnd* pDesktopWnd, UINT nHitTest, UINT message);
	afx_msg HBRUSH OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor);
	afx_msg void OnClose();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
#endif

/////////////////////////////////////////////////////////////////////////////
