// sweepwnd.cpp : implementation file

// Ten-Tec Graphic Interface Radio Control Program
// Pegasus Control GUI (c) 1999,2000 Ten-Tec Inc.
// The source code contained in this file and associated files is copyright Ten-Tec, Inc.


#include "stdafx.h"
#include "tttrx.h"
#include "sweepwnd.h"
#include "math.h"
#include "resource.h"
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

#define ID_POINTFREQ 351
#define ID_SLIDEFREQ 352
extern double m_SweepStartFreq;		// in Mhz
extern double m_SweepEndFreq;		// in Mhz
extern double m_SweepStepFreq;		// in hz			    
extern unsigned int Sarray[];
extern int SarrayIndex;

#define LINEAR_FACTOR 125

/////////////////////////////////////////////////////////////////////////////
// CSweepWnd

CSweepWnd::CSweepWnd()
{
}

CSweepWnd::~CSweepWnd()
{
}

BEGIN_MESSAGE_MAP(CSweepWnd, CWnd)
	//{{AFX_MSG_MAP(CSweepWnd)
	ON_WM_ERASEBKGND()
	ON_WM_PAINT()
	ON_WM_LBUTTONDBLCLK()
	ON_WM_LBUTTONDOWN()
	ON_WM_MOUSEMOVE()
	ON_WM_CREATE()
	ON_WM_SETCURSOR()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSweepWnd message handlers



BOOL CSweepWnd::OnEraseBkgnd(CDC* pDC)
{
	// TODO: Add your message handler code here and/or call default

// create a brush

	CBrush* pOldBrush=(CBrush*) pDC->SelectStockObject(LTGRAY_BRUSH);
	CPen* pOldPen=(CPen*) pDC->SelectStockObject(NULL_PEN);

	CBrush brushDarkGray(RGB(128,128,128));


	pDC->SetBkMode(OPAQUE);
	pDC->SetBkColor(RGB(192,192,192));

// get the area that needs to be erased
	CRect rcClip;									
	GetClientRect(rcClip);


// Fill client area witrh solid color first

	pDC->FillRect(rcClip,(CBrush*) pDC->SelectStockObject(LTGRAY_BRUSH));
	pDC->FillRect(rcClip,(CBrush*) pDC->SelectStockObject(LTGRAY_BRUSH));

// Unselect brush out of device context

pDC->SelectObject(pOldBrush);
pDC->SelectObject(pOldPen);

return TRUE;	
//	return CWnd::OnEraseBkgnd(pDC);
}






void CSweepWnd::OnPaint()
{

int count;
double dbVal;
	CSize csSize;
	char csFreq[16];
	char tstring[127];
CRect rcClip;
GetClientRect(rcClip);


CBitmap Meter;
CBrush brushFaceColor(RGB(0,0,0));
CBrush brushBodyColor(RGB(192,192,192));
CBrush brushBorderColor(RGB(0,0,0));


CPen penIndicatorColor(PS_SOLID,3,RGB(0,0,200));
CPen penMemoryIndicatorColor(PS_SOLID,1,RGB(255,0,0));
CPen penTickColor(PS_SOLID,1,RGB(0,192,0));
CPen penBandColor(PS_SOLID,1,RGB(92,92,0));

CPen penCursorColor(PS_SOLID,1,RGB(255,0,0));


CPen penShadowColor(PS_SOLID,1,RGB(128,128,128));
CPen penMediumShadowColor(PS_SOLID,1,RGB(63,63,63));

CPen penMediumHighlightColor(PS_SOLID,1,RGB(192,192,192));
CPen penHighlightColor(PS_SOLID,1,RGB(255,255,255));


CPaintDC cDC(this);
CDC memDC;







memDC.CreateCompatibleDC(&cDC); 

CFont* pOldFont=memDC.SelectObject(&m_TinyFont);

Meter.CreateDiscardableBitmap(&cDC,rcClip.right-rcClip.left,
								rcClip.bottom-rcClip.top);
memDC.SelectObject(&Meter);

int hmargin=(int)(rcClip.Width()-300)/2;

scopeRect=CRect(hmargin,20,hmargin+300,100);


CBrush* pOldBrush=memDC.SelectObject(&brushBodyColor);





memDC.SetBkMode(TRANSPARENT);
// get the area that needs to be erased
CPoint wSize=(rcClip.Width(),rcClip.Height());
CRect rcFront(rcClip.left+5,rcClip.top+5,rcClip.right-5,rcClip.bottom-(wSize.x/3));

memDC.FillRect(rcClip,&brushFaceColor);
// Shadow layer
memDC.SelectObject(&penShadowColor);
memDC.MoveTo(rcClip.left,rcClip.bottom-1);
memDC.LineTo(rcClip.left,rcClip.top);
memDC.LineTo(rcClip.right-1,rcClip.top);

memDC.SelectObject(&penMediumShadowColor);
memDC.MoveTo(rcClip.left+1,rcClip.bottom-2);
memDC.LineTo(rcClip.left+1,rcClip.top+1);
memDC.LineTo(rcClip.right-1,rcClip.top+1);

memDC.SelectObject(&penMediumHighlightColor);
memDC.MoveTo(rcClip.right-2,rcClip.top+1);
memDC.LineTo(rcClip.right-2,rcClip.bottom-2);
memDC.LineTo(rcClip.left+1,rcClip.bottom-2);

memDC.SelectObject(&penHighlightColor);
memDC.MoveTo(rcClip.right-1,rcClip.top);
memDC.LineTo(rcClip.right-1,rcClip.bottom-1);
memDC.LineTo(rcClip.left,rcClip.bottom-1);


CPen* pOldPen=memDC.SelectObject(&penTickColor);



// Vertical tick marks and labels
for(count=0;count<30;count+=2)
{
memDC.MoveTo(scopeRect.left+(count*10)+10,scopeRect.top);
memDC.LineTo(scopeRect.left+(count*10)+10,scopeRect.bottom);


// Freq Labels
	if(div(count,4).rem==0)
	{	
	sprintf(csFreq,"%6.3f",(float) m_SweepStartFreq+((count+1)*(m_SweepStepFreq/1e5)));
	csSize=cDC.GetTextExtent(csFreq,strlen(csFreq));
	memDC.SetTextColor(RGB(190,190,190));
	
	memDC.DrawText(csFreq,strlen(csFreq),CRect(scopeRect.left+(count*10)+10-((int)csSize.cx/2),
												0,
												scopeRect.left+(count*10)+10+((int) csSize.cx/2),
                                                csSize.cy),
                                                DT_CENTER|DT_SINGLELINE|DT_TOP);
	}
}


// Horizontal and labels
if(logformat)
{
	for(count=0;count<=80;count+=10)
	{
	memDC.MoveTo(scopeRect.left,scopeRect.bottom-count);
	memDC.LineTo(scopeRect.right,scopeRect.bottom-count);
	sprintf(tstring,"%2d",count);
	csSize=cDC.GetTextExtent(tstring,strlen(tstring));
	memDC.SetTextColor(RGB(190,190,190));
	
	memDC.DrawText(tstring,strlen(tstring),CRect(scopeRect.left-((int)csSize.cx),
												scopeRect.bottom-count-csSize.cy/2,
												scopeRect.left,
                                                scopeRect.bottom-count+csSize.cy/2),
                                                DT_CENTER|DT_SINGLELINE|DT_TOP);
	memDC.DrawText(tstring,strlen(tstring),CRect(scopeRect.right,
												scopeRect.bottom-count-csSize.cy/2,
												scopeRect.right+((int)csSize.cx),
                                                scopeRect.bottom-count+csSize.cy/2),
                                                DT_CENTER|DT_SINGLELINE|DT_TOP);

}
}
else
{

	int Ypos=0;

	for(count=0;count<=80;count+=20)
	{
	memDC.MoveTo(scopeRect.left,scopeRect.bottom-count);
	memDC.LineTo(scopeRect.right,scopeRect.bottom-count);
	sprintf(tstring,"%2.2f",(double)(count*(0.25/20)));
	csSize=cDC.GetTextExtent(tstring,strlen(tstring));
	memDC.SetTextColor(RGB(190,190,190));
	
	memDC.DrawText(tstring,strlen(tstring),CRect(scopeRect.left-((int)csSize.cx),
												scopeRect.bottom-count-csSize.cy/2,
												scopeRect.left,
                                                scopeRect.bottom-count+csSize.cy/2),
                                                DT_CENTER|DT_SINGLELINE|DT_TOP);
	memDC.DrawText(tstring,strlen(tstring),CRect(scopeRect.right,
												scopeRect.bottom-count-csSize.cy/2,
												scopeRect.right+((int)csSize.cx),
                                                scopeRect.bottom-count+csSize.cy/2),
                                                DT_CENTER|DT_SINGLELINE|DT_TOP);

}
}




memDC.SelectStockObject(WHITE_PEN);

for(count=1;count<SarrayIndex;count++)
{

if(logformat) 
{
	if(barstyle) 
		{

		memDC.MoveTo(count+scopeRect.left,scopeRect.bottom-(int)(4*(Sarray[count])/256)); // 4 is 6 * (80/120)
		memDC.LineTo(count+scopeRect.left,scopeRect.bottom);
    	}
    else	
    	{

		if(count>0)
		{
		memDC.MoveTo(count+scopeRect.left,scopeRect.bottom-(int)(4*(Sarray[count])/256));
		memDC.LineTo(count+scopeRect.left-1,scopeRect.bottom-(int) (4*(Sarray[count])/256)-1) ;
		}

		}
		
}

else 
{

dbVal=(double) (0.30*Sarray[count]/256.0);

TRACE("dbVal=%fl\n",dbVal);

	if(barstyle) 
	    {
		memDC.MoveTo(count+scopeRect.left,scopeRect.bottom-(int)(pow(10.0,dbVal)/LINEAR_FACTOR));
		memDC.LineTo(count+scopeRect.left,scopeRect.bottom);
		}
	else
		{	
        if(count>0)
		{
		memDC.MoveTo(count+scopeRect.left,scopeRect.bottom-(Sarray[count]/LINEAR_FACTOR));
		memDC.LineTo(count+scopeRect.left-1,scopeRect.bottom-(Sarray[count-1]/LINEAR_FACTOR)+1);
        }
		}


}
}





memDC.SelectObject(&penIndicatorColor);

int deltax=(int)((m_TuneFrequency-m_SweepStartFreq)/(m_SweepStepFreq/1e6));

if(deltax>0 && deltax<scopeRect.Width())
{
memDC.MoveTo(deltax+scopeRect.left,scopeRect.top);
memDC.LineTo(deltax+scopeRect.left,scopeRect.bottom);
}


if(!scopeRect.PtInRect(cursorPoint)) cursorPoint=CPoint(-1,-1);

if((cursorPoint.x)!=-1)
{
if(logformat)	sprintf(tstring,"Log Scale  F= %09.6f MHz    SS= %3d dB",((double)(cursorPoint.x-scopeRect.left)*(m_SweepStepFreq/1e6))+m_SweepStartFreq,scopeRect.bottom-cursorPoint.y);
else sprintf(tstring,"Linear Scale  F= %09.6f MHz    SS= %4.4f",( (double) (cursorPoint.x-scopeRect.left)*(m_SweepStepFreq/1e6))+m_SweepStartFreq,(double)((scopeRect.bottom-cursorPoint.y)*(.25/20)));

	csSize=cDC.GetTextExtent(tstring,strlen(tstring));
	memDC.SetTextColor(RGB(190,190,190));
	
int width=scopeRect.right-scopeRect.left;

	memDC.DrawText(tstring,strlen(tstring),CRect(width/2-((int)csSize.cx),
												scopeRect.bottom,
												width/2+((int) csSize.cx),
                                                scopeRect.bottom+csSize.cy),
                                                DT_CENTER|DT_SINGLELINE|DT_TOP);


memDC.SelectObject(&penCursorColor);


memDC.MoveTo(scopeRect.left,cursorPoint.y);
memDC.LineTo(scopeRect.right,cursorPoint.y);

memDC.MoveTo(cursorPoint.x,scopeRect.top);
memDC.LineTo(cursorPoint.x,scopeRect.bottom);
}







cDC.BitBlt(0,0,rcClip.right,rcClip.bottom,&memDC,0,0,SRCCOPY);

memDC.SelectObject(pOldBrush);

memDC.SelectObject(pOldPen);

memDC.SelectObject(pOldFont);

}


afx_msg void CSweepWnd::SetIndicator(double Value)
{
m_TuneFrequency=Value;
Invalidate(FALSE);
return;
}


void CSweepWnd::SetScaleRange(float range)
{
m_fScaleRange=range;
Invalidate(FALSE);
}


void CSweepWnd::OnLButtonDblClk(UINT nFlags,CPoint point)
{

}

                    
                    
double CSweepWnd::GetPointFrequency()
{
return m_PointFreq;
}
                    
double CSweepWnd::GetIndicatorFrequency()
{
return m_TuneFrequency;
}


BOOL CSweepWnd::SwlBandCheck(int sFreq)
{
 if(sFreq>3900 && sFreq<4000) return (TRUE);
 if(sFreq>5950 && sFreq<6200) return (TRUE);
 if(sFreq>7100 && sFreq<7300) return (TRUE);
 if(sFreq>9500 && sFreq<9900) return (TRUE);
 if(sFreq>11650 && sFreq<12050) return (TRUE);
 if(sFreq>15100 && sFreq<15600) return (TRUE);
 if(sFreq>17550 && sFreq<17900) return (TRUE);
 if(sFreq>21450 && sFreq<21850) return (TRUE);
 if(sFreq>25670 && sFreq<26100) return (TRUE);
 return FALSE;	
}
          
         
BOOL CSweepWnd::GetSwlLabel(int sFreq)
{
	switch(sFreq)
	{
	case 3900:csTempString="75m";return TRUE;break;
	case 5950:csTempString="49m";return TRUE;break;
	case 7100:csTempString="41m";return TRUE;break;
	case 9500:csTempString="31m";return TRUE;break;
	case 11650:csTempString="25m";return TRUE;break;
	case 15100:csTempString="19m";return TRUE;break;
	case 17550:csTempString="16m";return TRUE;break;
	case 21450:csTempString="13m";return TRUE;break;
	case 25670:csTempString="11m";return TRUE;break;
	}
	return(FALSE);	
	
}

void CSweepWnd::OnLButtonDown(UINT nFlags,CPoint point)
{
if(scopeRect.PtInRect(point))
{
	m_TuneFrequency=((double)(point.x-scopeRect.left)*(m_SweepStepFreq/1e6))+m_SweepStartFreq;
	GetParentFrame()->SendMessage(WM_COMMAND,ID_SWEEPCLICKFREQ,(LPARAM) 0);
}

} 


void CSweepWnd::OnMouseMove(UINT nFlags,CPoint point)
{
CSize csSize;
CWindowDC cDC(this);
CRect wndRect;
CRect tempRect;
cDC.SetBkColor(RGB(0,0,0));
cDC.SetBkMode(OPAQUE);

	((double)(point.x-scopeRect.left)/m_SweepStepFreq)+m_SweepStartFreq;


	if(MK_LBUTTON && nFlags)
	{	
	m_TuneFrequency=((double)(point.x-scopeRect.left)*(m_SweepStepFreq/1e6))+m_SweepStartFreq;
	GetParentFrame()->SendMessage(WM_COMMAND,ID_SWEEPCLICKFREQ,(LPARAM) 0);
	}



if(scopeRect.PtInRect(point))
{
	SetCapture();
	cursorPoint=point;

	Invalidate(FALSE);
}
else
{
	cursorPoint=CPoint(scopeRect.left,scopeRect.bottom);
	Invalidate(FALSE);
	ReleaseCapture();
	
}


}



void CSweepWnd::ShowPoint(double freq,unsigned int valu)
{
Sarray[SarrayIndex++]=valu;
}

int CSweepWnd::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

    m_TinyFont.CreateFont(14,0,0,0,FW_DONTCARE,0,0,0,ANSI_CHARSET,
    					OUT_DEVICE_PRECIS,CLIP_DEFAULT_PRECIS,DEFAULT_QUALITY,
    					DEFAULT_PITCH|FF_DONTCARE,"Arial");

	return 0;
}


