// sweepwnd.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// CSweepWnd window

#ifndef _SWEEPWND_H_
#define _SWEEPWND_H_

class CSweepWnd : public CWnd
{
// Construction
public:
	CSweepWnd();

// Attributes
public:
double 	m_TuneFrequency;			// center or tuned frequency
float	m_fScaleRange;				// display represent what frequency range
double m_PointFreq;					// frequency determined at point/click time
CFont	m_TinyFont;
int		m_pointX;
CString csTempString;
CRect scopeRect;
CStatic	FreqIndWnd;					// pop-up frequency indicator window
BOOL barstyle;
BOOL logformat;
CPoint cursorPoint;
// Operations
public:

// Implementation
public:
	virtual ~CSweepWnd();
	void SetIndicator(double Value);
	void SetScaleRange(float range);
	double GetPointFrequency();
	BOOL SwlBandCheck(int sFreq);
	double GetIndicatorFrequency();
	BOOL GetSwlLabel(int sFreq);
	void ShowPoint(double freq,unsigned int valu);
		

protected:
	// Generated message map functions
	//{{AFX_MSG(CSweepWnd)
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnPaint();
	afx_msg void OnLButtonDblClk(UINT flags,CPoint where);
	afx_msg void OnLButtonDown(UINT flags,CPoint where);
	afx_msg void OnMouseMove(UINT nFlags,CPoint point);
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
#endif
/////////////////////////////////////////////////////////////////////////////
