// swlpanel.cpp : implementation file

// Ten-Tec Graphic Interface Radio Control Program
// Pegasus Control GUI (c) 1999,2000 Ten-Tec Inc.
// The source code contained in this file and associated files is copyright Ten-Tec, Inc.

#include "stdafx.h"
#include "tttrx.h"
#include "swlpanel.h"
#include "station.h"
#include "EditStat.h"
#include "stationw.h"
#include <ctype.h>
#include "meter.h"
#include "agcdlg.h"
#include "filterpa.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif
extern CObList obMemList;
extern CObList* obPtr;
extern CString strFileName;
extern BOOL m_DataModified;		// Modified File Flag
extern CStationWnd StationPanel;
extern CSwlPanel SwlPanel;
extern filter FilterList_RX320[];
extern filter MasterFilterList_TX550[];
extern Bands HamBands[];
extern m_AutoStepPreference;
extern m_AutoFilterPreference;
extern m_MeterPreference;
extern CFilterPanel MasterFilterPanel;
extern char AuxEncoderTuningMode;
extern BOOL m_bTuneActive;
extern char OppFilter;
extern CFont m_FreqFont;
extern CFont m_SmallFont;
extern CFont m_MicroFont;
extern CFont m_MiniFont;
extern char cRemoteTuneControl;
extern BOOL m_bNoFocus;

/////////////////////////////////////////////////////////////////////////////
// CSwlPanel

CSwlPanel::CSwlPanel()
{
	TuneStep=5000;
	PanelActive=FALSE;

	bSplitState==FALSE;
}

CSwlPanel::~CSwlPanel()
{
}

BEGIN_MESSAGE_MAP(CSwlPanel, CWnd)
	//{{AFX_MSG_MAP(CSwlPanel)

	ON_COMMAND(ID_REMOTENEXTSTEP,OnRemoteNextStep)
	ON_COMMAND(ID_REMOTENEXTTUNE,OnRemoteNextTune)
	ON_COMMAND(ID_REMOTENEXTMODE,OnRemoteNextMode)
	ON_COMMAND(ID_REMOTESPLITREVERSE,OnRemoteSplitReverse)
	ON_COMMAND(ID_REMOTESWAPAB,OnRemoteSwapAB)



	ON_WM_ERASEBKGND()
	ON_WM_CREATE()
	ON_WM_CLOSE()
	ON_WM_CTLCOLOR()
	ON_WM_NCHITTEST()
	ON_WM_MOUSEACTIVATE()
	ON_WM_SETCURSOR()
	ON_WM_CHAR()
	ON_WM_ACTIVATE()
	ON_WM_ACTIVATE()
	ON_WM_NCRBUTTONDOWN()
	//}}AFX_MSG_MAP
	ON_MESSAGE(ID_TEST,OnEncoderMove)	
	ON_MESSAGE(IDM_STEPREQUEST,ShowStepBox)
	ON_MESSAGE(ID_POINTFREQ,OnClickToFrequency)
	ON_MESSAGE(ID_SLIDEFREQ,OnSlideToFrequency)
    ON_COMMAND(ID_STEP1,ShowQuickStepBox)
    ON_COMMAND(ID_MUTE,MuteRequest)
    ON_COMMAND(ID_FILTER1,SetFilter1)
    ON_COMMAND(ID_FILTER2,SetFilter2)
    ON_COMMAND(ID_FILTER3,SetFilter3)
    ON_COMMAND(ID_FILTER4,SetFilter4)
    ON_COMMAND(ID_FILTER5,SetFilter5)
    ON_COMMAND(ID_FILTER6,SetFilter6)
    ON_COMMAND(ID_FILTER7,SetFilter7)
    ON_COMMAND(ID_FILTER8,SetFilter8)
    ON_COMMAND(ID_FILTER9,SetFilter9)
	ON_COMMAND(ID_SPLIT,OnToggleSplit)


	ON_COMMAND(ID_AGC_FAST,OnAgcFastSelect)
	ON_COMMAND(ID_AGC_SLOW,OnAgcSlowSelect)
	ON_COMMAND(ID_AGC_MEDIUM,OnAgcMedSelect)

	ON_COMMAND(ID_ATTN,OnAttnToggle)

	ON_MESSAGE(MSG_RB_FREQ,OnRepeatButtonPressed)

	ON_COMMAND(ID_MEMSTORE,AddStation)
	ON_COMMAND(ID_VFOTOMEM,AddStation)

    ON_COMMAND(ID_AM,SetModeAM)
    ON_COMMAND(ID_CW,SetModeCW)
    ON_COMMAND(ID_LSB,SetModeLSB)
    ON_COMMAND(ID_USB,SetModeUSB)

    ON_COMMAND(ID_FM,SetModeFM)
	ON_COMMAND(ID_FREQUENCY_BOX,DirectFrequency)	
	ON_COMMAND(ID_FREQUENCY_BOX2,DirectFrequency2)	

	ON_MESSAGE(ID_SPEAKERSLIDER,OnVolumeChange)
	ON_MESSAGE(ID_RFGAIN_SLIDER,OnRFGainChange)
	ON_MESSAGE(ID_SQUELCH_SLIDER,OnSquelchChange)



	ON_COMMAND(ID_MEMRECALL,OnMemRecall)
	ON_COMMAND(ID_MEMTOVFO,OnMemRecall)	
	
	ON_COMMAND(ID_MEMTIME,TuneToWWV)
	ON_COMMAND(ID_TUNE,RFTuneRadio)
	ON_COMMAND(ID_MON,ToggleTxMonitor)
	ON_COMMAND(ID_VOXONOFF,ToggleVoxMode)
	ON_COMMAND(ID_SPOTONOFF,ToggleSpotMode)
	ON_COMMAND(ID_AEQB,VfoAEQB)
	ON_COMMAND(ID_REFMETER,SetMeter_REF)
	ON_COMMAND(ID_FWDMETER,SetMeter_FWD)
	ON_COMMAND(ID_SWRMETER,SetMeter_SWR)
	ON_COMMAND(ID_SWAPAB,VfoSWAPAB)
	ON_COMMAND(ID_LOCK,ToggleEncoderLock)
	ON_COMMAND(ID_MANUAL_PTT,ToggleManualTx)
	ON_COMMAND(ID_PBT,SelectPbt)
	ON_COMMAND(ID_SQL,SelectSql)
	ON_COMMAND(ID_BFO,SelectBfo)
	ON_COMMAND(ID_RIT,SelectRit)
	ON_COMMAND(ID_XIT,SelectXit)
	ON_COMMAND(ID_AUXON,SelectAuxOn)
	ON_COMMAND(ID_AUXOFF,SelectAuxOff)
	ON_COMMAND(ID_AUXCLR,SelectAuxClr)

	ON_COMMAND(ID_BANDS_160METERS,OnSelect160Meters)
	ON_COMMAND(ID_BANDS_80METERS,OnSelect80Meters)
	ON_COMMAND(ID_BANDS_40METERS,OnSelect40Meters)
	ON_COMMAND(ID_BANDS_30METERS,OnSelect30Meters)
	ON_COMMAND(ID_BANDS_20METERS,OnSelect20Meters)
	ON_COMMAND(ID_BANDS_17METERS,OnSelect17Meters)
	ON_COMMAND(ID_BANDS_15METERS,OnSelect15Meters)
	ON_COMMAND(ID_BANDS_12METERS,OnSelect12Meters)
	ON_COMMAND(ID_BANDS_10METERS,OnSelect10Meters)




	ON_COMMAND(ID_NOISE_REDUCTION,ToggleNoiseReduction)
	ON_COMMAND(ID_AUTO_NOTCH,ToggleAutoNotch)

	ON_COMMAND(ID_PHBUTTON_DOWN,OnPHButtonDown)
	ON_COMMAND(ID_PHBUTTON_UP,OnPHButtonUp)


END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSwlPanel message handlers

/////////////////////////////////////////////////////////////////////////////
// BACKGROUND & PAINTING
/////////////////////////////////////////////////////////////////////////////
BOOL CSwlPanel::OnEraseBkgnd(CDC* pDC)
{

 	CRect DisplayAreaRect;
 	
	DisplayAreaRect=CRect(48,5,552,77);				// 


// create a brush

	CPen penBorderColor(PS_SOLID,1,DISPLAY_BORDER_COLOR);					

	CBrush* pOldBrush=(CBrush*) pDC->SelectStockObject(LTGRAY_BRUSH);
	CPen* pOldPen=(CPen*) pDC->SelectStockObject(NULL_PEN);

	CBrush brushDarkGray(RGB(128,128,128));

	CPen penShadowColor(PS_SOLID,1,RGB(128,128,128));
	CPen penMediumShadowColor(PS_SOLID,1,RGB(63,63,63));

	CPen penMediumHighlightColor(PS_SOLID,1,RGB(192,192,192));
	CPen penHighlightColor(PS_SOLID,1,RGB(255,255,255));

	CPen penRacingStripe(PS_SOLID,2,RGB(0,0,200));


	pDC->SetBkMode(OPAQUE);
	pDC->SetBkColor(RGB(192,192,192));

// get the area that needs to be erased
	CRect rcClip;									
	GetClientRect(rcClip);


	CRect winClip;
	GetWindowRect(winClip);

// Fill client area witrh solid color first

	pDC->FillRect(rcClip,(CBrush*) pDC->SelectStockObject(BLACK_BRUSH));
	pDC->FillRect(rcClip,(CBrush*) pDC->SelectStockObject(BLACK_BRUSH));

	pDC->FillRect(rcClip,(CBrush*) pDC->SelectStockObject(LTGRAY_BRUSH));
	pDC->FillRect(rcClip,(CBrush*) pDC->SelectStockObject(LTGRAY_BRUSH));
  	pDC->FillRect(DisplayAreaRect,&DisplayBackgroundBrush);

	DisplayAreaRect.InflateRect(+2,+2);

// Shadow layer
	pDC->SelectObject(&penShadowColor);
	pDC->MoveTo(DisplayAreaRect.left,DisplayAreaRect.bottom-1);
	pDC->LineTo(DisplayAreaRect.left,DisplayAreaRect.top);
	pDC->LineTo(DisplayAreaRect.right-1,DisplayAreaRect.top);

	pDC->SelectObject(&penMediumShadowColor);
	pDC->MoveTo(DisplayAreaRect.left+1,DisplayAreaRect.bottom-2);
	pDC->LineTo(DisplayAreaRect.left+1,DisplayAreaRect.top+1);
	pDC->LineTo(DisplayAreaRect.right-1,DisplayAreaRect.top+1);

	pDC->SelectObject(&penMediumHighlightColor);
	pDC->MoveTo(DisplayAreaRect.right-2,DisplayAreaRect.top+1);
	pDC->LineTo(DisplayAreaRect.right-2,DisplayAreaRect.bottom-2);
	pDC->LineTo(DisplayAreaRect.left+1,DisplayAreaRect.bottom-2);

	pDC->SelectObject(&penHighlightColor);
	pDC->MoveTo(DisplayAreaRect.right-1,DisplayAreaRect.top);
	pDC->LineTo(DisplayAreaRect.right-1,DisplayAreaRect.bottom-1);
	pDC->LineTo(DisplayAreaRect.left,DisplayAreaRect.bottom-1);

	pDC->SelectObject(&penHighlightColor);
	pDC->MoveTo(548,115);
	pDC->LineTo(548,247);

	pDC->SetBkColor(RGB(0,0,0));
	pDC->SetTextColor(RGB(192,192,192));
	CFont* pOldFont =pDC->SelectObject(&m_SmallFont);
	pDC->DrawText("Agc",-1,CRect(395,5,450,20),DT_CENTER);
	pDC->DrawText("Step Tune",-1,CRect(450,5,500,20),DT_CENTER);

	pDC->SelectObject(&m_MicroFont);
	pDC->SetBkColor(RGB(192,192,192));
	pDC->SetTextColor(RGB(0,0,0));
	pDC->DrawText("-- Memory ---",-1,CRect(65,217,181,230),DT_CENTER|DT_VCENTER);

// Unselect brush out of device context

	pDC->SelectObject(pOldBrush);
	pDC->SelectObject(pOldPen);
	pDC->SelectObject(pOldFont);
	return TRUE;	
}

HBRUSH CSwlPanel::OnCtlColor(CDC* pDC,CWnd* pWnd, UINT nCtlColor)
{
	pDC->SetBkMode(TRANSPARENT);

 if(nCtlColor==CTLCOLOR_SCROLLBAR)
    {
		pDC->SetTextColor(RGB(100,100,100));
		return (HBRUSH) GetStockObject(GRAY_BRUSH);
    }

	if(GetDlgItem(ID_RITDATA_BOX) == pWnd )
	{
 		pDC->SetBkMode(TRANSPARENT);
 		pDC->SetTextColor(FREQUENCY_DISPLAY_TEXT_COLOR);
		return (HBRUSH) DisplayBackgroundBrush.GetSafeHandle();
    }

	if(GetDlgItem(ID_XITDATA_BOX) == pWnd )
	{
 		pDC->SetBkMode(TRANSPARENT);
 		pDC->SetTextColor(RGB(255,0,0));
		return (HBRUSH) DisplayBackgroundBrush.GetSafeHandle();
    }

	if(GetDlgItem(ID_BFO_LABEL) == pWnd )
	{
		pDC->SetTextColor(RGB(0,0,0));
		return (HBRUSH) GetStockObject(LTGRAY_BRUSH);
    }
    
	if(GetDlgItem(ID_MUTE_BOX) == pWnd )
	{
	if(MuteActive)	pDC->SetTextColor(OPTION_HIGHLIGHT_COLOR);
	else pDC->SetTextColor(OPTION_DIM_COLOR);

	return (HBRUSH) DisplayBackgroundBrush.GetSafeHandle();
    }

	if(GetDlgItem(ID_TUNE_BOX) == pWnd )
	{
	if(TuneActive)pDC->SetTextColor(OPTION_WARNING_COLOR);
	else pDC->SetTextColor(OPTION_DIM_COLOR);

	return (HBRUSH) DisplayBackgroundBrush.GetSafeHandle();
    }


	if(GetDlgItem(ID_MON_BOX) == pWnd )
	{
	if(MonActive) pDC->SetTextColor(OPTION_HIGHLIGHT_COLOR);
	else pDC->SetTextColor(OPTION_DIM_COLOR);

	return (HBRUSH) DisplayBackgroundBrush.GetSafeHandle();
    }

	if(GetDlgItem(ID_ATTN_BOX) == pWnd )
	{
	if(bAttnState==TRUE) pDC->SetTextColor(OPTION_HIGHLIGHT_COLOR);
	else pDC->SetTextColor(OPTION_DIM_COLOR);

	return (HBRUSH) DisplayBackgroundBrush.GetSafeHandle();
    }

	if(GetDlgItem(ID_STEP_LABEL) == pWnd )
	{
	pDC->SetTextColor(LEGEND_TEXT_COLOR);
	return (HBRUSH) GetStockObject(GRAY_BRUSH);
     }
    

	if(GetDlgItem(ID_VOLUME_LABEL) == pWnd )
	{
		pDC->SetTextColor(RGB(0,0,180));
		return (HBRUSH) GetStockObject(LTGRAY_BRUSH);
     }

	if(GetDlgItem(ID_LINE_LABEL) == pWnd )
	{
		pDC->SetTextColor(RGB(0,0,0));
		return (HBRUSH) GetStockObject(LTGRAY_BRUSH);
     }


 if((nCtlColor==CTLCOLOR_EDIT))

 	{
 		pDC->SetBkMode(TRANSPARENT);
 		pDC->SetTextColor(DISPLAY_TEXT_COLOR);
		return (HBRUSH) DisplayBackgroundBrush.GetSafeHandle();
 	}

	if(GetDlgItem(ID_MODE_BOX) == pWnd)
	{
	pDC->SetTextColor(RGB(255,255,0));
	return (HBRUSH) GetStockObject(BLACK_BRUSH);
     }

	if(GetDlgItem(ID_OPPMODE_BOX)==pWnd)
	{
	pDC->SetTextColor(RGB(0,255,0));
	return (HBRUSH) GetStockObject(BLACK_BRUSH);
     }

	if(GetDlgItem(ID_STEP_BOX) == pWnd )
	{
	pDC->SetTextColor(RGB(0,255,255));
	return (HBRUSH) GetStockObject(BLACK_BRUSH);
     }

	if(GetDlgItem(ID_WORLDTIME_LABEL) == pWnd )
	{
	pDC->SetTextColor(RGB(0,255,255));
	return (HBRUSH) GetStockObject(BLACK_BRUSH);
     }
	if(GetDlgItem(ID_WORLDTIME_BOX) == pWnd )
	{
	pDC->SetTextColor(RGB(0,255,255));
	return (HBRUSH) GetStockObject(BLACK_BRUSH);
     }


	if(GetDlgItem(ID_LOCALTIME_BOX) == pWnd )
	{
	pDC->SetTextColor(RGB(0,150,0));
	return (HBRUSH) GetStockObject(BLACK_BRUSH);
     }
	if(GetDlgItem(ID_LOCALTIME_LABEL) == pWnd )
	{
	pDC->SetTextColor(RGB(0,150,0));
	return (HBRUSH) GetStockObject(BLACK_BRUSH);
     }
	if(GetDlgItem(ID_MEMORY_BOX) == pWnd )
	{
	pDC->SetTextColor(RGB(192,192,192));
	return (HBRUSH) GetStockObject(BLACK_BRUSH);
     }

	if(GetDlgItem(ID_AGCMODE_BOX) == pWnd )
	{
	pDC->SetTextColor(RGB(0,255,255));
	return (HBRUSH) GetStockObject(BLACK_BRUSH);
     }

 	if(GetDlgItem(ID_REF_BOX) == pWnd)
	{
	if(m_MeterPreference == REFLECTED_DISPLAY) pDC->SetTextColor(OPTION_HIGHLIGHT_COLOR);
	else pDC->SetTextColor(OPTION_DIM_COLOR);	
	return (HBRUSH) GetStockObject(BLACK_BRUSH);
	}	
	if(GetDlgItem(ID_SWR_BOX) == pWnd)
    {

	if(m_MeterPreference== SWR_DISPLAY) pDC->SetTextColor(OPTION_HIGHLIGHT_COLOR);
	else pDC->SetTextColor(OPTION_DIM_COLOR);
	return (HBRUSH) GetStockObject(BLACK_BRUSH);
    }
	if(GetDlgItem(ID_FWD_BOX) == pWnd)
	{
	if(m_MeterPreference==FORWARD_DISPLAY) pDC->SetTextColor(OPTION_HIGHLIGHT_COLOR);
	else pDC->SetTextColor(OPTION_DIM_COLOR);
	return (HBRUSH) GetStockObject(BLACK_BRUSH);
    }
 
 
 if((nCtlColor==CTLCOLOR_STATIC))		// default for all static 

 	{
 		pDC->SetBkMode(TRANSPARENT);
 		pDC->SetTextColor(RGB(128,128,128));

		return (HBRUSH) GetStockObject(LTGRAY_BRUSH);
 	}



pDC->SetTextColor(RGB(0,0,0));
return (HBRUSH) GetStockObject(LTGRAY_BRUSH);
}


/////////////////////////////////////////////////////////////////////////////
// PANEL CREATION & INITIALIZATION
/////////////////////////////////////////////////////////////////////////////
int CSwlPanel::OnCreate(LPCREATESTRUCT lpCreateStruct)
{

	radio_freq=15.000;
    AuxDisplayMode="BFO";
	RitFreq=0;
	XitFreq=0;
	PbtFreq=0;
	SqlLevel=0;
	BfoFreq=0;
	bAttnState=FALSE;
	MuteActive=FALSE;
	MonActive=FALSE;
	TuneActive=FALSE;
    bANState=FALSE;
    bNRState=FALSE;
	VoxActive=FALSE;    
	SpotActive=FALSE;
	RitActive=FALSE;
	XitActive=FALSE;
	PbtActive=FALSE;
	SqlActive=FALSE;
	
	m_MeterPreference=FORWARD_DISPLAY;

	if (CWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	FrequencyBox.Create(CRect(200,30,400,70),this,ID_FREQUENCY_BOX,radio_freq);
	FreqScale.Create( CRect(100,80,500,105),this,ID_FREQSCALE,200.0);

	FrequencyBox2.Create(CRect(200,7,306,30),this,ID_FREQUENCY_BOX2,radio_freq);
	FrequencyBox2.SetFont(&m_MiniFont);
	FrequencyBox.SetFont(&m_FreqFont);
	FrequencyBox.SetColor(RGB(255,255,0));
	FrequencyBox2.SetColor(RGB(0,127,0));
	


	DisplayBackgroundBrush.CreateSolidBrush(DISPLAY_BACKGROUND_COLOR);
	FrequencyDisplayBrush.CreateSolidBrush(FREQUENCY_DISPLAY_TEXT_COLOR);
    TextColorPen.CreatePen(PS_SOLID,1,FREQUENCY_DISPLAY_TEXT_COLOR);
    BackgroundColorPen.CreatePen(PS_SOLID,1,DISPLAY_BACKGROUND_COLOR);

	
	int kx=450,ky=28;

	
                                                                 
	AMbutton.Create("AM",		WS_CHILD|BS_PUSHBUTTON|WS_VISIBLE,    CRect(195,110,235,127),this,ID_AM);
	AMbutton.SetFont(&m_SmallFont);

 	LSBbutton.Create("LSB",			WS_CHILD|BS_PUSHBUTTON|WS_VISIBLE,CRect(195,130,235,147),this,ID_LSB);
	LSBbutton.SetFont(&m_SmallFont);

	USBbutton.Create("USB",			WS_CHILD|BS_PUSHBUTTON|WS_VISIBLE,CRect(195,150,235,167),this,ID_USB);
	USBbutton.SetFont(&m_SmallFont);


 	CWbutton.Create("CW",			WS_CHILD|BS_PUSHBUTTON|WS_VISIBLE,CRect(195,170,235,187),this,ID_CW);
	CWbutton.SetFont(&m_SmallFont);                                          

 	FMbutton.Create("FM",			WS_CHILD|BS_PUSHBUTTON|WS_VISIBLE,CRect(195,190,235,207),this,ID_FM);
	FMbutton.SetFont(&m_SmallFont);                                          




	RITbutton.Create("RIT",		WS_CHILD|BS_PUSHBUTTON|WS_VISIBLE|BS_OWNERDRAW,    CRect(536,115,562,132),this,ID_RIT);
	RITbutton.SetFont(&m_MicroFont);


	XITbutton.Create("XIT",		WS_CHILD|BS_PUSHBUTTON|WS_VISIBLE|BS_OWNERDRAW,    CRect(536,152,562,169),this,ID_XIT);
	XITbutton.SetFont(&m_MicroFont);


	PBTbutton.Create("PBT",		WS_CHILD|BS_PUSHBUTTON|WS_VISIBLE|BS_OWNERDRAW,    CRect(536,189,562,206),this,ID_PBT);
	PBTbutton.SetFont(&m_MicroFont);

	AGCbutton.Create("AGC",		WS_CHILD|BS_PUSHBUTTON|WS_VISIBLE|BS_OWNERDRAW,    CRect(195,210,235,227),this,ID_AGC);
	AGCbutton.SetFont(&m_SmallFont);
	AGCbutton.SetPopupMenu(IDR_AGC_MENU);

	
 	REVbutton.Create("REV",			WS_CHILD|BS_PUSHBUTTON|WS_VISIBLE|BS_OWNERDRAW,CRect(365,210,405,227),this,ID_REVERSE);
	REVbutton.SetFont(&m_SmallFont);                                          
	REVbutton.EnableWindow(TRUE);


	HamBandsButton.Create("Amateur Bands",		WS_CHILD|BS_PUSHBUTTON|WS_VISIBLE|BS_OWNERDRAW,    CRect(240,230,360,247),this,ID_HAMBANDS_BUTTON);
	HamBandsButton.SetFont(&m_MicroFont);
	HamBandsButton.SetPopupMenu(IDR_BANDSMENU);

	ATTNbutton.Create("Attn",		WS_CHILD|BS_PUSHBUTTON|WS_VISIBLE|BS_OWNERDRAW,    CRect(557,62,593,79),this,ID_ATTN);
	ATTNbutton.SetFont(&m_MicroFont);



	SQLbutton.Create("SQL",		WS_CHILD|BS_PUSHBUTTON,    CRect(504,170,535,187),this,ID_SQL);
	SQLbutton.SetFont(&m_MicroFont);
    SQLbutton.EnableWindow(FALSE);


	RitDataBox.Create("",SS_LEFT|WS_CHILD|WS_VISIBLE,CRect(400,40,440,55),this,ID_RITDATA_BOX);
	RitDataBox.SetFont(&m_MicroFont);

	XitDataBox.Create("",SS_LEFT|WS_CHILD|WS_VISIBLE,CRect(400,55,440,70),this,ID_XITDATA_BOX);
	XitDataBox.SetFont(&m_MicroFont);


 	CRect ADBoxCrect(419,110,535,142);
	RitDataDragit.Create(ADBoxCrect,this,ID_RITDATA_DRAGIT,200.0);
	RitDataDragit.SetIndicator(0);
	RitDataDragit.SetZoom(1);
	RitDataDragit.SetLimits(-9999,+9999);

	CRect RddBoxCrect(419,144,535,176);

	XitDataDragit.Create(RddBoxCrect,this,ID_XITDATA_DRAGIT,200.0);
	XitDataDragit.SetIndicator(0);
	XitDataDragit.SetZoom(1);
	XitDataDragit.SetLimits(-9999,+9999);

 	CRect PbtBoxCrect(419,179,535,211);

	PbtDataDragit.Create(PbtBoxCrect,this,ID_PBTDATA_DRAGIT,200.0);
	PbtDataDragit.SetIndicator(0);
	PbtDataDragit.SetZoom(1);
	PbtDataDragit.SetLimits(-2000,+2000);

	TUNEbutton.Create("Tune",		WS_CHILD|BS_PUSHBUTTON|WS_VISIBLE|BS_OWNERDRAW,    CRect(557,5,593,22),this,ID_TUNE);
	TUNEbutton.SetFont(&m_SmallFont);
	TUNEbutton.SetSelectedColor(RGB(255,0,0));

	MUTEbutton.Create("Mute",		WS_CHILD|BS_PUSHBUTTON|WS_VISIBLE|BS_OWNERDRAW,    CRect(557,24,593,41),this,ID_MUTE);
	MUTEbutton.SetFont(&m_SmallFont);

	MONITORbutton.Create("Mon",		WS_CHILD|BS_PUSHBUTTON|WS_VISIBLE|BS_OWNERDRAW,    CRect(557,43,593,60),this,ID_MON);
	MONITORbutton.SetFont(&m_SmallFont);

	NRbutton.Create("Noise Reduction",		WS_CHILD|BS_PUSHBUTTON|WS_VISIBLE|BS_OWNERDRAW,    CRect(419,210,535,227),this,ID_NOISE_REDUCTION);
	NRbutton.SetFont(&m_MicroFont);

	ANbutton.Create("Automatic Notch",		WS_CHILD|BS_PUSHBUTTON|WS_VISIBLE|BS_OWNERDRAW,    CRect(419,230,535,247),this,ID_AUTO_NOTCH);
	ANbutton.SetFont(&m_MicroFont);


	ABSWAPbutton.Create("A / B",		WS_CHILD|BS_PUSHBUTTON|WS_VISIBLE,    CRect(365,110,405,127),this,ID_SWAPAB);
	ABSWAPbutton.SetFont(&m_SmallFont);

	AEQBbutton.Create("A = B",		WS_CHILD|BS_PUSHBUTTON|WS_VISIBLE,    CRect(365,130,405,147),this,ID_AEQB);
	AEQBbutton.SetFont(&m_SmallFont);

	TB1button.Create("V>M",		WS_CHILD|BS_PUSHBUTTON|WS_VISIBLE,    CRect(365,150,405,167),this,ID_VFOTOMEM);
	TB1button.SetFont(&m_SmallFont);

	TB2button.Create("M>V",		WS_CHILD|BS_PUSHBUTTON|WS_VISIBLE,    CRect(365,170,405,187),this,ID_MEMTOVFO);
	TB2button.SetFont(&m_SmallFont);



	SPLITbutton.Create("SPLIT",		WS_CHILD|BS_PUSHBUTTON|WS_VISIBLE|BS_OWNERDRAW,    CRect(365,190,405,207),this,ID_SPLIT);
	SPLITbutton.SetFont(&m_SmallFont);

	LOCKbutton.Create("LOCK",		WS_CHILD|BS_PUSHBUTTON|WS_VISIBLE|BS_OWNERDRAW,    CRect(365,230,405,247),this,ID_LOCK);
	LOCKbutton.SetFont(&m_SmallFont);
	LOCKbutton.SetSelected(FALSE);

 	FWDMETERbutton.Create("PWR",	WS_CHILD|BS_PUSHBUTTON|WS_VISIBLE|BS_OWNERDRAW ,		CRect(2,5,44,22),this,ID_FWDMETER);
	FWDMETERbutton.SetFont(&m_MicroFont);
	FWDMETERbutton.SetPopupMenu(IDR_METER_MENU);

 	VOXbutton.Create("Vox",	WS_CHILD|BS_PUSHBUTTON|WS_VISIBLE|BS_OWNERDRAW,		CRect(2,24,44,41),this,ID_VOXONOFF);
	VOXbutton.SetFont(&m_SmallFont);

 	SPOTbutton.Create("Spot",	WS_CHILD|BS_PUSHBUTTON|WS_VISIBLE|BS_OWNERDRAW,		CRect(2,43,44,60),this,ID_SPOTONOFF);
	SPOTbutton.SetFont(&m_SmallFont);

 	MANUALPTTbutton.Create("T-X",	WS_CHILD|BS_PUSHBUTTON|WS_VISIBLE|BS_OWNERDRAW,		CRect(2,62,44,79),this,ID_MANUAL_PTT);
	MANUALPTTbutton.SetFont(&m_SmallFont);


 	FILTER1button.Create("",	WS_CHILD|BS_PUSHBUTTON|WS_VISIBLE|BS_OWNERDRAW,		CRect( 65,160,103,177),this,ID_FILTER1);
 	FILTER2button.Create("",	WS_CHILD|BS_PUSHBUTTON|WS_VISIBLE|BS_OWNERDRAW,		CRect(104,160,142,177),this,ID_FILTER2);
 	FILTER3button.Create("",	WS_CHILD|BS_PUSHBUTTON|WS_VISIBLE|BS_OWNERDRAW,		CRect(143,160,181,177),this,ID_FILTER3);
 	FILTER4button.Create("",	WS_CHILD|BS_PUSHBUTTON|WS_VISIBLE|BS_OWNERDRAW,		CRect( 65,180,103,197),this,ID_FILTER4);
 	FILTER5button.Create("",	WS_CHILD|BS_PUSHBUTTON|WS_VISIBLE|BS_OWNERDRAW,		CRect(104,180,142,197),this,ID_FILTER5);
 	FILTER6button.Create("",	WS_CHILD|BS_PUSHBUTTON|WS_VISIBLE|BS_OWNERDRAW,		CRect(143,180,181,197),this,ID_FILTER6);
 	FILTER7button.Create("",	WS_CHILD|BS_PUSHBUTTON|WS_VISIBLE|BS_OWNERDRAW,		CRect( 65,200,103,217),this,ID_FILTER7);
 	FILTER8button.Create("",	WS_CHILD|BS_PUSHBUTTON|WS_VISIBLE|BS_OWNERDRAW,		CRect(104,200,142,217),this,ID_FILTER8);
 	FILTER9button.Create("",	WS_CHILD|BS_PUSHBUTTON|WS_VISIBLE|BS_OWNERDRAW,		CRect(143,200,181,217),this,ID_FILTER9);

	FILTER1button.ProgramFilterButton(1);
	FILTER2button.ProgramFilterButton(2);
	FILTER3button.ProgramFilterButton(3);
	FILTER4button.ProgramFilterButton(4);
	FILTER5button.ProgramFilterButton(5);
	FILTER6button.ProgramFilterButton(6);
	FILTER7button.ProgramFilterButton(7);
	FILTER8button.ProgramFilterButton(8);
	FILTER9button.ProgramFilterButton(9);

	FILTER1button.SetFont(&m_SmallFont);
	FILTER2button.SetFont(&m_SmallFont);
	FILTER3button.SetFont(&m_SmallFont);
	FILTER4button.SetFont(&m_SmallFont);
	FILTER5button.SetFont(&m_SmallFont);
	FILTER6button.SetFont(&m_SmallFont);
	FILTER7button.SetFont(&m_SmallFont);
	FILTER8button.SetFont(&m_SmallFont);
	FILTER9button.SetFont(&m_SmallFont);

 	CRect FPICBoxCrect(65,110,181,155);
	FilterPicBox.SetFont(&m_SmallFont);
	FilterPicBox.Create(FPICBoxCrect,this,ID_FILTERPIC_BOX);

    Stepbutton1.Create("Step",	WS_CHILD|BS_PUSHBUTTON|WS_VISIBLE,CRect(195,230,235,247),this,ID_STEP1);
	
	Stepbutton1.SetFont(&m_SmallFont);
	Stepbutton2.SetFont(&m_MicroFont);
	Stepbutton3.SetFont(&m_MicroFont);
	Stepbutton4.SetFont(&m_MicroFont);
	Stepbutton5.SetFont(&m_MicroFont);


	MemGroupButton.Create("Memory",	WS_CHILD|BS_GROUPBOX,CRect(10,110,82,240),this,ID_MODE_GROUP);
	MemGroupButton.SetFont(&m_SmallFont);
                      
	MemStorebutton.Create("Store",	WS_CHILD|BS_PUSHBUTTON|WS_VISIBLE,CRect(65,230,121,247),this,ID_MEMSTORE);
	MemStorebutton.SetFont(&m_SmallFont);

	MemRecallbutton.Create("Recall",	WS_CHILD|BS_PUSHBUTTON|WS_VISIBLE,CRect(127,230,183,247),this,ID_MEMRECALL);
	MemRecallbutton.SetFont(&m_SmallFont);


	MemTimebutton.Create("Time",	WS_CHILD|BS_PUSHBUTTON,CRect(13,210,79,227),this,ID_MEMTIME);
	MemTimebutton.SetFont(&m_SmallFont);

	CRect MemBoxCrect(306,12,365,35);
	MemBox.Create("",SS_CENTER|WS_CHILD|WS_VISIBLE,MemBoxCrect,this,ID_MEMORY_BOX);
	MemBox.SetFont(&m_SmallFont);

	CRect ModeBoxCrect(177,55,205,75);
	ModeBoxCrect.InflateRect(-2,-2);
	ModeBox.Create("AM",SS_LEFT|WS_CHILD|WS_VISIBLE,ModeBoxCrect,this,ID_MODE_BOX);
	ModeBox.SetFont(&m_SmallFont);

	CRect OppModeBoxCrect(175,12,200,35);
	OppModeBoxCrect.InflateRect(-2,-2);
	OppModeBox.Create("CW",SS_LEFT|WS_CHILD|WS_VISIBLE,OppModeBoxCrect,this,ID_OPPMODE_BOX);
	OppModeBox.SetFont(&m_SmallFont);


 	CRect StepBoxCrect(450,18,510,35);
	StepBoxCrect.InflateRect(-2,-2);
	StepBox.Create("",SS_LEFT|WS_CHILD|WS_VISIBLE,StepBoxCrect,this,ID_STEP_BOX);
	StepBox.SetFont(&m_SmallFont);
            

	CRect AgcModeCrect(395,18,450,35);
	AgcModeCrect.InflateRect(-2,-2);
	AgcModeBox.Create("fast",WS_CHILD|SS_CENTER|WS_VISIBLE,AgcModeCrect,this,ID_AGCMODE_BOX);
	AgcModeBox.SetFont(&m_SmallFont);

	VolumeLabelBox.Create("AF",SS_CENTER|WS_CHILD|WS_VISIBLE,CRect(574,110,594,123),this);
	VolumeLabelBox.SetFont(&m_SmallFont);

	RFGainLabelBox.Create("RF",SS_CENTER|WS_CHILD|WS_VISIBLE,CRect(7,110,27,123),this);
	RFGainLabelBox.SetFont(&m_SmallFont);

	SquelchLabelBox.Create("SQ",SS_CENTER|WS_CHILD|WS_VISIBLE,CRect(35,110,55,123),this);
	SquelchLabelBox.SetFont(&m_SmallFont);


	ModelLabelBox.Create("Pegasus 550",SS_CENTER|WS_CHILD|WS_VISIBLE,CRect(7,85,90,105),this);
	ModelLabelBox.SetFont(&m_SmallFont);

	LocalTimeBox.Create("LOC 00:00:00",SS_CENTER|WS_CHILD|WS_VISIBLE,CRect(460,45,530,60),this,ID_LOCALTIME_BOX);
	LocalTimeBox.SetFont(&m_MicroFont);
	WorldTimeBox.Create("UTC 00:00:00",SS_CENTER|WS_CHILD|WS_VISIBLE,CRect(460,60,530,75),this,ID_WORLDTIME_BOX);
	WorldTimeBox.SetFont(&m_MicroFont);


	CPoint ECenter(300,165);
	CSize  ESize(55,55);

	CRect ERect(ECenter.x-ESize.cx,ECenter.y-ESize.cy,ECenter.x+ESize.cx,ECenter.y+ESize.cy);

	MainEncoder.Create(ERect,this,ID_MAINENCODER,18,RGB(192,192,192));
	MainEncoder.SetEncoderState(TRUE);
	CPoint OECenter(477,172);
	CSize  OESize(22,22);
	CRect OERect(OECenter.x-OESize.cx,OECenter.y-OESize.cy,OECenter.x+OESize.cx,OECenter.y+OESize.cy);
	OffsetEncoder.Create(OERect,this,ID_OFFSETENCODER,18,RGB(192,192,192));

	OffsetEncoder.m_ThumbKnob=FALSE;
	OffsetEncoder.ShowWindow(SW_HIDE);



	CPoint VRCenter(320,135);
	CSize  VRSize(20,20);
	CRect VRRect(VRCenter.x-VRSize.cx,VRCenter.y-VRSize.cy,VRCenter.x+VRSize.cx,VRCenter.y+VRSize.cy);
	CPoint TRCenter(325,172);
	CSize  TRSize(20,20);
	CRect TRRect(TRCenter.x-TRSize.cx,TRCenter.y-TRSize.cy,TRCenter.x+TRSize.cx,TRCenter.y+TRSize.cy);

	CRect BSRect(10,18,50,100);

	CRect VSRect(570,125,590,240);
	SpeakerSlider.Create(VSRect,this,ID_SPEAKERSLIDER,18);
	SpeakerSlider.SetSliderLimits(0,63);
    SpeakerSlider.SetSliderPos(63);


	CRect VTRect(7,125,27,240);

	RFGainSlider.Create(VTRect,this,ID_RFGAIN_SLIDER,18);
	RFGainSlider.SetSliderLimits(0,127);
	RFGainSlider.SetSliderPos(127);

	CRect SQRect(35,125,55,240);
	SquelchSlider.Create(SQRect,this,ID_SQUELCH_SLIDER,18);
	SquelchSlider.SetSliderLimits(0,15);
	SquelchSlider.SetSliderPos(0);




	AMbutton.SetFont(&m_SmallFont);
	CWbutton.SetFont(&m_SmallFont);
	USBbutton.SetFont(&m_SmallFont);
	LSBbutton.SetFont(&m_SmallFont);




	TTIconBox1.Create( "RADIO_ICON2", WS_CHILD|WS_VISIBLE|SS_ICON, CRect(539,83,570,98),this);
    SigMeter.Create(CRect(60,10,166,65), this,ID_SIGNALMETER,0,6500);
	SigMeter.SetMeterLimits(0,6500,SMETER_DISPLAY);
	SigMeter.SetMeterLimits(0,150,FORWARD_DISPLAY);
	SigMeter.SetMeterLimits(0,150,REFLECTED_DISPLAY);
	SigMeter.SetMeterLimits(0,50,SWR_DISPLAY);

	SigMeter.SetIndicator(0);
    SigMeter.ShowWindow(SW_SHOW);


	PositionTimeDisplay();
	UpdateRitDisplayPanel();
	UpdateXitDisplayPanel();
	UpdatePbtDisplayPanel();

	return 0;
}

void CSwlPanel::OnClose() 
{
	ShowWindow(SW_HIDE);
}


void CSwlPanel::PositionTimeDisplay()
{
}


/////////////////////////////////////////////////////////////////////////////
// MAIN ENCODER/LOG SCALE/TUNING ROUTINES
/////////////////////////////////////////////////////////////////////////////
afx_msg LRESULT CSwlPanel::OnEncoderMove(WPARAM nID,LPARAM direction)
{

if(nID==ID_MAINENCODER)
{
	switch(direction)
	{   
	case CLOCKWISE:
	KeyTuneUp();
	break;
	case COUNTERCLOCKWISE:
	KeyTuneDown();
	break;
	}
}


if(nID==ID_OFFSETENCODER)
{
	switch(direction)
	{   
	case CLOCKWISE:
	AuxTuneUp();
	break;
	case COUNTERCLOCKWISE:
	AuxTuneDown();
	break;
	}



}









 return (LRESULT)0;
}

afx_msg LRESULT CSwlPanel::ShowStepBox(WPARAM nID,LPARAM params)
{

if(nID==ID_MAINENCODER)
{
char str[32];
if(TuneStep<1000) sprintf(str,"Current Step = %3.0f Hz",TuneStep);
else sprintf(str,"Current Step = %3.1f kHz",TuneStep/1000);                                                             


TuneStepDlg.m_CurrentStepString=(const char *) str;
if(TuneStepDlg.DoModal()==IDOK) TuneStep=TuneStepDlg.m_SelectedStep;

}

if(TuneStep<100) FreqScale.SetZoom(100);
else if(TuneStep<1000) FreqScale.SetZoom(10);
else FreqScale.SetZoom(1);

ShowStep(TuneStep);
 return (LRESULT)0;
}



void CSwlPanel::ShowQuickStepBox()
{
char str[32];
if(TuneStep<1000) sprintf(str,"Current Step = %3.0f Hz",TuneStep);
else sprintf(str,"Current Step = %3.1f kHz",TuneStep/1000);                                                             


TuneStepDlg.m_CurrentStepString=(const char *) str;
if(TuneStepDlg.DoModal()==IDOK) TuneStep=TuneStepDlg.m_SelectedStep;

ShowStep(TuneStep);

}

void CSwlPanel::KeyTuneUp()
{
            radio_freq+=(TuneStep/1e6);
            if(radio_freq>30.0) radio_freq=30.0;
    	ShowFreq(radio_freq);
    MainEncoder.MoveEncoder(CLOCKWISE);
	ChangeNotifyParent();
}

void CSwlPanel::KeyTuneDown()
{
            radio_freq-=(TuneStep/1e6);
            if(radio_freq<0) radio_freq=0;
   	ShowFreq(radio_freq);
	MainEncoder.MoveEncoder(COUNTERCLOCKWISE);
	ChangeNotifyParent();
}

 void CSwlPanel::ShowFreq(double freq)
{
    char str[20];
    sprintf(str,"%09.6f",freq);
  	FrequencyBox.SetFrequency(freq);
	FreqScale.SetIndicator(radio_freq);	
	
	return;	}






LRESULT CSwlPanel::OnClickToFrequency(WPARAM wParam,LPARAM lParam)
{
if(wParam==ID_FREQSCALE)
{
	double freq=FreqScale.GetPointFrequency()/1000;
	if(freq<0) freq=0;
	if(freq>30.0) freq=30.0;
	radio_freq=freq;

	FreqScale.SetIndicator(radio_freq);	

	FrequencyBox.SetFrequency(radio_freq);
	ChangeNotifyParent();
}    

if(wParam==ID_RITDATA_DRAGIT)
{
RitFreq=(int)RitDataDragit.GetPointFrequency();
RitDataDragit.SetIndicator(RitFreq);
UpdateRitDisplayPanel();
ChangeNotifyParent();
}

if(wParam==ID_XITDATA_DRAGIT)
{
XitFreq=(int)XitDataDragit.GetPointFrequency();
XitDataDragit.SetIndicator(XitFreq);
UpdateXitDisplayPanel();
ChangeNotifyParent();
}
    
if(wParam==ID_PBTDATA_DRAGIT)
{
PbtFreq=(int)PbtDataDragit.GetPointFrequency();
PbtDataDragit.SetIndicator(RitFreq);
UpdatePbtDisplayPanel();
ChangeNotifyParent();
}
	return 0;
}


LRESULT CSwlPanel::OnSlideToFrequency(WPARAM wParam,LPARAM lParam)
{
char str[32];
if(wParam==ID_FREQSCALE)
{
double freq=FreqScale.GetIndicatorFrequency();
if(freq<0) freq=0;
if(freq>30.0) freq=30.0;
radio_freq=freq;

FreqScale.SetIndicator(radio_freq);	
FrequencyBox.SetFrequency(radio_freq);
ChangeNotifyParent();
}

if(wParam==ID_RITDATA_DRAGIT)
{
RitFreq=(int)RitDataDragit.GetIndicatorFrequency();

if(RitFreq>9999) RitFreq=9999;
if(RitFreq<-9999) RitFreq=-9999;

RitDataDragit.SetIndicator(RitFreq);
UpdateRitDisplayPanel();
ChangeNotifyParent();
}

if(wParam==ID_XITDATA_DRAGIT)
{
XitFreq=(int)XitDataDragit.GetIndicatorFrequency();

if(XitFreq>9999) XitFreq=9999;
if(XitFreq<-9999) XitFreq=-9999;

XitDataDragit.SetIndicator(XitFreq);
UpdateXitDisplayPanel();
ChangeNotifyParent();
}

if(wParam==ID_PBTDATA_DRAGIT)
{
PbtFreq=(int)PbtDataDragit.GetIndicatorFrequency();

if(PbtFreq>2000) PbtFreq=2000;
if(PbtFreq<-2000) RitFreq=-2000;

PbtDataDragit.SetIndicator(PbtFreq);
UpdatePbtDisplayPanel();
ChangeNotifyParent();
}

if(wParam==ID_FILTERPIC_BOX)
{
int newpos=(int)FilterPicBox.GetCenter();
sprintf(str,"newpos=%d",newpos);

if(newpos>2000) newpos=2000;
if(newpos<-2000) newpos=-2000;
PbtFreq=newpos;
FilterPicBox.SetCenter(newpos);
UpdatePbtDisplayPanel();
ChangeNotifyParent();
}


return 0;
}

UINT CSwlPanel::OnNcHitTest(CPoint point) 
{
	UINT nHitTest = CWnd::OnNcHitTest(point);	
	if(nHitTest==HTCLIENT)
		{
		return(HTCAPTION);
		}
	return (nHitTest);
}

void CSwlPanel::OnStep1Pressed()
{

double freq= (double) ((long)((radio_freq+0.005)*100))/100;
radio_freq=freq;
ChangeNotifyParent();
FreqScale.SetIndicator(radio_freq);	
FrequencyBox.SetFrequency(radio_freq);

ShowStep(10000);

SetFocusToParent();
}

void CSwlPanel::OnStep2Pressed()
{
double freq= (double) ((long)((radio_freq+0.0005)*200))/200;
radio_freq=freq;
ChangeNotifyParent();
FreqScale.SetIndicator(radio_freq);	
FrequencyBox.SetFrequency(radio_freq);
ShowStep(5000);
TuneStep=5000;
SetFocusToParent();
}
void CSwlPanel::OnStep3Pressed()
{
double freq= (double) ((long)((radio_freq+0.0001)*1000))/1000;
radio_freq=freq;
ChangeNotifyParent();
FreqScale.SetIndicator(radio_freq);	
FrequencyBox.SetFrequency(radio_freq);

ShowStep(1000);
TuneStep=1000;
SetFocusToParent();
}
void CSwlPanel::OnStep4Pressed()
{
double freq= (double) ((long)((radio_freq+0.000005)*10000))/10000;
radio_freq=freq;
ChangeNotifyParent();
FreqScale.SetIndicator(radio_freq);	
FrequencyBox.SetFrequency(radio_freq);
ShowStep(100);
TuneStep=100;
SetFocusToParent();
}
void CSwlPanel::OnStep5Pressed()
{
double freq= (double) ((long)((radio_freq+0.0000005)*100000))/100000;
radio_freq=freq;
ChangeNotifyParent();
FreqScale.SetIndicator(radio_freq);	
FrequencyBox.SetFrequency(radio_freq);
ShowStep(10);
TuneStep=10;
SetFocusToParent();
}




void CSwlPanel::SetFocusToParent()
{
	if(m_bNoFocus==TRUE) return;
	GetParent()->SetFocus();
    return;
}   


void CSwlPanel::UpdatePanelData(double NewFreq,char NewMode,double NewStep,int NewFilter,double NewOppFreq,char NewOppMode)
{
	CString ModeString;
	PanelActive=TRUE;
	CString boxtext;
	if(NewMode!=NULL)
	{
		ModeBox.SetWindowText(ModeCodeToString(NewMode));
		SetFocusToParent();	
		Mode=NewMode;
	}
	if(NewOppMode!=NULL)
	{	
		OppModeBox.SetWindowText(ModeCodeToString(NewOppMode));
		SetFocusToParent();	
		OppMode=NewOppMode;
    }
	

    if(NewFreq!=NULL)
    {
    radio_freq=NewFreq;
	FreqScale.SetIndicator(radio_freq);	
	FrequencyBox.SetFrequency(radio_freq);
    }

	if(NewFilter!=NULL)
	{
	boxtext=(const char*) MasterFilterList_TX550[NewFilter].name;
	FilterPicBox.SetBandwidth(FilterBandwidth(NewFilter));

    SetFilter(NewFilter);
	}
			
	if(NewStep!=NULL)
	{
	ShowStep(NewStep);
	}



    if(NewOppFreq!=NULL)
    {
    Opp_radio_freq=NewOppFreq;
	FrequencyBox2.SetFrequency(Opp_radio_freq);
    }

	if(PbtFreq!=PbtDataDragit.GetIndicatorFrequency())	UpdatePbtDisplayPanel();


}



void CSwlPanel::SetModeAM()
{
		SetFocusToParent();	
		if(m_bTuneActive) return;
		ModeBox.SetWindowText("AM");
 		AMbutton.SetSelected(TRUE);
		CWbutton.SetSelected(FALSE);
		LSBbutton.SetSelected(FALSE);
		USBbutton.SetSelected(FALSE);
		FMbutton.SetSelected(FALSE);

		Mode=AM_MODE;
		ChangeNotifyParent();
}


void CSwlPanel::SetModeCW()
{
	SetFocusToParent();	
		if(m_bTuneActive) return;

 		AMbutton.SetSelected(FALSE);
		CWbutton.SetSelected(TRUE);
		LSBbutton.SetSelected(FALSE);
		FMbutton.SetSelected(FALSE);
		USBbutton.SetSelected(FALSE);


	ModeBox.SetWindowText("CW");
	Mode=CW_MODE;
		ChangeNotifyParent();
}

void CSwlPanel::SetModeLSB()
{
	SetFocusToParent();	
		if(m_bTuneActive) return;


 		AMbutton.SetSelected(FALSE);
		CWbutton.SetSelected(FALSE);
		LSBbutton.SetSelected(TRUE);
		USBbutton.SetSelected(FALSE);
		FMbutton.SetSelected(FALSE);

	ModeBox.SetWindowText("LSB");
	Mode=LSB_MODE;
		ChangeNotifyParent();
}

void CSwlPanel::SetModeUSB()
{
	SetFocusToParent();	
		if(m_bTuneActive) return;

 		AMbutton.SetSelected(FALSE);
		CWbutton.SetSelected(FALSE);
		LSBbutton.SetSelected(FALSE);
		USBbutton.SetSelected(TRUE);
		FMbutton.SetSelected(FALSE);


	ModeBox.SetWindowText("USB");
	Mode=USB_MODE;
	ChangeNotifyParent();

}


void CSwlPanel::SetModeFM()
{
	SetFocusToParent();	
		if(m_bTuneActive) return;

 		AMbutton.SetSelected(FALSE);
		CWbutton.SetSelected(FALSE);
		LSBbutton.SetSelected(FALSE);
		USBbutton.SetSelected(FALSE);
		FMbutton.SetSelected(TRUE);

	ModeBox.SetWindowText("FM");
	Mode=FM_MODE;
		ChangeNotifyParent();
}



void CSwlPanel::DirectFrequency()
{
double newfreq;
char str[20];
newfreq=FrequencyBox.GetFrequency();

if(newfreq>=1000) newfreq=newfreq/1e6;
if(newfreq>30.0) newfreq=newfreq/1000;


if(newfreq>30.0 || newfreq<0.00)
	{
	MessageBeep(MB_ICONEXCLAMATION);
    MessageBox("INVALID FREQUENCY ENTERED!","ENTRY ERROR",MB_ICONEXCLAMATION);
	sprintf(str,"%09.6f",radio_freq);
	FrequencyBox.SetFrequency(radio_freq);
	return;
    }
radio_freq=newfreq;
sprintf(str,"%09.6f",radio_freq);
FrequencyBox.SetFrequency(radio_freq);
FreqScale.SetIndicator(radio_freq);	

GetParent()->SendMessage(WM_COMMAND,ID_SWLPANEL,(LPARAM) 0);
}

void CSwlPanel::DirectFrequency2()
{
double newfreq;
char str[20];
newfreq=FrequencyBox2.GetFrequency();

if(newfreq>=1000) newfreq=newfreq/1e6;
if(newfreq>30.0) newfreq=newfreq/1000;


if(newfreq>30.0 || newfreq<0.00)
	{
	MessageBeep(MB_ICONEXCLAMATION);
    MessageBox("INVALID FREQUENCY ENTERED!","ENTRY ERROR",MB_ICONEXCLAMATION);
	sprintf(str,"%09.6f",Opp_radio_freq);
	FrequencyBox2.SetFrequency(Opp_radio_freq);
	return;
    }
Opp_radio_freq=newfreq;
sprintf(str,"%09.6f",Opp_radio_freq);
FrequencyBox2.SetFrequency(Opp_radio_freq);
FreqScale.SetIndicator(Opp_radio_freq);	

GetParent()->SendMessage(WM_COMMAND,ID_SWLPANEL,(LPARAM) 0);
}

 
 
double CSwlPanel::GetFrequency()
{
	return radio_freq;
}

char CSwlPanel::GetMode()
{
	return Mode;
}

char CSwlPanel::GetOppMode()
{
	return OppMode;
}

double CSwlPanel::GetTuneStep()
{
	return TuneStep;
}

int CSwlPanel::GetFilter()
{
	return m_FilterNumber;
}

void CSwlPanel::SetFilter(int Fn)
{
 	CString boxtext;

    m_FilterNumber=Fn;
	boxtext=(const char*) MasterFilterList_TX550[Fn].name;
	FilterPicBox.SetBandwidth(FilterBandwidth(m_FilterNumber));

	SetFocusToParent();	
}                       
                         


	

void CSwlPanel::SetVolume(int ivol)
{
	volume=ivol;
    SpeakerSlider.SetSliderPos(volume);
}

int CSwlPanel::GetVolume()
{
	return volume;
}	
				 
				 
LRESULT CSwlPanel::OnVolumeChange(WPARAM wParam,LPARAM lParam)
{
 	volume=SpeakerSlider.GetSetting();
	ChangeNotifyParent();
	return 0;
}


LRESULT CSwlPanel::OnRFGainChange(WPARAM wParam,LPARAM lParam)
{
	rfgain=127-RFGainSlider.GetSetting();
	ChangeNotifyParent();
	return 0;
}


LRESULT CSwlPanel::OnSquelchChange(WPARAM wParam,LPARAM lParam)
{
	m_Squelch=SquelchSlider.GetSetting();
	ChangeNotifyParent();
	return 0;
}


void CSwlPanel::ChangeNotifyParent()
{
 if(PanelActive==FALSE) return;
 GetParent()->SendMessage(WM_COMMAND,ID_SWLPANEL,(LPARAM) 0);
}


void CSwlPanel::SetFilter1()
{
SetFilter(FILTER1button.FilterIndex);
FILTER1button.SetSelected(TRUE);
FILTER2button.SetSelected(FALSE);
FILTER3button.SetSelected(FALSE);
FILTER4button.SetSelected(FALSE);
FILTER5button.SetSelected(FALSE);
FILTER6button.SetSelected(FALSE);
FILTER7button.SetSelected(FALSE);
FILTER8button.SetSelected(FALSE);
FILTER9button.SetSelected(FALSE);
ChangeNotifyParent();
}
void CSwlPanel::SetFilter2()
{
SetFilter(FILTER2button.FilterIndex);
FILTER1button.SetSelected(FALSE);
FILTER2button.SetSelected(TRUE);
FILTER3button.SetSelected(FALSE);
FILTER4button.SetSelected(FALSE);
FILTER5button.SetSelected(FALSE);
FILTER6button.SetSelected(FALSE);
FILTER7button.SetSelected(FALSE);
FILTER8button.SetSelected(FALSE);
FILTER9button.SetSelected(FALSE);
ChangeNotifyParent();
}
void CSwlPanel::SetFilter3()
{
SetFilter(FILTER3button.FilterIndex);
FILTER1button.SetSelected(FALSE);
FILTER2button.SetSelected(FALSE);
FILTER3button.SetSelected(TRUE);
FILTER4button.SetSelected(FALSE);
FILTER5button.SetSelected(FALSE);
FILTER6button.SetSelected(FALSE);
FILTER7button.SetSelected(FALSE);
FILTER8button.SetSelected(FALSE);
FILTER9button.SetSelected(FALSE);
ChangeNotifyParent();
}
void CSwlPanel::SetFilter4()
{
SetFilter(FILTER4button.FilterIndex);
FILTER1button.SetSelected(FALSE);
FILTER2button.SetSelected(FALSE);
FILTER3button.SetSelected(FALSE);
FILTER4button.SetSelected(TRUE);
FILTER5button.SetSelected(FALSE);
FILTER6button.SetSelected(FALSE);
FILTER7button.SetSelected(FALSE);
FILTER8button.SetSelected(FALSE);
FILTER9button.SetSelected(FALSE);
ChangeNotifyParent();
}

void CSwlPanel::SetFilter5()
{
SetFilter(FILTER5button.FilterIndex);
FILTER1button.SetSelected(FALSE);
FILTER2button.SetSelected(FALSE);
FILTER3button.SetSelected(FALSE);
FILTER4button.SetSelected(FALSE);
FILTER5button.SetSelected(TRUE);
FILTER6button.SetSelected(FALSE);
FILTER7button.SetSelected(FALSE);
FILTER8button.SetSelected(FALSE);
FILTER9button.SetSelected(FALSE);
ChangeNotifyParent();
}

void CSwlPanel::SetFilter6()
{
SetFilter(FILTER6button.FilterIndex);
FILTER1button.SetSelected(FALSE);
FILTER2button.SetSelected(FALSE);
FILTER3button.SetSelected(FALSE);
FILTER4button.SetSelected(FALSE);
FILTER5button.SetSelected(FALSE);
FILTER6button.SetSelected(TRUE);
FILTER7button.SetSelected(FALSE);
FILTER8button.SetSelected(FALSE);
FILTER9button.SetSelected(FALSE);
ChangeNotifyParent();
}

void CSwlPanel::SetFilter7()
{
SetFilter(FILTER7button.FilterIndex);
FILTER1button.SetSelected(FALSE);
FILTER2button.SetSelected(FALSE);
FILTER3button.SetSelected(FALSE);
FILTER4button.SetSelected(FALSE);
FILTER5button.SetSelected(FALSE);
FILTER6button.SetSelected(FALSE);
FILTER7button.SetSelected(TRUE);
FILTER8button.SetSelected(FALSE);
FILTER9button.SetSelected(FALSE);
ChangeNotifyParent();
}

void CSwlPanel::SetFilter8()
{
SetFilter(FILTER8button.FilterIndex);
FILTER1button.SetSelected(FALSE);
FILTER2button.SetSelected(FALSE);
FILTER3button.SetSelected(FALSE);
FILTER4button.SetSelected(FALSE);
FILTER5button.SetSelected(FALSE);
FILTER6button.SetSelected(FALSE);
FILTER7button.SetSelected(FALSE);
FILTER8button.SetSelected(TRUE);
FILTER9button.SetSelected(FALSE);
ChangeNotifyParent();
}

void CSwlPanel::SetFilter9()
{
SetFilter(FILTER9button.FilterIndex);
FILTER1button.SetSelected(FALSE);
FILTER2button.SetSelected(FALSE);
FILTER3button.SetSelected(FALSE);
FILTER4button.SetSelected(FALSE);
FILTER5button.SetSelected(FALSE);
FILTER6button.SetSelected(FALSE);
FILTER7button.SetSelected(FALSE);
FILTER8button.SetSelected(FALSE);
FILTER9button.SetSelected(TRUE);
ChangeNotifyParent();
}

afx_msg LRESULT CSwlPanel::OnRepeatButtonPressed(WPARAM nID,LPARAM direction)
{

switch(nID)
	{
	case ID_RB_FAST_UP:
	ProgTuneUp(TuneStep * 10);

	break;
	case ID_RB_UP:
	ProgTuneUp(TuneStep);
	break;
	case ID_RB_FAST_DOWN:
	ProgTuneDown(TuneStep * 10);
	break;
	case ID_RB_DOWN:
	ProgTuneDown(TuneStep);

	break;

	}	

return (LRESULT)0;
}


void CSwlPanel::ProgTuneUp(double FreqDelta)
{
	radio_freq+=(FreqDelta/1e6);
            if(radio_freq>30.0) radio_freq=30.0;
    	ShowFreq(radio_freq);
    MainEncoder.MoveEncoder(CLOCKWISE);
	ChangeNotifyParent();
}

void CSwlPanel::ProgTuneDown(double FreqDelta)
{
            radio_freq-=(FreqDelta/1e6);
            if(radio_freq<0) radio_freq=0;
   	ShowFreq(radio_freq);
	MainEncoder.MoveEncoder(COUNTERCLOCKWISE);
	ChangeNotifyParent();
}


afx_msg void CSwlPanel::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	if(isdigit(nChar)|| nChar=='.' || nChar==VK_DECIMAL)
	{
	GetDescendantWindow(ID_FREQUENCY_BOX,FALSE)->SetFocus();
	((CEdit*) GetDescendantWindow(ID_FREQUENCY_BOX,FALSE))->SetSel(0,-1,FALSE);
	GetDescendantWindow(ID_FREQUENCY_BOX,FALSE)->PostMessage(WM_CHAR,nChar,nRepCnt);
	return;
	}
	CWnd::OnChar(nChar,nRepCnt,nFlags);	
}


afx_msg void CSwlPanel::OnActivate( UINT nState, CWnd* pWndOther, BOOL bMinimized )
{
 	if(nState==WA_ACTIVE | nState==WA_CLICKACTIVE) BringWindowToTop();
	SetFocusToParent();	
}

int CSwlPanel::OnMouseActivate(CWnd* pDesktopWnd, UINT nHitTest, UINT message)
{
	BringWindowToTop();
	SetFocusToParent();	
	return TRUE;	
}


void CSwlPanel::AddStation()
{
 CEditStationDialog EditStation;


 EditStation.m_StationFrequency=radio_freq;
 
 EditStation.m_StationMode="AM";
 if(Mode==CW_MODE) EditStation.m_StationMode="CW";
 if(Mode==USB_MODE) EditStation.m_StationMode="USB";
 if(Mode==LSB_MODE) EditStation.m_StationMode="LSB";
 if(Mode==FM_MODE) EditStation.m_StationMode="FM";





 EditStation.m_StationFilter=MasterFilterList_TX550[m_FilterNumber].name;

 if(EditStation.DoModal()==IDCANCEL) return;

CStation* station=new CStation;
 station->Name=EditStation.m_StationName;
 station->Frequency=EditStation.m_StationFrequency;
 station->Filter=EditStation.m_StationFilter;
 station->Language=EditStation.m_StationLanguage;
 station->Mode=EditStation.m_StationMode;
 station->Country=EditStation.m_StationCountry;
 station->Address=EditStation.m_StationAddress;

obPtr->AddTail(station);
StationPanel.LoadListBox(); 
m_DataModified=TRUE;
}


	
void CSwlPanel::OnMemRecall()
{


StationPanel.ShowWindow(SW_SHOW);
StationPanel.BringWindowToTop();

}

BOOL CSwlPanel::OnSetCursor(CWnd* pWnd, UINT nHitTest,UINT message)
{

switch(pWnd->GetDlgCtrlID())
{
	case ID_FREQSCALE:
 SetCursor(AfxGetApp()->LoadCursor("IDC_HAND"));
 return TRUE;
		break;	
	case ID_SPEAKERSLIDER:
 SetCursor(AfxGetApp()->LoadCursor("IDC_HAND"));
 return TRUE;
		break;	

	case ID_POWERSLIDER:
 SetCursor(AfxGetApp()->LoadCursor("IDC_HAND"));
 return TRUE;
		break;	

	case ID_RFGAIN_SLIDER:
 SetCursor(AfxGetApp()->LoadCursor("IDC_HAND"));
 return TRUE;
		break;	

	case ID_SQUELCH_SLIDER:
 SetCursor(AfxGetApp()->LoadCursor("IDC_HAND"));
 return TRUE;
		break;	

	case ID_RITDATA_DRAGIT:
 SetCursor(AfxGetApp()->LoadCursor("IDC_HAND"));
 return TRUE;
		break;	
	case ID_XITDATA_DRAGIT:
 SetCursor(AfxGetApp()->LoadCursor("IDC_HAND"));
 return TRUE;
		break;	
	case ID_PBTDATA_DRAGIT:
 SetCursor(AfxGetApp()->LoadCursor("IDC_HAND"));
 return TRUE;
		break;	
	case ID_FILTERPIC_BOX:
 SetCursor(AfxGetApp()->LoadCursor("IDC_HAND"));
 return TRUE;
		break;	




}

return CWnd::OnSetCursor(pWnd,nHitTest,message);
}     



void CSwlPanel::ShowStep(double step)
{
char str[32];
if(step>=1) TuneStep=step;
else TuneStep=1;
if(TuneStep<1000) sprintf(str,"%3.0f Hz",TuneStep);
else sprintf(str,"%3.1f kHz",TuneStep/1000);          
StepBox.SetWindowText( (const char *) str);

ChangeNotifyParent();
 
}

void CSwlPanel::SetMute(BOOL bState)
{
MuteActive=bState;
if(MuteActive) MUTEbutton.SetSelected(TRUE);
else MUTEbutton.SetSelected(FALSE);

return;
}

void CSwlPanel::MuteRequest()
{
GetParent()->SendMessage(WM_COMMAND,ID_MUTE,(LPARAM) 0);
}

void CSwlPanel::TuneToWWV()
{
 GetParent()->SendMessage(WM_COMMAND,IDM_TIMETUNE,(LPARAM) 0);
}

void CSwlPanel::RFTuneRadio()
{
if(TuneActive) 
{	
	TuneActive=FALSE;
	TUNEbutton.SetSelected(FALSE);	
}
else
{
TUNEbutton.SetSelected(TRUE);
TuneActive=TRUE;
} 


ChangeNotifyParent();
SetFocusToParent();

}

void CSwlPanel::ToggleTxMonitor()
{
if(MonActive) MonActive=FALSE;
else MonActive=TRUE;
if(MonActive) MONITORbutton.SetSelected(TRUE);
else MONITORbutton.SetSelected(FALSE);
ChangeNotifyParent();
SetFocusToParent();
}

void CSwlPanel::ToggleVoxMode()
{
if(VoxActive) VoxActive=FALSE;
else VoxActive=TRUE;
if(VoxActive) VOXbutton.SetSelected(TRUE);
else VOXbutton.SetSelected(FALSE);
ChangeNotifyParent();
SetFocusToParent();
}


void CSwlPanel::ToggleSpotMode()
{
if(SpotActive) SpotActive=FALSE;
else SpotActive=TRUE;
if(SpotActive) SPOTbutton.SetSelected(TRUE);
else SPOTbutton.SetSelected(FALSE);
ChangeNotifyParent();
SetFocusToParent();
}


void CSwlPanel::VfoAEQB()
{
Opp_radio_freq=radio_freq;
OppMode=Mode;
OppModeBox.SetWindowText(ModeCodeToString(OppMode));
FrequencyBox2.SetFrequency(Opp_radio_freq);
FrequencyBox.SetFrequency(radio_freq);
SetFocusToParent();	
ChangeNotifyParent();

}


CString CSwlPanel::ModeCodeToString(char modecode)
{
	switch(modecode)
		{
		case '0':
		return "AM";
			break;
        case '1':
		return "USB";
    		break;
        case '2':
		return "LSB";
            break;
        case '3':
		return "CW";
            break;

		case '4':
			return "FM";
			break;


	}        	    

	return "AM";
}

void CSwlPanel::SetMeter_SWR()
{
m_MeterPreference=SWR_DISPLAY;
SetFocusToParent();
FWDMETERbutton.SetWindowText("SWR");
}

void CSwlPanel::SetMeter_REF()
{
m_MeterPreference=REFLECTED_DISPLAY;
SetFocusToParent();
FWDMETERbutton.SetWindowText("REF");
}

void CSwlPanel::SetMeter_FWD()
{
m_MeterPreference=FORWARD_DISPLAY;
SetFocusToParent();
FWDMETERbutton.SetWindowText("FWD");
}

void CSwlPanel::ToggleManualTx()
{
if(ManualTxActive) 
{	
	ManualTxActive=FALSE;
	MANUALPTTbutton.SetSelected(FALSE);	
	

}
else
{
	ManualTxActive=TRUE;
	MANUALPTTbutton.SetSelected(TRUE);	
} 

ChangeNotifyParent();
SetFocusToParent();

}

void CSwlPanel::ShowSideTone()
{
SetFocusToParent();
}


void CSwlPanel::VfoSWAPAB()
{
double tempfreq;
char tempmode;
char tempfilter;
tempmode=Mode;
Mode=OppMode;
OppMode=tempmode;

tempfreq=radio_freq;
radio_freq=Opp_radio_freq;
Opp_radio_freq=tempfreq;

tempfilter=m_FilterNumber;
m_FilterNumber=OppFilter;
OppFilter=tempfilter;
SetFilter(m_FilterNumber);
CheckFilterHighlite(m_FilterNumber);
OppModeBox.SetWindowText(ModeCodeToString(OppMode));
ModeBox.SetWindowText(ModeCodeToString(Mode));
FrequencyBox2.SetFrequency(Opp_radio_freq);
FrequencyBox.SetFrequency(radio_freq);
ShowFreq(radio_freq);
SetFocusToParent();	
ChangeNotifyParent();
}

void CSwlPanel::ToggleEncoderLock()
{
if(MainEncoder.GetEncoderState()==TRUE) {
	MainEncoder.SetEncoderState(FALSE);
	LOCKbutton.SetSelected(TRUE);
}
else {
	MainEncoder.SetEncoderState(TRUE);
	LOCKbutton.SetSelected(FALSE);

}
SetFocusToParent();
}


void CSwlPanel::UpdateRitDisplayPanel()
{
char tstr[32];

	if(RitActive==TRUE) 
	{
		if(RitFreq<1000) sprintf(tstr,"%+3d",RitFreq);
		else sprintf(tstr,"%+4.3f",(double)RitFreq/1000); 
	RitDataDragit.SetIndicator(RitFreq);
	RitDataBox.SetWindowText((const char *) tstr);
	}
	else
	{
	RitDataBox.SetWindowText("+0");
	}	

}
void CSwlPanel::UpdateXitDisplayPanel()
{
char tstr[32];

	if(XitActive==TRUE)
	{
	if(XitFreq<1000) sprintf(tstr,"%+3d",XitFreq);
	else sprintf(tstr,"%+4.3f",(double)XitFreq/1000); 
	XitDataDragit.SetIndicator(XitFreq);
	PbtDataDragit.SetIndicator(PbtFreq);
	XitDataBox.SetWindowText((const char *) tstr);

	}
	else
	{
	XitDataBox.SetWindowText("+0");
	}



}

void CSwlPanel::UpdatePbtDisplayPanel()
{
	if(PbtActive==TRUE) 
	{
	PbtDataDragit.SetIndicator(PbtFreq);
	FilterPicBox.SetCenter(PbtFreq);	
	}
	else 
	{
	PbtDataDragit.SetIndicator(PbtFreq);
	}

}


void CSwlPanel::SelectRit()
{
if(RitActive==TRUE) 
{
RitActive=FALSE;
RITbutton.SetSelected(FALSE);
}
else
{
RITbutton.SetSelected(TRUE);
RitActive=TRUE;
}
ChangeNotifyParent();
UpdateRitDisplayPanel();
SetFocusToParent();	
}


void CSwlPanel::SelectXit()
{
if(XitActive==TRUE) 
{
XitActive=FALSE;
XITbutton.SetSelected(FALSE);
}
else
{
XITbutton.SetSelected(TRUE);
XitActive=TRUE;
}
UpdateXitDisplayPanel();
ChangeNotifyParent();
SetFocusToParent();	
}

void CSwlPanel::SelectPbt()
{
if(PbtActive==TRUE) 
{
PbtActive=FALSE;
PBTbutton.SetSelected(FALSE);
}
else
{
PBTbutton.SetSelected(TRUE);
PbtActive=TRUE;
}
UpdatePbtDisplayPanel();
ChangeNotifyParent();
SetFocusToParent();	
}


void CSwlPanel::SelectSql()
{
if(AuxDisplayMode=="SQL" && SqlActive==TRUE) 
{
SqlActive=FALSE;
SQLbutton.SetSelected(FALSE);
}
else
{
SQLbutton.SetSelected(TRUE);
SqlActive=TRUE;
AuxDisplayMode="SQL";
}
SetFocusToParent();	
}

void CSwlPanel::SelectBfo()
{
AuxDisplayMode="BFO";
}


void CSwlPanel::SelectAuxOn()
{

if(AuxDisplayMode=="RIT") RitActive=TRUE;
if(AuxDisplayMode=="XIT") XitActive=TRUE;
if(AuxDisplayMode=="SQL") SqlActive=TRUE;
if(AuxDisplayMode=="PBT") PbtActive=TRUE;
}


void CSwlPanel::SelectAuxOff()
{
if(AuxDisplayMode=="RIT") RitActive=FALSE;
if(AuxDisplayMode=="XIT") XitActive=FALSE;
if(AuxDisplayMode=="SQL") SqlActive=FALSE;
if(AuxDisplayMode=="PBT") PbtActive=FALSE;
}

void CSwlPanel::SelectAuxClr()
{

if(AuxDisplayMode=="RIT" && RitActive==TRUE) RitFreq=0;
if(AuxDisplayMode=="XIT" && XitActive==TRUE) XitFreq=0;
if(AuxDisplayMode=="SQL" && SqlActive==TRUE) SqlLevel=0;
if(AuxDisplayMode=="PBT" && PbtActive==TRUE) PbtFreq=0;
ChangeNotifyParent();
}

void CSwlPanel::AuxTuneUp()
{
if(cRemoteTuneControl==REMOTE_PBT_TUNE)
{
PbtFreq+=10;
if(PbtFreq<-2000) PbtFreq=-2000;
if(PbtFreq>2000) PbtFreq=2000;
FilterPicBox.SetCenter(PbtFreq);
}

if(cRemoteTuneControl==REMOTE_RIT_TUNE)
{
RitFreq+=10;
if(RitFreq<-9999) RitFreq=-9999;
if(RitFreq>9999) RitFreq=9999;
RitDataDragit.SetIndicator(RitFreq);
UpdateRitDisplayPanel();
}

if(cRemoteTuneControl==REMOTE_XIT_TUNE)
{
XitFreq+=10;
if(XitFreq<-9999) XitFreq=-9999;
if(XitFreq>9999) XitFreq=9999;
XitDataDragit.SetIndicator(XitFreq);
UpdateXitDisplayPanel();
}
	ChangeNotifyParent();
	UpdatePbtDisplayPanel();
}

void CSwlPanel::AuxTuneDown()
{
if(cRemoteTuneControl==REMOTE_PBT_TUNE)
{
PbtFreq-=10;
if(PbtFreq<-2000) PbtFreq=-2000;
if(PbtFreq>2000) PbtFreq=2000;
FilterPicBox.SetCenter(PbtFreq);
}

if(cRemoteTuneControl==REMOTE_RIT_TUNE)
{
RitFreq-=10;
if(RitFreq<-9999) RitFreq=-9999;
if(RitFreq>9999) RitFreq=9999;
RitDataDragit.SetIndicator(RitFreq);
UpdateRitDisplayPanel();
}

if(cRemoteTuneControl==REMOTE_XIT_TUNE)
{
XitFreq-=10;
if(XitFreq<-9999) XitFreq=-9999;
if(XitFreq>9999) XitFreq=9999;
XitDataDragit.SetIndicator(XitFreq);
UpdateXitDisplayPanel();
}
	ChangeNotifyParent();
	UpdatePbtDisplayPanel();
}






void CSwlPanel::OnAgcFastSelect()
{
CString boxtext="UNKNOWN";

boxtext="Fast";m_AgcMode=AGC_FAST;

AgcModeBox.SetWindowText(boxtext);

ChangeNotifyParent();
SetFocusToParent();	

}

void CSwlPanel::OnAgcSlowSelect()
{
CString boxtext="UNKNOWN";

boxtext="Slow";m_AgcMode=AGC_SLOW;

AgcModeBox.SetWindowText(boxtext);

ChangeNotifyParent();
SetFocusToParent();	

}

void CSwlPanel::OnAgcMedSelect()
{
CString boxtext="UNKNOWN";

boxtext="Med";m_AgcMode=AGC_MEDIUM;

AgcModeBox.SetWindowText(boxtext);

ChangeNotifyParent();
SetFocusToParent();	

}


void CSwlPanel::SetAgcMode(int agcmode)
{
CString boxtext;
m_AgcMode=agcmode;
if(m_AgcMode==AGC_FAST) boxtext="Fast";
if(m_AgcMode==AGC_MEDIUM) boxtext="Med";
if(m_AgcMode==AGC_SLOW) boxtext="Slow";

AgcModeBox.SetWindowText(boxtext);


}


void CSwlPanel::OnAttnToggle()
{
if(bAttnState==TRUE) bAttnState=FALSE;
else bAttnState=TRUE;
if (bAttnState==TRUE) ATTNbutton.SetSelected(TRUE);
else ATTNbutton.SetSelected(FALSE);

ChangeNotifyParent();

SetFocusToParent();	
}

void CSwlPanel::ToggleNoiseReduction()
{

if(bNRState==TRUE) 
	{
	bNRState=FALSE;
 	NRbutton.SetSelected(FALSE);
	}
else 
	{
	bNRState=TRUE;
	NRbutton.SetSelected(TRUE);
	}

ChangeNotifyParent();

SetFocusToParent();	
}


void CSwlPanel::ToggleAutoNotch()
{

if(bANState==TRUE) 
	{
	bANState=FALSE;
	ANbutton.SetSelected(FALSE);
	}
else 
	{
	bANState=TRUE;
	ANbutton.SetSelected(TRUE);
	}

ChangeNotifyParent();

SetFocusToParent();	
}



void CSwlPanel::OnDblClickRIT() // this function not currently being used
{
RitFreq=0;

}



void CSwlPanel::OnToggleSplit()
{
if(bSplitState==TRUE)
	{
	SPLITbutton.SetSelected(FALSE);
	bSplitState=FALSE;	
	}
	else
	{
	SPLITbutton.SetSelected(TRUE);
	bSplitState=TRUE;	
	}
ChangeNotifyParent();
}
	
	
int CSwlPanel::FilterBandwidth(int index)
{
double bw;
char str[64];
    bw=atof(MasterFilterList_TX550[index].name);
    if(bw<10) sprintf(str,"%1.2f",bw*1000);
    else sprintf(str,"%3.0f",bw);
    return atoi(str);
}
	
	
void CSwlPanel::OnSelect160Meters()
{
OnSelectHamBand(BAND160METERS);
}

void CSwlPanel::OnSelect80Meters()
{
OnSelectHamBand(BAND80METERS);
}

void CSwlPanel::OnSelect40Meters()
{
OnSelectHamBand(BAND40METERS);
}

void CSwlPanel::OnSelect30Meters()
{
OnSelectHamBand(BAND30METERS);
}

void CSwlPanel::OnSelect20Meters()
{
OnSelectHamBand(BAND20METERS);
}

void CSwlPanel::OnSelect17Meters()
{
OnSelectHamBand(BAND17METERS);
}

void CSwlPanel::OnSelect15Meters()
{
OnSelectHamBand(BAND15METERS);
}

void CSwlPanel::OnSelect12Meters()
{
OnSelectHamBand(BAND12METERS);
}

void CSwlPanel::OnSelect10Meters()
{
OnSelectHamBand(BAND10METERS);
}


void CSwlPanel::OnSelectHamBand(char BandIndex)
{
radio_freq=HamBands[BandIndex].LastFreq;
Mode=HamBands[BandIndex].LastMode;
m_FilterNumber=HamBands[BandIndex].LastFilter;
ShowFreq(radio_freq);
SetFilter(m_FilterNumber);
CheckFilterHighlite(m_FilterNumber);
switch(Mode)
	{
	case AM_MODE: SetModeAM();break;
	case CW_MODE: SetModeCW();break;
	case LSB_MODE: SetModeLSB();break;
	case USB_MODE: SetModeUSB();break;
	case FM_MODE: SetModeFM();break;
	}
ChangeNotifyParent();
SetFocusToParent();	
}



void CSwlPanel::OnRemoteNextStep()
{

if(TuneStep==100000)
{
TuneStep=50000;
ShowStep(TuneStep);
return;
}

if(TuneStep==50000)
{
TuneStep=10000;
ShowStep(TuneStep);
return;
}

switch((int)TuneStep)
	{
	case  10000: TuneStep=5000;break;
	case   5000: TuneStep=2500;break;
	case   2500: TuneStep=1000;break;
	case   1000: TuneStep=500;break;
	case    500: TuneStep=100;break;
	case    100: TuneStep=50;break;
	case     50: TuneStep=10;break;
	case     10: TuneStep=5;break;
	case      5: TuneStep=1;break;
	case      1: TuneStep=100000;break;
	}	

ShowStep(TuneStep);
}

void CSwlPanel::OnRemoteNextTune()
{
}

void CSwlPanel::OnRemoteNextMode()
{
	switch(Mode)
		{
		case AM_MODE: SetModeLSB();break;
		case LSB_MODE:SetModeUSB();break;
		case USB_MODE: SetModeCW();break;
		case CW_MODE: SetModeFM();break;
		case FM_MODE: SetModeAM();break;
		}
}

void CSwlPanel::OnRemoteSplitReverse()
{
if(!bSplitState) return;
VfoSWAPAB();
}

void CSwlPanel::OnRemoteSwapAB()
{
VfoSWAPAB();
}


afx_msg void CSwlPanel::OnLButtonDown(UINT flags,CPoint point)
{
MessageBox("LButtonDown");
}


void CSwlPanel::OnPHButtonUp()
{
if(!bSplitState) return;

VfoSWAPAB();
}

void CSwlPanel::OnPHButtonDown()
{
if(!bSplitState) return;
VfoSWAPAB();
}


void CSwlPanel::CheckFilterHighlite(int filter)
{
FILTER1button.SetSelected(FALSE);
FILTER2button.SetSelected(FALSE);
FILTER3button.SetSelected(FALSE);
FILTER4button.SetSelected(FALSE);
FILTER5button.SetSelected(FALSE);
FILTER6button.SetSelected(FALSE);
FILTER7button.SetSelected(FALSE);
FILTER8button.SetSelected(FALSE);
FILTER9button.SetSelected(FALSE);

	if(filter==FILTER1button.FilterIndex) FILTER1button.SetSelected(TRUE); 
	if(filter==FILTER2button.FilterIndex) FILTER2button.SetSelected(TRUE); 
	if(filter==FILTER3button.FilterIndex) FILTER3button.SetSelected(TRUE); 
	if(filter==FILTER4button.FilterIndex) FILTER4button.SetSelected(TRUE); 
	if(filter==FILTER5button.FilterIndex) FILTER5button.SetSelected(TRUE); 
	if(filter==FILTER6button.FilterIndex) FILTER6button.SetSelected(TRUE); 
	if(filter==FILTER7button.FilterIndex) FILTER7button.SetSelected(TRUE); 
	if(filter==FILTER8button.FilterIndex) FILTER8button.SetSelected(TRUE); 
	if(filter==FILTER9button.FilterIndex) FILTER9button.SetSelected(TRUE); 
}
	