// swlpanel.h : header file
//
#include "stdafx.h"
#include "freqdisp.h"
#include "Scale.h"							// Sliding Log Scale Class
#include "slider.h"                         // Sliding Volume Control Class
#include "repbutto.h"                       // Repeating Button Class
#include "encoder.h"
#include "meter.h"
#include "tunesel.h"						// Tune Step Selection Dialog
#include "filterwn.h"
#include "filterbu.h"
#include "agcdlg.h"
#include "bistateb.h"
#include "dragit.h"
#include "filtcon.h"
#include "menubtn.h"
#include "PHbutton.h"

#ifndef _SWLPANEL_H_
#define _SWLPANEL_H_

/////////////////////////////////////////////////////////////////////////////
// CSwlPanel window

class CSwlPanel : public CWnd
{
// Construction
public:
	CSwlPanel();

// Attributes
public:

	double radio_freq,Old_Freq;
	double TuneStep;
	char Mode;	
	int volume;
	int m_FilterNumber;
	int outputpower;
	int rfgain;
	int m_AgcMode;
    double Opp_radio_freq;
    char OppMode;
	BOOL ManualTxActive;
	BOOL VoxActive;
	BOOL SpotActive;

	int m_Squelch;

	int RitFreq,XitFreq,BfoFreq,PbtFreq;
	int SqlLevel;
	CString AuxDisplayMode;	// Text to display when using auxillary display
	BOOL SqlActive,RitActive,XitActive,PbtActive;
	BOOL MuteActive, MonActive, TuneActive;
	BOOL bNRState,bANState,bSplitState;


	int MeterMode;

	BOOL bAttnState;

   	// repeating buttons
	//    CRepButton TRepButton;
    CRepButton RBFastUp;
    CRepButton RBUp;
    CRepButton RBFastDown;
    CRepButton RBDown;
	// ROTARY ENCODERS
	CEncoder MainEncoder;
	CEncoder OffsetEncoder;


    // Tune Selction Dialog
    CTuneSel	TuneStepDlg;

	// KNOBS
    CSlider LineSlider;
    CSlider SpeakerSlider;
    CSlider PowerSlider;
	CSlider RFGainSlider;
	CSlider SquelchSlider;
	CAgcDlg AgcSelectDialog;


    // STATIC DISPLAY BOXES
	CStatic VolumeLabelBox;
	CStatic MemBox;
	CStatic ModeBox;
	CStatic StepBox;
	CStatic OppModeBox;

	CStatic BandWidthBox;
	CStatic AgcModeBox;
	
	CStatic ModelLabelBox;
	CStatic SquelchLabelBox;
	CStatic RFGainLabelBox;
	CStatic LineLabelBox;
	CStatic LocalTimeBox;
	CStatic WorldTimeBox;
	CStatic WorldTimeLabel;
	CStatic LocalTimeLabel;
    CStatic PwrLabelBox;
	CStatic LOCKbox;

	CStatic RITBox;
	CStatic XITBox;
	CStatic PBTBox;
	CStatic SQLBox;

	CStatic RitDataBox;		
	CStatic XitDataBox;
	CStatic TimeBox;		// Time display box

	CButton Stepbutton0;
	CButton	Stepbutton1;			// embedded keypad buttons
	CButton	Stepbutton2;
	CButton	Stepbutton3;
	CButton	Stepbutton4;
	CButton	Stepbutton5;

	CButton ABSWAPbutton;
	CButton AEQBbutton;
	CBiStateButton XITbutton;
	CBiStateButton RITbutton;
	CButton BFObutton;
	CBiStateButton PBTbutton;
	CBiStateButton SQLbutton;

	CButton TB1button;
	CButton TB2button;


	CButton AUXONbutton;
	CButton AUXOFFbutton;
	CButton AUXCLRbutton;
	CPHButton REVbutton;
	

	CBiStateButton SPLITbutton;
	CBiStateButton LOCKbutton;

    CBiStateButton TUNEbutton;
	CBiStateButton NRbutton;
	CBiStateButton ANbutton;

	CBiStateButton REFMETERbutton;
	CBiStateButton SWRMETERbutton;
	CBiStateButton MANUALPTTbutton;
	CBiStateButton MONITORbutton;
	CButton SIDETONEbutton;
	CBiStateButton	ATTNbutton;
	
	CBiStateButton MUTEbutton;
	CBiStateButton VOXbutton;
	CBiStateButton SPOTbutton;


	CMenuBtn HamBandsButton;
	CMenuBtn FWDMETERbutton;
	CMenuBtn AGCbutton;


	CButton KEY0button;
	CButton	KEY1button;
    CButton KEY2button;
    CButton KEY3button;
    CButton KEY4button;
    CButton KEY5button;
    CButton KEY6button;
    CButton KEY7button;
    CButton KEY8button;
    CButton KEY9button;
	CButton KEYENTbutton;
    CButton KEYCLRbutton;
    CButton KEYKHZbutton;
    CButton KEYMHZbutton;





	CFreqDisplay 	FrequencyBox;
	CFreqDisplay 	FrequencyBox2;

	// Scale
	CScale FreqScale;

	//Drag-it boxes
	CDragit RitDataDragit;
	CDragit XitDataDragit;
	CDragit PbtDataDragit;


	// Filter Selection Box
	CFilterControl FilterPicBox;	


    // GLOBAL DRAWING OBJECT
	CBrush DisplayBackgroundBrush;
    CPen TextColorPen;
    CPen BackgroundColorPen;
	CBrush FrequencyDisplayBrush;

	CBiStateButton SAMbutton;
	CBiStateButton	AMbutton;
	CBiStateButton CWbutton;
	CBiStateButton USBbutton;
	CBiStateButton LSBbutton;
	CBiStateButton FMbutton;

	CButton RTTYbutton;



	CFilterButton FILTER1button;
	CFilterButton FILTER2button;
	CFilterButton FILTER3button;
	CFilterButton FILTER4button;
	CFilterButton FILTER5button;
	CFilterButton FILTER6button;
	CFilterButton FILTER7button;
	CFilterButton FILTER8button;
	CFilterButton FILTER9button;

	CButton ModeGroupButton;
	CButton FilterGroupButton;
	CButton StepGroupButton;
	CButton MemGroupButton;

	CButton BrandBox;

	CButton MemStorebutton;
	CButton MemRecallbutton;

	CButton MemOptionbutton;
	CButton MemTimebutton;

	CMeter	SigMeter;
	CMeter	FwdPwrMeter;
	
	CStatic TTIconBox1;
	CStatic TTIconBox2;

	BOOL PanelActive;

// Operations
public:
	int FilterBandwidth(int index);
	LRESULT CSwlPanel::OnSquelchChange(WPARAM wParam,LPARAM lParam);

	void CSwlPanel::OnRemoteNextStep();
	void CSwlPanel::OnRemoteNextTune();
	void CSwlPanel::OnRemoteNextMode();
	void CSwlPanel::OnRemoteSplitReverse();
	void CSwlPanel::OnRemoteSwapAB();

	void OnToggleSplit();
	void AuxTuneUp();
	void AuxTuneDown();
	void OnDblClickRIT();
	void SetAgcMode(int agcmode);
	void CSwlPanel::ToggleNoiseReduction();
	void CSwlPanel::ToggleAutoNotch();
	void CSwlPanel::ToggleVoxMode();

	void SelectAuxOn();
	void SelectAuxOff();
	void SelectAuxClr();
	void PositionTimeDisplay();
	void UpdateRitDisplayPanel();
	void UpdateXitDisplayPanel();
	void UpdatePbtDisplayPanel();


	void KeyTuneUp();
	void KeyTuneDown();
	void ShowFreq(double freq);
	void OnStep1Pressed();
	void OnStep2Pressed();
	void OnStep3Pressed();
	void OnStep4Pressed();
	void OnStep5Pressed();
	void OnStep1DblClicked();
	void SetFocusToParent();
    void SetFilter1();
    void SetFilter2();
    void SetFilter3();
    void SetFilter4();
    void SetFilter5();
    void SetFilter6();
    void SetFilter7();
    void SetFilter8();
    void SetFilter9();

	void OnAgcSlowSelect();
	void OnAgcFastSelect();
	void OnAgcMedSelect();


	void SetFilter(int Fn);


	void SetMeter_REF();
	void SetMeter_FWD();
	void SetMeter_SWR();


	void SetModeAM();
    void SetModeCW();
    void SetModeLSB();
    void SetModeUSB();
	void SetModeFM();
    void SetModeSAM();
	void DirectFrequency();
	void DirectFrequency2();

	void VfoAEQB();
	CString ModeCodeToString(char modecode);
	void UpdatePanelData(double NewFreq,char NewMode=NULL,double NewStep=NULL,int NewFilter=NULL,double NewOppFreq=NULL,char NewOppMode=NULL);
	void CSwlPanel::OnAttnToggle();


	void ShowQuickStepBox();
	void MuteRequest();
	void RFTuneRadio();
 	void ToggleTxMonitor();
	void ToggleEncoderLock();
	void ToggleManualTx();
	void ShowSideTone();
	void ToggleSpotMode();

	LRESULT OnRFGainChange(WPARAM wParam,LPARAM lParam);

	void OnSelect160Meters();
	void OnSelect80Meters();
	void OnSelect40Meters();
	void OnSelect30Meters();
	void OnSelect20Meters();
	void OnSelect17Meters();
	void OnSelect15Meters();
	void OnSelect12Meters();
	void OnSelect10Meters();
	
	afx_msg LRESULT OnEncoderMove(WPARAM nID,LPARAM direction);
	afx_msg LRESULT	ShowStepBox(WPARAM nID,LPARAM params);
	LRESULT OnClickToFrequency(WPARAM wParam,LPARAM lParam);
	LRESULT OnSlideToFrequency(WPARAM wParam,LPARAM lParam);
	LRESULT OnVolumeChange(WPARAM wParam,LPARAM lParam);
	void CSwlPanel::CheckFilterHighlite(int filter);

	void CSwlPanel::OnPHButtonUp();
	void CSwlPanel::OnPHButtonDown();
	void CSwlPanel::OnSelectHamBand(char BandIndex);


	afx_msg LRESULT OnRepeatButtonPressed(WPARAM nID,LPARAM direction);
 	void ProgTuneUp(double FreqDelta);
	void ProgTuneDown(double FreqDelta);
	afx_msg void OnChar(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnActivate( UINT nState, CWnd* pWndOther, BOOL bMinimized );

	double GetFrequency();
	char GetMode();
	char GetOppMode();
	double GetTuneStep();
	int GetFilter();
	void SetVolume(int vol);
	int GetVolume();	
	void ChangeNotifyParent();
	void AddStation();
	void OnMemRecall();
	void ShowStep(double step);
	void SetMute(BOOL bState);
	void TuneToWWV();
	void VfoSWAPAB();

	void SelectPbt();
	void SelectSql();
	void SelectBfo();
	void SelectRit();
	void SelectXit();
// Implementation
public:
	virtual ~CSwlPanel();

protected:
	// Generated message map functions
	//{{AFX_MSG(CSwlPanel)
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnClose();
	afx_msg HBRUSH OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor);
	afx_msg UINT OnNcHitTest(CPoint point);
	afx_msg int OnMouseActivate(CWnd* pDesktopWnd, UINT nHitTest, UINT message);
	afx_msg BOOL OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message);
	afx_msg void CSwlPanel::OnLButtonDown(UINT flags,CPoint point);

	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
#endif

/////////////////////////////////////////////////////////////////////////////
