// transops.cpp : implementation file

// Ten-Tec Graphic Interface Radio Control Program
// Pegasus Control GUI (c) 1999,2000 Ten-Tec Inc.
// The source code contained in this file and associated files is copyright Ten-Tec, Inc.


#include "stdafx.h"
#include "tttrx.h"
#include "transops.h"
#include "resource.h"
#include "slider.h"
#include "transops.h"



#define OPSEL_PREFERENCES 0
#define OPSEL_TRANSMIITER 1
#define OPSEL_CW 2
#define OPSEL_SSB	3
#define OPSEL_VOX	4
#define OPSEL_REMOTE 5
#define OPSEL_INTERFACE 6
#define OPSEL_AMSWL 15
#define OPSEL_AUX	16
#define OPSEL_RECEIVER	17

extern filter MasterFilterList_TX550[];
extern CTransOps TxOpsPanel;

extern CFont m_SmallFont;
extern CFont m_MicroFont;
extern int maxPort;
/////////////////////////////////////////////////////////////////////////////
// CTransOps

CTransOps::CTransOps()
{
SideToneFreq=700;
}

CTransOps::~CTransOps()
{
}

BEGIN_MESSAGE_MAP(CTransOps, CWnd)
	//{{AFX_MSG_MAP(CTransOps)
	ON_WM_CREATE()
	ON_WM_ERASEBKGND()
	ON_WM_MOUSEACTIVATE()
	ON_WM_CLOSE()
	ON_LBN_SELCHANGE(ID_SECTIONLIST_BOX,OnSelectionChanged)
	ON_WM_CTLCOLOR()
	ON_WM_ACTIVATE()
	ON_WM_NCHITTEST()
	ON_LBN_SELCHANGE(ID_TXFILTERLIST_BOX,OnTxFilterChanged)
	ON_LBN_SELCHANGE(ID_MUTELIST_BOX,ModifyNotify)
	ON_MESSAGE(ID_STVOLUME_SLIDER,OnSTVolumeChange)
	ON_MESSAGE(ID_CWSPOT_SLIDER,OnCWSpotVolumeChange)
	ON_MESSAGE(ID_CWQSK_SLIDER,OnCWQSKChange)

	ON_MESSAGE(ID_CWSPEED_SLIDER,OnCWSpeedChange)
	ON_MESSAGE(ID_CWWEIGHT_SLIDER,OnCWWeightChange)

	ON_MESSAGE(ID_MONVOLUME_SLIDER,OnMONVolumeChange)
	ON_MESSAGE(ID_POWERSLIDER,OnPowerChange)
	ON_MESSAGE(ID_VOXGAIN_SLIDER,OnVoxGainChange)
	ON_MESSAGE(ID_ANTIVOX_SLIDER,OnAntiVoxChange)
	ON_MESSAGE(ID_VOXDELAY_SLIDER,OnVoxHangChange)
	ON_MESSAGE(ID_MICGAIN_SLIDER,OnMicGainChange)
	ON_MESSAGE(ID_TXHANGSLIDER,OnTxHangChange)
	ON_BN_CLICKED(ID_OPSEL_TXLOOP,ModifyNotify)
	ON_BN_CLICKED(ID_OPSEL_TXENABLE,ModifyNotify)
	ON_BN_CLICKED(ID_OPSEL_MICAUDIO,ModifyNotify)
	ON_BN_CLICKED(ID_OPSEL_AUXAUDIO,ModifyNotify)
	ON_BN_CLICKED(ID_OPSEL_ENABLEKEYER,ModifyNotify)
	ON_BN_CLICKED(ID_OPSEL_POWERTUNE,TuneToggle)
    ON_LBN_SELCHANGE(ID_COMMPORTLIST_BOX,OnCommPortChange) 
	ON_EN_KILLFOCUS(ID_OPSEL_UTCH_BOX,ModifyNotify)
	ON_COMMAND(ID_OPSEL_STF_BOX,ModifyNotify)
	ON_COMMAND(ID_OPSEL_UTCH_BOX,ModifyNotify)
//	ON_WM_CHAR()
	//}}AFX_MSG_MAP 	//disabled
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTransOps message handlers


int CTransOps::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	TuneState=FALSE;

// Preferences Section Controls
	UTCLabel.Create("Local/UTC Correction:",SS_LEFT|WS_CHILD,CRect(110,20,250,45),this);	
	UTCLabel.SetFont(&m_SmallFont);
	UTCHoursEdit.Create(WS_BORDER|WS_CHILD,CRect(260,20,310,40),this,ID_OPSEL_UTCH_BOX);
	UTCHoursEdit.SetFont(&m_SmallFont);
	MuteOptionsLabel.Create("Mute Radio On Exit?",SS_LEFT|WS_CHILD,CRect(110,50,250,70),this);
	MuteOptionsLabel.SetFont(&m_SmallFont);
	MuteOptionsListBox.Create(WS_BORDER|WS_CHILD|WS_VISIBLE|CBS_DROPDOWNLIST,CRect(260,50,340,220),this,ID_MUTELIST_BOX);
	MuteOptionsListBox.AddString("Always");
	MuteOptionsListBox.AddString("Never");
	MuteOptionsListBox.AddString("Ask");
	MuteOptionsListBox.SetFont(&m_SmallFont);

	HamCallPathLabel.Create("HamCall Drive Letter or Path",SS_LEFT|WS_CHILD,CRect(110,90,250,110),this);
	HamCallPathLabel.SetFont(&m_SmallFont);
	HamCallPathEditBox.Create(WS_BORDER|WS_CHILD,CRect(110,120,310,140),this,ID_OPSEL_HAMCALLPATH);

	SweepMuteCheckBox.Create("Mute Audio During Frequency Sweep", WS_GROUP|WS_CHILD|WS_VISIBLE|BS_AUTOCHECKBOX , CRect(110,160,340,180),this, ID_OPSEL_SWEEPMUTE);
    SweepMuteCheckBox.SetCheck(1);
	SweepMuteCheckBox.SetFont(&m_SmallFont);

// Transmitter Section Controls

	CRect PwrRect(335,45,365,180);
	PowerSlider.Create(PwrRect,this,ID_POWERSLIDER,18);
	PowerSlider.SetSliderLimits(0,255);
    PowerSlider.SetSliderPos(0);
	PowerTune.Create("Tune",WS_CHILD|WS_VISIBLE|BS_OWNERDRAW,CRect(330,188,372,208),this, ID_OPSEL_POWERTUNE);
	PowerTune.SetSelectedColor(RGB(255,0,0));
	PowerTune.SetFont(&m_SmallFont);
	ForwardPowerLabel.Create("----",SS_CENTER|WS_CHILD,CRect(330,215,372,230),this,ID_OPSEL_FORWARDPOWER);	
	ForwardPowerLabel.SetFont(&m_SmallFont);

	TXPowerLabel.Create("Output\tPower",SS_CENTER|WS_CHILD,CRect(320,10,380,45),this);	
	TXPowerLabel.SetFont(&m_SmallFont);
	TxControlsLabel.Create("Transmitter Control",SS_LEFT|WS_CHILD,CRect(130,10,280,25),this);
	TxControlsLabel.SetFont(&m_SmallFont);
	TxLoopCheckBox.Create("Enable Keying Loop", WS_CHILD|WS_VISIBLE|BS_AUTOCHECKBOX , CRect(130,40,280,60),this, ID_OPSEL_TXLOOP );
	TxLoopCheckBox.SetFont(&m_SmallFont);
	TxEnableCheckBox.Create("Enable Transmitter", WS_CHILD|WS_VISIBLE|BS_AUTOCHECKBOX , CRect(130,65,280,85),this, ID_OPSEL_TXENABLE );
	TxEnableCheckBox.SetCheck(1);
	TxEnableCheckBox.SetFont(&m_SmallFont);
	TxAudioSourceLabel.Create("Transmit Audio Source",SS_LEFT|WS_CHILD,CRect(130,100,280,115),this);	
	TxAudioSourceLabel.SetFont(&m_SmallFont);
	TxMicAudioCheckBox.Create("Microphone Input", WS_GROUP|WS_CHILD|WS_VISIBLE|BS_AUTORADIOBUTTON , CRect(130,120,280,135),this, ID_OPSEL_MICAUDIO);
	TxMicAudioCheckBox.SetFont(&m_SmallFont);
	TxAuxAudioCheckBox.Create("Accessory Input", WS_CHILD|WS_VISIBLE|BS_AUTORADIOBUTTON , CRect(130,140,280,155),this, ID_OPSEL_AUXAUDIO);
	TxAuxAudioCheckBox.SetFont(&m_SmallFont);


	CRect TxHangRect(280,45,310,180);
	TxHangSlider.Create(TxHangRect,this,ID_TXHANGSLIDER,0);
	TxHangSlider.SetSliderLimits(0,255);
    TxHangSlider.SetSliderPos(0);
	TxHangLabel.Create("Ext-T/R\tDelay",SS_CENTER|WS_CHILD,CRect(270,10,320,45),this);	
	TxHangLabel.SetFont(&m_SmallFont);

	

// CW Section Controls

	CRect VSRect(120,45,150,180);
	STVolumeSlider.Create(VSRect,this,ID_STVOLUME_SLIDER,18);
	STVolumeSlider.SetSliderLimits(0,255);
    STVolumeSlider.SetSliderPos(20);
	STVolLabel.Create("S.T.\r\nVol",SS_CENTER|WS_CHILD,CRect(120,10,150,40),this);	
	STVolLabel.SetFont(&m_SmallFont);

	CRect CWSpotRect(165,45,195,180);
	CWSpotSlider.Create(CWSpotRect,this,ID_CWSPOT_SLIDER,1);
	CWSpotSlider.SetSliderLimits(0,100);
    CWSpotSlider.SetSliderPos(20);
	CWSpotLabel.Create("Spot\r\nVol",SS_CENTER|WS_CHILD,CRect(165,10,195,40),this);	
	CWSpotLabel.SetFont(&m_SmallFont);

	CRect CWQskRect(235,45,265,180);
	CWQskSlider.Create(CWQskRect,this,ID_CWQSK_SLIDER,1);
	CWQskSlider.SetSliderLimits(0,127);
    CWQskSlider.SetSliderPos(20);
	CWQskLabel.Create("CW\r\nQsk",SS_CENTER|WS_CHILD,CRect(235,10,265,40),this);	
	CWQskLabel.SetFont(&m_SmallFont);

	CRect CWSpdRect(280,45,310,180);
	CWSpdSlider.Create(CWSpdRect,this,ID_CWSPEED_SLIDER,1);
	CWSpdSlider.SetSliderLimits(0,50);
    CWSpdSlider.SetSliderPos(20);
	CWSpdLabel.Create("Key\r\nSpd",SS_CENTER|WS_CHILD,CRect(280,10,310,40),this);	
	CWSpdLabel.SetFont(&m_SmallFont);

	CRect CWWtRect(325,45,355,180);
	CWWtSlider.Create(CWWtRect,this,ID_CWWEIGHT_SLIDER,1);
	CWWtSlider.SetSliderLimits(0,60);
    CWWtSlider.SetSliderPos(30);
	CWWtLabel.Create("Key\r\nWght",SS_CENTER|WS_CHILD,CRect(325,10,355,40),this);	
	CWWtLabel.SetFont(&m_SmallFont);


   
	CRect stbCRect(140,220,170,240);
	STFBox.Create(WS_BORDER|WS_CHILD,stbCRect,this,ID_OPSEL_STF_BOX);
	STFBox.SetWindowText("700");
	STFBox.SetFont(&m_SmallFont);
	STFLabel.Create("Sidetone(Hz)",SS_LEFT|WS_CHILD,CRect(120,200,200,220),this);	
	STFLabel.SetFont(&m_SmallFont);

	EnableKeyerCheckBox.Create("Enable Keyer", WS_GROUP|WS_CHILD|WS_VISIBLE|BS_AUTOCHECKBOX , CRect(270,210,370,230),this, ID_OPSEL_ENABLEKEYER);
    EnableKeyerCheckBox.SetCheck(0);
	EnableKeyerCheckBox.SetFont(&m_SmallFont);


// Sideband Section Controls
	CRect MONRect(245,45,275,180);
	MONVolumeSlider.Create(MONRect,this,ID_MONVOLUME_SLIDER,18);
	MONVolumeSlider.SetSliderLimits(0,63);
    MONVolumeSlider.SetSliderPos(0);
	MONVolLabel.Create("Monitor\tVolume",SS_CENTER|WS_CHILD,CRect(230,10,290,40),this);	
	MONVolLabel.SetFont(&m_SmallFont);
	CRect MICRect(315,45,345,180);
	MICGainSlider.Create(MICRect,this,ID_MICGAIN_SLIDER,15);
	MICGainSlider.SetSliderLimits(0,15);
    MICGainSlider.SetSliderPos(0);
	MICGainLabel.Create("Mic\tGain",SS_CENTER|WS_CHILD,CRect(300,10,360,40),this);	
	MICGainLabel.SetFont(&m_SmallFont);
	TxFilterLabel.Create("Transmit Filter",SS_LEFT|WS_CHILD,CRect(110,20,210,40),this);
	TxFilterLabel.SetFont(&m_SmallFont);
	TxFilterListBox.Create(WS_VSCROLL|WS_BORDER|WS_CHILD|WS_VISIBLE|CBS_DROPDOWNLIST,CRect(110,45,210,200),this,ID_TXFILTERLIST_BOX);
	TxFilterListBox.SetFont(&m_SmallFont);
	TxFilterListBox.SetItemData(TxFilterListBox.AddString(MasterFilterList_TX550[9].name),9);
	TxFilterListBox.SetItemData(TxFilterListBox.AddString(MasterFilterList_TX550[10].name),10);
	TxFilterListBox.SetItemData(TxFilterListBox.AddString(MasterFilterList_TX550[11].name),11);
	TxFilterListBox.SetItemData(TxFilterListBox.AddString(MasterFilterList_TX550[12].name),12);
	TxFilterListBox.SetItemData(TxFilterListBox.AddString(MasterFilterList_TX550[13].name),13);
	TxFilterListBox.SetItemData(TxFilterListBox.AddString(MasterFilterList_TX550[14].name),14);
	TxFilterListBox.SetItemData(TxFilterListBox.AddString(MasterFilterList_TX550[15].name),15);
	TxFilterListBox.SetItemData(TxFilterListBox.AddString(MasterFilterList_TX550[16].name),16);
	TxFilterListBox.SetItemData(TxFilterListBox.AddString(MasterFilterList_TX550[17].name),17);
	TxFilterListBox.SetItemData(TxFilterListBox.AddString(MasterFilterList_TX550[18].name),18);
	TxFilterListBox.SetItemData(TxFilterListBox.AddString(MasterFilterList_TX550[19].name),19);

	TxFilterListBox.SetItemData(TxFilterListBox.AddString(MasterFilterList_TX550[20].name),20);
	TxFilterListBox.SetItemData(TxFilterListBox.AddString(MasterFilterList_TX550[21].name),21);
	TxFilterListBox.SetItemData(TxFilterListBox.AddString(MasterFilterList_TX550[22].name),22);
	TxFilterListBox.SetItemData(TxFilterListBox.AddString(MasterFilterList_TX550[23].name),23);
	TxFilterListBox.SetItemData(TxFilterListBox.AddString(MasterFilterList_TX550[24].name),24);
	TxFilterListBox.SetItemData(TxFilterListBox.AddString(MasterFilterList_TX550[25].name),25);
	TxFilterListBox.SetItemData(TxFilterListBox.AddString(MasterFilterList_TX550[26].name),26);


// AM-SWL Settings




// VOX Settings
	
	VoxGainSlider.Create(CRect(175,45,205,180),this,ID_VOXGAIN_SLIDER,18);
	VoxGainSlider.SetSliderLimits(0,32);
    VoxGainSlider.SetSliderPos(20);
	VoxGainLabel.Create("Vox\tGain",SS_CENTER|WS_CHILD,CRect(160,10,220,40),this);	
    VoxGainLabel.SetFont(&m_SmallFont);
	AntiVoxSlider.Create(CRect(245,45,275,180),this,ID_ANTIVOX_SLIDER,18);
	AntiVoxSlider.SetSliderLimits(0,255);
    AntiVoxSlider.SetSliderPos(20);
	AntiVoxLabel.Create("Anti\tVox",SS_CENTER|WS_CHILD,CRect(240,10,280,40),this);	
	AntiVoxLabel.SetFont(&m_SmallFont);
	VoxDelaySlider.Create(CRect(315,45,345,180),this,ID_VOXDELAY_SLIDER,18);
	VoxDelaySlider.SetSliderLimits(0,32);
    VoxDelaySlider.SetSliderPos(20);
	VoxDelayLabel.Create("Vox\tDelay",SS_CENTER|WS_CHILD,CRect(300,10,360,40),this);	
	VoxDelayLabel.SetFont(&m_SmallFont);
// Remote POD Section 



	FKeyOneLabel.Create("Function Key 1",SS_LEFT|WS_CHILD,CRect(110,25,200,40),this);
	FKeyOneLabel.SetFont(&m_SmallFont);
	FKeyOneBox.Create(WS_BORDER|WS_CHILD|WS_VISIBLE|CBS_DROPDOWNLIST,CRect(200,20,360,220),this,ID_FUNCTIONKEY1_BOX);
	FKeyOneBox.SetFont(&m_SmallFont);

	FKeyOneBox.SetItemData(FKeyOneBox.AddString("Tuning Steps"),ID_REMOTENEXTSTEP );
	FKeyOneBox.SetItemData(FKeyOneBox.AddString("Tuning Selections"),ID_REMOTENEXTTUNE);
	FKeyOneBox.SetItemData(FKeyOneBox.AddString("Mode Selections"),ID_REMOTENEXTMODE);
	FKeyOneBox.SetItemData(FKeyOneBox.AddString("Split Reverse"),ID_REMOTESPLITREVERSE);
	FKeyOneBox.SetItemData(FKeyOneBox.AddString("A/B Toggle"),ID_REMOTESWAPAB);

	FKeyTwoLabel.Create("Function Key 2",SS_LEFT|WS_CHILD,CRect(110,60,200,75),this);
	FKeyTwoLabel.SetFont(&m_SmallFont);
	FKeyTwoBox.Create(WS_BORDER|WS_CHILD|WS_VISIBLE|CBS_DROPDOWNLIST,CRect(200,60,360,220),this,ID_FUNCTIONKEY1_BOX);
	FKeyTwoBox.SetFont(&m_SmallFont);

	FKeyTwoBox.SetItemData(FKeyTwoBox.AddString("Tuning Steps"), ID_REMOTENEXTSTEP);
	FKeyTwoBox.SetItemData(FKeyTwoBox.AddString("Tuning Selections"),ID_REMOTENEXTTUNE);
	FKeyTwoBox.SetItemData(FKeyTwoBox.AddString("Mode Selections"),ID_REMOTENEXTMODE);
	FKeyTwoBox.SetItemData(FKeyTwoBox.AddString("Split Reverse"),ID_REMOTESPLITREVERSE);
	FKeyTwoBox.SetItemData(FKeyTwoBox.AddString("A/B Toggle"),ID_REMOTESWAPAB);

	FKeyThreeLabel.Create("Function Key 3",SS_LEFT|WS_CHILD,CRect(110,95,200,110),this);
	FKeyThreeLabel.SetFont(&m_SmallFont);
	FKeyThreeBox.Create(WS_BORDER|WS_CHILD|WS_VISIBLE|CBS_DROPDOWNLIST,CRect(200,95,360,220),this,ID_FUNCTIONKEY1_BOX);
	FKeyThreeBox.SetFont(&m_SmallFont);

	FKeyThreeBox.SetItemData(FKeyThreeBox.AddString("Tuning Steps"), ID_REMOTENEXTSTEP);
	FKeyThreeBox.SetItemData(FKeyThreeBox.AddString("Tuning Selections"),ID_REMOTENEXTTUNE);
	FKeyThreeBox.SetItemData(FKeyThreeBox.AddString("Mode Selections"),ID_REMOTENEXTMODE);
	FKeyThreeBox.SetItemData(FKeyThreeBox.AddString("Split Reverse"),ID_REMOTESPLITREVERSE);
	FKeyThreeBox.SetItemData(FKeyThreeBox.AddString("A/B Toggle"),ID_REMOTESWAPAB);

// Interface Section Settings

	ComPortLabel.Create("Radio Port", SS_LEFT|WS_CHILD, CRect(160,10,300,40),this);
	ComPortLabel.SetFont(&m_SmallFont);
	CommPortListBox.Create(WS_VSCROLL|WS_BORDER|WS_CHILD|WS_VISIBLE|LBS_STANDARD,CRect(110,45,270,150),this,ID_COMMPORTLIST_BOX);
		


////  GENERAL CONTROLS APPLIED TO ALL SUB-CONTROLS


	NoAssignmentLabel.Create("No Controls Assigned",SS_CENTER|WS_CHILD,CRect(175,100,300,150),this);	

	CRect slbCRect(5,20,100,180);
	SectionListBox.Create(WS_BORDER|WS_CHILD|WS_VISIBLE|LBS_NOTIFY|LBS_DISABLENOSCROLL,slbCRect,this,ID_SECTIONLIST_BOX);
	SectionListBox.SetFont(&m_SmallFont);
	SectionListBox.AddString("Preferences");
//	SectionListBox.AddString("Receiver");
	SectionListBox.AddString("Transmitter");
//	SectionListBox.AddString("AM Settings");
	SectionListBox.AddString("CW Settings");
	SectionListBox.AddString("SSB Settings");
//	SectionListBox.AddString("Aux Controls");
	SectionListBox.AddString("Vox Controls");
	SectionListBox.AddString("Remote Pod");
	SectionListBox.AddString("Interface");
	SectionListBox.SetCurSel(0);
	SetVisibleSelections(0);
	return 0;
}

afx_msg void CTransOps::SetVisibleSelections(int choice)
{

// Hide Everything First.
	STVolumeSlider.ShowWindow(SW_HIDE);
	MONVolumeSlider.ShowWindow(SW_HIDE);
	MICGainSlider.ShowWindow(SW_HIDE);
	PowerSlider.ShowWindow(SW_HIDE);

	STFBox.ShowWindow(SW_HIDE);	
	UTCHoursEdit.ShowWindow(SW_HIDE);
	UTCLabel.ShowWindow(SW_HIDE);	

	MONVolLabel.ShowWindow(SW_HIDE);
	STVolLabel.ShowWindow(SW_HIDE);
	STFLabel.ShowWindow(SW_HIDE);

	HamCallPathLabel.ShowWindow(SW_HIDE);
	HamCallPathEditBox.ShowWindow(SW_HIDE);

	SweepMuteCheckBox.ShowWindow(SW_HIDE);

	CWSpdSlider.ShowWindow(SW_HIDE);
	CWSpdLabel.ShowWindow(SW_HIDE);
	EnableKeyerCheckBox.ShowWindow(SW_HIDE);
	CWSpotSlider.ShowWindow(SW_HIDE);
	CWSpotLabel.ShowWindow(SW_HIDE);
	CWWtLabel.ShowWindow(SW_HIDE);
	CWWtSlider.ShowWindow(SW_HIDE);
	CWQskLabel.ShowWindow(SW_HIDE);
	CWQskSlider.ShowWindow(SW_HIDE);


	MICGainLabel.ShowWindow(SW_HIDE);
	MuteOptionsListBox.ShowWindow(SW_HIDE);
	MuteOptionsLabel.ShowWindow(SW_HIDE);
	TXPowerLabel.ShowWindow(SW_HIDE);
	TxLoopCheckBox.ShowWindow(SW_HIDE);
	TxEnableCheckBox.ShowWindow(SW_HIDE);
	TxFilterLabel.ShowWindow(SW_HIDE);
	TxFilterListBox.ShowWindow(SW_HIDE);
	TxAuxAudioCheckBox.ShowWindow(SW_HIDE);
	TxMicAudioCheckBox.ShowWindow(SW_HIDE);	
    PowerTune.ShowWindow(SW_HIDE);
	ForwardPowerLabel.ShowWindow(SW_HIDE);
	TxAudioSourceLabel.ShowWindow(SW_HIDE);
	TxControlsLabel.ShowWindow(SW_HIDE);    
	TxHangSlider.ShowWindow(SW_HIDE);
	TxHangLabel.ShowWindow(SW_HIDE);


	AntiVoxSlider.ShowWindow(SW_HIDE);
	AntiVoxLabel.ShowWindow(SW_HIDE);
	VoxDelaySlider.ShowWindow(SW_HIDE);
	VoxDelayLabel.ShowWindow(SW_HIDE);
	VoxGainSlider.ShowWindow(SW_HIDE);
	VoxGainLabel.ShowWindow(SW_HIDE);

	FKeyOneLabel.ShowWindow(SW_HIDE);
	FKeyOneBox.ShowWindow(SW_HIDE);

	FKeyTwoLabel.ShowWindow(SW_HIDE);
	FKeyTwoBox.ShowWindow(SW_HIDE);

	FKeyThreeLabel.ShowWindow(SW_HIDE);
	FKeyThreeBox.ShowWindow(SW_HIDE);

	Com1CheckBox.ShowWindow(SW_HIDE);
	Com2CheckBox.ShowWindow(SW_HIDE);
	Com3CheckBox.ShowWindow(SW_HIDE);
	Com4CheckBox.ShowWindow(SW_HIDE);

	CommPortListBox.ShowWindow(SW_HIDE);
	ComPortLabel.ShowWindow(SW_HIDE);
	NoAssignmentLabel.ShowWindow(SW_HIDE);

switch(choice)
{
case OPSEL_PREFERENCES: 
	UTCHoursEdit.ShowWindow(SW_SHOW);
	UTCLabel.ShowWindow(SW_SHOW);	
	MuteOptionsListBox.ShowWindow(SW_SHOW);
	MuteOptionsLabel.ShowWindow(SW_SHOW);
	HamCallPathLabel.ShowWindow(SW_SHOW);
	HamCallPathEditBox.ShowWindow(SW_SHOW);
	SweepMuteCheckBox.ShowWindow(SW_SHOW);
	break;
	
case OPSEL_RECEIVER: 
	NoAssignmentLabel.ShowWindow(SW_SHOW);
	break;
case OPSEL_TRANSMIITER: 
	PowerSlider.ShowWindow(SW_SHOW);
	TXPowerLabel.ShowWindow(SW_SHOW);
	TxLoopCheckBox.ShowWindow(SW_SHOW);
	TxEnableCheckBox.ShowWindow(SW_SHOW);
	TxAuxAudioCheckBox.ShowWindow(SW_SHOW);
	TxMicAudioCheckBox.ShowWindow(SW_SHOW);	
    PowerTune.ShowWindow(SW_SHOW);
	ForwardPowerLabel.ShowWindow(SW_SHOW);
	TxAudioSourceLabel.ShowWindow(SW_SHOW);
	TxControlsLabel.ShowWindow(SW_SHOW);    
	TxHangSlider.ShowWindow(SW_SHOW);
	TxHangLabel.ShowWindow(SW_SHOW);

	break;
case OPSEL_AMSWL: 
	NoAssignmentLabel.ShowWindow(SW_SHOW);
	break;
case OPSEL_CW:
	STVolumeSlider.ShowWindow(SW_SHOW);
	STFBox.ShowWindow(SW_SHOW);	
	STVolLabel.ShowWindow(SW_SHOW);
	STFLabel.ShowWindow(SW_SHOW);
	CWSpdSlider.ShowWindow(SW_SHOW);
	CWSpdLabel.ShowWindow(SW_SHOW);
	CWSpotSlider.ShowWindow(SW_SHOW);
	CWSpotLabel.ShowWindow(SW_SHOW);
	CWWtSlider.ShowWindow(SW_SHOW);
	CWWtLabel.ShowWindow(SW_SHOW);
	CWQskSlider.ShowWindow(SW_SHOW);
	CWQskLabel.ShowWindow(SW_SHOW);

	EnableKeyerCheckBox.ShowWindow(SW_SHOW);

 	break;
case OPSEL_SSB:
	MONVolumeSlider.ShowWindow(SW_SHOW);
	MICGainSlider.ShowWindow(SW_SHOW);
	MICGainLabel.ShowWindow(SW_SHOW);
	MONVolLabel.ShowWindow(SW_SHOW);
	TxFilterLabel.ShowWindow(SW_SHOW);
	TxFilterListBox.ShowWindow(SW_SHOW);

	break;
case OPSEL_AUX:
	NoAssignmentLabel.ShowWindow(SW_SHOW);


	break;
case OPSEL_VOX:
	AntiVoxSlider.ShowWindow(SW_SHOW);
	AntiVoxLabel.ShowWindow(SW_SHOW);
	VoxDelaySlider.ShowWindow(SW_SHOW);
	VoxDelayLabel.ShowWindow(SW_SHOW);
	VoxGainSlider.ShowWindow(SW_SHOW);
	VoxGainLabel.ShowWindow(SW_SHOW);
	break;

case OPSEL_REMOTE:
//	NoAssignmentLabel.ShowWindow(SW_SHOW);

	FKeyOneLabel.ShowWindow(SW_SHOW);
	FKeyOneBox.ShowWindow(SW_SHOW);
	FKeyTwoLabel.ShowWindow(SW_SHOW);
	FKeyTwoBox.ShowWindow(SW_SHOW);
	FKeyThreeLabel.ShowWindow(SW_SHOW);
	FKeyThreeBox.ShowWindow(SW_SHOW);

	break;	



case OPSEL_INTERFACE: 
	ComPortLabel.ShowWindow(SW_SHOW);
	CommPortListBox.ShowWindow(SW_SHOW);

	break;

}

}





BOOL CTransOps::OnEraseBkgnd(CDC* pDC)
{
	CBrush* pOldBrush=(CBrush*) pDC->SelectStockObject(LTGRAY_BRUSH);
	CPen* pOldPen=(CPen*) pDC->SelectStockObject(NULL_PEN);

	CBrush brushDarkGray(RGB(192,192,192));


	pDC->SetBkMode(OPAQUE);
	pDC->SetBkColor(RGB(192,192,192));

// get the area that needs to be erased
	CRect rcClip;									
	GetClientRect(rcClip);


// Fill client area witrh solid color first

	pDC->FillRect(rcClip,(CBrush*) pDC->SelectStockObject(LTGRAY_BRUSH));
	pDC->FillRect(rcClip,(CBrush*) pDC->SelectStockObject(LTGRAY_BRUSH));


	CRect boxRect(105,5,rcClip.right-5,rcClip.bottom-5);


	pDC->FrameRect( boxRect, (CBrush*) pDC->SelectStockObject(BLACK_BRUSH) );
	pDC->FrameRect( boxRect, (CBrush*) pDC->SelectStockObject(BLACK_BRUSH) );



// Unselect brush out of device context

pDC->SelectObject(pOldBrush);
pDC->SelectObject(pOldPen);

return TRUE;	
	
}

int CTransOps::OnMouseActivate(CWnd* pDesktopWnd, UINT nHitTest, UINT message)
{
	BringWindowToTop();
	SetFocusToParent();	
	return TRUE;	
}


void CTransOps::OnCloseTxOps()
{
ShowWindow(SW_HIDE);
}

void CTransOps::OnClose()
{
	// TODO: Add your message handler code here and/or call default
ShowWindow(SW_HIDE);
	
//	CWnd::OnClose();
}

void CTransOps::SideToneFreqUp()
{
	SideToneFreq+=10;
	if (SideToneFreq>1500) SideToneFreq=1500;
}

void CTransOps::SideToneFreqDn()
{
	SideToneFreq-=10;
	if (SideToneFreq<400) SideToneFreq=400;
}
        


        
void CTransOps::ChangeNotifyParent()
{
 GetParent()->SendMessage(WM_COMMAND,ID_TXOPS_PANEL,(LPARAM) 0);
}

LRESULT CTransOps::OnSTVolumeChange(WPARAM wParam,LPARAM lParam)
{

	ChangeNotifyParent();
	return 0;
}

LRESULT CTransOps::OnCWSpotVolumeChange(WPARAM wParam,LPARAM lParam)
{

	ChangeNotifyParent();
	return 0;
}

LRESULT CTransOps::OnCWQSKChange(WPARAM wParam,LPARAM lParam)
{
	ChangeNotifyParent();
	return 0;
}

LRESULT CTransOps::OnCWSpeedChange(WPARAM wParam,LPARAM lParam)
{
	ChangeNotifyParent();
	return 0;
}


LRESULT CTransOps::OnMONVolumeChange(WPARAM wParam,LPARAM lParam)
{
	ChangeNotifyParent();
	return 0;

}

LRESULT CTransOps::OnCWWeightChange(WPARAM wParam,LPARAM lParam)
{
	ChangeNotifyParent();
	return 0;
}


afx_msg void CTransOps::OnSelectionChanged()
{

SetVisibleSelections(SectionListBox.GetCurSel());
}

afx_msg void CTransOps::OnTxFilterChanged()
{
TxFilter=(int)TxFilterListBox.GetItemData(TxFilterListBox.GetCurSel());
TRACE("TXOPS FILTER = %d\n",TxFilter);
ChangeNotifyParent();
}


        
HBRUSH CTransOps::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor)
{
	pDC->SetBkMode(TRANSPARENT);

 if(nCtlColor==CTLCOLOR_STATIC||nCtlColor==CTLCOLOR_BTN)
    {
		pDC->SetTextColor(RGB(0,0,0));
		return (HBRUSH) GetStockObject(LTGRAY_BRUSH);
    }
	
	
	return CWnd::OnCtlColor(pDC, pWnd, nCtlColor);
}



LRESULT CTransOps::OnPowerChange(WPARAM wParam,LPARAM lParam)
{
	outputpower=PowerSlider.GetSetting();
	ChangeNotifyParent();
	return 0;
}



LRESULT CTransOps::OnVoxGainChange(WPARAM wParam,LPARAM lParam)
{
	VoxGain=VoxGainSlider.GetSetting();
	ChangeNotifyParent();
return 0;
}

LRESULT CTransOps::OnAntiVoxChange(WPARAM wParam,LPARAM lParam)
{
	AntiVox=AntiVoxSlider.GetSetting();
	ChangeNotifyParent();
return 0;
}

LRESULT CTransOps::OnVoxHangChange(WPARAM wParam,LPARAM lParam)
{
	VoxHang=VoxDelaySlider.GetSetting();
	ChangeNotifyParent();
return 0;
}

LRESULT CTransOps::OnMicGainChange(WPARAM wParam,LPARAM lParam)
{
	ChangeNotifyParent();
return 0;
}

LRESULT CTransOps::OnTxHangChange(WPARAM wParam,LPARAM lParam)
{
	ChangeNotifyParent();
return 0;
}



int CTransOps::GetPowerSetting()
{

	return (PowerSlider.GetSetting());
}

void CTransOps::SetPowerSetting(int power)
{
	PowerSlider.SetSliderPos(power);	
	outputpower=PowerSlider.GetSetting();


}

void CTransOps::SetKeyerSetting(int speed)
{
	CWSpdSlider.SetSliderPos(speed);
	KeyerSpeed=speed;
}

void CTransOps::SetSTVolumeSetting(int vol)
{
	STVolumeSlider.SetSliderPos(vol);
	STVolume=vol;	
}

int CTransOps::GetSTVolumeSetting()
{
	return(STVolumeSlider.GetSetting());
}

void CTransOps::SetCWSpotVolumeSetting(int vol)
{
	CWSpotSlider.SetSliderPos(vol);
	SpotVolume=vol;	
}

int CTransOps::GetCWSpotVolumeSetting()
{
	return(CWSpotSlider.GetSetting());
}


void CTransOps::SetKeyerWeightSetting(int wt)
{
	CWWtSlider.SetSliderPos(wt-70);
	KeyerWeight=wt;	
}

int CTransOps::GetKeyerWeightSetting()
{
	return(CWWtSlider.GetSetting()+70);
}





afx_msg void CTransOps::ModifyNotify()
{
ChangeNotifyParent();
}

void CTransOps::OnActivate(UINT nState, CWnd* pWndOther, BOOL bMinimized)
{
 	if(nState==WA_ACTIVE | nState==WA_CLICKACTIVE) BringWindowToTop();
	SetFocusToParent();	
	
}


void CTransOps::SetFocusToParent()
{
	GetParent()->SetFocus();
    return;
}   

UINT CTransOps::OnNcHitTest(CPoint point)
{
	UINT nHitTest = CWnd::OnNcHitTest(point);	
	if(nHitTest==HTCLIENT)
		{
		return(HTCAPTION);
		}
	return (nHitTest);
}


void CTransOps::TuneToggle()
{
if(PowerTune.GetSelected())
{
	PowerTune.SetSelected(FALSE);
	TuneState=FALSE;
}
else
{
	PowerTune.SetSelected(TRUE);
	TuneState=TRUE;
}
ChangeNotifyParent();
}
	
	
		
	
int CTransOps::GetCommPortCount()
{

return maxPort;
}

afx_msg void CTransOps::OnCommPortChange()
{
CommPortListBox.GetText( CommPortListBox.GetCurSel(), CommPortString );
ModifyNotify();
}

void CTransOps::SetSelectedCommPort(CString portStr)
{
CommPortString=portStr;
if(CommPortListBox.SelectString(-1, CommPortString )==LB_ERR)
	{
	CommPortListBox.SetCurSel(0);	
	CommPortListBox.GetText( 0, CommPortString );
	}

}


afx_msg void CTransOps::OnSTFreqChange()
{
ModifyNotify();
}

	
void CTransOps::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags)
{
		MessageBox("RETURN PRESSED");
	CWnd::OnChar(nChar, nRepCnt, nFlags);
}


void CTransOps::LoadComListBox(int ports)
{
	int max=ports;
	int cnt;
	char temp[32];
	for(cnt=1;cnt<max+1;cnt++){
		sprintf(temp,"COM%d",cnt);
		CommPortListBox.AddString(temp); 
		}
}
