// transops.h : header file
//

#include "encoder.h"
#include "tttrx.h"
#include "slider.h"                         // Sliding Volume Control Class
#include "bistateb.h"
#include "cspc_ed.h"
#include "cnum_ed.h"

#ifndef _TRANSOPS_H_
#define _TRANSOPS_H_


/////////////////////////////////////////////////////////////////////////////
// CTransOps window

class CTransOps : public CWnd
{
// Construction
public:
	CTransOps();
	void OnCloseTxOps();
	void SideToneFreqDn();
	void SideToneFreqUp();
	void ChangeNotifyParent();
	void TuneToggle();
	void SetPowerSetting(int power);
	int CTransOps::GetCommPortCount();
	afx_msg void CTransOps::OnCommPortChange();
	void CTransOps::SetSelectedCommPort(CString portStr);
	afx_msg void CTransOps::OnSTFreqChange();

	afx_msg void ModifyNotify();
	LRESULT OnSTVolumeChange(WPARAM wParam,LPARAM lParam);
	LRESULT OnMONVolumeChange(WPARAM wParam,LPARAM lParam);
	LRESULT OnPowerChange(WPARAM wParam,LPARAM lParam);
	LRESULT CTransOps::OnVoxGainChange(WPARAM wParam,LPARAM lParam);
	LRESULT CTransOps::OnAntiVoxChange(WPARAM wParam,LPARAM lParam);
	LRESULT CTransOps::OnVoxHangChange(WPARAM wParam,LPARAM lParam);
	LRESULT CTransOps::OnMicGainChange(WPARAM wParam,LPARAM lParam);
	LRESULT CTransOps::OnCWSpeedChange(WPARAM wParam,LPARAM lParam);
	LRESULT CTransOps::OnTxHangChange(WPARAM wParam,LPARAM lParam);
	LRESULT CTransOps::OnCWSpotVolumeChange(WPARAM wParam,LPARAM lParam);
	LRESULT CTransOps::OnCWWeightChange(WPARAM wParam,LPARAM lParam);
	LRESULT CTransOps::OnCWQSKChange(WPARAM wParam,LPARAM lParam);

	void CTransOps::SetKeyerSetting(int speed);
	void CTransOps::SetSTVolumeSetting(int vol);
	int CTransOps::GetSTVolumeSetting();
	void CTransOps::LoadComListBox(int ports);
	int CTransOps::GetCWSpotVolumeSetting();
	void CTransOps::SetCWSpotVolumeSetting(int vol);
	void CTransOps::SetKeyerWeightSetting(int wt);
	int CTransOps::GetKeyerWeightSetting();



afx_msg void CTransOps::OnTxFilterChanged();

	int GetPowerSetting();
	void SetFocusToParent();

// General Preferences
    CComboBox MuteOptionsListBox;
	CStatic MuteOptionsLabel;
	CStatic UTCLabel;
	CListBox MuteOptionList;
	CEdit UTCHoursEdit;
	CEdit FreqAdj;
	CStatic HamCallPathLabel;
	CSpecialEdit HamCallPathEditBox;
	CButton SweepMuteCheckBox;
		

// CW Section
	CSlider STVolumeSlider;
	CNumericEdit STFBox;
	CStatic STVolLabel;
	CStatic STFLabel;
	CSlider CWSpdSlider;
	CStatic CWSpdLabel;
	CButton EnableKeyerCheckBox;
	CSlider CWSpotSlider;
	CStatic CWSpotLabel;
	CSlider CWWtSlider;
	CStatic CWWtLabel;
	CSlider CWQskSlider;
	CStatic CWQskLabel;

	
//SSB Section
	CSlider MONVolumeSlider;
	CSlider MICGainSlider;
	CStatic MONVolLabel;
	CStatic MICGainLabel;
	CComboBox TxFilterListBox;
	CStatic TxFilterLabel;

//Receiver Section



//Transmitter Section
	CSlider PowerSlider;
	CStatic TXPowerLabel;
	CButton TxLoopCheckBox;
	CButton TxEnableCheckBox;
	CButton TxMicAudioCheckBox;
	CButton TxAuxAudioCheckBox;
	CBiStateButton PowerTune;
	CStatic ForwardPowerLabel;
	CStatic TxAudioSourceLabel;
	CStatic TxControlsLabel;
	CSlider TxHangSlider;
	CStatic TxHangLabel;

// VOX Section
	CSlider AntiVoxSlider;
	CSlider VoxDelaySlider;
	CSlider VoxGainSlider;
	CStatic AntiVoxLabel;
	CStatic VoxDelayLabel;
	CStatic VoxGainLabel;	


// Remote POD Section

	CStatic FKeyOneLabel;
	CStatic FKeyTwoLabel;
	CStatic FKeyThreeLabel;


	CComboBox FKeyOneBox;
	CComboBox FKeyTwoBox;
	CComboBox FKeyThreeBox;
	


// Interface Section

	CButton Com1CheckBox;
	CButton Com2CheckBox;
	CButton Com3CheckBox;
	CButton Com4CheckBox;
	CStatic ComPortLabel;
	CListBox CommPortListBox;


// Applied to All Sections
	CListBox SectionListBox;
	CStatic NoAssignmentLabel;	


	
	int outputpower;
	int SideToneFreq;		// Side Tone Frequency
    int TxFilter;
	int VoxGain;
	int AntiVox;
	int VoxHang;
	int STVolume;
	int SpotVolume;
	int forwardpower;
	BOOL TuneState;	
	int KeyerSpeed;
	int KeyerWeight;
	CString CommPortString;

// Attributes
public:

// Operations
public:

// Implementation
public:
	virtual ~CTransOps();

protected:
	// Generated message map functions
	//{{AFX_MSG(CTransOps)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg int OnMouseActivate(CWnd* pDesktopWnd, UINT nHitTest, UINT message);
	afx_msg void OnClose();
	afx_msg void OnSelectionChanged();
	afx_msg void SetVisibleSelections(int choice);
	afx_msg HBRUSH OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor);
	afx_msg void OnActivate(UINT nState, CWnd* pWndOther, BOOL bMinimized);
	afx_msg UINT OnNcHitTest(CPoint point);
	afx_msg void OnChar(UINT nChar, UINT nRepCnt, UINT nFlags);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

#endif



