// worldtim.cpp : implementation file
// Ten-Tec Graphic Interface Radio Control Program
// Pegasus Control GUI (c) 1999,2000 Ten-Tec Inc.
// The source code contained in this file and associated files is copyright Ten-Tec, Inc.


#include "stdafx.h"
#include "tttrx.h"
#include "worldtim.h"

extern double radio_freq; 

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CWorldTime dialog


CWorldTime::CWorldTime(CWnd* pParent /*=NULL*/)
	: CDialog(CWorldTime::IDD, pParent)
{
	//{{AFX_DATA_INIT(CWorldTime)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}

void CWorldTime::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CWorldTime)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CWorldTime, CDialog)
	//{{AFX_MSG_MAP(CWorldTime)
	ON_BN_CLICKED(IDC_CHU14PT670, OnChu14pt670)
	ON_BN_CLICKED(IDC_CHU3PT33, OnChu3pt33)
	ON_BN_CLICKED(IDC_CHU7PT335, OnChu7pt335)
	ON_BN_CLICKED(IDC_WWV10, OnWwv10)
	ON_BN_CLICKED(IDC_WWV15, OnWwv15)
	ON_BN_CLICKED(IDC_WWV20, OnWwv20)
	ON_BN_CLICKED(IDC_WWV2PT5, OnWwv2pt5)
	ON_BN_CLICKED(IDC_WWV5, OnWwv5)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CWorldTime message handlers

void CWorldTime::OnChu14pt670()
{
radio_freq=(double) 14.670;
 GetParent()->SendMessage(WM_COMMAND,ID_TIMEFREQTUNE,(LPARAM) 0);
	
}

void CWorldTime::OnChu3pt33()
{
radio_freq=(double) 3.330;
 GetParent()->SendMessage(WM_COMMAND,ID_TIMEFREQTUNE,(LPARAM) 0);
	
}

void CWorldTime::OnChu7pt335()
{
radio_freq=(double) 7.335;
 GetParent()->SendMessage(WM_COMMAND,ID_TIMEFREQTUNE,(LPARAM) 0);
	
}

void CWorldTime::OnWwv10()
{
radio_freq=(double) 10.0;
 GetParent()->SendMessage(WM_COMMAND,ID_TIMEFREQTUNE,(LPARAM) 0);
	
}

void CWorldTime::OnWwv15()
{
radio_freq=(double) 15.0;
 GetParent()->SendMessage(WM_COMMAND,ID_TIMEFREQTUNE,(LPARAM) 0);
	
}

void CWorldTime::OnWwv20()
{
radio_freq=(double) 20.0;
 GetParent()->SendMessage(WM_COMMAND,ID_TIMEFREQTUNE,(LPARAM) 0);
	
}

void CWorldTime::OnWwv2pt5()
{
radio_freq=(double) 2.5;
 GetParent()->SendMessage(WM_COMMAND,ID_TIMEFREQTUNE,(LPARAM) 0);
	
}

void CWorldTime::OnWwv5()
{
radio_freq=(double) 5.0;
 GetParent()->SendMessage(WM_COMMAND,ID_TIMEFREQTUNE,(LPARAM) 0);
	
}

void CWorldTime::OnCancel()
{
	
	CDialog::OnCancel();
}
