// Ten-Tec Graphic Interface Radio Control Program
// Pegasus Control GUI (c) 1999,2000 Ten-Tec Inc.
// The source code contained in this file and associated files is copyright Ten-Tec, Inc.


#include "dragit.h"
#include <float.h>
#include "cmainwin.h"
BEGIN_MESSAGE_MAP(CDragit, CWnd)
	ON_WM_PAINT()
	ON_WM_CREATE()
	ON_WM_LBUTTONDBLCLK()
	ON_WM_MOUSEMOVE()
	ON_WM_LBUTTONDOWN()
	ON_WM_RBUTTONDOWN()
END_MESSAGE_MAP()                

CDragit::CDragit()
{
}
        
CDragit::Create(CRect sizepos, CWnd *PWnd,UINT nID,float scale=100)
{                   
m_fScaleRange=scale;
m_WindowSize=CRect(0,0,sizepos.right-sizepos.left,sizepos.bottom-sizepos.top);
m_cID=nID;
m_Zoom=1;
 return CWnd::Create(NULL,NULL,WS_CLIPSIBLINGS|WS_CHILD|WS_VISIBLE,sizepos,PWnd,nID,NULL);
} 


afx_msg int CDragit::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
    m_TinyFont.CreateFont(14,0,0,0,FW_DONTCARE,0,0,0,ANSI_CHARSET,
    					OUT_DEVICE_PRECIS,CLIP_DEFAULT_PRECIS,DEFAULT_QUALITY,
    					DEFAULT_PITCH|FF_DONTCARE,"Arial");

	return 0;
}


afx_msg void CDragit::OnPaint()
{
int count;

ldiv_t tenmod;		// div_t stuctures for modulus calculations
ldiv_t hundredmod;	
ldiv_t thousandmod;
double startfreq,endfreq; // variables to hold band marker frequencies

CBitmap Meter;
CBrush brushFaceColor(RGB(0,0,0));
CBrush brushBodyColor(RGB(192,192,192));
CBrush brushBorderColor(RGB(0,0,0));
CBrush brushAuxColor(RGB(0,0,255));

CPen penIndicatorColor(PS_SOLID,1,RGB(255,0,0));
CPen penMemoryIndicatorColor(PS_SOLID,1,RGB(255,0,0));
CPen penTickColor(PS_SOLID,1,RGB(0,192,0));
CPen penBandColor(PS_SOLID,1,RGB(92,92,0));

CPen penShadowColor(PS_SOLID,1,RGB(128,128,128));
CPen penMediumShadowColor(PS_SOLID,1,RGB(63,63,63));

CPen penMediumHighlightColor(PS_SOLID,1,RGB(192,192,192));
CPen penHighlightColor(PS_SOLID,1,RGB(255,255,255));


CPaintDC cDC(this);
CDC memDC;

memDC.CreateCompatibleDC(&cDC); 

	CFont* pOldFont =memDC.SelectObject(&m_TinyFont);


CRect rcClip=m_WindowSize;

Meter.CreateDiscardableBitmap(&cDC,rcClip.right-rcClip.left,
								rcClip.bottom-rcClip.top);
memDC.SelectObject(&Meter);

CBrush* pOldBrush=memDC.SelectObject(&brushBodyColor);

memDC.SetBkMode(TRANSPARENT);
// get the area that needs to be erased
CPoint wSize=(rcClip.Width(),rcClip.Height());
CRect rcFront(rcClip.left+5,rcClip.top+5,rcClip.right-5,rcClip.bottom-(wSize.x/3));

memDC.FillRect(rcClip,&brushFaceColor);
// Shadow layer
memDC.SelectObject(&penShadowColor);
memDC.MoveTo(rcClip.left,rcClip.bottom-1);
memDC.LineTo(rcClip.left,rcClip.top);
memDC.LineTo(rcClip.right-1,rcClip.top);

memDC.SelectObject(&penMediumShadowColor);
memDC.MoveTo(rcClip.left+1,rcClip.bottom-2);
memDC.LineTo(rcClip.left+1,rcClip.top+1);
memDC.LineTo(rcClip.right-1,rcClip.top+1);

memDC.SelectObject(&penMediumHighlightColor);
memDC.MoveTo(rcClip.right-2,rcClip.top+1);
memDC.LineTo(rcClip.right-2,rcClip.bottom-2);
memDC.LineTo(rcClip.left+1,rcClip.bottom-2);

memDC.SelectObject(&penHighlightColor);
memDC.MoveTo(rcClip.right-1,rcClip.top);
memDC.LineTo(rcClip.right-1,rcClip.bottom-1);
memDC.LineTo(rcClip.left,rcClip.bottom-1);



memDC.SelectObject(&penTickColor);

MeterArea=CRect(rcClip.left+2,(int) ((rcClip.bottom-rcClip.top)),rcClip.right-2,rcClip.bottom-4);


int half=MeterArea.bottom-(MeterArea.top/2);
int qtr=MeterArea.bottom-(MeterArea.top/4);
int eighth=MeterArea.bottom-(MeterArea.top/8);
int third=MeterArea.bottom-(MeterArea.top/3);
int sixteenth=MeterArea.bottom-(MeterArea.top/16);

int qrtrwidth=(MeterArea.right-MeterArea.left)/4;
int eighthwidth=(MeterArea.right-MeterArea.left)/8;


long sfreq=(long) (m_fCenterFrequency*(double)(m_Zoom)+.5)-((int)MeterArea.right/2)+2;
long tfreq=sfreq;                                            
long ScaleStartFreq=sfreq;
long ScaleEndFreq=(long) sfreq+(int)MeterArea.right;
startfreq=0;
endfreq=0;
                                            

for(count=MeterArea.left;count<MeterArea.right;count++)
{
memDC.SelectObject(&penTickColor);
 




tenmod=ldiv(sfreq,2);
hundredmod=ldiv(sfreq,50);
thousandmod=ldiv(sfreq,10);

	memDC.SelectObject(&penTickColor);



if(tenmod.rem==0)
	{
	memDC.MoveTo(count,sixteenth);
	memDC.LineTo(count,MeterArea.bottom);
    }


if(thousandmod.rem==0)
	{
	memDC.MoveTo(count,eighth);
	memDC.LineTo(count,MeterArea.bottom);
    }

if(hundredmod.rem==0)
	{
  	memDC.MoveTo(count,qtr);
	memDC.LineTo(count,MeterArea.bottom);
	char csFreq[16];


	if(m_Zoom==1)sprintf(csFreq,"%2.0f",(float) sfreq);
	if(m_Zoom==10)sprintf(csFreq,"%2.0f",(float) (sfreq*m_Zoom));
	if(m_Zoom==100)sprintf(csFreq,"%2.0f",(float) (sfreq*m_Zoom));


	CSize csSize;
	csSize=cDC.GetTextExtent(csFreq,strlen(csFreq));
	memDC.SetTextColor(RGB(190,190,190));
	
	memDC.DrawText(csFreq,strlen(csFreq),CRect(count-((int)csSize.cx/2),
												half,
												count+((int) csSize.cx/2),
                                                csSize.cy+half),
                                                DT_CENTER|DT_SINGLELINE|DT_TOP);

    }





sfreq++;
}                     
memDC.SelectObject(&penIndicatorColor);
memDC.MoveTo(MeterArea.right/2,(int) MeterArea.bottom/2);
memDC.LineTo(MeterArea.right/2,MeterArea.bottom);


//// Secondary Area

CRect BRect(MeterArea.left,2,MeterArea.right,MeterArea.bottom-half-4);
AuxAreaRect=BRect;	// coarse tuning rect structure
memDC.SelectObject(&brushBodyColor);
memDC.SelectObject(&penTickColor);

memDC.Rectangle(BRect);

bwidth=upperlimit-lowerlimit;
int bcenter=bwidth/2;
int dx=(int)(((m_fCenterFrequency+bcenter)/bwidth)*BRect.Width()+BRect.left);

CRect IndRect(dx-2,BRect.top,dx+2,BRect.bottom);
AuxTuningRect=IndRect;
memDC.FrameRect( IndRect, &brushAuxColor );
memDC.MoveTo(bcenter+BRect.left,2);
memDC.LineTo(bcenter+BRect.left,BRect.bottom-1);


memDC.SelectObject(pOldFont);
cDC.BitBlt(0,0,wSize.x,wSize.y,&memDC,0,0,SRCCOPY);
cDC.BitBlt(0,0,rcClip.right,rcClip.bottom,&memDC,0,0,SRCCOPY);


return;
}


afx_msg void CDragit::SetIndicator(double Value)
{
m_fCenterFrequency=Value;
Invalidate(FALSE);
return;
}


void CDragit::SetLimits(int lower,int upper)
{
lowerlimit=lower;
upperlimit=upper;

Invalidate(FALSE);
}


void CDragit::OnLButtonDblClk(UINT nFlags,CPoint point)
{
CRect rcClip=m_WindowSize;

CRect MeterArea(rcClip.left+2,(int) ((rcClip.bottom-rcClip.top)),rcClip.right-2,rcClip.bottom-4);
long sfreq=(long)(m_fCenterFrequency*m_Zoom)-((int)MeterArea.right/2);
double newfreq=(sfreq+point.x)/m_Zoom;

m_PointFreq=newfreq;



GetOwner()->SendMessage(ID_POINTFREQ,(WPARAM) m_cID,(LPARAM) 0);

}

                    
                    
double CDragit::GetPointFrequency()
{
return m_PointFreq;
}
                    
double CDragit::GetIndicatorFrequency()
{
return m_fCenterFrequency;
}
                    
         
void CDragit::OnLButtonDown(UINT nFlags,CPoint point)
{
	if(AuxAreaRect.PtInRect(point))
	{
	CRect rcClip=m_WindowSize;
	CRect MeterArea(rcClip.left+2,(int) ((rcClip.bottom-rcClip.top)),rcClip.right-2,rcClip.bottom-4);

	double newfreq=lowerlimit+(dxb*point.x);
	m_PointFreq=newfreq;
	GetOwner()->SendMessage(ID_POINTFREQ,(WPARAM) m_cID,(LPARAM) 0);
	m_pointX=point.x;	// save the x position for later moves

	}
	else
	{
	m_pointX=point.x;	// save the x position for later moves
	}


}

void CDragit::OnMouseMove(UINT nFlags,CPoint point)
{


if(nFlags==MK_LBUTTON)
{
	if(!AuxAreaRect.PtInRect(point))
	{
	int diff=m_pointX-point.x;
	double freq=m_fCenterFrequency*m_Zoom;

	m_fCenterFrequency=(double)((freq+diff)/m_Zoom);
	m_pointX=point.x;
	
	GetOwner()->PostMessage(ID_SLIDEFREQ,(WPARAM) m_cID,(LPARAM) 0);
	}
	else
	{
	int diff=point.x;	
	double freq=m_fCenterFrequency*m_Zoom;

	m_pointX=point.x;
	dxb=(double)(bwidth/MeterArea.Width());	// how much freq for each bit ? 
	dxf=((double)diff*dxb);

	m_fCenterFrequency=lowerlimit+dxf;
	GetOwner()->PostMessage(ID_SLIDEFREQ,(WPARAM) m_cID,(LPARAM) 0);
	}
	    
    

}



else CWnd::OnMouseMove(nFlags,point);
}
         
         
void CDragit::SetZoom(int zoom)
{
m_Zoom=zoom;
Invalidate(FALSE);
}


afx_msg void CDragit::OnRButtonDown(UINT nFlags,CPoint point)         
{
m_fCenterFrequency=0;
m_PointFreq=0;
GetOwner()->SendMessage(ID_POINTFREQ,(WPARAM) m_cID,(LPARAM) 0);
}