
#include <afxwin.h>

#ifndef _DRAGIT_H_
#define _DRAGIT_H_
#define ID_POINTFREQ 351
#define ID_SLIDEFREQ 352


class CDragit:public CWnd
{
//friend class CMainWin;
CRect m_WindowSize;        			// window size
CRect AuxAreaRect;                  // Auxillary control area rectangle
CRect AuxTuningRect;
CRect MeterArea;
int bwidth;							// scale width (upper minus lower limits)
UINT m_cID;
double 	m_fCenterFrequency;			// center or tuned frequency
double dxb,dxf;
float	m_fScaleRange;				// display represent what frequency range
double m_PointFreq;					// frequency determined at point/click time
CFont	m_TinyFont;
int		m_pointX;
CString csTempString;
unsigned int m_Zoom;
int lowerlimit,upperlimit;

public:	
	CDragit();
	afx_msg void OnPaint();
	afx_msg void OnRButtonDown(UINT nFlags,CPoint point);         

	void SetIndicator(double Value);
	void SetLimits(int lowerlimit,int upperlimit);
	afx_msg int CDragit::OnCreate(LPCREATESTRUCT lpCreateStruct);
	double GetPointFrequency();
	double GetIndicatorFrequency();
	void SetZoom(int zoom);
		
//protected:
	BOOL Create(CRect sizepos, CWnd *PWnd,UINT nID,float scale);
	afx_msg void OnLButtonDblClk(UINT flags,CPoint where);
	afx_msg void CDragit::OnMouseMove(UINT nFlags,CPoint point);
	afx_msg void OnLButtonDown(UINT flags,CPoint where);

protected:

	DECLARE_MESSAGE_MAP()
};

#endif
// _DRAGIT_H_


