// Ten-Tec Graphic Interface Radio Control Program
// Pegasus Control GUI (c) 1999,2000 Ten-Tec Inc.
// The source code contained in this file and associated files is copyright Ten-Tec, Inc.

#include "filtcon.h"
#include <float.h>
#include "cmainwin.h"
BEGIN_MESSAGE_MAP(CFilterControl, CWnd)
	ON_WM_PAINT()
	ON_WM_CREATE()
	ON_WM_LBUTTONDBLCLK()
	ON_WM_MOUSEMOVE()
	ON_WM_LBUTTONDOWN()
END_MESSAGE_MAP()                

CFilterControl::CFilterControl()
{
}
        
CFilterControl::Create(CRect sizepos, CWnd *PWnd,UINT nID)
{                   
m_WindowSize=CRect(0,0,sizepos.right-sizepos.left,sizepos.bottom-sizepos.top);
m_cID=nID;
 return CWnd::Create(NULL,NULL,WS_CLIPSIBLINGS|WS_CHILD|WS_VISIBLE,sizepos,PWnd,nID,NULL);
m_iBandwidth=6000;
upperlimit=6000;
lowerlimit=-6000;
m_iCenter=0;


} 



afx_msg int CFilterControl::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
    m_TinyFont.CreateFont(14,0,0,0,FW_DONTCARE,0,0,0,ANSI_CHARSET,
    					OUT_DEVICE_PRECIS,CLIP_DEFAULT_PRECIS,DEFAULT_QUALITY,
    					DEFAULT_PITCH|FF_DONTCARE,"Arial");
upperlimit=6000;
lowerlimit=-6000;

	return 0;
}


afx_msg void CFilterControl::OnPaint()
{
int count;

CBitmap Meter;
CBrush brushFaceColor(RGB(0,0,0));
CBrush brushBodyColor(RGB(192,192,192));
CBrush brushBorderColor(RGB(0,0,0));
CBrush brushAuxColor(RGB(192,192,192));

CPen penIndicatorColor(PS_SOLID,3,RGB(128,0,0));
CPen penMemoryIndicatorColor(PS_SOLID,1,RGB(255,0,0));
CPen penTickColor(PS_SOLID,2,RGB(255,255,0));

CPen penBandColor(PS_SOLID,1,RGB(92,92,0));


CPen penShadowColor(PS_SOLID,1,RGB(128,128,128));
CPen penMediumShadowColor(PS_SOLID,1,RGB(63,63,63));

CPen penMediumHighlightColor(PS_SOLID,1,RGB(192,192,192));
CPen penHighlightColor(PS_SOLID,1,RGB(255,255,255));
CPen penScaleColor(PS_SOLID,1,RGB(128,128,128));

CPaintDC cDC(this);
CDC memDC;

memDC.CreateCompatibleDC(&cDC); 

	CFont* pOldFont =memDC.SelectObject(&m_TinyFont);


CRect rcClip=m_WindowSize;

Meter.CreateDiscardableBitmap(&cDC,rcClip.right-rcClip.left,
								rcClip.bottom-rcClip.top);
memDC.SelectObject(&Meter);

CBrush* pOldBrush=memDC.SelectObject(&brushBodyColor);

memDC.SetBkMode(TRANSPARENT);
// get the area that needs to be erased
CPoint wSize=(rcClip.Width(),rcClip.Height());
CRect rcFront(rcClip.left+5,rcClip.top+5,rcClip.right-5,rcClip.bottom-(wSize.x/3));

memDC.FillRect(rcClip,&brushFaceColor);
// Shadow layer
memDC.SelectObject(&penShadowColor);
memDC.MoveTo(rcClip.left,rcClip.bottom-1);
memDC.LineTo(rcClip.left,rcClip.top);
memDC.LineTo(rcClip.right-1,rcClip.top);

memDC.SelectObject(&penMediumShadowColor);
memDC.MoveTo(rcClip.left+1,rcClip.bottom-2);
memDC.LineTo(rcClip.left+1,rcClip.top+1);
memDC.LineTo(rcClip.right-1,rcClip.top+1);

memDC.SelectObject(&penMediumHighlightColor);
memDC.MoveTo(rcClip.right-2,rcClip.top+1);
memDC.LineTo(rcClip.right-2,rcClip.bottom-2);
memDC.LineTo(rcClip.left+1,rcClip.bottom-2);

memDC.SelectObject(&penHighlightColor);
memDC.MoveTo(rcClip.right-1,rcClip.top);
memDC.LineTo(rcClip.right-1,rcClip.bottom-1);
memDC.LineTo(rcClip.left,rcClip.bottom-1);




CRect MeterArea(rcClip.left+2,(int) ((rcClip.bottom-rcClip.top)),rcClip.right-2,rcClip.bottom-4);

int half=MeterArea.bottom-(MeterArea.top/2);
int qtr=MeterArea.bottom-(MeterArea.top/4);
int eighth=MeterArea.bottom-(MeterArea.top/8);
int third=MeterArea.bottom-(MeterArea.top/3);
int sixteenth=MeterArea.bottom-(MeterArea.top/16);

int halfwidth=(MeterArea.right-MeterArea.left)/2;
int qrtrwidth=(MeterArea.right-MeterArea.left)/4;
int eighthwidth=(MeterArea.right-MeterArea.left)/8;
int width=(MeterArea.right-MeterArea.left);
int rangewidth=upperlimit-lowerlimit;

xfactor=(double)((double)width/(double)rangewidth);
dxb=(double)((double)rangewidth/(double)width);
memDC.SelectObject(&penScaleColor);

for (count=0;count<upperlimit;count+=1000)
{
memDC.MoveTo(halfwidth+(int)(xfactor*count),3);
memDC.LineTo(halfwidth+(int)(xfactor*count),MeterArea.bottom);
memDC.MoveTo(halfwidth-(int)(xfactor*count),3);
memDC.LineTo(halfwidth-(int)(xfactor*count),MeterArea.bottom);
} 

for (count=0;count<MeterArea.bottom;count+=10)
{
memDC.MoveTo(MeterArea.left,count);
memDC.LineTo(MeterArea.right,count);
}


memDC.SelectObject(&penTickColor);

double prop=(double)m_iBandwidth/(double)rangewidth;

int flwidth=(int)(prop*width);

double centerprop=(double)m_iCenter/(double)rangewidth;
int centeradj=(int)(centerprop*width);

TRACE("center=%d centeradj=%d\n",m_iCenter,centeradj);


div_t result;
result = div(flwidth,2);
if(result.rem!=0) flwidth++; // add 1 if odd number

memDC.SelectObject(&penTickColor);

int ftop=(int)(0.20*(rcClip.bottom-rcClip.top));
CenterConRect=CRect(centeradj+halfwidth-2,ftop-3,centeradj+halfwidth+3,ftop+3);
LeftConRect=CRect(centeradj+halfwidth-2-flwidth/2,ftop-3,centeradj+halfwidth+3-flwidth/2,ftop+3);
RightConRect=CRect(centeradj+halfwidth-2+flwidth/2,ftop-3,centeradj+halfwidth+3+flwidth/2,ftop+3);


memDC.FrameRect( CenterConRect, &brushAuxColor );
memDC.FrameRect( LeftConRect, &brushAuxColor );
memDC.FrameRect( RightConRect, &brushAuxColor );


TRACE("Prop=%f Width=%d Flwidth=%d\n",prop,width,flwidth);

int fbottom=MeterArea.bottom-4;
memDC.SelectObject(&penTickColor);
memDC.MoveTo(centeradj+halfwidth-flwidth/2,ftop);
memDC.LineTo(centeradj+halfwidth+flwidth/2,ftop);

memDC.MoveTo(centeradj+halfwidth-flwidth/2,ftop);
memDC.LineTo((centeradj+halfwidth-flwidth/2)-10,fbottom);

memDC.MoveTo(centeradj+halfwidth+flwidth/2,ftop);
memDC.LineTo((centeradj+halfwidth+flwidth/2)+10,fbottom);



memDC.SelectObject(&penIndicatorColor);
memDC.MoveTo(halfwidth,(int) MeterArea.bottom/2);
memDC.LineTo(halfwidth,MeterArea.bottom);



	char csFreq[16];
	sprintf(csFreq,"%4.0d",m_iBandwidth);


	CSize csSize;
	csSize=cDC.GetTextExtent(csFreq,strlen(csFreq));
	memDC.SetTextColor(RGB(255,255,255));
	
	memDC.DrawText(csFreq,strlen(csFreq),CRect(centeradj+halfwidth-((int)csSize.cx/2),
												MeterArea.bottom-csSize.cy,
												centeradj+halfwidth+((int) csSize.cx/2),
                                                MeterArea.bottom),
                                                DT_CENTER|DT_SINGLELINE|DT_TOP);



memDC.SelectObject(pOldFont);
cDC.BitBlt(0,0,wSize.x,wSize.y,&memDC,0,0,SRCCOPY);
cDC.BitBlt(0,0,rcClip.right,rcClip.bottom,&memDC,0,0,SRCCOPY);


return;
}


afx_msg void CFilterControl::SetCenter(int Value)
{
m_iCenter=Value;
Invalidate(FALSE);
return;
}

afx_msg void CFilterControl::SetBandwidth(int Value)
{
m_iBandwidth=Value;
Invalidate(FALSE);
return;
}

void CFilterControl::SetLimits(int lower,int upper)
{
lowerlimit=lower;
upperlimit=upper;

Invalidate(FALSE);
}


void CFilterControl::OnLButtonDblClk(UINT nFlags,CPoint point)
{
return;
}

                    
                    
double CFilterControl::GetPointFrequency()
{
return m_iPointFreq;
}
                    
double CFilterControl::GetCenter()
{
return m_iCenter;
}
                    
         
void CFilterControl::OnLButtonDown(UINT nFlags,CPoint point)
{
m_ipointX=point.x;	// save the x position for later moves
}

void CFilterControl::OnMouseMove(UINT nFlags,CPoint point)
{


if(nFlags==MK_LBUTTON)
{
int diff=point.x;
double freq=m_iCenter;
m_iCenter=(int)(lowerlimit+(diff*dxb));
m_ipointX=point.x;
GetOwner()->PostMessage(ID_SLIDEFREQ,(WPARAM) m_cID,(LPARAM) 0);
}

else CWnd::OnMouseMove(nFlags,point);

}
         
         
         