// LookupCall Window

// Ten-Tec Graphic Interface Radio Control Program
// Pegasus Control GUI (c) 1999,2000 Ten-Tec Inc.
// The source code contained in this file and associated files is copyright Ten-Tec, Inc.


#include "stdafx.h"
#include "tttrx.h"
#include "lookupca.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

extern CFont m_FreqFont;
extern CFont m_SmallFont;
extern CFont m_MicroFont;
extern CFont m_MiniFont;

/////////////////////////////////////////////////////////////////////////////
// CLookupCallWnd

CLookupCallWnd::CLookupCallWnd()
{
	//{{AFX_DATA_INIT(CLookupCallWnd)
	//}}AFX_DATA_INIT

}

CLookupCallWnd::~CLookupCallWnd()
{
}


BEGIN_MESSAGE_MAP(CLookupCallWnd, CWnd)
	//{{AFX_MSG_MAP(CLookupCallWnd)
	ON_WM_CHAR()
	ON_WM_CLOSE()
	ON_WM_CREATE()
	ON_WM_NCHITTEST()
	ON_WM_ERASEBKGND()
	ON_WM_CTLCOLOR()
	ON_WM_MOUSEACTIVATE()
	ON_COMMAND(IDCLOSE,OnClose)
    ON_COMMAND(ID_FINDCALL,LookupCall)
	ON_COMMAND(ID_CALLTEXT_BOX,LookupCall)
	ON_EN_CHANGE(ID_CALLTEXT_BOX,OnCallChanged)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CLookupCallWnd message handlers


int CLookupCallWnd::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	HamDataListBox.Create( ES_MULTILINE|ES_READONLY |WS_BORDER|WS_VISIBLE| WS_VSCROLL | WS_TABSTOP|WS_CHILD, CRect(5,20,300,205), this, IDC_STATIONLIST );
	HamDataListBox.SetFont(&m_SmallFont);

	FindInDatabaseButton.Create("Find",WS_VISIBLE|BS_PUSHBUTTON |WS_CHILD,CRect(380,65,440,100),this,ID_FINDCALL);
	FindInDatabaseButton.SetFont(&m_SmallFont);
	CloseWindowButton.Create("Close",WS_VISIBLE|BS_PUSHBUTTON |WS_CHILD,CRect(380,165,440,200),this,IDCLOSE);
	CloseWindowButton.SetFont(&m_SmallFont);
	CallSignLabel.Create("Call Sign",WS_VISIBLE|WS_CHILD|SS_CENTER, CRect(380,5,440,25),this);
	CallSignLabel.SetFont(&m_SmallFont);

	CallSignBox.Create(WS_BORDER|WS_VISIBLE|WS_CHILD|ES_UPPERCASE, CRect(320,30,440,55),this,ID_CALLTEXT_BOX);
	CallSignBox.SetFont(&m_SmallFont);
	FindInDatabaseButton.EnableWindow(FALSE);
	return 0;
}

UINT CLookupCallWnd::OnNcHitTest(CPoint point) 
{
	UINT nHitTest = CWnd::OnNcHitTest(point);	
	if(nHitTest==HTCLIENT)
		{
		return(HTCAPTION);
		}
	return (nHitTest);
	
}

BOOL CLookupCallWnd::OnEraseBkgnd(CDC* pDC)
{
	CBrush* pOldBrush=(CBrush*) pDC->SelectStockObject(LTGRAY_BRUSH);
	CPen* pOldPen=(CPen*) pDC->SelectStockObject(NULL_PEN);

	CBrush brushDarkGray(RGB(128,128,128));


	pDC->SetBkMode(OPAQUE);
	pDC->SetBkColor(RGB(192,192,192));

// get the area that needs to be erased
	CRect rcClip;									
	GetClientRect(rcClip);


// Fill client area witrh solid color first

	pDC->FillRect(rcClip,(CBrush*) pDC->SelectStockObject(LTGRAY_BRUSH));
	pDC->FillRect(rcClip,(CBrush*) pDC->SelectStockObject(LTGRAY_BRUSH));

// Unselect brush out of device context

pDC->SelectObject(pOldBrush);
pDC->SelectObject(pOldPen);

return TRUE;	
}

HBRUSH CLookupCallWnd::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor)
{


 if((nCtlColor==CTLCOLOR_STATIC))

 	{
 		pDC->SetBkMode(TRANSPARENT);
 		pDC->SetTextColor(RGB(0,0,0));

		return (HBRUSH) GetStockObject(LTGRAY_BRUSH);
 	}
	
else
	{
 		pDC->SetBkMode(TRANSPARENT);
 		pDC->SetTextColor(RGB(0,0,0));

		return (HBRUSH) GetStockObject(WHITE_BRUSH);
	}




//	return CWnd::OnCtlColor(pDC, pWnd, nCtlColor);
}

int CLookupCallWnd::OnMouseActivate(CWnd* pDesktopWnd, UINT nHitTest, UINT message)
{
	// TODO: Add your message handler code here and/or call default
	BringWindowToTop();
	CallSignBox.SetFocus();
	return TRUE;	

//	return CWnd::OnMouseActivate(pDesktopWnd, nHitTest, message);
}


void CLookupCallWnd::PostNcDestroy()
{
}         






afx_msg void CLookupCallWnd::OnSetFocus(CWnd* pOldWnd)
{


}


afx_msg void CLookupCallWnd::OnClose()
{
 ShowWindow(SW_HIDE);
}
  
  
void CLookupCallWnd::LookupCall()
{
 GetParent()->SendMessage(WM_COMMAND,ID_LOOKUPCALL,(LPARAM) 0);
 SetFocusToParent();
}



void CLookupCallWnd::OnCallChanged()
{
CallSignBox.GetWindowText(CallText);
if(CallText.IsEmpty()) FindInDatabaseButton.EnableWindow(FALSE);
else FindInDatabaseButton.EnableWindow(TRUE);
}


afx_msg void CLookupCallWnd::OnChar( UINT nChar, UINT nRepCnt, UINT nFlags )
{
MessageBox("Press Return");
}



void CLookupCallWnd::SetFocusToParent()
{
	GetParent()->SetFocus();
    return;
}   


void CLookupCallWnd::AddString(char* string)
{
 char text[4096];
 HamDataListBox.GetWindowText(text,4095);
 strcat(text,string);
 strcat(text,"\r\n"); 	
 HamDataListBox.SetWindowText(text);
}

void CLookupCallWnd::ResetContent()
{
HamDataListBox.SetWindowText("");
}

