// bistateb.cpp : implementation file

// Ten-Tec Graphic Interface Radio Control Program
// Pegasus Control GUI (c) 1999,2000 Ten-Tec Inc.
// The source code contained in this file and associated files is copyright Ten-Tec, Inc.


#include "tttrx.h"
#include "phbutton.h"
#include "etc.h"
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPHButton



BEGIN_MESSAGE_MAP(CPHButton, CButton)


	//{{AFX_MSG_MAP(CPHButton)
	ON_WM_RBUTTONDOWN()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()

	//}}AFX_MSG_MAP

END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPHButton message handlers



void CPHButton::DrawOuterFrame(CDC *pDC, CRect& rect, BOOL bThick)
{
	CPen blackPen(PS_SOLID, 1, RGB(0,0,0));
	CBrush brBlack(RGB(0,0,0));
	
	// Draw the first outside rectangle
	CPen *pOldPen = pDC->SelectObject(&blackPen);
	
	// top side
	pDC->MoveTo(rect.left+1, rect.top);	
	pDC->LineTo(rect.right-1, rect.top);
	
	// right side
	pDC->MoveTo(rect.right-1, rect.top+1);
	pDC->LineTo(rect.right-1, rect.bottom-1);

	// bottom side	
	pDC->MoveTo(rect.right-2, rect.bottom-1); 
	pDC->LineTo(rect.left, rect.bottom-1);

	// left side	
	pDC->MoveTo(rect.left, rect.bottom-2);
	pDC->LineTo(rect.left, rect.top);

	rect.InflateRect(-1, -1);

	pDC->SelectObject(pOldPen);
}



void CPHButton::DrawItem(LPDRAWITEMSTRUCT lpDIS)
{

	CRect rect(&(lpDIS->rcItem));
	CDC *pDC = CDC::FromHandle(lpDIS->hDC);
	UINT state = lpDIS->itemState;
	UINT action = lpDIS->itemAction;

	CBrush brBlack(RGB(0, 0, 0));

	// Fill the entire button with the button brush (gray)
	HBRUSH hOldBrush = (HBRUSH) ::SelectObject(pDC->m_hDC, g_etc.hbrBtnFace);
 	pDC->FillRect(rect, CBrush::FromHandle(g_etc.hbrBtnFace));

	// Draw the outer border first (thick if we're focused)
	BOOL bThick	= state & ODS_FOCUS;
	DrawOuterFrame(pDC, rect, bThick);
	
	// The rect is now inset from the border either 1 or 2 pixels
	// Draw the highlight and shadow next
	if (state & ODS_SELECTED)
	{
		CPen shadowPen(PS_SOLID, 1, g_etc.clrBtnShadow);
		CPen *pOldPen = pDC->SelectObject(&shadowPen);

		pDC->MoveTo(rect.left, rect.bottom-1);
		pDC->LineTo(rect.left, rect.top);
		pDC->LineTo(rect.right, rect.top);		
		pDC->SelectObject(pOldPen);	
	} 
	else 

	{
		// Button is up
		CPen hilitePen(PS_SOLID, 2,  g_etc.clrBtnHilite);
		CPen shadowPen(PS_SOLID, 1, g_etc.clrBtnShadow);
		
		CPen *pOldPen = pDC->SelectObject(&hilitePen);

		// Draw the hilite (white) part with the 2 pixel width pen
		pDC->Rectangle(rect.left+1, rect.top+1, rect.right, rect.bottom);		

		// Draw the shadow on the bottom half
		pDC->SelectObject(&shadowPen);

		pDC->MoveTo(rect.left, rect.bottom-1);
		pDC->LineTo(rect.right-1, rect.bottom-1);
		pDC->LineTo(rect.right-1, rect.top-1);
		
		pDC->MoveTo(rect.left+1, rect.bottom-2);
		pDC->LineTo(rect.right-2, rect.bottom-2);
		pDC->LineTo(rect.right-2, rect.top);
		
		pDC->SelectObject(pOldPen);
	}  

	// Calculate the width and height of the triangle
	// based on a the 'M' character
	CSize szTri = pDC->GetOutputTextExtent("M", 1);

	// Calculate the width and height of the text
	CString text;
	GetWindowText(text);
	CSize szText = pDC->GetOutputTextExtent(text, text.GetLength());

	// Calculate the total size of the text + the triangle
	CSize szTotal;
	szTotal.cx = szText.cx + szTri.cx;
	szTotal.cy = szText.cy; 

	// change the width/height of the button rect
	CRect textRect = rect;
	textRect.InflateRect(-((rect.Width() - szTotal.cx)/2), 
		-((rect.Height() - szTotal.cy)/2));

	CRect triRect = textRect;
	triRect.left = textRect.right - szTri.cx;
	triRect.InflateRect(0, -((textRect.Height() - szTri.cy)/2));

	// Draw the text
	pDC->SetBkMode(TRANSPARENT);
	if (state & ODS_SELECTED)
		textRect.OffsetRect(1, 1);
	
	// Draw the text

	if(m_bSelected==TRUE)	pDC->SetTextColor(SelectColor);
	if(m_bSelected==FALSE)	pDC->SetTextColor(RGB(0,0,0));

  	pDC->DrawText(text, -1, textRect, DT_SINGLELINE | DT_CENTER);

	// Draw the triangle
	CBrush blackBrush(RGB(0, 0, 0));
	CBrush *pOldBrush = pDC->SelectObject(&blackBrush);
	CPoint ptTri(textRect.left + szText.cx, textRect.top + 3);
	pDC->SelectObject(pOldBrush);
	

	::SelectObject(pDC->m_hDC, hOldBrush);

}

void CPHButton::DrawTriangle(CDC *pDC, CPoint ptTopLeft, int nWidth)
{
	// Use odd widths for best results
	POINT ptArray[3];
	ptArray[0] = ptTopLeft;
	ptArray[1].x = ptTopLeft.x + nWidth - 1;
	ptArray[1].y = ptTopLeft.y;
	ptArray[2].x = ptTopLeft.x + nWidth / 2;
	ptArray[2].y = ptTopLeft.y + nWidth / 2;
	pDC->Polygon(ptArray, 3);
}


void CPHButton::SetSelectedColor(COLORREF color)
{
SelectColor=color;
Invalidate();
}

void CPHButton::SetNormalColor(COLORREF color)
{
NormalColor=color;
Invalidate();
}



void CPHButton::SetSelected(BOOL select)
{
m_bSelected=select;
Invalidate();
}



void CPHButton::OnRButtonDown(UINT nFlags, CPoint point)
{
	
	CButton::OnRButtonDown(nFlags, point);
	GetOwner()->SendMessage(WM_COMMAND,ID_AUXCLR ,(LPARAM) 0);
}


void CPHButton::OnLButtonDown(UINT nFlags, CPoint point)
{
	
	GetOwner()->SendMessage(WM_COMMAND,ID_PHBUTTON_DOWN ,(LPARAM) 0);
	CButton::OnLButtonDown(nFlags, point);
}

void CPHButton::OnLButtonUp(UINT nFlags, CPoint point)
{
	
	CButton::OnLButtonUp(nFlags, point);
	GetOwner()->SendMessage(WM_COMMAND,ID_PHBUTTON_UP ,(LPARAM) 0);
}


BOOL CPHButton::GetSelected()
{
return m_bSelected;
}
