// Ten-Tec Graphic Interface Radio Control Program
// Pegasus Control GUI (c) 1999,2000 Ten-Tec Inc.
// The source code contained in this file and associated files is copyright Ten-Tec, Inc.

/* 16 bit source devloped using Microsoft Visual C++ 1.52 */

/*   
	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation. 

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/



/* 
Ten-Tec retains all copyrights and commercial development rights. Any product derived from 
this source code should acknowledge Ten-Tec as copyright holder. The listed guidelines must be
followed to legally use this source code. Use of this code signifies agreement with the following guidelines.

1) Ten-Tec retains all commercial right to this product.

2) Ten-Tec provides no warranty or support for this code or the use of this code in a particular application.

3) This source code cannot be used in any commercial product without prior written permission from Ten-Tec, Inc

4) Products derived from this code may be distributed , but must be done at no charge except distribution expense.

5) Derived products should list Ten-Tec as holder of the original copyright.

6) Non-commercial products derived from this code shall be made freely available in binary and source formats so that
   others can participate in the development process.
*/



#define GUI_VERSION_TEXT "GUI SRC DERIVED FROM TT 1.63x6"
// Please do-not use Ten-Tec Version numbers
// #define HAMCALL_FIELD_TEST	// Enable HAMCALL field testing
// #define COMM_ERROR_REPORT	// Enable serial communication error reporting

#define ASCIIDATA_SAVE_INTERVAL 500
#define ASCIIDATA_CHECK_INTERVAL 2000

#define DATAINWINDOW			// used to turn on watch window without the radio being attached

#include <afxwin.h>
#include "FilterBu.h"			// Filter Selection Dialog
#include "swlpanel.h"			// Main Radio Panel
#include "sweeppan.h"			// Sweep Panel
#include <afxdlgs.h>
#include <afxext.h>
#include <string.h> 		
#include <graph.h>
#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include "encoder.h" 			// Main Tuning Knob Class 
#include "tttrx.h"          	// Main Header File
#include "resource.h"			// Resources
#include "Scale.h"				// Sliding Log Scale Class
#include <time.h>
#include <math.h>
#include "freqdisp.h"			// Main Frequency Display Class /Entry block
#include "station.h"			// Station Class
#include "bandobj.h"			// Band Obejct Structure
#include "editstat.h"			// Edit Station Dialog Class
#include "splashsc.h"           // Start-up Splash Screen
#include "slider.h"             // Sliding Volume Control Class
#include "repbutto.h"           // Repeating Button Class
#include <direct.h>             // Direct Entry 
#include "cmainwin.h"			// Derived Application Frame
#include <ctype.h>
#include "statdlg.h"            // Main Station Dialog Class
#include "stationw.h"			// Memory Panel
#include "aboutpro.h"			// About Dialog
#include "ctl3d.h"		        // 3D Add-On from Microsoft
#include "WorldTim.h"   		// World Time Dialog
#include "meter.h"				// Meter Display
#include "transops.h"			// Transceiver Options Dialog
#include "dragit.h"				// DragIt controls (XIT/RIT...)
#include "filterpa.h"			// Filter Display Panel
#include "exitdlg.h"			// Exit PRogram Dialog
#include "lookupca.h"			// Call Sign Lookup Panel
#include "phbutton.h"			// Push/Hold Button

// HAMCALL related
HINSTANCE hInstHamCall=NULL;
typedef int ( far pascal *LOOKUPHAMCALL)( char*, char*, int, char*);
LOOKUPHAMCALL LookupCallSign;
char buffer[2048];
char rstr[255];
char path[256];
char call[64];


// Globals
#define BUSY   -1
#define CLEAR   0 
#define MAINX 580 
#define MAINY 280
#define PEAKTIME 10;

CString MainProgramWindowName("Pegasus Control Panel");
unsigned char fwd_pwr=0;
unsigned char ref_pwr=0;
double radio_freq=12.000000,old_freq;
double LastSavedFreq=0;
double Opp_radio_freq;
char OppMode,PrevOppMode;
char LastSavedMode=0;
char OppFilter=15;      
int Bfo=2200, Old_Bfo=0;
char Mode=AM_MODE, old_mode,PrevMode;
char TxMode=AM_MODE;
char Old_Vol;
int Old_NVal,Old_FVal;
int SendStatus=CLEAR;    
double TuneStep=5000;
int Volume=15;
int AuxCodecVolume=15;
int CommPort=1;
int idCommDev;
int m_SidetoneVolume=0;
int m_CWSpotVolume=0;
int m_CWQSKSetting=0;
char cRemoteTuneControl=REMOTE_VFO_TUNE;
BOOL bMuteDuringSweep=TRUE;
BOOL SplitMode=FALSE;
BOOL LastSavedSplitMode=FALSE;
DCB CommDCB;
BOOL m_TuningKnob_Status=TRUE;
BOOL bPreLoadMemories=FALSE;
BOOL m_DataModified;
BOOL m_SMeterHoldOff=TRUE;
BOOL m_SMeterResponse=TRUE;
BOOL m_bMonitorState=FALSE;
BOOL m_bNRState=FALSE;
BOOL m_bANState=FALSE;
int iAuxTxHang=0;
int m_FilterNumber,old_FilterNumber;
CString CommunicationsPort;
CString strFileName;			// Current File Name of Memory File
int maxPort;
unsigned int DSPVersion=0;				// double number containing version identification
char DSPVersionString[64];		
int PeakHoldCount;
int m_iUtcHours;
int m_iUtcMinutes;
char MuteStatus=0;
int RxCount=0;
BOOL m_SoundCard_Status=TRUE;
BOOL m_FixedLineLevel_Status=FALSE;
int m_iFixedLineLevel=32;
BOOL m_bSweepActive=FALSE;
double m_SweepFreq;				// Current Sweep Frequency
long int smeterval=1;
unsigned int AnalogAgc=0;
unsigned int SMeterNormalMax=10000;
long int peaksmeter=1;
long int sigmeterval=10;
double m_SweepStartFreq;	// in Mhz
double m_SweepEndFreq;		// in Mhz
double m_SweepStepFreq=1000;		// in hz			    
int m_SweepFilter;
unsigned int Sarray[300];
int SarrayIndex=0;
BOOL m_bSwlPanelVisible=FALSE;
BOOL m_bSweepPanelVisible=FALSE;
BOOL m_bStationPanelVisible=FALSE;
BOOL m_SMeterActive=0;
BOOL m_MuteAlways=FALSE;
BOOL m_AutoFilterPreference=TRUE;
BOOL m_AutoStepPreference=TRUE;
BOOL m_bAttnState=FALSE;
#ifdef DATAINWINDOW
BOOL m_bRadioMode=TRUE;
#else
BOOL m_bRadioMode=FALSE;
#endif
BOOL m_bCommLogging=FALSE;
BOOL m_bVoxState=FALSE;
BOOL m_bSpotState=FALSE;
BOOL m_bTuneActive=FALSE;
BOOL m_bManualTxActive=FALSE;
BOOL bPrevTx=FALSE;	// used to aid toggling of display colors
int m_FrequencyAdjustment=0;
CRect MainWndrect;
BOOL m_NormalizeInProgress=FALSE;
BOOL m_ContSweep=FALSE;
int meter_time=50;
int m_PowerSetting=0;
char DataOutPos=0;
CString DataOutList[32];
char DataInPos=0;
CString DataInList[32];
int AgcMode;
int m_RFGain=0;
int m_MeterPreference=FORWARD_DISPLAY;
BOOL m_XitActive,m_RitActive,m_SqlActive,m_PbtActive;
int m_RitFreq,m_XitFreq,m_PbtFreq,m_SqlLevel;
CString ExitPassword="bigdaddy";
char AuxEncoderTuningMode=0;
char TxAudioSelect=TX_MIC_SELECT;
int m_VoxGain=1;
int m_AntiVox=0;
int m_VoxHang=1;
int m_MicGain=0;
int m_MonitorLevel=0;
BOOL m_bTxEnable=TRUE;
BOOL m_bTxLoopEnable=FALSE;
int m_iTxFilter=0;
int squelch_Slevel=0;
int KeyerSpeed=20;
int KeyerWeight=100;
BOOL m_bEnableKeyer=FALSE;
CStdioFile CommFile;
CStdioFile FamOutFile;
CStdioFile FamInFile;
CWnd* TopWnd;
BOOL m_bNoFocus=FALSE;

///////// Tables/Structures
filter far MasterFilterList_TX550[35]=
{
{"",0,0},				// zero index not used here (filler only)
{"8.0 kHz ",4200,33},				
{"6.0 kHz",3200,0},     
{"5.7 kHz",3050,1},     
{"5.4 kHz",2900,2},     
{"5.1 kHz",2750,3},
{"4.8 kHz",2600,4},
{"4.5 kHz",2450,5},    
{"4.2 kHz",2300,6},
{"3.9 kHz",2150,7},				
{"3.6 kHz",2000,8},     
{"3.3 kHz",1850,9},     
{"3.0 kHz",1700,10},     
{"2.85 kHz",1625,11},
{"2.7 kHz",1550,12},
{"2.55 kHz",1475,13},    
{"2.4 kHz",1400,14},
{"2.25 kHz",1325,15},
{"2.10 kHz",1250,16},    
{"1.95 kHz",1175,17},
{"1.80 kHz",1100,18},				
{"1.650 kHz",1025,19},     
{"1.50 kHz",950,20},     
{"1.350 kHz",875,21},     
{"1.200 kHz",800,22},
{"1.050 kHz",725,23},
{"900 Hz",650,24},    
{"750 Hz",575,25},
{"675 Hz",538,26},
{"600 Hz",500,27},				
{"525 Hz",462,28},     
{"450 Hz",425,29},     
{"375 Hz",387,30},     
{"330 Hz",365,31},
{"300 Hz",350,32},    
};

filter far FilterList_RX320[16]=
{
{"",0,0},				// zero index not used here (filler only)
{"8.0",4200,33},				
{"6.0",3200,1},     
{"4.8",2600,4},     
{"3.0",1700,10},     
{"2.5",1450,13},
{"1.8",1100,18},
{"500",450,28},    
{"250",325,32},
};

struct stations
	{
		char name[32];
		double frequency;
		char Mode[4];
		char country[16];
	};	

//sample station list for testing
stations Station_List[26]=
{
{"BBC",5.975,"AM","Great Britain"},
{"Canada",13.650,"AM","Canada"},
{"WWV",10.0,"AM","Colorado"},
{"WSEV",0.930,"AM","Sevierville"},
{"WLW",0.700,"AM","Cinci"},
{"Radio France",15.365,"AM","France"},
{"Radio Australia",17.880,"AM","Down Under"},
{"Radio Austria International",6.015,"AM","Down Under"},
{"Radio Bangladesh",6.195,"AM","There"},
{"Radio Havana",6.060,"AM","Cuba"},
{"Egyptian Radio",9.475,"AM","Egypt"},
{"Ghana Broadcasting",3.366,"AM","Ghana"},
{"Germany",6.085,"AM","Germany"},
{"Greece",9.375,"AM","Greece"},
{"Italy (RAI)",9.575,"AM","Italy"},
{"Radio Japan",6.120,"AM","Tokyo"},
{"Radio Kuwait",13.620,"AM","Kuwait"},
{"Russia",11.950,"AM","Ruski"},
{"South Africa",3.995,"AM","the Swamp"},
{"Spain",9.530,"AM","Spain"},            
{"Spain",9.530,"AM","Spain"},
{"Switzerland",9.650,"AM","Swizi"},
{"United Kingdom",5.9750,"AM","UK"},
{"Voice of America",6.0950,"AM","America"},
{"United Nations Radio",7.3750,"AM","Secret"},

};


// Band registers
#define MAXBANDS 9		
Bands far HamBands[MAXBANDS]=
	{
	{"160 Meters",1.80,2.0,1.80,LSB_MODE,11},
	{"80 Meters", 3.5,4.0,3.50,LSB_MODE,11},
	{"40 Meters", 7.0,7.3,7.00,LSB_MODE,11},
	{"30 Meters", 10.1,10.15,10.10,USB_MODE,11},
	{"20 Meters", 14.0,14.35,14.0,USB_MODE,11},
	{"17 Meters", 18.068,18.170,18.068,USB_MODE,11},
	{"15 Meters", 21.0,21.45,21.0,USB_MODE,11},
	{"12 Meters", 24.89,24.99,24.89,USB_MODE,11},
	{"10 Meters", 28.00,29.7,28.0,USB_MODE,11},
	};

// 			Global GUI Objects
/*========================================*/
	CFont m_FreqFont; 
	CFont m_SmallFont;
	CFont m_MicroFont;
	CFont m_MiniFont;
	CFont m_TinyFont;

    // GLOBAL DRAWING OBJECT
	CBrush DisplayBackgroundBrush;
    CPen TextColorPen;
    CPen BackgroundColorPen;
	CBrush FrequencyDisplayBrush;

	CBitmap mainbmp;
	CBitmap	bkgrnd1;

    // Memory/Data File Members
    CObList   obMemList;
    CObList*  obPtr;

	// Band Definitions (data/file members )
	CObList	obBandList;
  	
	// DIALOGS
	CStationDialog StationDialog;
	CWorldTime	TimeDialog;
	

	// Icons for Application
    HICON TTClassIcon;

	// Super Filter Manipulation Panel
	CFilterPanel MasterFilterPanel;

	// Primary SWL Window
	CSwlPanel	SwlPanel;


	CSweepPanel	SweepPanel;

	CTransOps TxOpsPanel;

	// Special Items used for testing 

	CDialogBar	DialogBar; 
	CDialogBar  MonitorBar;

	// Station Window
	CStationWnd StationPanel;

	// Call Lookup Panel
	CLookupCallWnd CallLookupPanel;

	// Exit Dialog
	CExitDlg ExitDialog;

	// Special Static class window for notices
	CStatic TimedMessageBox;	

// global prototypes
void DelayOneSecond();


// WINDOWS MESSAGE HANDLERS
BEGIN_MESSAGE_MAP(CMainWin, CFrameWnd)
    ON_COMMAND(IDM_QUIT,OnExit)
    ON_COMMAND(ID_DONE,OnExit)
    ON_COMMAND(ID_PHONEPLUS,IncreaseVolume)
    ON_COMMAND(ID_PHONEMINUS,DecreaseVolume)
    ON_COMMAND(ID_POWERUP,IncreasePower)
    ON_COMMAND(ID_POWERDOWN,DecreasePower)
    ON_COMMAND(ID_MUTE,MuteAudio)
	ON_COMMAND(IDM_SETUP,InterfaceOptions)
	ON_COMMAND(IDM_USEROPT,ViewTransmitOptions)
	ON_COMMAND(IDM_TXOPS,ViewTransmitOptions)
    ON_COMMAND(ID_VOLLEFT,DecreaseVolume)
    ON_COMMAND(ID_VOLRIGHT,IncreaseVolume)
    ON_COMMAND(ID_STEPRIGHT,DecreaseStep)
    ON_COMMAND(ID_STEPLEFT,IncreaseStep)
	ON_COMMAND(ID_SWLPANEL,OnSwlPanelChanged)
	ON_COMMAND(ID_TXOPS_PANEL,OnTxOpsPanelChanged)
	ON_COMMAND(ID_TIMEFREQTUNE,OnTimeFreqChange)
    ON_WM_RBUTTONDOWN()
	ON_WM_PAINT()
	ON_WM_SIZE()
	ON_WM_SETCURSOR()
	ON_WM_VSCROLL()
    ON_WM_ERASEBKGND()
	ON_WM_CREATE()
	ON_WM_CLOSE()
	ON_WM_TIMER()
	ON_WM_CTLCOLOR()
	ON_WM_CHAR()
	ON_WM_ACTIVATE()												// Child to Parent Message Handlers
	ON_WM_SYSCOMMAND()
	ON_MESSAGE(WM_COMMNOTIFY,OnCommNotify)
	ON_MESSAGE(ID_MEMORYRECALL,OnMemorySelect)
	ON_COMMAND(ID_LOOKUPCALL,OnLookupCall)
	ON_COMMAND(ID_MEMSTORE,AddStation)
	ON_COMMAND(IDH_RECEIVERCONTROLS,ReceiverHelp)
	ON_COMMAND(IDH_TROUBLESHOOTING,TroubleShootingHelp)
	ON_COMMAND(ID_HELP,ReceiverHelp)
	ON_COMMAND(ID_SETUP_TOPMOST,ToggleTopMostSelection)
	ON_UPDATE_COMMAND_UI(ID_SETUP_TOPMOST,UpdateTopMostSelection)
	ON_UPDATE_COMMAND_UI(IDM_LOOKUP_CALL,UpdateLookupCall)
	ON_COMMAND(IDM_LOOKUP_CALL,OnViewCallLookup)
	ON_COMMAND(IDM_ABOUT,OnAbout)
	ON_COMMAND(ID_VIEW_SHORTWAVE,OnViewShortWave)
	ON_UPDATE_COMMAND_UI(ID_VIEW_SHORTWAVE,UpdateViewShortWave)
    ON_COMMAND(ID_UP,KeyTuneUp)
    ON_COMMAND(ID_DOWN,KeyTuneDown)
	ON_COMMAND(ID_VIEW_SWEEPPANEL,OnViewSweepPanel)
	ON_UPDATE_COMMAND_UI(ID_VIEW_SWEEPPANEL,UpdateViewSweepPanel)
	ON_COMMAND(ID_VIEWSTATION,OnViewStationPanel)
	ON_UPDATE_COMMAND_UI(ID_VIEWSTATION,UpdateViewStationPanel)
	ON_COMMAND(IDM_TIMETUNE,ShowTimeDialog)
	ON_COMMAND(ID_VIEW_CONTROLBAR,OnViewControlBar)
	ON_UPDATE_COMMAND_UI(ID_VIEW_CONTROLBAR,UpdateViewControlBar)
	ON_COMMAND(IDM_FILEOPEN,OpenFile)
	ON_COMMAND(IDM_FILESAVEAS,SaveAsFile)
	ON_COMMAND(IDM_FILESAVE,SaveFile)
	ON_COMMAND(IDM_FILECLOSE,CloseFile)
	ON_COMMAND(IDM_NEWFILE,CloseFile)
	ON_UPDATE_COMMAND_UI(IDM_FILESAVEAS,UpdateMenuFileSaveAs)
	ON_UPDATE_COMMAND_UI(IDM_FILESAVE,UpdateMenuFileSave)
	ON_UPDATE_COMMAND_UI(IDM_FILECLOSE,UpdateMenuFileClose)
    ON_COMMAND(ID_STARTSWEEP,SpectrumSweep)
    ON_COMMAND(ID_SWEEPSTOP,StopSpectrumSweep)
    ON_COMMAND(ID_SWEEPCLICKFREQ,OnSweepClickFrequency)
    ON_COMMAND(ID_AM,SetModeAM)
    ON_COMMAND(ID_CW,SetModeCW)
    ON_COMMAND(ID_LSB,SetModeLSB)
    ON_COMMAND(ID_USB,SetModeUSB)
    ON_COMMAND(ID_FM,SetModeFM)
    ON_COMMAND(ID_VIEWMONITORBAR,OnViewMonitorBar)
	ON_COMMAND(IDC_QUERY_FWD,OnMonitorQueryFwd)
	ON_COMMAND(IDC_QUERY_REF,OnMonitorQueryRef)
	ON_COMMAND(IDC_QUERY_SMETER,OnMonitorQuerySMeter)
	ON_COMMAND(IDC_QUERY_ENVELOPE,OnMonitorQueryEnvelope)
	ON_COMMAND(IDC_QUERY_EPORT,OnMonitorQueryEPort)
    ON_COMMAND(IDC_CLR_MONITOR,OnClearMonitorWindow)
    ON_COMMAND(IDC_MANUAL_SEND,OnMonitorWindowManualSend)
	ON_UPDATE_COMMAND_UI(IDC_QUERY_FWD,UpdateMonitorControls)
	ON_UPDATE_COMMAND_UI(IDC_QUERY_REF,UpdateMonitorControls)
	ON_UPDATE_COMMAND_UI(IDC_QUERY_SMETER,UpdateMonitorControls)
    ON_UPDATE_COMMAND_UI(IDC_CLR_MONITOR,UpdateClearMonitorWindow)
    ON_UPDATE_COMMAND_UI(IDC_MANUAL_SEND,UpdateMonitorControls)
END_MESSAGE_MAP()

    
/* Main Application Window */
CMainWin::CMainWin()
{

	TopMostWindow=FALSE;
	obPtr=&obMemList;

	CClientDC DC(this);
	m_memDC.CreateCompatibleDC(&DC);

    m_FreqFont.CreateFont(48,0,0,0,FW_DONTCARE,0,0,0,ANSI_CHARSET,
    					OUT_TT_PRECIS,CLIP_DEFAULT_PRECIS,PROOF_QUALITY,
    					DEFAULT_PITCH|FF_DONTCARE,"Arial");
	

    m_SmallFont.CreateFont(14,0,0,0,FW_NORMAL,0,0,0,ANSI_CHARSET,
    					OUT_TT_PRECIS,CLIP_DEFAULT_PRECIS,PROOF_QUALITY,
    					DEFAULT_PITCH|FF_DONTCARE,"Arial");

    m_MicroFont.CreateFont(12,0,0,0,FW_BOLD,0,0,0,ANSI_CHARSET,
    					OUT_TT_PRECIS,CLIP_DEFAULT_PRECIS,PROOF_QUALITY,
    					DEFAULT_PITCH|FF_DONTCARE,"Arial");
    m_MiniFont.CreateFont(25,0,0,0,FW_DONTCARE,0,0,0,ANSI_CHARSET,
    					OUT_TT_PRECIS,CLIP_DEFAULT_PRECIS,PROOF_QUALITY,
    					DEFAULT_PITCH|FF_DONTCARE,"Arial");

     m_TinyFont.CreateFont(14,0,0,0,FW_DONTCARE,0,0,0,ANSI_CHARSET,
    					OUT_DEVICE_PRECIS,CLIP_DEFAULT_PRECIS,DEFAULT_QUALITY,
    					DEFAULT_PITCH|FF_DONTCARE,"Arial");


  	short xdim=GetSystemMetrics(SM_CXSCREEN);
	short ydim=GetSystemMetrics(SM_CYSCREEN);
	short startx=(xdim-MAINX)/2;
	short starty=(ydim-MAINY)/2;
	
	char tcwd[_MAX_DIR];										// Current Working Directory
    char tbuff[40];

	
	_getcwd(tcwd,_MAX_DIR);

	CString tstr;												// temporary string
	tstr=(const char*) tcwd;

	if(tstr.Right(1)=="\\")	strcat(tcwd,"pegasus.ini");
	else strcat(tcwd,"\\pegasus.ini");	

	GetPrivateProfileString("MAIN WINDOW","LOCATION","",tbuff,sizeof(tbuff),tcwd);
	CString CSTemp=(const char*) tbuff;

	if (!CSTemp.IsEmpty()) {
        MainWndrect.left = atoi((const char*) CSTemp);
        MainWndrect.top = atoi((const char*) CSTemp + 5);
        MainWndrect.right = atoi((const char*) CSTemp + 10);
        MainWndrect.bottom = atoi((const char*) CSTemp + 15);
      }
      else {
        MainWndrect = rectDefault;
			}

	GetPrivateProfileString("MAIN WINDOW","MAXIMIZE","TRUE",tbuff,sizeof(tbuff),tcwd);
	CSTemp=(const char*) tbuff;

	Create(NULL,(const char*)MainProgramWindowName,WS_OVERLAPPEDWINDOW, MainWndrect,NULL,"MAINMENU");
	if(CSTemp=="FALSE") ShowWindow(SW_SHOWNORMAL);
	else ShowWindow(SW_SHOWMAXIMIZED);	
	LoadAccelTable(MAKEINTRESOURCE(IDACC_RADIO_PANEL));
}


// This is the application class
class CApp: public CWinApp
{
public:
	CApp();
	virtual BOOL InitInstance();
	virtual BOOL OnIdle(LONG lCount);
	virtual BOOL PreTranslateMessage(MSG *pMsg);	
	virtual int ExitInstance();
	CSplashScreen *mpSplashScreen;
	DWORD mSplashTime;
};
          
CApp::CApp()
{
mpSplashScreen=NULL;
}


CApp::ExitInstance()
{
Ctl3dUnregister(AfxGetInstanceHandle());
return CWinApp::ExitInstance();
}
          

BOOL CApp::InitInstance()
{
	
HWND pFirstWnd,pFirstChildWnd;

if(pFirstWnd=FindWindow(NULL,(const char*) MainProgramWindowName))
	{
		pFirstChildWnd=GetLastActivePopup(pFirstWnd);
		BringWindowToTop(pFirstWnd);
		if(IsIconic(pFirstWnd))
			ShowWindow(pFirstWnd,SW_SHOWNORMAL);
		if(pFirstWnd!=pFirstChildWnd)
    		BringWindowToTop(pFirstChildWnd);
 	return (FALSE);
    }


// Handle Command Line Arguments
CString CSCmd=m_lpCmdLine;
if(CSCmd.Find("-BETA1")>=0)
{
}          
// end of command line arg handler



BeginWaitCursor();
mpSplashScreen = new CSplashScreen;
mpSplashScreen->Create();
mpSplashScreen->ShowWindow(SW_SHOW);
mpSplashScreen->UpdateWindow();
mSplashTime= ::GetCurrentTime();
SetDialogBkColor(RGB(192,192,192),RGB(0,0,0));
m_nCmdShow=SW_SHOW;//MAXIMIZED;
m_pMainWnd= new CMainWin;
m_pMainWnd->UpdateWindow();
return TRUE;
}


BOOL CApp::OnIdle(LONG lCount)
{
	BOOL result = CWinApp::OnIdle(lCount);
	
	if(mpSplashScreen != NULL) {
		if(::GetCurrentTime()-mSplashTime >= SPLASH_TIME) {
			mpSplashScreen->DestroyWindow();
			delete mpSplashScreen;
			mpSplashScreen=NULL;
			EndWaitCursor();

m_pMainWnd->ShowWindow(m_nCmdShow);
((CMainWin*)m_pMainWnd)->InitializeCommPort();			
((CMainWin*)m_pMainWnd)->WakeUpRadio();

		}
		else{
			result = TRUE;			
            }
		}            
	return result;
}	            
 
 
BOOL CApp::PreTranslateMessage(MSG *pMsg)
{ 

	if (mpSplashScreen != NULL){
    	if (pMsg->message == WM_KEYDOWN || pMsg->message == WM_SYSKEYDOWN ||
				pMsg->message == WM_LBUTTONDOWN || pMsg->message == WM_RBUTTONDOWN ||
				pMsg->message == WM_MBUTTONDOWN || pMsg->message == WM_NCLBUTTONDOWN ||
				pMsg->message == WM_NCRBUTTONDOWN || pMsg->message == WM_NCMBUTTONDOWN){
			if (pMsg->hwnd == mpSplashScreen->m_hWnd){
				mSplashTime -= SPLASH_TIME;
				}
			else{
				mpSplashScreen->DestroyWindow ();
				delete mpSplashScreen;
				mpSplashScreen = NULL;
                
				}
			}
		}
 	
 	return CWinApp::PreTranslateMessage(pMsg);
}
 
 
 
 
            
CApp App;   // instantiate the application

afx_msg void CMainWin::OnVScroll(UINT SBCode, UINT Pos, CScrollBar* SB)
{

if (GetDlgItem(ID_STEPSCROLL) == SB )
{
    switch(SBCode) {
        case SB_LINEUP:
			TuneStep+=01.00;
		    if(TuneStep>1e5) TuneStep=1e5;
            break;
        case SB_LINEDOWN:
			TuneStep-=01.00;
			if(TuneStep<0) TuneStep=0;
            break;
        }

}
}


afx_msg void CMainWin::OnUpdateFreqDisplay()
{                      
    CClientDC DC(this);
	DC.SetBkColor(RGB(0,50,255));
}

afx_msg void CMainWin::OnPaint()
{

CFrameWnd::OnPaint();
}
   
afx_msg void CMainWin::OnSize(UINT nType,int cx,int cy)
{

    CFrameWnd::OnSize(nType,cx,cy);
	return;
}



void CMainWin::SetFilter(int index)
{
	CString boxtext;
	int number;
	char commstring[20];
	char *tptr;
	int lp_count=0;

	m_FilterNumber=index;
	boxtext=MasterFilterList_TX550[index].name;
	number=MasterFilterList_TX550[index].dspfilter;
    SetRadioFrequencies();

	tptr=commstring;
	*tptr++='W';
	*tptr++=number&0xff;
	*tptr++='\r';
	*tptr++='\0';

 	SendToRadio(commstring,3);
	SetFocusToMain();	
}

void CMainWin::SetTxFilter(int index)
{

    int number;
	char commstring[20];
	char *tptr;
	number=MasterFilterList_TX550[index].dspfilter;
    m_iTxFilter=index;
	tptr=commstring;
	*tptr++='C';
	*tptr++=number&0xff;
	*tptr++='\r';
	*tptr++='\0';

 	SendToRadio(commstring,3);
	SetFocusToMain();	
}


BOOL CMainWin::OnEraseBkgnd(CDC* pDC)
{
	// Fill client area witrh solid color first
	CRect ClientClip;									
	GetClientRect(ClientClip);
	pDC->FillRect(ClientClip,(CBrush*) pDC->SelectStockObject(BLACK_BRUSH));
	pDC->FillRect(ClientClip,(CBrush*) pDC->SelectStockObject(BLACK_BRUSH));
	return TRUE;
}
 
 
 
int CMainWin::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
int left,top;
int width,height;

CRect SweepWndrect(0,0,0,0);
CRect RadioWndrect(0,0,0,0);
CRect StationWndrect(0,0,0,0);
CRect TxOpsWndrect(0,0,0,0);
CRect LookupWndrect(0,0,0,0);
char tcwd[_MAX_DIR];			// Current Working Directory
char tbuff[40];
CString CSTemp;

	LoadHamCallSupport();
	
	_getcwd(tcwd,_MAX_DIR);

	CString tstr;					// temporary string
	tstr=(const char*) tcwd;

	if(tstr.Right(1)=="\\")	strcat(tcwd,"pegasus.ini");
	else strcat(tcwd,"\\pegasus.ini");	


///////// Communications Logging Control
	GetPrivateProfileString("SPECIAL",  "COMMLOG","0",tbuff,sizeof(tbuff),tcwd);
	m_bCommLogging=atoi(tbuff);
	if(m_bCommLogging==1) OpenLogFile();



///////// SMeter ACTIVE?
	GetPrivateProfileString("OPERATING STATUS","SMETER ACTIVE","0",tbuff,sizeof(tbuff),tcwd);
	m_SMeterActive=atoi(tbuff);


///////// SWEEP WINDOW

	GetPrivateProfileString("SWEEP WINDOW","LOCATION","",tbuff,sizeof(tbuff),tcwd);
	CSTemp=(const char*) tbuff;
      	SweepWndrect = CRect(100,100,480,340);
		CalcWindowRect(SweepWndrect);
		width=SweepWndrect.Width();
		height=SweepWndrect.Height();

   if (!CSTemp.IsEmpty()) {
		left=atoi((const char*) CSTemp);
        top = atoi((const char*) CSTemp + 5);
		SweepWndrect.right=left+width;;
		SweepWndrect.bottom=top+height;
        SweepWndrect.left = left;
        SweepWndrect.top = top;
      }


	GetPrivateProfileString("SWEEP WINDOW","VISIBLE","FALSE",tbuff,sizeof(tbuff),tcwd);
	CSTemp=(const char*) tbuff;

	SweepPanel.Create(NULL,"SweepPanel",WS_SYSMENU|WS_CAPTION|WS_CLIPSIBLINGS|WS_CHILD|WS_BORDER,SweepWndrect,this,ID_SWLPANEL,NULL);
	if(CSTemp=="TRUE")SweepPanel.ShowWindow(SW_SHOW);
	SweepPanel.SetFont(&m_SmallFont);


///////// TRANSMIT OPTIONS WINDOW
	GetPrivateProfileString("TX OPTIONS WINDOW","LOCATION","",tbuff,sizeof(tbuff),tcwd);
	CSTemp=(const char*) tbuff;
      	TxOpsWndrect = CRect(100,100,480,350);
		CalcWindowRect(TxOpsWndrect);
		width=TxOpsWndrect.Width();
		height=TxOpsWndrect.Height();

   if (!CSTemp.IsEmpty()) {
		left=atoi((const char*) CSTemp);
        top = atoi((const char*) CSTemp + 5);
		TxOpsWndrect.right=left+width;;
		TxOpsWndrect.bottom=top+height;
        TxOpsWndrect.left = left;
        TxOpsWndrect.top = top;
      }

	TxOpsPanel.Create(NULL,"Transceiver Settings",WS_SYSMENU|WS_CAPTION|WS_CLIPSIBLINGS|WS_CHILD|WS_BORDER,TxOpsWndrect,this,ID_TXOPS_PANEL,NULL);
	TxOpsPanel.SetFont(&m_SmallFont);

	GetPrivateProfileString("TX OPTIONS WINDOW","VISIBLE","FALSE",tbuff,sizeof(tbuff),tcwd);
	CSTemp=(const char*) tbuff;
	if(CSTemp=="TRUE")TxOpsPanel.ShowWindow(SW_SHOW);

///////// DIALOG BAR
DialogBar.Create( this,IDD_CONTROLBAR1,CBRS_TOP, ID_CONTROLBAR1 );

MonitorBar.Create( this,IDD_MONITORBAR,CBRS_LEFT   , IDD_MONITORBAR );
MonitorBar.ShowWindow(SW_HIDE);
///////// STATION WINDOW

	GetPrivateProfileString("MEMORY WINDOW","LOCATION","",tbuff,sizeof(tbuff),tcwd);
	CSTemp=(const char*) tbuff;

      	StationWndrect = CRect(100,100,550,340);
		CalcWindowRect(StationWndrect);
		width=StationWndrect.Width();
		height=StationWndrect.Height();

   if (!CSTemp.IsEmpty()) {
		left=atoi((const char*) CSTemp);
        top = atoi((const char*) CSTemp + 5);
		StationWndrect.right=left+width;;
		StationWndrect.bottom=top+height;
        StationWndrect.left = left;
        StationWndrect.top = top;
      }


	StationPanel.Create(NULL,"Station Memories",WS_SYSMENU|WS_CAPTION|WS_CLIPSIBLINGS|WS_CHILD|WS_BORDER,StationWndrect,this,ID_STATIONPANEL,NULL);
	StationPanel.SetFont(&m_SmallFont);

	GetPrivateProfileString("MEMORY WINDOW","VISIBLE","FALSE",tbuff,sizeof(tbuff),tcwd);
	CSTemp=(const char*) tbuff;
	if(CSTemp=="TRUE")StationPanel.ShowWindow(SW_SHOW);

///////// RADIO WINDOW
	GetPrivateProfileString("RADIO WINDOW","LOCATION","",tbuff,sizeof(tbuff),tcwd);
	CSTemp=(const char*) tbuff;
        RadioWndrect = CRect(0,100,600,350);
		CalcWindowRect(RadioWndrect);
		width=RadioWndrect.Width();
		height=RadioWndrect.Height();

   if (!CSTemp.IsEmpty()) {
		left=atoi((const char*) CSTemp);
        top = atoi((const char*) CSTemp + 5);
		RadioWndrect.right=left+width;;
		RadioWndrect.bottom=top+height;
        RadioWndrect.left = left;
        RadioWndrect.top = top;
      }



/////// Ham Lookup Window
	GetPrivateProfileString("LOOKUP WINDOW","LOCATION","",tbuff,sizeof(tbuff),tcwd);
	CSTemp=(const char*) tbuff;

      	LookupWndrect = CRect(100,100,550,300);
		CalcWindowRect(LookupWndrect);
		width=LookupWndrect.Width();
		height=LookupWndrect.Height();

   if (!CSTemp.IsEmpty()) {
		left=atoi((const char*) CSTemp);
        top = atoi((const char*) CSTemp + 5);
		LookupWndrect.right=left+width;;
		LookupWndrect.bottom=top+height;
        LookupWndrect.left = left;
        LookupWndrect.top = top;
      }


	CallLookupPanel.Create(NULL,"Call Lookup",WS_SYSMENU|WS_CAPTION|WS_CLIPSIBLINGS|WS_CHILD|WS_BORDER,LookupWndrect,this,ID_CALLLOOKUPPANEL,NULL);
	CallLookupPanel.SetFont(&m_SmallFont);

	SwlPanel.Create(NULL,"Radio Window",WS_SYSMENU|WS_CHILD|WS_CLIPSIBLINGS|WS_CAPTION,RadioWndrect,this,ID_SWLPANEL,NULL);
	SwlPanel.SetFont(&m_SmallFont);

	GetPrivateProfileString("RADIO WINDOW","VISIBLE","TRUE",tbuff,sizeof(tbuff),tcwd);
	CSTemp=(const char*) tbuff;
	if(CSTemp=="TRUE")SwlPanel.ShowWindow(SW_SHOW);
	SwlPanel.BringWindowToTop();

	GetOperatingStatus();
	SwlPanel.UpdatePanelData(radio_freq,Mode,TuneStep,m_FilterNumber,Opp_radio_freq,OppMode);

	RecallMemFile();
	StationPanel.LoadListBox();

	load_band_definitions();
	InitializeTXOpsWindow();
	m_SweepStartFreq=radio_freq-(150*(m_SweepStepFreq/1e6));

	char tstring[16];
	sprintf(tstring,"%09.6f",radio_freq);	
	SweepPanel.StartFreqEditBox.SetWindowText(tstring);

	ShowRemoteTuneSelection();
	WakeUpRadio();
	return 0;	
}

void CMainWin::LoadNewIcon(LPCSTR nNewIcon)
{
	// Get handle to new and current Icon
	HICON hIconNew=AfxGetApp()->LoadIcon(nNewIcon);
	HICON hIconOld=GetClassIcon();
		
	ASSERT(hIconNew);
	ASSERT(hIconOld);
	
	// Substitute the new icon for the old (if different )
	// and redraw the window
	if(hIconNew!=hIconOld)
		{
			DestroyIcon(hIconOld);
			SetClassIcon(hIconNew);
			RedrawWindow(NULL,NULL,RDW_FRAME | RDW_ERASE | RDW_INVALIDATE);
		}
}



HICON CMainWin::GetClassIcon()
{
	HICON hIcon;
#ifdef _WIN32
	hIcon=(HICON) GetClassLong (CFrameWnd::GetSafeHwnd(),GCL_HICON);
#else						 
	hIcon=(HICON) GetClassWord (CFrameWnd::GetSafeHwnd(),GCW_HICON);
#endif
      
     return hIcon;
}

void CMainWin::SetClassIcon(HICON hIcon)
{
#ifdef _WIN32
	SetClassLong(CFrameWnd::GetSafeHwnd(),GCL_HICON, (LONG) hIcon);
#else
	SetClassWord(CFrameWnd::GetSafeHwnd(),GCW_HICON, (WORD) hIcon);
#endif	      

}



// Convert Frequency to proper format for radio and update radio
//

void CMainWin::SetRadioFrequencies()
{
	FrequencyToIndex(radio_freq);
	SweepPanel.SetIndicator(radio_freq);
    char comstring[20];//,str[20];
	char *tptr;
	double TFreq,IVal;
	int NVal,FVal;		// N value/finetune value
    int TBfo;			// temporary BFO 
	int IBfo;			// Intermediate BFO Freq
	int FilterBw;		// Filter Bandwidth determined from table

	int PbtAdj,RitAdj;

	PbtAdj=0;
	if(m_PbtActive==TRUE) PbtAdj=m_PbtFreq;

	RitAdj=0;
	if(m_RitActive==TRUE) RitAdj=m_RitFreq;



	FilterBw=FilterBandwidth(m_FilterNumber);

		{
		TFreq=radio_freq+(double)(m_FrequencyAdjustment/1e6)+(double)(RitAdj/1e6);

		if(Mode==USB_MODE)
		    {
			IBfo=(FilterBw/2)+200;
			TFreq=radio_freq+(double)(IBfo/1e6)+(double)(m_FrequencyAdjustment/1e6)+(double)(PbtAdj/1e6)+(double)(RitAdj/1e6);
			IBfo=IBfo+PbtAdj; 
            }


		if(Mode==LSB_MODE) 
			{
			IBfo=(FilterBw/2)+200;
			TFreq=radio_freq-(double)(IBfo/1e6)+(double)(m_FrequencyAdjustment/1e6)-(double)(PbtAdj/1e6)+(double)(RitAdj/1e6);
			IBfo=IBfo+PbtAdj; 
            }
		if(Mode==CW_MODE) 
		    {	
			// CW Mode uses LSB Mode 
			if (( (FilterBw/2)+300) <= Bfo)
			{
		 		IBfo=0;
				TFreq=radio_freq-(double)(IBfo/1e6)+(double)(m_FrequencyAdjustment/1e6)-(double)(PbtAdj/1e6)+(double)(RitAdj/1e6);
				IBfo=IBfo+PbtAdj+Bfo; 
			}		
			else
			{

		 	IBfo=(FilterBw/2)+300;
			TFreq=radio_freq-(double)(IBfo/1e6)+(double)(Bfo/1e6)+(double)(m_FrequencyAdjustment/1e6)-(double)(PbtAdj/1e6)+(double)(RitAdj/1e6);
			IBfo=IBfo+PbtAdj; 
			}		
			
			}	



		if(Mode==FM_MODE) 
		    {	
	    	IBfo=0;
			TFreq=radio_freq-(double)(IBfo/1e6)+(double)(Bfo/1e6)+(double)(m_FrequencyAdjustment/1e6)-(double)(PbtAdj/1e6)+(double)(RitAdj/1e6);
			IBfo=0;
			}		


		TFreq=TFreq-0.00125;
		NVal=(int)(TFreq*400);
		IVal=(double)((TFreq*400.0)-NVal);
		FVal=(int)(IVal*2500.0*5.46);
		NVal=(NVal+18000);

		tptr=comstring;
		*tptr++='N';
		*tptr++=(NVal>>8)&0xff;
		*tptr++=NVal&0xff;
							
        *tptr++=(FVal>>8)&0xff;
        *tptr++=FVal&0xff;

		TBfo=(int)(((double)IBfo+8000.0)*2.73);
		*tptr++=(TBfo>>8)&0xff;
		*tptr++=TBfo&0xff;
		*tptr++='\r';
		*tptr++='\0';
  	 	SendToRadio(comstring,8);
		}        	

	SetTxFrequencies();

	UpdateHamBandRegisters(radio_freq);


}

void CMainWin::SetTxFrequencies()
{
    char comstring[20];
	char *tptr;
	double TFreq,IVal;
	int NVal,FVal;		// N value/finetune value
    int TBfo;			// temporary BFO 
	int IBfo;			// Intermediate BFO Freq
	int bwBFO;			// BFO based on selected bandwidth
	int FilterBw;		// Filter Bandwidth determined from table
	char tmode;
	tmode=Mode;
	double txdispfreq;
	int XitAdj;



	XitAdj=0;
	if(m_XitActive==TRUE) XitAdj=m_XitFreq;

		{

		if(SplitMode) 
		{
		txdispfreq=Opp_radio_freq;
		tmode=OppMode;
		}
		else
		{
		txdispfreq=radio_freq;
		tmode=Mode;
		}



		TFreq=txdispfreq+(double)(XitAdj/1e6);

		IBfo=1500; //{ SSB fixed Tx for Now }
		
		FilterBw=FilterBandwidth(m_iTxFilter);
		bwBFO=(FilterBw/2)+200;

      	IBfo = (bwBFO>IBfo)?  bwBFO : IBfo ;

		TRACE("m_iTxFilter=%d filterbw=%d bwBFO=%d IBfo=%d\n",m_iTxFilter,FilterBw,bwBFO,IBfo);

		if(tmode==USB_MODE)
		    {
			TFreq=txdispfreq+(double)(IBfo/1e6)+(double)(XitAdj/1e6);
			TBfo=(int)(IBfo * 2.73);
            }


		if(tmode==LSB_MODE)
			{
			TFreq=txdispfreq-(double)(IBfo/1e6)+(double)(XitAdj/1e6);
			TBfo=(int)(IBfo * 2.73);
            }


		if(tmode==CW_MODE) 
		    {	
			// CW Mode uses LSB Mode 
			IBfo=1500;
			TFreq=txdispfreq-(double)(IBfo/1e6)+(double)(Bfo/1e6)+(double)(XitAdj/1e6);
			TBfo=(int)(Bfo * 2.73);
			}		


		if(tmode==FM_MODE) 
		    {	
	    	IBfo=0;
			TFreq=txdispfreq-(double)(IBfo/1e6)+(double)(m_FrequencyAdjustment/1e6)+(double)(XitAdj/1e6);
			TBfo=0;
			}		


		TFreq=TFreq-0.00125;
		NVal=(int)(TFreq*400);
		IVal=(double)((TFreq*400.0)-NVal);
		FVal=(int)(IVal*2500.0*5.46);
		NVal=(NVal+18000);

		tptr=comstring;
		*tptr++='T';
		*tptr++=(NVal>>8)&0xff;
		*tptr++=NVal&0xff;
							
        *tptr++=(FVal>>8)&0xff;
        *tptr++=FVal&0xff;
		*tptr++=(TBfo>>8)&0xff;
		*tptr++=TBfo&0xff;
		*tptr++='\r';
		*tptr++='\0';
  	 	SendToRadio(comstring,8);
		}        	



}

                    
afx_msg void CMainWin::OnClose()
{


int response;

if(ExitPassword!="") 
{
	response=ExitDialog.DoModal();
	if (response==IDCANCEL) return;
	if(ExitPassword!=ExitDialog.m_PasswordString) return;
}



if(m_DataModified) response=MessageBox(strFileName+" \n has beed modified ... Accept Changes?",
		"",MB_ICONQUESTION|MB_YESNOCANCEL);
if(response==IDCANCEL) return;
if(response==IDYES) SaveFile();

switch(m_MuteAlways)
{
case 0:response=IDYES;break;
case 1:response=IDOK;break;
case 2:response = MessageBox(" Mute Receiver Audio on Exit ?","Exit",MB_YESNOCANCEL|MB_ICONQUESTION);
        break;
}

if(response==IDCANCEL) return;
if(response==IDYES) 
{
	SetRadioVolume(0);
	SetAuxCodecVolume(0);
}	

SaveOperatingStatus();
CloseComm(idCommDev);
KillTimer(ID_TIMER1);
KillTimer(ID_TIMER_CLOCK);
FreeStationMemory();
FreeBandListMemory();
CloseLogFile();
CFrameWnd::OnClose();
}

                    
                                

void CMainWin::SendToRadio(char *comstring,int length)
{
	COMSTAT far ComStat;	
	int status;
    int mboxret=0;
	char tstring[256];
	char cstring[6];
	char comstatstring[64];
	int count;
    char *tptr;
    strcpy(tstring,"");
	strcpy(cstring,"");
    tptr=comstring;

	for(count=0;count<length;count++)
        {
        sprintf(cstring,"%02hX ",(unsigned char) *tptr++);
        strcat(tstring,cstring);
        }

if(MonitorBar.IsWindowVisible()) AddToDataOutWindow(tstring);

AddToLogWindowOut(tstring);

#ifdef COMMAND_STRING_TEST
	MessageBox(tstring,"COMMAND STRING",MB_OK);
#endif
	
		status=GetCommError(idCommDev,&ComStat);
       	sprintf(comstatstring,"Com Stat Before: %d",status);
		AddToLogWindowOut(comstatstring);

#ifdef COMM_ERROR_REPORT
		if(status & CE_TXFULL) 	mboxret=MessageBox("COMMUNICATIONS BUFFER FULL",comstatstring,MB_ABORTRETRYIGNORE);
		else if(status & CE_FRAME || status & CE_RXPARITY) mboxret=MessageBox("FRAME/PARITY ERROR",comstatstring,MB_ABORTRETRYIGNORE); 		
        else if(status !=0) mboxret=MessageBox("COMMUNICATION ERRORS",comstatstring,MB_ABORTRETRYIGNORE); 		
#endif		


	 	WriteComm(idCommDev,comstring,length);

		status=GetCommError(idCommDev,&ComStat);
       	sprintf(comstatstring,"Com Stat After : %d",status);
		AddToLogWindowOut(comstatstring);


if(m_bSweepActive==TRUE)
{
		SendStatus=BUSY;
		KillTimer(ID_TIMER1);
		SetTimer(ID_TIMER1,200,NULL);
}

}                    

afx_msg void CMainWin::OnTimer(UINT TimerID)
{
CString World;
CString Local;

switch(TimerID)
	{
	case ID_ASCIIDATA_SAVE:
	UpdateASCIIDataFile();
	break;

	case ID_ASCIIDATA_CHECK:
	CheckASCIIDataFile();
	break;

	case ID_SWEEPDELAYTIMER:
		KillTimer(TimerID);
		m_SMeterHoldOff=FALSE;
		SMeterTrigger();
        break;
	case ID_SMETERTIMER:
	if(m_SMeterHoldOff==TRUE) return;
	SMeterTrigger();

	break;	

	case ID_MESSAGETIMER:
	RemoveTimedMessageWindow();
	break;	

	case ID_TIMER1:
	SendStatus=CLEAR;
	KillTimer(TimerID);                    
	break;

	case ID_TIMER_CLOCK:
	CTime curtime=CTime::GetCurrentTime();
	Local=curtime.Format("LOC %H:%M:%S");
	SwlPanel.LocalTimeBox.SetWindowText(Local);
	CTime WorldTime(curtime.GetYear(),curtime.GetMonth(),curtime.GetDay(),
					curtime.GetHour()+m_iUtcHours,curtime.GetMinute()+m_iUtcMinutes,
					curtime.GetSecond());
	World=WorldTime.Format("UTC %H:%M:%S");
	SwlPanel.WorldTimeBox.SetWindowText(World);
	break;


	}

}
                    


afx_msg void CMainWin::OnExit()
{
CloseLogFile();
SendMessage(WM_CLOSE);
}




void CMainWin::DecreaseVolume()
{
 Volume-=3;
 if(Volume<0) Volume=0;
		SetRadioVolume(Volume);

		SwlPanel.SetVolume(Volume);	
		SetFocusToMain();	

}

void CMainWin::IncreaseVolume()
{
 Volume+=3;
 if(Volume>63) Volume=63;
		SetRadioVolume(Volume);
		SwlPanel.SetVolume(Volume);	

		SetFocusToMain();	
}


void CMainWin::SetRadioVolume(char vol)
{
if(MuteStatus==1) 	MuteAudio(); 
	

					   // 	  1  2  3  4  5  6  7  8  9 10 11 12 13 14 15 16 
static int VolTable[65]=	{00,00,10,16,21,24,27,30,31,35,37,38,39,40,41,42,
							 43,44,44,45,46,47,47,48,49,49,50,50,51,51,52,52,
							 53,53,54,54,54,55,55,56,56,56,57,57,57,58,58,58,
							 59,59,59,60,60,60,60,61,61,61,62,62,62,62,63,63}; 						


CString vstring;
int attn;

attn=VolTable[vol] * 2;


		char comstring[20];
	    char *tptr;
		tptr=comstring;

		*tptr++='V';
		*tptr++=attn&0xff;
		*tptr++='\r';
		*tptr++='\0';
        SendToRadio(comstring,3);
		return;
}

void CMainWin::SetRadioFilter(int filter)
{
		char comstring[20];
	    char *tptr;
		tptr=comstring;
		*tptr++='W';
		*tptr++=filter&0xff;
		*tptr++='\r';
		*tptr++='\0';
        SendToRadio(comstring,3);
		return;
}


void CMainWin::SetOutputPower(int power)
{
		char comstring[20];
	    char *tptr;
		tptr=comstring;

		m_PowerSetting=power;

		*tptr++='P';
		*tptr++=(m_PowerSetting!=0x0d) ? m_PowerSetting&0xff : 0x0E;
		*tptr++='\r';
		*tptr++='\0';
        SendToRadio(comstring,3);

		return;
}

void CMainWin::SetRFGain(int attn)
{
		char comstring[20];
	    char *tptr;
		tptr=comstring;

		m_RFGain=attn;
			*tptr++='A';
		*tptr++=attn&0xff;
		*tptr++='\r';
		*tptr++='\0';
        SendToRadio(comstring,3);

		return;
}


void CMainWin::MuteAudio()
{
	if(MuteStatus==0)
		{
		SetRadioVolume(0);
		SetAuxCodecVolume(0);
		SwlPanel.SetMute(TRUE);
		SetFocusToMain();	
		MuteStatus=1;
        return;
        }

		MuteStatus=0;
		SetRadioVolume(Volume);
		SetAuxCodecVolume(63);
		SwlPanel.SetMute(FALSE);

		SetFocusToMain();	

}





void CMainWin::ProgTuneUp(double FreqDelta)
{
    if(SendStatus!=CLEAR) return;
	CRect drect(40,6,307,51);
	radio_freq+=(FreqDelta/1e6);
            if(radio_freq>30.0) radio_freq=30.0;
    SetRadioFrequencies();
	SwlPanel.UpdatePanelData(radio_freq);

}

void CMainWin::ProgTuneDown(double FreqDelta)
{
    if(SendStatus!=CLEAR) return;
	CRect drect(40,6,307,51);
            radio_freq-=(FreqDelta/1e6);
            if(radio_freq<0) radio_freq=0;
    SetRadioFrequencies();
	SwlPanel.UpdatePanelData(radio_freq);

}


void CMainWin::SaveOperatingStatus()
{
	char tcwd[_MAX_DIR];	
	char tbuff[40];
	_getcwd(tcwd,_MAX_DIR);
	CString tstr;					// temporary string
	tstr=(const char*) tcwd;

	if(tstr.Right(1)=="\\")	strcat(tcwd,"pegasus.ini");
	else strcat(tcwd,"\\pegasus.ini");	

    sprintf(tbuff,"%09.6f",radio_freq);
	WritePrivateProfileString("OPERATING STATUS","VFO-A FREQUENCY",tbuff,tcwd);

    sprintf(tbuff,"%09.6f",Opp_radio_freq);
	WritePrivateProfileString("OPERATING STATUS","VFO-B FREQUENCY",tbuff,tcwd);

    sprintf(tbuff,"%d",SwlPanel.XitFreq);
	WritePrivateProfileString("OPERATING STATUS","XIT FREQUENCY",tbuff,tcwd);

    sprintf(tbuff,"%d",SwlPanel.RitFreq);
	WritePrivateProfileString("OPERATING STATUS","RIT FREQUENCY",tbuff,tcwd);

    sprintf(tbuff,"%d",SwlPanel.PbtFreq);
	WritePrivateProfileString("OPERATING STATUS","PBT FREQUENCY",tbuff,tcwd);

    sprintf(tbuff,"%d",SwlPanel.SqlLevel);
	WritePrivateProfileString("OPERATING STATUS","SQL SETTING",tbuff,tcwd);

    sprintf(tbuff,"%d",SwlPanel.SqlActive);
	WritePrivateProfileString("OPERATING STATUS","SQL STATUS",tbuff,tcwd);

    sprintf(tbuff,"%d",SwlPanel.PbtActive);
	WritePrivateProfileString("OPERATING STATUS","PBT STATUS",tbuff,tcwd);

    sprintf(tbuff,"%d",SwlPanel.XitActive);
	WritePrivateProfileString("OPERATING STATUS","XIT STATUS",tbuff,tcwd);

    sprintf(tbuff,"%d",SwlPanel.RitActive);
	WritePrivateProfileString("OPERATING STATUS","RIT STATUS",tbuff,tcwd);

    sprintf(tbuff,"%d",TxOpsPanel.TxHangSlider.GetSetting());
	WritePrivateProfileString("OPERATING STATUS","AUX T HANG",tbuff,tcwd);
	

    CString CMode="CW";
    if(Mode==AM_MODE) CMode="AM";
    if(Mode==CW_MODE) CMode="CW";
    if(Mode==LSB_MODE) CMode="LSB";
    if(Mode==USB_MODE) CMode="USB";
    if(Mode==FM_MODE) CMode="FM";

	WritePrivateProfileString("OPERATING STATUS","VFO-A MODE",CMode,tcwd);

    CMode="CW";
    if(OppMode==AM_MODE) CMode="AM";
    if(OppMode==CW_MODE) CMode="CW";
    if(OppMode==LSB_MODE) CMode="LSB";
    if(OppMode==USB_MODE) CMode="USB";
    if(OppMode==FM_MODE) CMode="FM";

	WritePrivateProfileString("OPERATING STATUS","VFO-B MODE",CMode,tcwd);


	sprintf(tbuff,"%d",Bfo);
	WritePrivateProfileString("OPERATING STATUS","BFO",tbuff,tcwd);
	sprintf(tbuff,"%d",Volume);
	WritePrivateProfileString("OPERATING STATUS","VOLUME",tbuff,tcwd);
	sprintf(tbuff,"%d",m_PowerSetting);
	WritePrivateProfileString("OPERATING STATUS","POWER",tbuff,tcwd);

	sprintf(tbuff,"%c",AgcMode);
	WritePrivateProfileString("OPERATING STATUS","AGC MODE",tbuff,tcwd);

	sprintf(tbuff,"%d",SwlPanel.FILTER1button.FilterIndex);
	WritePrivateProfileString("PREFERENCE","FILTER 1",tbuff,tcwd);

	sprintf(tbuff,"%d",SwlPanel.FILTER2button.FilterIndex);
	WritePrivateProfileString("PREFERENCE","FILTER 2",tbuff,tcwd);

	sprintf(tbuff,"%d",SwlPanel.FILTER3button.FilterIndex);
	WritePrivateProfileString("PREFERENCE","FILTER 3",tbuff,tcwd);

	sprintf(tbuff,"%d",SwlPanel.FILTER4button.FilterIndex);
	WritePrivateProfileString("PREFERENCE","FILTER 4",tbuff,tcwd);

	sprintf(tbuff,"%d",SwlPanel.FILTER5button.FilterIndex);
	WritePrivateProfileString("PREFERENCE","FILTER 5",tbuff,tcwd);

	sprintf(tbuff,"%d",SwlPanel.FILTER6button.FilterIndex);
	WritePrivateProfileString("PREFERENCE","FILTER 6",tbuff,tcwd);

	sprintf(tbuff,"%d",SwlPanel.FILTER7button.FilterIndex);
	WritePrivateProfileString("PREFERENCE","FILTER 7",tbuff,tcwd);

	sprintf(tbuff,"%d",SwlPanel.FILTER8button.FilterIndex);
	WritePrivateProfileString("PREFERENCE","FILTER 8",tbuff,tcwd);

	sprintf(tbuff,"%d",SwlPanel.FILTER9button.FilterIndex);
	WritePrivateProfileString("PREFERENCE","FILTER 9",tbuff,tcwd);

	TxOpsPanel.HamCallPathEditBox.GetWindowText(tstr);
	WritePrivateProfileString("PREFERENCE","HAM CALL",(const char *) tstr,tcwd);

	bMuteDuringSweep=TxOpsPanel.SweepMuteCheckBox.GetCheck();
    sprintf(tbuff,"%d",bMuteDuringSweep);
	WritePrivateProfileString("PREFERENCE","MUTE DURING SWEEP",tbuff,tcwd);

	sprintf(tbuff,"%d",m_FilterNumber);
	WritePrivateProfileString("OPERATING STATUS","RX FILTER",tbuff,tcwd);

	sprintf(tbuff,"%d",OppFilter);
	WritePrivateProfileString("OPERATING STATUS","VFO-B RX FILTER",tbuff,tcwd);

	sprintf(tbuff,"%d",m_iTxFilter);
	WritePrivateProfileString("OPERATING STATUS","TX FILTER",tbuff,tcwd);

	sprintf(tbuff,"%06.0f",TuneStep);
	WritePrivateProfileString("OPERATING STATUS","STEP",tbuff,tcwd);
	sprintf(tbuff,"%d",m_MuteAlways);
	WritePrivateProfileString("OPERATING STATUS","MUTE ALWAYS",tbuff,tcwd);

	sprintf(tbuff,"%d",m_TuningKnob_Status);
	WritePrivateProfileString("OPERATING STATUS","TUNING KNOB",tbuff,tcwd);

	sprintf(tbuff,"%d",m_iUtcHours);
	WritePrivateProfileString("OPERATING STATUS","UTC_HOUR_CORRECTION",tbuff,tcwd);


	sprintf(tbuff,"%d",m_iUtcMinutes);
	WritePrivateProfileString("OPERATING STATUS","UTC_MINUTE_CORRECTION",tbuff,tcwd);
	WritePrivateProfileString("OPERATING STATUS","MEMORY FILE",strFileName,tcwd);

	WritePrivateProfileString("INTERFACE","COMPORT", CommunicationsPort,tcwd);

	sprintf(tbuff,"%d",m_FrequencyAdjustment);
	WritePrivateProfileString("OPERATING STATUS","FREQUENCY CORRECTION",tbuff,tcwd);

	WINDOWPLACEMENT lpwndpl;
    lpwndpl.length = sizeof(WINDOWPLACEMENT);

	GetWindowPlacement(&lpwndpl);
	char tempstring[40];
	sprintf(tempstring,"%04d %04d %04d %04d",
	lpwndpl.rcNormalPosition.left,
	lpwndpl.rcNormalPosition.top,
	lpwndpl.rcNormalPosition.right,
	lpwndpl.rcNormalPosition.bottom);
	WritePrivateProfileString("MAIN WINDOW","LOCATION",tempstring,tcwd);
	if(lpwndpl.showCmd == SW_SHOWMAXIMIZED)	WritePrivateProfileString("MAIN WINDOW","MAXIMIZE","TRUE",tcwd);
	else WritePrivateProfileString("MAIN WINDOW","MAXIMIZE","FALSE",tcwd);

	SweepPanel.GetWindowPlacement(&lpwndpl);
	sprintf(tempstring,"%04d %04d",
	lpwndpl.rcNormalPosition.left,

	lpwndpl.rcNormalPosition.top);
	WritePrivateProfileString("SWEEP WINDOW","LOCATION",tempstring,tcwd);
	if(SweepPanel.IsWindowVisible())	WritePrivateProfileString("SWEEP WINDOW","VISIBLE","TRUE",tcwd);
	else WritePrivateProfileString("SWEEP WINDOW","VISIBLE","FALSE",tcwd);

	SwlPanel.GetWindowPlacement(&lpwndpl);
	sprintf(tempstring,"%04d %04d",
	lpwndpl.rcNormalPosition.left,
	lpwndpl.rcNormalPosition.top);
	WritePrivateProfileString("RADIO WINDOW","LOCATION",tempstring,tcwd);

	if(SwlPanel.IsWindowVisible()) WritePrivateProfileString("RADIO WINDOW","VISIBLE","TRUE",tcwd);
	else WritePrivateProfileString("RADIO WINDOW","VISIBLE","FALSE",tcwd);

	StationPanel.GetWindowPlacement(&lpwndpl);
	sprintf(tempstring,"%04d %04d",
	lpwndpl.rcNormalPosition.left,
	lpwndpl.rcNormalPosition.top);
	WritePrivateProfileString("MEMORY WINDOW","LOCATION",tempstring,tcwd);


	TxOpsPanel.GetWindowPlacement(&lpwndpl);
	sprintf(tempstring,"%04d %04d",
	lpwndpl.rcNormalPosition.left,
	lpwndpl.rcNormalPosition.top);
	WritePrivateProfileString("TX OPTIONS WINDOW","LOCATION",tempstring,tcwd);

    if(TxOpsPanel.IsWindowVisible())	WritePrivateProfileString("TX OPTIONS WINDOW","VISIBLE","TRUE",tcwd);
	else WritePrivateProfileString("TX OPTIONS WINDOW","VISIBLE","FALSE",tcwd);

	if(StationPanel.IsWindowVisible()) WritePrivateProfileString("MEMORY WINDOW","VISIBLE","TRUE",tcwd);
	else WritePrivateProfileString("MEMORY WINDOW","VISIBLE","FALSE",tcwd);

	WritePrivateProfileString("RADIO WINDOW","AUX",SwlPanel.AuxDisplayMode,tcwd);

	sprintf(tbuff,"%d",m_SidetoneVolume);
	WritePrivateProfileString("OPERATING STATUS","SIDETONE VOLUME",tbuff,tcwd);

	sprintf(tbuff,"%d",m_CWSpotVolume);
	WritePrivateProfileString("OPERATING STATUS","SPOT VOLUME",tbuff,tcwd);

	sprintf(tbuff,"%d",m_CWQSKSetting);
	WritePrivateProfileString("OPERATING STATUS","CW QSK DELAY",tbuff,tcwd);

	sprintf(tbuff,"%d",m_AntiVox);
	WritePrivateProfileString("OPERATING STATUS","ANTI VOX",tbuff,tcwd);

	sprintf(tbuff,"%d",m_VoxHang);
	WritePrivateProfileString("OPERATING STATUS","VOX HANG",tbuff,tcwd);

	sprintf(tbuff,"%d",m_VoxGain);
	WritePrivateProfileString("OPERATING STATUS","VOX GAIN",tbuff,tcwd);

	sprintf(tbuff,"%d",m_MicGain);
	WritePrivateProfileString("OPERATING STATUS","MIC GAIN",tbuff,tcwd);

	sprintf(tbuff,"%d",m_MonitorLevel);
	WritePrivateProfileString("OPERATING STATUS","MONITOR",tbuff,tcwd);

    sprintf(tbuff,"%d",m_bTxEnable);
	WritePrivateProfileString("OPERATING STATUS","TX ENABLE",tbuff,tcwd);

    sprintf(tbuff,"%d",m_bTxLoopEnable);
	WritePrivateProfileString("OPERATING STATUS","TX LOOP",tbuff,tcwd);

    sprintf(tbuff,"%d",m_bEnableKeyer);
	WritePrivateProfileString("OPERATING STATUS","KEYER",tbuff,tcwd);

	KeyerSpeed=TxOpsPanel.CWSpdSlider.GetSetting();
    sprintf(tbuff,"%d",KeyerSpeed);
	WritePrivateProfileString("OPERATING STATUS","KEYER SPEED",tbuff,tcwd);

	KeyerWeight=TxOpsPanel.GetKeyerWeightSetting();
    sprintf(tbuff,"%d",KeyerWeight);
	WritePrivateProfileString("OPERATING STATUS","KEYER WEIGHT",tbuff,tcwd);


	int cnt;

	for(cnt=0;cnt<MAXBANDS;cnt++)
	{
    sprintf(tbuff,"%09.6f",HamBands[cnt].LastFreq);
	WritePrivateProfileString(HamBands[cnt].name,"Frequency",tbuff,tcwd);
    sprintf(tbuff,"%d",HamBands[cnt].LastMode);
	WritePrivateProfileString(HamBands[cnt].name,"Mode",tbuff,tcwd);
    sprintf(tbuff,"%d",HamBands[cnt].LastFilter);
	WritePrivateProfileString(HamBands[cnt].name,"Filter",tbuff,tcwd);
	}	
	
	CString fkeypref;
	int selection;

	selection = TxOpsPanel.FKeyOneBox.GetCurSel();
	TxOpsPanel.FKeyOneBox.GetLBText( selection, fkeypref);
	WritePrivateProfileString("PREFERENCE","302 FUNCTION KEY 1",fkeypref,tcwd);

	selection = TxOpsPanel.FKeyTwoBox.GetCurSel();
	TxOpsPanel.FKeyTwoBox.GetLBText( selection, fkeypref);
	WritePrivateProfileString("PREFERENCE","302 FUNCTION KEY 2",fkeypref,tcwd);

	selection = TxOpsPanel.FKeyThreeBox.GetCurSel();
	TxOpsPanel.FKeyThreeBox.GetLBText( selection, fkeypref);
	WritePrivateProfileString("PREFERENCE","302 FUNCTION KEY 3",fkeypref,tcwd);



	


}	


void CMainWin::GetOperatingStatus()
{
	char tcwd[_MAX_DIR];			// Current Working Directory
    char tbuff[40];
	
	_getcwd(tcwd,_MAX_DIR);

	CString tstr;					// temporary string
	tstr=(const char*) tcwd;

	if(tstr.Right(1)=="\\")	strcat(tcwd,"pegasus.ini");
	else strcat(tcwd,"\\pegasus.ini");	


	strcpy(path,"");
	GetPrivateProfileString("INTERFACE","COMPORT","COM1",tbuff,sizeof(tbuff),tcwd);
	CommunicationsPort=tbuff;
	GetPrivateProfileString("OPERATING STATUS","MEMORY FILE","NONAME",tbuff,sizeof(tbuff),tcwd);
	strFileName=tbuff;
	GetPrivateProfileString("OPERATING STATUS","VFO-A FREQUENCY","15.000",tbuff,sizeof(tbuff),tcwd);
	radio_freq=atof(tbuff);	

	GetPrivateProfileString("OPERATING STATUS","VFO-B FREQUENCY","15.000",tbuff,sizeof(tbuff),tcwd);
	Opp_radio_freq=atof(tbuff);	
	SwlPanel.Opp_radio_freq=Opp_radio_freq;
	GetPrivateProfileString("OPERATING STATUS","BFO","700",tbuff,sizeof(tbuff),tcwd);
	Bfo=atoi(tbuff);
    
	GetPrivateProfileString("OPERATING STATUS","VOLUME","20",tbuff,sizeof(tbuff),tcwd);
	Volume=atoi(tbuff);
  	SwlPanel.SetVolume(Volume);
	if(m_FixedLineLevel_Status==TRUE) AuxCodecVolume=m_iFixedLineLevel;

	GetPrivateProfileString("OPERATING STATUS","SMETER ACTIVE","1",tbuff,sizeof(tbuff),tcwd);
	m_SMeterActive=atoi(tbuff);

	if(!m_SMeterActive) 
	{
	SwlPanel.PositionTimeDisplay();
	SwlPanel.SigMeter.ShowWindow(SW_HIDE);
	KillTimer(ID_SMETERTIMER);
	SwlPanel.Invalidate();
	}

	GetPrivateProfileString("OPERATING STATUS","MUTE ALWAYS","0",tbuff,sizeof(tbuff),tcwd);
	m_MuteAlways=atoi(tbuff);
	GetPrivateProfileString("OPERATING STATUS","FREQUENCY CORRECTION","0",tbuff,sizeof(tbuff),tcwd);
	m_FrequencyAdjustment=atoi(tbuff);
	GetPrivateProfileString("OPERATING STATUS","VFO-A MODE","AM",tbuff,sizeof(tbuff),tcwd);
    CString CMode=(const char*) tbuff;
	Mode=CW_MODE;
    if(CMode=="CW") Mode=CW_MODE;
    if(CMode=="AM") Mode=AM_MODE;
    if(CMode=="LSB") Mode=LSB_MODE;
    if(CMode=="USB") Mode=USB_MODE;
    if(CMode=="FM") Mode=FM_MODE;

	GetPrivateProfileString("OPERATING STATUS","VFO-B MODE","AM",tbuff,sizeof(tbuff),tcwd);
    CMode=(const char*) tbuff;
	OppMode=CW_MODE;
    if(CMode=="CW")  OppMode=CW_MODE;
    if(CMode=="AM")  OppMode=AM_MODE;
    if(CMode=="LSB") OppMode=LSB_MODE;
    if(CMode=="USB") OppMode=USB_MODE;
    if(CMode=="FM") OppMode=FM_MODE;


	GetPrivateProfileString("INTERFACE","COMPORT","COM1",tbuff,sizeof(tbuff),tcwd);
	CommunicationsPort=tbuff;

	GetPrivateProfileString("INTERFACE","MAX PORT","8",tbuff,sizeof(tbuff),tcwd);
	maxPort=atoi(tbuff);

	TxOpsPanel.LoadComListBox(maxPort);


	GetPrivateProfileString("OPERATING STATUS","TUNING KNOB","1",tbuff,sizeof(tbuff),tcwd);
	m_TuningKnob_Status=atoi(tbuff);

	GetPrivateProfileString("OPERATING STATUS","RX FILTER","1",tbuff,sizeof(tbuff),tcwd);
	m_FilterNumber=atoi(tbuff);

	GetPrivateProfileString("OPERATING STATUS","VFO-B RX FILTER","1",tbuff,sizeof(tbuff),tcwd);
	OppFilter=atoi(tbuff);



	if(m_FilterNumber<1) m_FilterNumber=1;
	GetPrivateProfileString("OPERATING STATUS","TX FILTER","15",tbuff,sizeof(tbuff),tcwd);
	m_iTxFilter=atoi(tbuff);

	SwlPanel.SetFilter(m_FilterNumber);
	SetFilter(m_FilterNumber);
	GetPrivateProfileString("OPERATING STATUS","STEP","1000",tbuff,sizeof(tbuff),tcwd);
	TuneStep=atof(tbuff);
	SwlPanel.ShowStep(TuneStep);
	GetPrivateProfileString("OPERATING STATUS","MEMORY FILE","NONAME",tbuff,sizeof(tbuff),tcwd);
	strFileName=tbuff;


	GetPrivateProfileString("OPERATING STATUS",  "UTC_HOUR_CORRECTION","9",tbuff,sizeof(tbuff),tcwd);
	m_iUtcHours=atoi(tbuff);
	sprintf(tbuff,"%+d",m_iUtcHours);
	TxOpsPanel.UTCHoursEdit.SetWindowText((const char *)tbuff); 

	GetPrivateProfileString("OPERATING STATUS","UTC_MINUTE_CORRECTION","0",tbuff,sizeof(tbuff),tcwd);
	m_iUtcMinutes=atoi(tbuff);
	SetTimer(ID_TIMER_CLOCK,1000,NULL);

	GetPrivateProfileString("OPERATING STATUS",  "POWER","0",tbuff,sizeof(tbuff),tcwd);
	m_PowerSetting=atoi(tbuff);

	GetPrivateProfileString("OPERATING STATUS",  "AGC MODE","1",tbuff,sizeof(tbuff),tcwd);
	AgcMode=tbuff[0];

	if(AgcMode<0x31 || AgcMode >0x33) AgcMode=0x32;

	SwlPanel.SetAgcMode(AgcMode);


	TxOpsPanel.SetPowerSetting(m_PowerSetting);

	GetPrivateProfileString("VISUAL","RADIO_PANEL","FALSE",tbuff,sizeof(tbuff),tcwd);
    if(tbuff=="TRUE") m_bSwlPanelVisible=TRUE;

	GetPrivateProfileString("OPERATING STATUS","METER CYCLE","50",tbuff,sizeof(tbuff),tcwd);
	meter_time=atoi(tbuff);

	GetPrivateProfileString("PREFERENCE","FILTER 1","1",tbuff,sizeof(tbuff),tcwd);
	SwlPanel.FILTER1button.ProgramFilterButton(atoi(tbuff));
	if(atoi(tbuff)==m_FilterNumber) SwlPanel.FILTER1button.SetSelected(TRUE); 
	

	GetPrivateProfileString("PREFERENCE","FILTER 2","4",tbuff,sizeof(tbuff),tcwd);
	SwlPanel.FILTER2button.ProgramFilterButton(atoi(tbuff));
	if(atoi(tbuff)==m_FilterNumber) SwlPanel.FILTER2button.SetSelected(TRUE); 


	GetPrivateProfileString("PREFERENCE","FILTER 3","11",tbuff,sizeof(tbuff),tcwd);
	SwlPanel.FILTER3button.ProgramFilterButton(atoi(tbuff));
	if(atoi(tbuff)==m_FilterNumber) SwlPanel.FILTER3button.SetSelected(TRUE); 


	GetPrivateProfileString("PREFERENCE","FILTER 4","15",tbuff,sizeof(tbuff),tcwd);
	SwlPanel.FILTER4button.ProgramFilterButton(atoi(tbuff));
	if(atoi(tbuff)==m_FilterNumber) SwlPanel.FILTER4button.SetSelected(TRUE); 


	GetPrivateProfileString("PREFERENCE","FILTER 5","19",tbuff,sizeof(tbuff),tcwd);
	SwlPanel.FILTER5button.ProgramFilterButton(atoi(tbuff));
	if(atoi(tbuff)==m_FilterNumber) SwlPanel.FILTER5button.SetSelected(TRUE); 


	GetPrivateProfileString("PREFERENCE","FILTER 6","24",tbuff,sizeof(tbuff),tcwd);
	SwlPanel.FILTER6button.ProgramFilterButton(atoi(tbuff));
   	if(atoi(tbuff)==m_FilterNumber) SwlPanel.FILTER6button.SetSelected(TRUE); 


	GetPrivateProfileString("PREFERENCE","FILTER 7","26",tbuff,sizeof(tbuff),tcwd);
	SwlPanel.FILTER7button.ProgramFilterButton(atoi(tbuff));
	if(atoi(tbuff)==m_FilterNumber) SwlPanel.FILTER7button.SetSelected(TRUE); 


	GetPrivateProfileString("PREFERENCE","FILTER 8","28",tbuff,sizeof(tbuff),tcwd);
	SwlPanel.FILTER8button.ProgramFilterButton(atoi(tbuff));
	if(atoi(tbuff)==m_FilterNumber) SwlPanel.FILTER8button.SetSelected(TRUE); 

	GetPrivateProfileString("PREFERENCE","FILTER 9","33",tbuff,sizeof(tbuff),tcwd);
	SwlPanel.FILTER9button.ProgramFilterButton(atoi(tbuff));
	if(atoi(tbuff)==m_FilterNumber) SwlPanel.FILTER9button.SetSelected(TRUE); 

	GetPrivateProfileString("PREFERENCE","HAM CALL","",tbuff,sizeof(tbuff),tcwd);
	TxOpsPanel.HamCallPathEditBox.SetWindowText(tbuff);


	GetPrivateProfileString("PREFERENCE","MUTE DURING SWEEP","1",tbuff,sizeof(tbuff),tcwd);
	bMuteDuringSweep=atoi(tbuff);

	GetPrivateProfileString("OPERATING STATUS",  "XIT FREQUENCY","0",tbuff,sizeof(tbuff),tcwd);
	m_XitFreq=atoi(tbuff);
	SwlPanel.XitFreq=m_XitFreq;			

	GetPrivateProfileString("OPERATING STATUS",  "RIT FREQUENCY","0",tbuff,sizeof(tbuff),tcwd);
	m_RitFreq=atoi(tbuff);
	SwlPanel.RitFreq=m_RitFreq;			

	GetPrivateProfileString("OPERATING STATUS",  "PBT FREQUENCY","0",tbuff,sizeof(tbuff),tcwd);
	m_PbtFreq=atoi(tbuff);
	SwlPanel.PbtFreq=m_PbtFreq;			

	GetPrivateProfileString("OPERATING STATUS",  "SQL LEVEL","0",tbuff,sizeof(tbuff),tcwd);
	m_SqlLevel=atoi(tbuff);
	SwlPanel.SqlLevel=m_SqlLevel;			
			
	GetPrivateProfileString("OPERATING STATUS",  "XIT STATUS","0",tbuff,sizeof(tbuff),tcwd);
	m_XitActive=atoi(tbuff);
	SwlPanel.XitActive=m_XitActive;
	
	GetPrivateProfileString("OPERATING STATUS",  "RIT STATUS","0",tbuff,sizeof(tbuff),tcwd);
	m_RitActive=atoi(tbuff);
	SwlPanel.RitActive=m_RitActive;

	GetPrivateProfileString("OPERATING STATUS",  "PBT STATUS","0",tbuff,sizeof(tbuff),tcwd);
	m_PbtActive=atoi(tbuff);
	SwlPanel.PbtActive=m_PbtActive;

	GetPrivateProfileString("OPERATING STATUS",  "SQL STATUS","0",tbuff,sizeof(tbuff),tcwd);
	m_SqlActive=atoi(tbuff);
	SwlPanel.SqlActive=m_SqlActive;

	if(m_SqlActive) SwlPanel.SQLbutton.SetSelected(TRUE);
	if(m_XitActive) SwlPanel.XITbutton.SetSelected(TRUE);
	if(m_RitActive) SwlPanel.RITbutton.SetSelected(TRUE);
	if(m_PbtActive) SwlPanel.PBTbutton.SetSelected(TRUE);

	GetPrivateProfileString("RADIO WINDOW","AUX","RIT",tbuff,sizeof(tbuff),tcwd);
	SwlPanel.AuxDisplayMode=(const char *) tbuff;

	GetPrivateProfileString("OPERATING STATUS",  "SIDETONE VOLUME","40",tbuff,sizeof(tbuff),tcwd);
	m_SidetoneVolume=atoi(tbuff);

	GetPrivateProfileString("OPERATING STATUS",  "SPOT VOLUME","20",tbuff,sizeof(tbuff),tcwd);
	m_CWSpotVolume=atoi(tbuff);

	GetPrivateProfileString("OPERATING STATUS",  "CW QSK DELAY","0",tbuff,sizeof(tbuff),tcwd);
	m_CWQSKSetting=atoi(tbuff);
	if(m_CWQSKSetting>127) m_CWQSKSetting=127;

	TxOpsPanel.CWQskSlider.SetSliderPos(m_CWQSKSetting);	

	GetPrivateProfileString("SPECIAL",  "PASSWORD","",tbuff,sizeof(tbuff),tcwd);
	ExitPassword=(const char *) tbuff;



	GetPrivateProfileString("OPERATING STATUS",  "VOX GAIN","15",tbuff,sizeof(tbuff),tcwd);
	m_VoxGain=atoi(tbuff);

	GetPrivateProfileString("OPERATING STATUS",  "ANTI VOX","92",tbuff,sizeof(tbuff),tcwd);
	m_AntiVox=atoi(tbuff);

	GetPrivateProfileString("OPERATING STATUS",  "VOX HANG","15",tbuff,sizeof(tbuff),tcwd);
	m_VoxHang=atoi(tbuff);

	GetPrivateProfileString("OPERATING STATUS",  "MIC GAIN","0",tbuff,sizeof(tbuff),tcwd);
	m_MicGain=atoi(tbuff);


	GetPrivateProfileString("OPERATING STATUS",  "AUX T HANG","0",tbuff,sizeof(tbuff),tcwd);
	iAuxTxHang=atoi(tbuff);
	

	GetPrivateProfileString("OPERATING STATUS",  "MONITOR","0",tbuff,sizeof(tbuff),tcwd);
	m_MonitorLevel=atoi(tbuff);

	GetPrivateProfileString("OPERATING STATUS","TX ENABLE","1",tbuff,sizeof(tbuff),tcwd);
	m_bTxEnable=atoi(tbuff);

	GetPrivateProfileString("OPERATING STATUS","TX LOOP","0",tbuff,sizeof(tbuff),tcwd);
	m_bTxLoopEnable=atoi(tbuff);


	GetPrivateProfileString("OPERATING STATUS","KEYER","0",tbuff,sizeof(tbuff),tcwd);
	m_bEnableKeyer=atoi(tbuff);
	TxOpsPanel.EnableKeyerCheckBox.SetCheck(m_bEnableKeyer);

	GetPrivateProfileString("OPERATING STATUS","KEYER SPEED ","25",tbuff,sizeof(tbuff),tcwd);
	KeyerSpeed=atoi(tbuff);
    TxOpsPanel.SetKeyerSetting(KeyerSpeed);

	GetPrivateProfileString("OPERATING STATUS","KEYER WEIGHT","100",tbuff,sizeof(tbuff),tcwd);
	KeyerWeight=atoi(tbuff);
    TxOpsPanel.SetKeyerWeightSetting(KeyerWeight);

	int cnt;
	
	for(cnt=0;cnt<MAXBANDS;cnt++)
	{
    sprintf(tbuff,"%09.6f",HamBands[cnt].LastFreq);
	GetPrivateProfileString(HamBands[cnt].name,"Frequency",tbuff,tbuff,sizeof(tbuff),tcwd);
	HamBands[cnt].LastFreq=atof(tbuff);	

    sprintf(tbuff,"%d",HamBands[cnt].LastMode);
	GetPrivateProfileString(HamBands[cnt].name,"Mode",tbuff,tbuff,sizeof(tbuff),tcwd);
	HamBands[cnt].LastMode=atoi(tbuff);	

    sprintf(tbuff,"%d",HamBands[cnt].LastFilter);
	GetPrivateProfileString(HamBands[cnt].name,"Filter",tbuff,tbuff,sizeof(tbuff),tcwd);
	HamBands[cnt].LastFilter=atoi(tbuff);	
	}	

    int selection;
	GetPrivateProfileString("PREFERENCE","302 FUNCTION KEY 1","",tbuff,sizeof(tbuff),tcwd);
	selection=TxOpsPanel.FKeyOneBox.FindString(-1,tbuff);
	TxOpsPanel.FKeyOneBox.SetCurSel(selection>=0? selection : 0);

	GetPrivateProfileString("PREFERENCE","302 FUNCTION KEY 2","",tbuff,sizeof(tbuff),tcwd);
	selection=TxOpsPanel.FKeyTwoBox.FindString(-1,tbuff);
	TxOpsPanel.FKeyTwoBox.SetCurSel(selection>=0? selection : 0);

	GetPrivateProfileString("PREFERENCE","302 FUNCTION KEY 3","",tbuff,sizeof(tbuff),tcwd);
	selection=TxOpsPanel.FKeyThreeBox.FindString(-1,tbuff);
	TxOpsPanel.FKeyThreeBox.SetCurSel(selection>=0? selection : 0);

	SetTimer(ID_ASCIIDATA_SAVE,ASCIIDATA_SAVE_INTERVAL,NULL);
	SetTimer(ID_ASCIIDATA_CHECK,ASCIIDATA_CHECK_INTERVAL,NULL);

} 



void CMainWin::InitializeRadio()
{
	ShowTimedMessageWindow("Initializing Radio");
	GetDSPVersion();
	SetMode(Mode,(SplitMode==TRUE)? OppMode : Mode);
	SetAgcMode(AgcMode);
	SetFilter(m_FilterNumber);
	SetRadioVolume(Volume);
	SetAuxCodecVolume(63);
	SwlPanel.SetVolume(Volume);	
	SetOutputPower(m_PowerSetting);
	SetCWSidetoneVolume(m_SidetoneVolume);
	SelectTxAudio(TxAudioSelect);
	SetVoxGain(m_VoxGain);
	SetVoxHang(m_VoxHang);
	SetAntiVox(m_AntiVox);
	SetVoxState(m_bVoxState);
	SetMonitorState(m_bMonitorState);
	SetTxLoopState(m_bTxLoopEnable);
	SetTxEnableState(m_bTxEnable);
	SetTxFilter(m_iTxFilter);
	SetKeyerState(m_bEnableKeyer);	
	SetSquelch(0);
	SetKeyerSpeed(KeyerSpeed,KeyerWeight);

	SetCWQSK(m_CWQSKSetting);
	m_SMeterResponse=TRUE;
	if(m_SMeterActive) SetTimer(ID_SMETERTIMER,meter_time,NULL);
	m_bRadioMode=TRUE;
	SetAuxTxHang(iAuxTxHang);
}


afx_msg void CMainWin::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	if(isdigit(nChar) || nChar=='.' || nChar==VK_DECIMAL)
	{
	GetDescendantWindow(ID_FREQUENCY_BOX,FALSE)->SetFocus();
	((CEdit*) GetDescendantWindow(ID_FREQUENCY_BOX,FALSE))->SetSel(0,-1,FALSE);
	GetDescendantWindow(ID_FREQUENCY_BOX,FALSE)->PostMessage(WM_CHAR,nChar,nRepCnt);
	return;
	}
	CFrameWnd::OnChar(nChar,nRepCnt,nFlags);	
}



void CMainWin::SetFocusToMain()
{
	SetFocus();
 	return;
}	


BOOL CMainWin::OnSetCursor(CWnd* pWnd, UINT nHitTest,UINT message)
{
return CFrameWnd::OnSetCursor(pWnd,nHitTest,message);
}     


afx_msg void CMainWin::HandleFileOpen()
{
 CFileDialog OpenDialog(TRUE,"rmf","*.rmf",NULL,"*.*",this);
 OpenDialog.m_ofn.lpstrTitle="Open Receiver Memory File";
 OpenDialog.m_ofn.lpstrFilter="Memory Files(*.rmf)\0*.rmf\0All Files(*.*)\0*.*\0";
 OpenDialog.DoModal();
 } 
 
 
 afx_msg void CMainWin::HandleFileSaveAs()
{
 CFileDialog OpenDialog(TRUE,"rmf","*.rmf",NULL,"*.*",this);
 OpenDialog.m_ofn.lpstrTitle="Open Receiver Memory File";
 OpenDialog.m_ofn.lpstrFilter="Memory Files(*.rmf)\0*.rmf\0All Files(*.*)\0*.*\0";
 OpenDialog.DoModal();
  }

void CMainWin::InitializeCommPort()
{
CString ComString;
CString errString;
CloseComm(idCommDev);

		idCommDev=OpenComm(CommunicationsPort,4096,4096);
		if (idCommDev <0)
			{ 
			switch(idCommDev)
				{
				case IE_HARDWARE:
				errString="Communications port "+CommunicationsPort+ " unavailable.\r\n\r\nThe port may be locked by another application.";
				AfxMessageBox(errString);
				break;
								
				case IE_OPEN:
				errString="Communications port "+CommunicationsPort+ " already open.\r\n\r\nThe port may be locked by another application.";
				AfxMessageBox(errString);
				break;
				
				case IE_BADID:
				errString="Communications port "+CommunicationsPort+ " is not a valid port assignment\r\non this system.\r\n\r\nPlease select another COMM Port.";
				AfxMessageBox( errString);
				break;
        		default:
				errString="Error accessing "+CommunicationsPort+ ".\r\n";
				AfxMessageBox( errString);
				break;
				}
				idCommDev=NULL;

			}				


		ComString=CommunicationsPort+":19200,N,8,1";

    	BuildCommDCB(ComString,&CommDCB);

	//	if(idCommDev<0) MessageBox("UNABLE TO OPEN PORT!","ERROR",MB_OK);


	// These items need to be set for all port openings	

	CommDCB.fRtsDisable=0x00;
	CommDCB.fDtrDisable=0x00;
	CommDCB.fOutxCtsFlow=0x01;
	CommDCB.fOutxDsrFlow=0x00;
	CommDCB.fOutX= 0x00;
	CommDCB.EvtChar=0x0d;
	CommDCB.CtsTimeout=255;
	CommDCB.fRtsflow=1;
	CommDCB.BaudRate=57600;  

	SetCommEventMask(idCommDev,EV_RXFLAG);
	SetCommState(&CommDCB);
	FlushComm(idCommDev, 1);
	FlushComm(idCommDev, 0);
	EnableCommNotification(idCommDev,m_hWnd,-1,-1);
}


afx_msg void CMainWin::UseComm1()
{
CommPort=1;
InitializeCommPort();
SaveOperatingStatus();
}

afx_msg void CMainWin::UseComm2()
{
CommPort=2;
InitializeCommPort();
SaveOperatingStatus();
}


afx_msg void CMainWin::UseComm3()
{
CommPort=3;
InitializeCommPort();
SaveOperatingStatus();
}




afx_msg void CMainWin::DecreaseStep()
{

if(TuneStep==100000)
{
TuneStep=50000;
SwlPanel.ShowStep(TuneStep);	
return;
}

if(TuneStep==50000)
{
TuneStep=10000;
SwlPanel.ShowStep(TuneStep);	
return;
}

switch((int)TuneStep)
	{
	case  10000: TuneStep=5000;break;
	case   5000: TuneStep=2500;break;
	case   2500: TuneStep=1000;break;
	case   1000: TuneStep=500;break;
	case    500: TuneStep=100;break;
	case    100: TuneStep=50;break;
	case     50: TuneStep=10;break;
	case     10: TuneStep=5;break;
	case      5: TuneStep=1;break;
	case      1: TuneStep=1;break;
	}	

SwlPanel.ShowStep(TuneStep);	
}

afx_msg void CMainWin::IncreaseStep()
{

if(TuneStep==100000)
{
TuneStep=100000;
SwlPanel.ShowStep(TuneStep);	
return;
}

if(TuneStep==50000)
{
TuneStep=100000;
SwlPanel.ShowStep(TuneStep);	
return;
}


switch((int) TuneStep)
	{
	case  10000: TuneStep=50000;break;
	case   5000: TuneStep=10000;break;
	case   2500: TuneStep=5000;break;
	case   1000: TuneStep=2500;break;
	case    500: TuneStep=1000;break;
	case    100: TuneStep=500;break;
	case     50: TuneStep=100;break;
	case     10: TuneStep=50;break;
	case      5: TuneStep=10;break;
	case      1: TuneStep=5;break;
	}	


SwlPanel.ShowStep(TuneStep);	

}

afx_msg LRESULT CMainWin::OnCommNotify(WPARAM wParam, LPARAM lParam)
{
unsigned char low_byte;
unsigned int high_byte;
int commstate;
char temp[255];
char cstring[64];
char tstring[64];
unsigned char key_byte;
CString CSTemp;

unsigned char fwd_pwr_reading,ref_pwr_reading;
int aux_encoder_movement;
int fkeysel;
float swr=0;
float rho;
char *tptr;
char *cp;
unsigned char count;
char mstring[64];

 commstate=GetCommError(idCommDev,NULL);
 sprintf(temp,"%d",commstate);
 int Status=GetCommEventMask(idCommDev,0x1fff);
 sprintf(cstring,"CS: %d   ST: %d",commstate,Status);
 AddToLogWindowIn(cstring);


 if(Status & EV_RXFLAG)
	{ 
	int cnt=ReadComm(idCommDev,temp,255);
    strcpy(tstring,"");
	strcpy(cstring,"");
    tptr=temp;
	*(tptr+cnt+1)='\0';	
    tptr=temp;

	for(count=0;count<cnt;count++)
        {
        sprintf(cstring,"%02hX ",(unsigned char) *tptr++);
        strcat(tstring,cstring);
        }

    tptr=temp;
if(MonitorBar.IsWindowVisible()) AddToDataInWindow(tstring);
AddToLogWindowIn(tstring);


	CString tCstring=(const char*) temp;



             if(tCstring.Find("RADIO")>=0)
			{
		if(MonitorBar.IsWindowVisible()) AddToDataInWindow("RADIO MODE DETECTED\n");

			strcpy(mstring,"Initializing Radio ");
			strcat(mstring,temp);		
			ShowTimedMessageWindow(mstring);
			InitializeRadio();		
            return (LRESULT)0;

			}			

				if(tCstring.Find("VER")>=0)
				{
				sscanf(tptr+4,"%d",&DSPVersion);
				sprintf(DSPVersionString,"DSP VERSION %1.3f",(double) (DSPVersion/1000.0));				
				m_SMeterHoldOff=FALSE;
				return (LRESULT)0;

				}			
		

				if(tCstring.Find("DSP")>=0)
				{
				m_bRadioMode=FALSE;
				KillTimer(ID_SMETERTIMER);
				if(MonitorBar.IsWindowVisible()) AddToDataInWindow("DSP MODE DETECTED\n");
				ActivateRadioMode();
				return (LRESULT)0;
				}



		tptr=temp;




for(cp=strpbrk(temp,"!UST");cp;cp=strpbrk(cp,"!UTS"))		
{
	switch(*cp)
	{
	case '!':
		high_byte=((unsigned int) (*(++cp))<<8);        // cp+1
		low_byte=((unsigned char) *(++cp));        		// cp+2

        aux_encoder_movement=high_byte|low_byte;
		key_byte=((unsigned char) *(++cp));				// cp+3
	if(SwlPanel.MainEncoder.GetEncoderState()==TRUE)
		{

		switch(cRemoteTuneControl)
		{
		case REMOTE_VFO_TUNE:
			{		
	    	if(aux_encoder_movement>0)	ProgTuneUp(TuneStep);
        	if(aux_encoder_movement<0)  ProgTuneDown(TuneStep);
			}
		break;
		case REMOTE_PBT_TUNE:
			{
	    	if(aux_encoder_movement>0)	SwlPanel.AuxTuneUp();
        	if(aux_encoder_movement<0)  SwlPanel.AuxTuneDown();
			}
		break;
		case REMOTE_XIT_TUNE:
			{
	    	if(aux_encoder_movement>0)	SwlPanel.AuxTuneUp();
        	if(aux_encoder_movement<0)  SwlPanel.AuxTuneDown();
			}
		break;
		case REMOTE_RIT_TUNE:
			{
	    	if(aux_encoder_movement>0)	SwlPanel.AuxTuneUp();
        	if(aux_encoder_movement<0)  SwlPanel.AuxTuneDown();
			}
		break;
		}//end switch
   	} //end if block
	break; // end of '!' command processing

case 'U':
	key_byte=((unsigned char) *(++cp));
	sprintf(tstring,"Key %u",key_byte);	
	if(MonitorBar.IsWindowVisible()) AddToDataInWindow(tstring);

	if((key_byte>=0x2b && key_byte<=0x39) ||key_byte==0x0d)   GetFocus( )->PostMessage(WM_CHAR,key_byte,0);
	if(key_byte==0x11) // F1 KEY Pressed
		{
		fkeysel=TxOpsPanel.FKeyOneBox.GetCurSel();
		unsigned int comid=(int)TxOpsPanel.FKeyOneBox.GetItemData(fkeysel);
		if(comid==ID_REMOTENEXTTUNE)
			{
				switch(cRemoteTuneControl)
				{
				case REMOTE_VFO_TUNE: cRemoteTuneControl=REMOTE_PBT_TUNE; break;
				case REMOTE_PBT_TUNE: cRemoteTuneControl=REMOTE_RIT_TUNE; break;
				case REMOTE_RIT_TUNE: cRemoteTuneControl=REMOTE_XIT_TUNE; break;
				case REMOTE_XIT_TUNE: cRemoteTuneControl=REMOTE_VFO_TUNE; break;
				}
			ShowRemoteTuneSelection();            
			}
		else SwlPanel.PostMessage(WM_COMMAND,comid,NULL);		
       }// end F1 keypress

	if(key_byte==0x12) // F2 KEY Pressed
        {
		fkeysel=TxOpsPanel.FKeyTwoBox.GetCurSel();
		unsigned int comid=(int)TxOpsPanel.FKeyTwoBox.GetItemData(fkeysel);
		if(comid==ID_REMOTENEXTTUNE)
		{
			switch(cRemoteTuneControl)
			{
			case REMOTE_VFO_TUNE: cRemoteTuneControl=REMOTE_PBT_TUNE; break;
			case REMOTE_PBT_TUNE: cRemoteTuneControl=REMOTE_RIT_TUNE; break;
			case REMOTE_RIT_TUNE: cRemoteTuneControl=REMOTE_XIT_TUNE; break;
			case REMOTE_XIT_TUNE: cRemoteTuneControl=REMOTE_VFO_TUNE; break;
			}
		ShowRemoteTuneSelection();            
		}
        else SwlPanel.PostMessage(WM_COMMAND,comid,NULL);		
        }// end F2 keypress

	if(key_byte==0x13) // F3 KEY Pressed
		{
		fkeysel=TxOpsPanel.FKeyThreeBox.GetCurSel();
		unsigned int comid=(int)TxOpsPanel.FKeyThreeBox.GetItemData(fkeysel);
		if(comid==ID_REMOTENEXTTUNE)
		{
			switch(cRemoteTuneControl)
			{
			case REMOTE_VFO_TUNE: cRemoteTuneControl=REMOTE_PBT_TUNE; break;
			case REMOTE_PBT_TUNE: cRemoteTuneControl=REMOTE_RIT_TUNE; break;
			case REMOTE_RIT_TUNE: cRemoteTuneControl=REMOTE_XIT_TUNE; break;
			case REMOTE_XIT_TUNE: cRemoteTuneControl=REMOTE_VFO_TUNE; break;
			}
		ShowRemoteTuneSelection();            
		}
        else SwlPanel.PostMessage(WM_COMMAND,comid,NULL);		
        } // end F3 keypress

		if(key_byte==0x91) // F1 KEY Released
        {
		fkeysel=TxOpsPanel.FKeyOneBox.GetCurSel();
		unsigned int comid=(int)TxOpsPanel.FKeyOneBox.GetItemData(fkeysel);
		if(comid==ID_REMOTESPLITREVERSE) SwlPanel.PostMessage(WM_COMMAND,comid,NULL);		
        }

		if(key_byte==0x92) // F2 KEY Released
        {
		fkeysel=TxOpsPanel.FKeyTwoBox.GetCurSel();
		unsigned int comid=(int)TxOpsPanel.FKeyTwoBox.GetItemData(fkeysel);
		if(comid==ID_REMOTESPLITREVERSE) SwlPanel.PostMessage(WM_COMMAND,comid,NULL);		
        }

		if(key_byte==0x93) // F3 KEY Released
        {
		fkeysel=TxOpsPanel.FKeyThreeBox.GetCurSel();
		unsigned int comid=(int)TxOpsPanel.FKeyThreeBox.GetItemData(fkeysel);
		if(comid==ID_REMOTESPLITREVERSE) SwlPanel.PostMessage(WM_COMMAND,comid,NULL);		
        }

break; // end 'U' command processing

case 'T':
		swr=-1;
		rho=-1;

		fwd_pwr_reading=((unsigned char) *(++cp));        // get fwd power cp+1
		ref_pwr_reading=((unsigned char) *(++cp));        // get ref power cp+2
		{

			fwd_pwr=fwd_pwr_reading;

			ref_pwr=ref_pwr_reading;

		}


		{


			if(ref_pwr!=fwd_pwr && fwd_pwr!=0) 
			{
			rho=(float)sqrt( fabs ((float)ref_pwr/(float)fwd_pwr))  ;
	    	swr=(float)((1.0+rho)/(1.0-rho));		// calculated swr
			}

		}



		if(m_MeterPreference==FORWARD_DISPLAY)		SwlPanel.SigMeter.SetIndicator(fwd_pwr,m_MeterPreference);
		if(m_MeterPreference==REFLECTED_DISPLAY)	SwlPanel.SigMeter.SetIndicator(ref_pwr,m_MeterPreference);
		if(m_MeterPreference==SWR_DISPLAY)			SwlPanel.SigMeter.SetIndicator((int)(swr*100),m_MeterPreference);

	sprintf(tstring,"F=%d / R=%d / Rho=%2.2f SWR=%6.4f",fwd_pwr,ref_pwr,rho,swr);	

	if(MonitorBar.IsWindowVisible()) AddToDataInWindow(tstring);
	sprintf(tstring,"%d Watts",fwd_pwr);

	if(TxOpsPanel.IsWindowVisible()) TxOpsPanel.ForwardPowerLabel.SetWindowText(tstring);				
	m_SMeterResponse=TRUE;


	if(!SplitMode) SwlPanel.FrequencyBox.SetColor(RGB(255,0,0));
	else SwlPanel.FrequencyBox2.SetColor(RGB(255,0,0));
	bPrevTx=TRUE;
break; // end 'T' command processing


case 'S':
		sscanf(++cp,"%4x",&smeterval);
		sprintf(tstring,"METER= %d",smeterval);

		AddToDataInWindow(tstring);	


		if( m_bSweepActive) SignalLevel(radio_freq,(int)smeterval);


        sigmeterval=smeterval;

		if(sigmeterval>peaksmeter) 
		{
			peaksmeter=sigmeterval;
			PeakHoldCount=PEAKTIME;
		}


		else 
		{

			if(PeakHoldCount==0) peaksmeter=(int)(peaksmeter*.80);
			else PeakHoldCount--;
		}        	


		if(peaksmeter<1) peaksmeter=1;
		if(sigmeterval<1) sigmeterval=1;

		
		SwlPanel.SigMeter.SetIndicator(sigmeterval);
		SwlPanel.SigMeter.SetPeakIndicator(peaksmeter);
		SwlPanel.FwdPwrMeter.ShowWindow(SW_HIDE);
		SwlPanel.SigMeter.ShowWindow(SW_SHOW);

		m_SMeterHoldOff=FALSE;				


	if(TxOpsPanel.IsWindowVisible() && TxOpsPanel.ForwardPowerLabel.GetWindowTextLength( ) !=0) TxOpsPanel.ForwardPowerLabel.SetWindowText("");				

	m_SMeterResponse=TRUE;


	if(bPrevTx)
		{

	if(!SplitMode) SwlPanel.FrequencyBox.SetColor(RGB(255,255,0));
	else SwlPanel.FrequencyBox2.SetColor(RGB(0,127,0));
	bPrevTx=FALSE;
break; // end of 'S' command processing
	}
}
}//end of for processing loop
}

return (LRESULT)0;
}





afx_msg LRESULT CMainWin::OnVolumeMove(WPARAM nID,LPARAM setting)
{
Volume=(int) setting;
SetRadioVolume(Volume);
return (LRESULT)0;
}


	
	
	
 void CMainWin::InterfaceOptions()
{
}
	
	
	

 void CMainWin::UserOptions()
{
}






void DelayOneSecond()
{

CTime starttime=CTime::GetCurrentTime();
while(TRUE)
{
CTime curtime=CTime::GetCurrentTime();
if(curtime!=starttime) return;
}

}


	
	
void CMainWin::AccessStationMemories()
{
	if(StationDialog.m_hWnd==NULL)
	{
	StationDialog.Create();
	}
	else
	{
	StationDialog.ShowWindow(SW_SHOW);
	}
}


	
void CMainWin::PreloadStations()
{
if(!obPtr->IsEmpty()) return;

for(int i=0;i<25;i++)
{

CStation* station=new CStation;

station->Name=Station_List[i].name;
station->Frequency=Station_List[i].frequency;
station->Country=Station_List[i].country;

obPtr->AddTail(station);

}

}


afx_msg LRESULT CMainWin::OnMemorySelect(WPARAM nID,LPARAM direction)
{
	char tstring[64];
	CString tmode;
	CString tfilter;
	int itemp;
	radio_freq=(StationPanel.m_FREQUENCY);
	tmode=StationPanel.m_MODE;
	Mode=AM_MODE;	// default Mode if no match found below that overides this
	if(tmode=="AM") Mode=AM_MODE;
	if(tmode=="CW") Mode=CW_MODE;
	if(tmode=="USB") Mode=USB_MODE;
	if(tmode=="LSB") Mode=LSB_MODE;
	if(tmode=="FM") Mode=FM_MODE;
	SwlPanel.MemBox.SetWindowText(StationPanel.m_NAME);
	SetRadioFrequencies();
	SetMode(Mode,(SplitMode==TRUE)? OppMode : Mode);
	tfilter=StationPanel.m_Filter;
	itemp=FilterTextToFilterNumber((const char*) tfilter);

	m_FilterNumber = (itemp>0)? itemp: 1;
	sprintf(tstring,"%0d %0s",m_FilterNumber,(const char*) tfilter);

	SetFilter(m_FilterNumber);
	CheckFilterHighlite(m_FilterNumber);
	SwlPanel.UpdatePanelData(radio_freq,Mode,NULL,m_FilterNumber);

	return 0;
}    

    
int CMainWin::FrequencyToIndex(double tfreq)	// Is Current Frequency in List???
{
double d_tfreq,d_mfreq,diff;

if(obPtr->IsEmpty()) return -1;

d_tfreq=(10000.00 * tfreq);
for(int i=0;i<(obPtr->GetCount());i++)
{
CStation* ePtr=(CStation*) obPtr->GetAt(obPtr->FindIndex(i));

	d_mfreq=(10000.00 * ePtr->Frequency);
	diff=d_tfreq-d_mfreq;

	if( fabs(diff)<5) 
		{
		SwlPanel.MemBox.SetWindowText(ePtr->Name);
		return i;
		}
}
SwlPanel.MemBox.SetWindowText("- - - - - -");
return -1;

}


afx_msg void CMainWin::OnActivate(UINT nState,CWnd* pOtherWnd,BOOL bMinimized)
{	
BringWindowToTop();
}	

	
void CMainWin::TuneToWWV()
{
radio_freq=10.00;

DelayOneSecond();
SetRadioFrequencies();

SetFocusToMain();
}

void CMainWin::SetAuxCodecVolume(int v)
{
static int VolTable[65]=	{00,00,10,16,21,24,27,30,31,35,37,38,39,40,41,42,
							 43,44,44,45,46,47,47,48,49,49,50,50,51,51,52,52,
							 53,53,54,54,54,55,55,56,56,56,57,57,57,58,58,58,
							 59,59,59,60,60,60,60,61,61,61,62,62,62,62,63,63}; 						
int attn;
attn=63-VolTable[v];


		char comstring[20];
	    char *tptr;
		tptr=comstring;

		*tptr++='L';
		*tptr++=attn&0xff;
		*tptr++='\r';
		*tptr++='\0';
        SendToRadio(comstring,3);
		return;
}






void CMainWin::FreeStationMemory()
{
CStation *pObj;
while(!obPtr->IsEmpty())
{
	pObj = (CStation*) obPtr->RemoveHead();
	delete pObj;
}

}


void CMainWin::RecallMemFile()
{
if(strFileName.IsEmpty() || strFileName=="NONAME") return;
TRY
{
CFile MemoryFile(strFileName,CFile::modeRead);
CArchive MemArchive(&MemoryFile,CArchive::load);
MemArchive >> obPtr;
	MemArchive.Close();
	MemoryFile.Close();
}

CATCH(CFileException,e)
{
}
END_CATCH


}


void CMainWin::AddStation()
{
 CEditStationDialog EditStation;

 EditStation.m_StationFrequency=radio_freq;	
 EditStation.m_StationName="UNKNOWN";	


 if(EditStation.DoModal()==IDCANCEL) return;

CStation* station=new CStation;

 station->Name=EditStation.m_StationName;
 station->Frequency=EditStation.m_StationFrequency;
 station->Filter=EditStation.m_StationFilter;
 station->Language=EditStation.m_StationLanguage;
 station->Mode=EditStation.m_StationMode;
 station->Country=EditStation.m_StationCountry;
 station->Address=EditStation.m_StationAddress;

obPtr->AddTail(station);

	StationPanel.LoadListBox();

m_DataModified=TRUE;
SetFocusToMain();


}



             
void CMainWin::ReceiverHelp()
{
 WinHelp(508,HELP_CONTENTS);
}

void CMainWin::TroubleShootingHelp()
{
 WinHelp(508,HELP_CONTEXT);
}




void CMainWin::WindowOnTop()
{
	AfxGetMainWnd()->SetWindowPos(&wndTopMost,0,0,0,0,SWP_NOSIZE|SWP_NOMOVE);
}

void CMainWin::WindowNotOnTop()
{
	AfxGetMainWnd()->SetWindowPos(&wndNoTopMost,0,0,0,0,SWP_NOSIZE|SWP_NOMOVE);
}
	
	              
void CMainWin::UpdateTopMostSelection(CCmdUI *pCmdUI)
{
 if(TopMostWindow==TRUE) pCmdUI->SetCheck(TRUE);		
 else pCmdUI->SetCheck(FALSE);
}

void CMainWin::ToggleTopMostSelection()
{
if(TopMostWindow==TRUE)
	{
	TopMostWindow=FALSE;
	WindowNotOnTop();
	}
else
	{
	TopMostWindow=TRUE;
	WindowOnTop();
	}
}



void CMainWin::KillSplashShowRadio()
{
App.mpSplashScreen->DestroyWindow();
delete App.mpSplashScreen;
App.mpSplashScreen=NULL;
AfxGetMainWnd()->ShowWindow(SW_SHOWMAXIMIZED || SW_RESTORE);
AfxGetMainWnd()->UpdateWindow();
} 



    
    
void CMainWin::OnAbout()
{
	GetDSPVersion();
	DelayOneSecond();	
	CAboutProgram AboutDialog;
	AboutDialog.m_GUIVersion=GUI_VERSION_TEXT;
	AboutDialog.m_DspVersion=DSPVersionString;


 AboutDialog.DoModal();
}   





void CMainWin::OnSysColorChange()
{
	Ctl3dColorChange();
}	

// ShortWave Panelized Functions
void CMainWin::OnViewShortWave()
{
SetFocusToMain();	

if(SwlPanel.IsWindowVisible()) 
{
	if(TopWnd == (CWnd*) GetDlgItem(ID_SWLPANEL)) SwlPanel.ShowWindow(SW_HIDE);
	else
	{
	SwlPanel.BringWindowToTop();
	TopWnd=(CWnd*) GetDlgItem(ID_SWLPANEL);
	}
}
else 
{
SwlPanel.ShowWindow(SW_SHOW);
SwlPanel.BringWindowToTop();
TopWnd=(CWnd*) GetDlgItem(ID_SWLPANEL);
}

}



void CMainWin::UpdateViewShortWave(CCmdUI *pCmdUI)
{
 if(SwlPanel.IsWindowVisible()) pCmdUI->SetCheck(TRUE);		
 else pCmdUI->SetCheck(FALSE);
}

// Sweep Panelized Functions
void CMainWin::OnViewSweepPanel()
{
SetFocusToMain();	
if(SweepPanel.IsWindowVisible()) 
{
	if(TopWnd == (CWnd*) GetDlgItem(ID_SWEEPPANEL)) SweepPanel.ShowWindow(SW_HIDE);
	else
	{
	SweepPanel.BringWindowToTop();
	TopWnd=(CWnd*) GetDlgItem(ID_SWEEPPANEL);
	}
}
else 
{
SweepPanel.ShowWindow(SW_SHOW);
SweepPanel.BringWindowToTop();
TopWnd=(CWnd*) GetDlgItem(ID_SWEEPPANEL);
}
}

void CMainWin::UpdateViewSweepPanel(CCmdUI *pCmdUI)
{
 if(SweepPanel.IsWindowVisible()) pCmdUI->SetCheck(TRUE);		
 else pCmdUI->SetCheck(FALSE);
}

// Sweep Panelized Functions
void CMainWin::OnViewStationPanel()
{
CWnd* Wnd;
Wnd = (CWnd*) GetDlgItem(ID_STATIONPANEL);
SetFocusToMain();	
if(StationPanel.IsWindowVisible()) 
{



	if( (CWnd*) GetLastActivePopup()==Wnd || TopWnd == Wnd) StationPanel.ShowWindow(SW_HIDE);
	else
	{
	StationPanel.BringWindowToTop();
	TopWnd=(CWnd*) GetDlgItem(ID_STATIONPANEL);
	}



}
else 
{
StationPanel.ShowWindow(SW_SHOW);
StationPanel.BringWindowToTop();
TopWnd=(CWnd*) GetDlgItem(ID_STATIONPANEL);
}
}

void CMainWin::UpdateViewStationPanel(CCmdUI *pCmdUI)
{
 if(StationPanel.IsWindowVisible()) pCmdUI->SetCheck(TRUE);		
 else pCmdUI->SetCheck(FALSE);
}







void CMainWin::ProgramRadio(double NewFreq,char NewMode,int NewStep,int NewFilter)
{
	if(NewFreq!=radio_freq) 
	{ 	radio_freq=NewFreq;
		SetRadioFrequencies();
	}
	
	if(NewMode!=Mode)
	{
    Mode=NewMode;
    }



}


void CMainWin::OnSwlPanelChanged()
{
BOOL bRecalc=FALSE;

if(!m_bRadioMode) return;

if(radio_freq!=SwlPanel.GetFrequency())
	{
	radio_freq=SwlPanel.GetFrequency();
	bRecalc=TRUE;
	}

if(Opp_radio_freq!=SwlPanel.Opp_radio_freq)
	{
	Opp_radio_freq=SwlPanel.Opp_radio_freq;
	}



if(!m_bTuneActive)
{
	if(Mode!=SwlPanel.GetMode())
		{
		Mode=SwlPanel.GetMode();
		bRecalc=TRUE;
		SetMode(Mode,(SplitMode==TRUE)? OppMode : Mode);
		}

	if(OppMode!=SwlPanel.GetOppMode())
		{
		OppMode=SwlPanel.GetOppMode();
		bRecalc=TRUE; 
		SetMode(Mode,(SplitMode==TRUE)? OppMode : Mode);
		}
}




	if(Volume!=SwlPanel.GetVolume())
	{
	Volume=SwlPanel.GetVolume();
	SetRadioVolume(Volume);
	}	




	if(m_FilterNumber!=SwlPanel.GetFilter())
	{
	SetFilter(SwlPanel.GetFilter());
	}

	TuneStep=SwlPanel.GetTuneStep();




	if (AgcMode!=SwlPanel.m_AgcMode) SetAgcMode(SwlPanel.m_AgcMode);




	if(SwlPanel.bAttnState!=m_bAttnState) SetAttnState(SwlPanel.bAttnState);



	if(SwlPanel.MonActive!=m_bMonitorState) SetMonitorState(SwlPanel.MonActive);

	if(SwlPanel.VoxActive!=m_bVoxState) SetVoxState(SwlPanel.VoxActive);

	if(SwlPanel.SpotActive!=m_bSpotState) 
	{
		m_bSpotState=SwlPanel.SpotActive;
		SetCWSpotVolume((m_bSpotState==TRUE)? m_CWSpotVolume : 0);
	}

	if(SwlPanel.TuneActive!=m_bTuneActive) SetTuneState(SwlPanel.TuneActive);

	if(SwlPanel.ManualTxActive!=m_bManualTxActive) SetManualTxState(SwlPanel.ManualTxActive);

	if(SwlPanel.rfgain!=m_RFGain) SetRFGain(SwlPanel.rfgain);

	if(SwlPanel.bNRState!=m_bNRState)
		{
		 m_bNRState=SwlPanel.bNRState;
		 SetAdaptiveFilterStates(m_bNRState,m_bANState); 
		}		 

	if(SwlPanel.bANState!=m_bANState)
		{
		 m_bANState=SwlPanel.bANState;
		 SetAdaptiveFilterStates(m_bNRState,m_bANState); 
		}		 


	if(m_PbtFreq!=SwlPanel.PbtFreq)
	{
		m_PbtFreq=SwlPanel.PbtFreq;
		bRecalc=TRUE;		
	}


	if(m_RitFreq!=SwlPanel.RitFreq)
	{
		m_RitFreq=SwlPanel.RitFreq;
		bRecalc=TRUE;		
	}

	if(m_XitFreq!=SwlPanel.XitFreq)
	{
		m_XitFreq=SwlPanel.XitFreq;
		bRecalc=TRUE;		
	}

	if(SwlPanel.XitActive!=m_XitActive || SwlPanel.RitActive!=m_RitActive ||SwlPanel.PbtActive!=m_PbtActive ) 	bRecalc=TRUE;
	m_RitActive=SwlPanel.RitActive;
	m_XitActive=SwlPanel.XitActive;
	m_SqlActive=SwlPanel.SqlActive;
	m_PbtActive=SwlPanel.PbtActive;

	if(SwlPanel.bSplitState!=SplitMode) 
		{
		bRecalc=TRUE;
		SplitMode=SwlPanel.bSplitState;
	SetMode(Mode,(SplitMode==TRUE)? OppMode : Mode);

		}	



	if (bRecalc==TRUE) 
	{
	SetRadioFrequencies();
	}

	if(SwlPanel.TuneActive!=m_bTuneActive) 
	{
	SetTuneState(SwlPanel.TuneActive);
	SetRadioFrequencies();
	}



	if(squelch_Slevel!=SwlPanel.m_Squelch)
		{
		squelch_Slevel=SwlPanel.m_Squelch;
		SetSquelch(squelch_Slevel);			
		}



}


void CMainWin::SetMode(char rxMode,char txMode)
{
		char comstring[20];
	    char *tptr;
		tptr=comstring;

		*tptr++='M';
		*tptr++=rxMode;
		*tptr++=txMode;

		*tptr++='\r';
		*tptr++='\0';
        SendToRadio(comstring,4);

}

void CMainWin::SetAgcMode(char iMode)
{
		AgcMode=iMode;
		char comstring[20];
	    char *tptr;
		tptr=comstring;
		*tptr++='G';
		*tptr++=iMode;
		*tptr++='\r';
		*tptr++='\0';
       SendToRadio(comstring,3);

}


void CMainWin::SetSquelch(char s_units)
{
		char comstring[20];
	    char *tptr;
		tptr=comstring;
		*tptr++='S';
		*tptr++=s_units;
		*tptr++='\r';
		*tptr++='\0';
       SendToRadio(comstring,3);

}


void CMainWin::SetTxMode(char rxmode,char txmode)
{
	return;
}

void CMainWin::SetAttnState(BOOL bSet)
{
	m_bAttnState=bSet;
	if(bSet==TRUE) SendToRadio("B1\r",3);
	else SendToRadio("B0\r",3);
}


void CMainWin::SetMonitor(int setting)
{
		char comstring[20];
	    char *tptr;
		tptr=comstring;
		*tptr++='H';
		*tptr++=setting & 0x3f;
		*tptr++='\r';
		*tptr++='\0';
        SendToRadio(comstring,3);
}



void CMainWin::SetMonitorState(BOOL bSet)
{
	m_bMonitorState=bSet;
	if(bSet==TRUE) SetMonitor(m_MonitorLevel);
	else SetMonitor(0);
}

void CMainWin::SetVoxState(BOOL bSet)
{
	m_bVoxState=bSet;
	if(bSet==TRUE) SendToRadio("U1\r",3);
	else SendToRadio("U0\r",3);

}


void CMainWin::SetTuneState(BOOL bSet)
{
m_bTuneActive=bSet;
if(bSet==TRUE) 
{	
SendToRadio("Q1\r",3);
PrevOppMode=OppMode;
OppMode=CW_MODE;
PrevMode=Mode;
Mode=CW_MODE;
SetMode(CW_MODE,CW_MODE);
SetRadioFrequencies();
SwlPanel.TUNEbutton.SetSelected(TRUE);
TxOpsPanel.PowerTune.SetSelected(TRUE);
SwlPanel.TuneActive=TRUE;
TxOpsPanel.TuneState=TRUE;
}
else 
{
SendToRadio("Q0\r",3);
Mode=PrevMode;
OppMode=PrevOppMode;
SetMode(Mode,(SplitMode==TRUE)? OppMode : Mode);
SetRadioFrequencies();
SwlPanel.TUNEbutton.SetSelected(FALSE);
TxOpsPanel.PowerTune.SetSelected(FALSE);
SwlPanel.TuneActive=FALSE;
TxOpsPanel.TuneState=FALSE;
}
}

void CMainWin::SetManualTxState(BOOL bSet)
{
	m_bManualTxActive=bSet;
if(bSet==TRUE) 
{	
SendToRadio("Q1\r",3);
}
else 
{
SendToRadio("Q0\r",3);
}
}






afx_msg void CMainWin::OnSysCommand( UINT nID, LPARAM lParam )
{

if(ExitPassword!="")
{
	switch(nID)
	{
	case SC_MINIMIZE: 	return;break;
	case SC_CLOSE:		return;break;
	case SC_NEXTWINDOW:	return;break;
	case SC_RESTORE:	return;break;
	case SC_SIZE:		return;break;
	case SC_TASKLIST:	return;break;
	}

}

	CFrameWnd::OnSysCommand( nID, lParam );	 	
}







void CMainWin::KeyTuneUp()
{
		radio_freq=SwlPanel.radio_freq;


            radio_freq+=(TuneStep/1e6);
            if(radio_freq>30.0) radio_freq=30.0;
    SwlPanel.MainEncoder.MoveEncoder(CLOCKWISE);
    SetRadioFrequencies();
	SwlPanel.UpdatePanelData(radio_freq);
}


void CMainWin::KeyTuneDown()
{
		radio_freq=SwlPanel.radio_freq;

            radio_freq-=(TuneStep/1e6);
            if(radio_freq<0) radio_freq=0;
	SwlPanel.MainEncoder.MoveEncoder(COUNTERCLOCKWISE);
    SetRadioFrequencies();
	SwlPanel.UpdatePanelData(radio_freq);
}






void CMainWin::CloseFile()
{
int response;
if(m_DataModified) response=MessageBox(strFileName+" \n has beed modified ... Save Changes?",
		"",MB_ICONQUESTION|MB_YESNOCANCEL);
if(response==IDCANCEL) return;
if(response==IDYES) SaveFile();

POSITION pos=obPtr->GetHeadPosition();

while( pos != NULL)
{
	CStation *pObj = (CStation*) obPtr->GetNext(pos);
	delete pObj;
}

obPtr->RemoveAll();
strFileName="NONAME";
StationPanel.LoadListBox();
UpdateFileName();
m_DataModified=FALSE;
} 

void CMainWin::SaveFile()
{
if(strFileName=="NONAME")
{
	CFileDialog FileDialog(FALSE,"rmf",NULL,OFN_OVERWRITEPROMPT,"Memory Files(*.rmf)|*.rmf|All files(*.*)|*.*||",this);

	if(FileDialog.DoModal()==IDCANCEL) 
	{
	return;
    }
strFileName=FileDialog.GetPathName();
}

CFile MemoryFile(strFileName,CFile::modeCreate|CFile::modeWrite);
CArchive MemArchive(&MemoryFile,CArchive::store);
MemArchive<< obPtr;
	MemArchive.Close();
	MemoryFile.Close();

m_DataModified=FALSE;
}

void CMainWin::OnUpdateFileOpen(CCmdUI* pCmdUI)
{
 MessageBox("FILEOPEN UI","TEST",MB_OK);
}

void CMainWin::OnUpdateFileSave(CCmdUI* pCmdUI)
{
 MessageBox("FILESAVE UI","TEST",MB_OK);
}
                                     
void CMainWin::OnUpdateFileSaveAs(CCmdUI* pCmdUI)
{
 MessageBox("FILESAVEAS UI","TEST",MB_OK);
}

void CMainWin::OnUpdateFileClose(CCmdUI* pCmdUI)
{
 MessageBox("FILECLOSE UI","TEST",MB_OK);
}

void CMainWin::SaveAsFile()
{


CFileDialog FileDialog(FALSE,"rmf",NULL,OFN_OVERWRITEPROMPT,"Memory Files(*.rmf)|*.rmf|All files(*.*)|*.*||",this);

if(FileDialog.DoModal()==IDCANCEL) 
	{
	return;
    }
UpdateFileName();

TRY
{
CFile MemoryFile(FileDialog.GetPathName(),CFile::modeCreate|CFile::modeWrite);
CArchive MemArchive(&MemoryFile,CArchive::store);
MemArchive<< obPtr;
	MemArchive.Close();
	MemoryFile.Close();

}

CATCH(CFileException,e)
{
 if(e->m_cause == CFileException::accessDenied)
 	MessageBox("ERROR: Access to File Denied","CFileException",MB_OK);
}
END_CATCH

m_DataModified=FALSE;
}



void CMainWin::OpenFile()
{
if(m_DataModified) CloseFile();
if(m_DataModified) return;

CFileDialog FileDialog(TRUE,"rmf",NULL,OFN_OVERWRITEPROMPT,"Memory Files(*.rmf)|*.rmf|All files(*.*)|*.*||",this);

if(FileDialog.DoModal()==IDCANCEL) 
	{
	return;
    }
if(!(obPtr->IsEmpty())) FreeStationMemory();

UpdateFileName();

TRY
{
strFileName=FileDialog.GetPathName();
CFile MemoryFile(FileDialog.GetPathName(),CFile::modeRead);
CArchive MemArchive(&MemoryFile,CArchive::load);
MemArchive >> obPtr;
	MemArchive.Close();
	MemoryFile.Close();
}

CATCH(CFileException,e)
{
 if(e->m_cause == CFileException::fileNotFound)
 	MessageBox("Unable to locate file: "+strFileName,"Error- File Not Found",MB_OK);
	return;
}
END_CATCH

//#ifdef _DEBUG
//afxDump.SetDepth(1);
//afxDump<< &obPtr;
//#endif

StationPanel.LoadListBox();
m_DataModified=FALSE;
}


void CMainWin::UpdateFileName()
{
}


void CMainWin::OnViewControlBar()
{
 if(DialogBar.IsWindowVisible()) DialogBar.ShowWindow(SW_HIDE);
	else DialogBar.ShowWindow(SW_SHOW);
	RecalcLayout();
	return;
}


void CMainWin::OnViewMonitorBar()
{
 if(MonitorBar.IsWindowVisible()) MonitorBar.ShowWindow(SW_HIDE);
	else MonitorBar.ShowWindow(SW_SHOW);
	RecalcLayout();
	return;
}

		
	
void CMainWin::UpdateViewControlBar(CCmdUI *pCmdUI)
{
 if(DialogBar.IsWindowVisible()) pCmdUI->SetCheck(TRUE);		
 else pCmdUI->SetCheck(FALSE);
}



void CMainWin::UpdateMenuFileSave(CCmdUI *pCmdUI)
{
if(m_DataModified==TRUE) pCmdUI->Enable(TRUE);
else pCmdUI->Enable(FALSE); 
}

void CMainWin::UpdateMenuFileSaveAs(CCmdUI *pCmdUI)
{
if(obPtr->IsEmpty()) pCmdUI->Enable(FALSE); 
else pCmdUI->Enable(TRUE);
}

void CMainWin::UpdateMenuFileClose(CCmdUI *pCmdUI)
{



}



void CMainWin::OnViewCallLookup()
{
SetFocusToMain();	

if(CallLookupPanel.IsWindowVisible()) 
{
	if(TopWnd == (CWnd*) GetDlgItem(ID_CALLLOOKUPPANEL)) CallLookupPanel.ShowWindow(SW_HIDE);
	else
	{
	CallLookupPanel.BringWindowToTop();
	TopWnd=(CWnd*) GetDlgItem(ID_CALLLOOKUPPANEL);

	}
}
else 
{
CallLookupPanel.ShowWindow(SW_SHOW);
CallLookupPanel.BringWindowToTop();
TopWnd=(CWnd*) GetDlgItem(ID_CALLLOOKUPPANEL);
CallLookupPanel.CallSignBox.SetFocus();

}

}


void CMainWin::UpdateLookupCall(CCmdUI *pCmdUI)
{
if((UINT)hInstHamCall<32) pCmdUI->Enable(FALSE);  
else pCmdUI->Enable(TRUE);
}


void CMainWin::SMeterTrigger()
{
	m_SMeterHoldOff==TRUE;
	SendToRadio("?S\x0d",3);
	m_SMeterResponse=FALSE;
}


void CMainWin::SpectrumSweep()
{

	ClearSpectrumArray();
	old_freq=radio_freq;
	old_mode=Mode;
	old_FilterNumber=m_FilterNumber;

	m_SweepFreq=m_SweepStartFreq;
	{

    if(TxOpsPanel.SweepMuteCheckBox.GetCheck()==TRUE)
	{
	MuteAudio();
	MuteStatus=0;
    }

	m_SweepEndFreq=m_SweepStartFreq+(300*(m_SweepStepFreq/1e6));
	SetFilter(m_SweepFilter);
	}

	m_bSweepActive=TRUE;
	radio_freq=m_SweepFreq;

	SetMode(AM_MODE,AM_MODE);
	SetAgcMode(AGC_FAST);
	SetRadioFrequencies();
	m_SMeterHoldOff=TRUE;
	SMeterTrigger();
	}
	

   

void CMainWin::StopSpectrumSweep()
{
radio_freq=old_freq;
Mode=old_mode;
m_FilterNumber=old_FilterNumber;
SetMode(Mode,(SplitMode==TRUE)? OppMode : Mode);
SetFilter(m_FilterNumber);
SetAgcMode(AGC_MEDIUM);
SetRadioFrequencies();
MuteStatus=1;
MuteAudio();

}

   
void CMainWin::SignalLevel(double sFreq,unsigned int Sig)
{


	if(m_bSweepActive==FALSE) return;


	if(m_SweepFreq<m_SweepEndFreq)
	{

		m_SweepFreq+=(m_SweepStepFreq/1e6);
		SweepPanel.SweepPointResult(sFreq,Sig);
		radio_freq=m_SweepFreq;
    	SetRadioFrequencies();
		SMeterTrigger();
	}	
	else
	{	

	if(m_ContSweep)
		{
		m_SweepFreq=m_SweepStartFreq;
		SarrayIndex=0;
		}
        else
        {
			StopSpectrumSweep();
			SweepPanel.OnSweepStop();
		}
	}
}			
   

void CMainWin::ClearSpectrumArray()
{
int count;
for(count=0;count<200;count++)
{
	Sarray[count]=0;
}
	SarrayIndex=0;
	return;
}	       




void CMainWin::ShowTimedMessageWindow(const char* msg)
{
	if(TimedMessageBox.m_hWnd!=NULL) TimedMessageBox.DestroyWindow();
	TimedMessageBox.Create(msg, WS_DLGFRAME|WS_CLIPSIBLINGS|WS_CHILD|WS_VISIBLE, CRect(50,50,300,75), this);
	TimedMessageBox.BringWindowToTop();
	SetTimer(ID_MESSAGETIMER,2000,NULL);
}

void CMainWin::RemoveTimedMessageWindow()
{

	if(TimedMessageBox.m_hWnd!=NULL) TimedMessageBox.DestroyWindow();	
	KillTimer(ID_MESSAGETIMER);
}


void CMainWin::OnSweepClickFrequency()
{
radio_freq=SweepPanel.SweepWindow.GetIndicatorFrequency();
SetRadioFrequencies();
SwlPanel.UpdatePanelData(radio_freq);

}


void CMainWin::GetDSPVersion()
{
	SendToRadio("?V\x0d",3);
}


void CMainWin::SetModeAM()
{
	SwlPanel.SetModeAM();
}


void CMainWin::SetModeCW()
{
	SwlPanel.SetModeCW();
}

void CMainWin::SetModeLSB()
{
	SwlPanel.SetModeLSB();
}

void CMainWin::SetModeUSB()
{
	SwlPanel.SetModeUSB();
}

void CMainWin::SetModeFM()
{
	SwlPanel.SetModeFM();
}



void CMainWin::NormalizeRadio()
{
SetFilter(1);
SetRadioFrequencies();
m_NormalizeInProgress=TRUE;
DelayOneSecond();
SMeterTrigger();
}
	


int CMainWin::load_band_definitions()
{
char name[255];
float startfreq,endfreq;
int result;
int entrycount=0;
char* pFileName = "bands.dat";
char instring[255];

CStdioFile f1;
if( !f1.Open( pFileName,
		CFile::modeRead | CFile::typeText ) ) 
{
	#ifdef _DEBUG
		afxDump << "Unable to open file" << "\n";
	#endif
	return(-1);
}

while(f1.ReadString(instring,255)!=NULL)
	{
  result=sscanf(instring,"%[^,]%*[,]%f%*[ ,]%f",name,&startfreq,&endfreq);
	
	if(result==3)
		{
	CBandObj* NewBand = new CBandObj;
	NewBand->BandName=name;
	NewBand->StartFrequency=(double) startfreq;
	NewBand->EndFrequency=(double)endfreq;
	entrycount++;
	obBandList.AddTail(NewBand);
		}

}

f1.Close();
return( entrycount );

}    

                                   
void CMainWin::FreeBandListMemory()
{
CBandObj *pObj;
while(!obBandList.IsEmpty())
{
	pObj = (CBandObj*) obBandList.RemoveHead();
	delete pObj;
}
}



void CMainWin::ShowTimeDialog()
{
double SaveFreq=radio_freq;
char SaveMode=Mode;
int SaveFilter=m_FilterNumber;

m_FilterNumber=1;
SetFilter(1);
Mode=AM_MODE;
SetMode(AM_MODE,AM_MODE);

SetRadioFrequencies();
SwlPanel.UpdatePanelData(radio_freq,Mode,TuneStep,m_FilterNumber);


if( TimeDialog.DoModal() !=IDOK)
{
radio_freq=SaveFreq;
Mode=SaveMode;
m_FilterNumber=SaveFilter;
}
SetMode(Mode,(SplitMode==TRUE)? OppMode : Mode);
SetFilter(m_FilterNumber);
SetRadioFrequencies();
SwlPanel.UpdatePanelData(radio_freq,Mode,TuneStep,m_FilterNumber);

}



void CMainWin::OnTimeFreqChange()
{
	SwlPanel.UpdatePanelData(radio_freq);
	SetRadioFrequencies();
}




void CMainWin::AddToDataOutWindow(CString dstring)
{
CString cfstring="R< "+dstring;

char cnt;
DataOutList[DataOutPos]=dstring;
DataOutPos=(DataOutPos++) & 0x0f;
cnt= ((CListBox*)  MonitorBar.GetDlgItem(IDC_OUTBOX))->GetCount() ;
if(  cnt > 45)
{
((CListBox*) MonitorBar.GetDlgItem(IDC_OUTBOX))->DeleteString(0);
((CListBox*) MonitorBar.GetDlgItem(IDC_OUTBOX))->AddString(dstring);
((CListBox*) MonitorBar.GetDlgItem(IDC_OUTBOX))->SetTopIndex(45);
}
else
{
((CListBox*) MonitorBar.GetDlgItem(IDC_OUTBOX))->AddString(dstring);
}


}


void CMainWin::AddToDataInWindow(CString dstring)
{
CString cfstring="R> "+dstring;

char cnt;
DataInList[DataInPos]=dstring;
DataInPos=(DataInPos++) & 0x0f;
cnt= ((CListBox*)  MonitorBar.GetDlgItem(IDC_INFOBOX))->GetCount() ;
if(  cnt > 45)
{
((CListBox*) MonitorBar.GetDlgItem(IDC_INFOBOX))->DeleteString(0);
((CListBox*) MonitorBar.GetDlgItem(IDC_INFOBOX))->AddString(dstring);
((CListBox*) MonitorBar.GetDlgItem(IDC_INFOBOX))->SetTopIndex(45);
}
else
{
((CListBox*) MonitorBar.GetDlgItem(IDC_INFOBOX))->AddString(dstring);
}

}



// return filter selection number given a bandwidth
int CMainWin::BandwidthToFilterTable(int bw)
{
int bwf;
int index;
	for(index=1;index<35;index++)
	{
	bwf=(int) atof(MasterFilterList_TX550[index].name);
	if(bwf==bw) return index;
	}
	return 0;
}				

// return filter selection given the text desciption
int CMainWin::FilterTextToFilterNumber(const char* text)
{
int index;
	for(index=1;index<35;index++)
	{
	if( strcmp(text,MasterFilterList_TX550[index].name)==0) return index;
	}
	return 0;
}				







int CMainWin::FilterBandwidth(int index)
{
double bw;
char str[64];
    bw=atof(MasterFilterList_TX550[index].name);
    if(bw<10) sprintf(str,"%1.2f",bw*1000);
    else sprintf(str,"%3.0f",bw);
    return atoi(str);
}

void CMainWin::OnMonitorQueryEPort()
{
	    	SendToRadio("?!\r",3);
}

void CMainWin::OnMonitorQueryFwd()
{
	    	SendToRadio("?F\r",3);
}

void CMainWin::OnMonitorQueryRef()
{
	    	SendToRadio("?R\r",3);
}
	    	

void CMainWin::OnMonitorQuerySMeter()
{
	    	SendToRadio("?S\r",3);
}

void CMainWin::OnMonitorQueryEnvelope()
{

	    	SendToRadio("?X\r",3);
}




void CMainWin::UpdateMonitorControls(CCmdUI *pCmdUI)
{
 pCmdUI->Enable(TRUE);
}
	    	
void CMainWin::OnClearMonitorWindow()
{

FlushComm(idCommDev, 1);
FlushComm(idCommDev, 0);

((CListBox*) MonitorBar.GetDlgItem(IDC_OUTBOX))->ResetContent();
((CListBox*) MonitorBar.GetDlgItem(IDC_INFOBOX))->ResetContent();
}

void CMainWin::UpdateClearMonitorWindow(CCmdUI *pCmdUI)
{
 pCmdUI->Enable(TRUE);
}




void CMainWin::IncreasePower()
{

	m_PowerSetting+=5;
	if(m_PowerSetting>255) m_PowerSetting=255;
	TxOpsPanel.SetPowerSetting(m_PowerSetting);
	SetOutputPower(m_PowerSetting);
}

void CMainWin::DecreasePower()
{
	m_PowerSetting-=5;
	if(m_PowerSetting<0) m_PowerSetting=0;
	TxOpsPanel.SetPowerSetting(m_PowerSetting);
	SetOutputPower(m_PowerSetting);
	SwlPanel.outputpower=m_PowerSetting;
}


void CMainWin::OnMonitorWindowManualSend()
{
char string[255];
int count;
count = ((CEdit*) MonitorBar.GetDlgItem(IDC_COMMAND_STRING))->GetLine(0,string,255);
string[count]=0x0d;
SendToRadio(string,count+1);
}


void CMainWin::ViewTransmitOptions()
{
SetFocusToMain();	

if(TxOpsPanel.IsWindowVisible()) 
{
	if(TopWnd == (CWnd*) GetDlgItem(ID_TXOPS_PANEL)) TxOpsPanel.ShowWindow(SW_HIDE);
	else
	{
	TxOpsPanel.BringWindowToTop();
	TopWnd=(CWnd*) GetDlgItem(ID_TXOPS_PANEL);
	}

}

else 
{
TxOpsPanel.ShowWindow(SW_SHOW);
TxOpsPanel.BringWindowToTop();
TopWnd=(CWnd*) GetDlgItem(ID_TXOPS_PANEL);
}

}



void CMainWin::SetCWSidetoneVolume(int vol)
{
		char comstring[20];
	    char *tptr;
		tptr=comstring;

		*tptr++='J';
		*tptr++=(vol!=0x0d) ? vol&0xff : 0x0e;
		*tptr++='\r';
		*tptr++='\0';
        SendToRadio(comstring,3);

		return;
}

void CMainWin::SetCWSpotVolume(int vol)
{
		char comstring[20];
	    char *tptr;
		tptr=comstring;
		*tptr++='F';
		*tptr++=vol&0xff;
		*tptr++='\r';
		*tptr++='\0';
        SendToRadio(comstring,3);
		return;
}


void CMainWin::InitializeTXOpsWindow()
{
char text[128];



	TxOpsPanel.SetSelectedCommPort(CommunicationsPort);
	TxOpsPanel.SetPowerSetting(m_PowerSetting);
	TxOpsPanel.SetSTVolumeSetting(m_SidetoneVolume);
	TxOpsPanel.SetCWSpotVolumeSetting(m_CWSpotVolume);

	TxOpsPanel.SetKeyerWeightSetting(KeyerWeight);


	sprintf(text,"%d",Bfo);
	TxOpsPanel.STFBox.SetWindowText(text);

	TxOpsPanel.MuteOptionsListBox.SetCurSel(m_MuteAlways);
	TxOpsPanel.TxMicAudioCheckBox.SetCheck(FALSE);
	TxOpsPanel.TxAuxAudioCheckBox.SetCheck(FALSE);
	TxOpsPanel.SweepMuteCheckBox.SetCheck(bMuteDuringSweep);

	
	if(TxAudioSelect==TX_MIC_SELECT)TxOpsPanel.TxMicAudioCheckBox.SetCheck(TRUE); 	
	else   TxOpsPanel.TxAuxAudioCheckBox.SetCheck(TRUE);

	TxOpsPanel.MICGainSlider.SetSliderPos(m_MicGain);

	TxOpsPanel.VoxGainSlider.SetSliderPos(m_VoxGain);

	TxOpsPanel.AntiVoxSlider.SetSliderPos(m_AntiVox);

	TxOpsPanel.VoxDelaySlider.SetSliderPos(m_VoxHang);

	TxOpsPanel.MONVolumeSlider.SetSliderPos(m_MonitorLevel);

	TxOpsPanel.TxHangSlider.SetSliderPos(iAuxTxHang);


	TxOpsPanel.TxLoopCheckBox.SetCheck(m_bTxLoopEnable);
	TxOpsPanel.TxEnableCheckBox.SetCheck(m_bTxEnable);
	int flt=TxOpsPanel.TxFilterListBox.FindString(-1,MasterFilterList_TX550[m_iTxFilter].name);
	TxOpsPanel.TxFilterListBox.SetCurSel(flt);

	TxOpsPanel.TxFilter=(m_iTxFilter);	
	TxOpsPanel.EnableKeyerCheckBox.SetCheck(m_bEnableKeyer);
}

void CMainWin::OnTxOpsPanelChanged()
{
CString textin;
BOOL bRecalc=FALSE;

	if( TxOpsPanel.CommPortString!=CommunicationsPort)
		{
		CommunicationsPort=TxOpsPanel.CommPortString;
		InitializeCommPort();
		WakeUpRadio();
		}


if(!m_bRadioMode) return;

if(m_SidetoneVolume!=TxOpsPanel.GetSTVolumeSetting())
	{ 
	m_SidetoneVolume=TxOpsPanel.GetSTVolumeSetting();
	SetCWSidetoneVolume(m_SidetoneVolume);

	}

if(m_CWSpotVolume!=TxOpsPanel.GetCWSpotVolumeSetting())
	{ 
	m_CWSpotVolume=TxOpsPanel.GetCWSpotVolumeSetting();
	SetCWSpotVolume((m_bSpotState==TRUE)? m_CWSpotVolume : 0);
	}


TxOpsPanel.STFBox.GetWindowText(textin);


if(Bfo!=atoi((const char *) textin))
	{
	    Bfo=atoi((const char *) textin);
		bRecalc=TRUE;
	}	

	if(m_PowerSetting!=TxOpsPanel.GetPowerSetting())
	{
	SetOutputPower(TxOpsPanel.GetPowerSetting());
	}

	m_MuteAlways=TxOpsPanel.MuteOptionsListBox.GetCurSel();
	TxOpsPanel.UTCHoursEdit.GetWindowText(textin);
	m_iUtcHours=atoi((const char*) textin);


	if(m_CWQSKSetting!=TxOpsPanel.CWQskSlider.GetSetting())
	{
	m_CWQSKSetting=TxOpsPanel.CWQskSlider.GetSetting();
 	SetCWQSK(m_CWQSKSetting);
	}


	if( TxOpsPanel.CommPortString!=CommunicationsPort)
		{
		MessageBox("THERE WAS A PORT CHANGE");
		CommunicationsPort=TxOpsPanel.CommPortString;
		InitializeCommPort();
		WakeUpRadio();
		}


	if(TxOpsPanel.TxMicAudioCheckBox.GetCheck()==TRUE && TxAudioSelect!=TX_MIC_SELECT) SelectTxAudio(TX_MIC_SELECT);
	if(TxOpsPanel.TxAuxAudioCheckBox.GetCheck()==TRUE && TxAudioSelect!=TX_AUX_SELECT) SelectTxAudio(TX_AUX_SELECT);

	if(m_MonitorLevel!=TxOpsPanel.MONVolumeSlider.GetSetting())
		{
		m_MonitorLevel=TxOpsPanel.MONVolumeSlider.GetSetting();
        SetMonitorState(SwlPanel.MonActive);
        }


	if(m_MicGain!=TxOpsPanel.MICGainSlider.GetSetting())
		{
		m_MicGain=TxOpsPanel.MICGainSlider.GetSetting();
		SelectTxAudio(TxAudioSelect);		
		}	


	if(m_AntiVox!=TxOpsPanel.AntiVoxSlider.GetSetting())
		{
		m_AntiVox=TxOpsPanel.AntiVoxSlider.GetSetting();		
		if (m_AntiVox==0x0d) m_AntiVox=0x0e;
		if (m_AntiVox==0x00) m_AntiVox=0x01;
		SetAntiVox(m_AntiVox);
		}
		
	if(m_VoxGain!=TxOpsPanel.VoxGainSlider.GetSetting())
		{
		m_VoxGain=TxOpsPanel.VoxGainSlider.GetSetting();		
		if(m_VoxGain==0x0d) m_VoxGain=0x0e;		
		if(m_VoxGain==0x00) m_VoxGain=0x01;		

		SetVoxGain(m_VoxGain);
		}

	if(m_VoxHang!=TxOpsPanel.VoxDelaySlider.GetSetting())
		{
		m_VoxHang=TxOpsPanel.VoxDelaySlider.GetSetting();		
		if(m_VoxHang==0x0d) m_VoxHang=0x0e;
		if(m_VoxHang==0x00) m_VoxHang=0x01;
		SetVoxHang(m_VoxHang);
		}


		if(TxOpsPanel.TxLoopCheckBox.GetCheck()!=m_bTxLoopEnable)
			{
			m_bTxLoopEnable=TxOpsPanel.TxLoopCheckBox.GetCheck();
			SetTxLoopState(m_bTxLoopEnable);
			}

		if(TxOpsPanel.TxEnableCheckBox.GetCheck()!=m_bTxEnable)
			{
			m_bTxEnable=TxOpsPanel.TxEnableCheckBox.GetCheck();
			SetTxEnableState(m_bTxEnable);
			}



        if(TxOpsPanel.TxFilter!=m_iTxFilter) 
                {
        		SetTxFilter(TxOpsPanel.TxFilter);
				SetTxFrequencies();
				}

		if(TxOpsPanel.CWSpdSlider.GetSetting()!=KeyerSpeed)
			{
			
		 KeyerSpeed=TxOpsPanel.CWSpdSlider.GetSetting();
			SetKeyerSpeed(KeyerSpeed,KeyerWeight);
			}


		if(TxOpsPanel.GetKeyerWeightSetting()!=KeyerWeight)
			{
			
		 KeyerWeight=TxOpsPanel.GetKeyerWeightSetting();
			SetKeyerSpeed(KeyerSpeed,KeyerWeight);
			}


	if(TxOpsPanel.EnableKeyerCheckBox.GetCheck()!=m_bEnableKeyer)
	{
	m_bEnableKeyer=TxOpsPanel.EnableKeyerCheckBox.GetCheck();
	SetKeyerState(m_bEnableKeyer);
    }


if(m_bTuneActive!=TxOpsPanel.TuneState)
	{
	m_bTuneActive=TxOpsPanel.TuneState;
	SetTuneState(m_bTuneActive);
	}

	if(TxOpsPanel.TxHangSlider.GetSetting()!=iAuxTxHang)
	{
	iAuxTxHang=TxOpsPanel.TxHangSlider.GetSetting();
	SetAuxTxHang(iAuxTxHang);
	}
	
if(bRecalc==TRUE) SetRadioFrequencies();	
}






void CMainWin::SetAntiVox(int setting)
{
		char comstring[20];
	    char *tptr;
		tptr=comstring;
		*tptr++='U';
		*tptr++='A';
		*tptr++=(setting!=0x0d) ? setting & 0xff : 0x0e;	
		*tptr++='\r';
		*tptr++='\0';
        SendToRadio(comstring,4);
}

void CMainWin::SetVoxGain(int setting)
{
		char comstring[20];
	    char *tptr;
		tptr=comstring;
		*tptr++='U';
		*tptr++='G';
		*tptr++=(setting!=0x0d) ? setting & 0xff : 0x0e;	
		*tptr++='\r';
		*tptr++='\0';
        SendToRadio(comstring,4);
}

void CMainWin::SetVoxHang(int setting)
{
		char comstring[20];
	    char *tptr;
		tptr=comstring;
		*tptr++='U';
		*tptr++='H';
		*tptr++=(setting!=0x0d) ? setting & 0xff : 0x0e;
		*tptr++='\r';
		*tptr++='\0';
        SendToRadio(comstring,4);
}


void CMainWin::SetCWQSK(int setting)
{
		char comstring[20];
	    char *tptr;
		tptr=comstring;
		*tptr++='U';
		*tptr++='Q';
		*tptr++= (setting*2) & 0xff;	
		*tptr++='\r';
		*tptr++='\0';
        SendToRadio(comstring,4);
}


void CMainWin::SelectTxAudio(char select)
{
		char source;
		char comstring[20];
	    char *tptr;
		tptr=comstring;


    TxAudioSelect=select;

	source=0x00;	// assume MIC source
	if(select==TX_AUX_SELECT) source=0x01;

		*tptr++='O';
		*tptr++='1';
		*tptr++=source & 0xff;	// select source
		*tptr++=m_MicGain & 0x0f;
		*tptr++='\r';
		*tptr++='\0';
        SendToRadio(comstring,5);
		return;

}



void CMainWin::SetTxEnableState(BOOL state)
{
		char source;
		source=(state==TRUE)? 0x31 : 0x30 ;
		char comstring[20];
	    char *tptr;
		tptr=comstring;
		*tptr++='#';
		*tptr++=source;
		*tptr++='\r';
		*tptr++='\0';
        SendToRadio(comstring,3);
}

void CMainWin::SetTxLoopState(BOOL state)
{
		char source;
		source= (state==TRUE) ? 0x33 : 0x32 ;
		char comstring[20];
	    char *tptr;
		tptr=comstring;
		*tptr++='#';
		*tptr++=source;
		*tptr++='\r';
		*tptr++='\0';
        SendToRadio(comstring,3);
}



void CMainWin::SetKeyerState(BOOL state)
{
		m_bEnableKeyer=state;
		char source;
		source= (state==TRUE) ? 0x37 : 0x36 ;
		char comstring[20];
	    char *tptr;
		tptr=comstring;
		*tptr++='#';
		*tptr++=source;
		*tptr++='\r';
		*tptr++='\0';
        SendToRadio(comstring,3);
}



void CMainWin::SetAdaptiveFilterStates(BOOL bNRstate,BOOL bANstate)
{
	char NRchar,ANchar;
	char comstring[20];
    char *tptr;
	tptr=comstring;

	NRchar= (bNRstate==TRUE) ? 0x31 : 0x30;
	ANchar= (bANstate==TRUE) ? 0x31 : 0x30;

	*tptr++='K';
	*tptr++=NRchar;
	*tptr++=ANchar;
	*tptr++='\r';
	*tptr++='\0';
    SendToRadio(comstring,4);
}


void CMainWin::SetKeyerSpeed(int iSpeed, int iWeighting)
{
    int ditfactor;
    int dahfactor;
	int spcfactor;
	int speed;
	double wt;
	char comstring[20];
    char *tptr;
	tptr=comstring;

	wt=(((double) KeyerWeight/100.0));

	speed=(iSpeed>0) ? iSpeed:1;
	spcfactor=(int)(((double)0.50/(speed*(double)0.4166*(double)0.0001667))*(2-wt));
	ditfactor=(int)(((double)0.50/(speed*(double)0.4166*(double)0.0001667))*wt);
	dahfactor=(int)((double)0.50/(speed*(double)0.4166*(double)0.0001667))*3;
    
	*tptr++='E';
	*tptr++=(ditfactor>>8)&0xff;
	*tptr++=ditfactor&0xff;
	*tptr++=(dahfactor>>8)&0xff;
	*tptr++=dahfactor&0xff;
	*tptr++=(spcfactor>>8)&0xff;
	*tptr++=spcfactor&0xff;
	*tptr++='\r';
	*tptr++='\0';
    SendToRadio(comstring,8);
}




void CMainWin::UpdateHamBandRegisters(double freq)
{
int cnt;
double upper,lower;

for(cnt=0;cnt<MAXBANDS;cnt++)
	{
	upper=HamBands[cnt].UpperLimit;
	lower=HamBands[cnt].LowerLimit;
	if((freq>=lower) && (freq<=upper)) 
	{
	HamBands[cnt].LastFreq=freq;
	HamBands[cnt].LastMode=Mode;	
	HamBands[cnt].LastFilter=m_FilterNumber;	
	}	
	}
	
}	


void CMainWin::SetAuxTxHang(unsigned int setting)
{
		char comstring[20];
	    char *tptr;
		tptr=comstring;
		*tptr++='U';
		*tptr++='T';
		*tptr++=setting & 0xff;
		*tptr++='\r';
		*tptr++='\0';
        SendToRadio(comstring,4);
}


		
void CMainWin::WakeUpRadio()
{
	FlushComm(idCommDev, 0);
	ShowTimedMessageWindow("Checking Radio Connection");
    SendToRadio("XX\r",3);
}


void CMainWin::ActivateRadioMode()
{
	FlushComm(idCommDev, 0);
	ShowTimedMessageWindow("Activating Radio Mode");
    SendToRadio("P1\r",3);
	DelayOneSecond();
}



void CMainWin::OpenLogFile()
{
char* pFileName = "comms.txt";
if( !CommFile.Open( pFileName,
		CFile::modeCreate | CFile::modeWrite | CFile::typeText ) ) 
{
	#ifdef _DEBUG
		afxDump << "Unable to Create Comm file" << "\n";
	#endif
}

if(CommFile.m_pStream !=NULL) CommFile.WriteString("Log File Begin\n");



}

void CMainWin::CloseLogFile()
{
if(CommFile.m_pStream!=NULL) CommFile.Flush();
if(CommFile.m_pStream!=NULL) CommFile.Close();
}


void CMainWin::AddToLogWindowOut(CString dstring)
{
if(!m_bCommLogging) return;

CString cfstring="R< "+dstring+"\r\n";
if(CommFile.m_pStream !=NULL) CommFile.WriteString(cfstring);
}


void CMainWin::AddToLogWindowIn(CString dstring)
{
if(!m_bCommLogging) return;
CString cfstring="R> "+dstring+"\r\n";
if( CommFile.m_pStream!=NULL ) CommFile.WriteString(cfstring);
}


int CMainWin::GetCommPortCount()
{
char temp[64];
int ports;

	ports=(int)EscapeCommFunction(NULL, GETMAXCOM);
	sprintf(temp,"%d COMM PORTS AVAILABLE",ports);
	MessageBox(temp);
	return ports;
}



void CMainWin::CheckFilterHighlite(int filter)
{
SwlPanel.FILTER1button.SetSelected(FALSE);
SwlPanel.FILTER2button.SetSelected(FALSE);
SwlPanel.FILTER3button.SetSelected(FALSE);
SwlPanel.FILTER4button.SetSelected(FALSE);
SwlPanel.FILTER5button.SetSelected(FALSE);
SwlPanel.FILTER6button.SetSelected(FALSE);
SwlPanel.FILTER7button.SetSelected(FALSE);
SwlPanel.FILTER8button.SetSelected(FALSE);
SwlPanel.FILTER9button.SetSelected(FALSE);

	if(filter==SwlPanel.FILTER1button.FilterIndex) SwlPanel.FILTER1button.SetSelected(TRUE); 
	if(filter==SwlPanel.FILTER2button.FilterIndex) SwlPanel.FILTER2button.SetSelected(TRUE); 
	if(filter==SwlPanel.FILTER3button.FilterIndex) SwlPanel.FILTER3button.SetSelected(TRUE); 
	if(filter==SwlPanel.FILTER4button.FilterIndex) SwlPanel.FILTER4button.SetSelected(TRUE); 
	if(filter==SwlPanel.FILTER5button.FilterIndex) SwlPanel.FILTER5button.SetSelected(TRUE); 
	if(filter==SwlPanel.FILTER6button.FilterIndex) SwlPanel.FILTER6button.SetSelected(TRUE); 
	if(filter==SwlPanel.FILTER7button.FilterIndex) SwlPanel.FILTER7button.SetSelected(TRUE); 
	if(filter==SwlPanel.FILTER8button.FilterIndex) SwlPanel.FILTER8button.SetSelected(TRUE); 
	if(filter==SwlPanel.FILTER9button.FilterIndex) SwlPanel.FILTER9button.SetSelected(TRUE); 
}

afx_msg void CMainWin::HamCallTest()
{
if(hInstHamCall==NULL)  return;
int result;
char call[128];
CString hcpath;

TxOpsPanel.HamCallPathEditBox.GetWindowText(hcpath);
strcpy(path,(const char *) hcpath);
if(!strchr(path,'\\')) strcat (path,"\\ham0\\");

strcpy(call,(const char*) CallLookupPanel.CallText);
CallLookupPanel.CallSignBox.SetWindowText("");
result=LookupCallSign( path, call,2047, buffer);

if(result<0)
{
switch(result)
	{
	case -1:
		CallLookupPanel.ResetContent();
		CallLookupPanel.AddString(call);
		CallLookupPanel.AddString("Callsign Not Found!");
		break;
	case -2:
		CallLookupPanel.ResetContent();
		CallLookupPanel.AddString("Database Not Found!");
		break;
	
	case -3:
		CallLookupPanel.ResetContent();
		CallLookupPanel.AddString("Database Index Error!");
		break;
	
	case -4:
		CallLookupPanel.ResetContent();
		CallLookupPanel.AddString("Database Memory Error!");
		break;

}

 return;




}
buffer[result+1]='\0';


sprintf(rstr,"Result=%d",result);
CallLookupPanel.ResetContent();


TRACE("RESULT = %d",result);
TRACE("Buffer = %s\n",buffer);
decode_response(buffer);
}


int CMainWin:: decode_response(char *string)
{
static char BmCodelist[]="IAXCMRDLQVZ-";
static char list[]="\xb6\xb7\xb8\xb9\xba\xbc\xbf\xc0\xc1";//\xc2\xc3\xc4\xc5\xc6\xc7\xc8\xc9\xca\xcb\xcc\xcd\xce\xcf\xd0\xd1\xd2\xd3\xd4\xd5";

int count;
char *cp;
char tstring[600];
char cstring[256];
char *tptr;
BOOL bShowData;
char firstname[128];
char lastname[128];
char middlename[128];
char callsign[32];
char hamclass[32];
char street[64];
char city[64];
char state[64];
char zipcode[16];
char BmCode[16]; // could be 1 or 2 places ??
int cnt;
unsigned tchr=0xb6;

strcpy(firstname,"");
strcpy(lastname,"");
strcpy(middlename,"");
strcpy(callsign,"");
strcpy(hamclass,"");
strcpy(street,"");
strcpy(city,"");
strcpy(state,"");
strcpy(BmCode,"");
strcpy(zipcode,"");
bShowData=TRUE;

tptr=string;
cnt=strlen(string);
strcpy(tstring,"");

TRACE("PARSING L=%d >> %s\n",cnt,string);


	for(count=0;count<cnt;count++)
        {
        sprintf(cstring,"%02hX ",(unsigned char) *tptr++);
        strcat(tstring,cstring);
        }
TRACE("STRING = %s\n",tstring);
if(MonitorBar.IsWindowVisible()) AddToDataOutWindow(tstring);

sscanf(string,"%[0-9A-Za-z ]",tstring);
sprintf(callsign,"%s",tstring);
TRACE("Call = %s\n",callsign);
if(MonitorBar.IsWindowVisible()) AddToDataOutWindow(callsign);

#ifdef HAMCALL_FIELD_TEST
CallLookupPanel.AddString(cstring);
#endif

for(cp=strpbrk(string,list);cp;cp=strpbrk(cp,list))
{

#ifdef HAMCALL_FIELD_TEST
field=*cp;
sscanf(++cp,"%[+-.0-9A-Za-z ]",tstring);
/* field testing */
sprintf(cstring,"%2X %s",field,tstring);
TRACE("Field %2X = %s\n",field,tstring);
CallLookupPanel.AddString(cstring);
#else

switch(*cp)
{
    case '\xb6': sscanf(++cp,"%[0-9A-Za-z ]",tstring);
		if(*tstring=='E') strcpy(hamclass,"- Extra Class");
		if(*tstring=='A') strcpy(hamclass,"- Advanced Class");
		if(*tstring=='G') strcpy(hamclass,"- General Class");
		if(*tstring=='P') strcpy(hamclass,"- Tech. Plus Class");
		if(*tstring=='T') strcpy(hamclass,"- Technician Class");
		if(*tstring=='N') strcpy(hamclass,"- Novice Class");
	break;
    case '\xb7': sscanf(++cp,"%[+-.0-9A-Za-z ]",tstring);
	sprintf(BmCode,"%s",tstring);
	break;
    case '\xb8': sscanf(++cp,"%[+-.0-9A-Za-z ]",tstring);
	sprintf(firstname,"%s",tstring);
	break;
    case '\xb9': sscanf(++cp,"%[+-.0-9A-Za-z ]",tstring);
	sprintf(middlename,"%s",tstring);
	break;
    case '\xba': sscanf(++cp,"%[+-.0-9A-Za-z ]",tstring);
	sprintf(lastname,"%s",tstring);
	break;
    case '\xbc': sscanf(++cp,"%[+-.0-9A-Za-z ]",tstring);
	sprintf(street,"%s",tstring);
	break;
    case '\xbf': sscanf(++cp,"%[+-.0-9A-Za-z ]",tstring);
	sprintf(city,"%s",tstring);
	break;
    case '\xc0': sscanf(++cp,"%[+-.0-9A-Za-z ]",tstring);
	sprintf(state,"%s",tstring);
	break;
    case '\xc1': sscanf(++cp,"%[+-.0-9A-Za-z ]",tstring);
	sprintf(zipcode,"%s",tstring);
	break;
}

#endif

}




for(cp=strpbrk(BmCode,BmCodelist);cp;cp=strpbrk(cp,BmCodelist))
{

 switch(*cp)
 {
	case 'Q':
		CallLookupPanel.AddString("Silent Key");
		break;

	case 'I':
		break;
	case 'A':
		break;
	case 'X':
		sprintf(cstring,"%s %s",callsign,lastname);
		CallLookupPanel.AddString(cstring);
		bShowData=FALSE;
		break;
	case 'C':
		CallLookupPanel.AddString("Club Call");
		break;
	case 'M':
		break;
	case 'R':
		break;
	case 'D':
		CallLookupPanel.AddString("FCC Deletion");
		break;
	case 'L':
		CallLookupPanel.AddString("Requested Deletion");
		break;
	case 'V':
		break;
	case 'Z':
		break;
	case '-':
		sprintf(cstring,"No Longer In Database");
		CallLookupPanel.AddString(cstring);
		break;
 } // end of switch					
 cp++;
}// end of for						
		
if(bShowData)
{
		sprintf(cstring,"%s %s",callsign,hamclass);
		CallLookupPanel.AddString(cstring);
		sprintf(cstring,"%s %s %s",firstname,middlename,lastname);
		CallLookupPanel.AddString(cstring);
		sprintf(cstring,"%s",street);
		CallLookupPanel.AddString(cstring);
		sprintf(cstring,"%s, %s  %s",city,state,zipcode);
		CallLookupPanel.AddString(cstring);
}
return 0;
}



void CMainWin::OnLookupCall()
{
HamCallTest();

}


void CMainWin::LoadHamCallSupport()
{
hInstHamCall= LoadLibrary("hamcall.dll");

if((UINT)hInstHamCall<32)
	{
	TRACE("DLL NOT LOADED\n");
	}                    
	else
	{
	LookupCallSign=(LOOKUPHAMCALL) GetProcAddress(hInstHamCall,"LookupCallSign");
	TRACE("ADDRESS = %Fp\n",LookupCallSign);
	TRACE("path=%Fp  call = %Fp\n",&path, &call);

	}                    
 
}
 

 
 
void CMainWin::ShowRemoteTuneSelection()
{


CString cstring;
switch(cRemoteTuneControl)
{
case REMOTE_VFO_TUNE:cstring="Remote: VFO";break;
case REMOTE_PBT_TUNE:cstring="Remote: PBT";break;
case REMOTE_RIT_TUNE:cstring="Remote: RIT";break;
case REMOTE_XIT_TUNE:cstring="Remote: XIT";break;
}



DialogBar.GetDlgItem(IDC_REMOTE_TUNE)->SetWindowText(cstring);

}


void CMainWin::UpdateASCIIDataFile()
{
if(LastSavedMode==Mode && LastSavedFreq==radio_freq && LastSavedSplitMode==SplitMode) return;

char* pFileName = "Pegasus.out";
char sdata[32];
if( !FamOutFile.Open( pFileName,CFile::modeCreate | CFile::modeWrite | CFile::typeText ) ) 
{
	#ifdef _DEBUG
		afxDump << "Unable to Create FAM OUT file" << "\n";
	#endif
}
    CString CMode="CW";
    if(Mode==AM_MODE) CMode="AM";
    if(Mode==CW_MODE) CMode="CW";
    if(Mode==LSB_MODE) CMode="LSB";
    if(Mode==USB_MODE) CMode="USB";
    if(Mode==FM_MODE) CMode="FM";

LastSavedMode=Mode;
LastSavedFreq=radio_freq;
LastSavedSplitMode=SplitMode;
sprintf(sdata,"%09.6f\n%s\n",radio_freq,(const char *) CMode);
FamOutFile.WriteString(sdata);

if(SplitMode)
    {
    CMode="CW";
    if(OppMode==AM_MODE) CMode="AM";
    if(OppMode==CW_MODE) CMode="CW";
    if(OppMode==LSB_MODE) CMode="LSB";
    if(OppMode==USB_MODE) CMode="USB";
    if(OppMode==FM_MODE) CMode="FM";
	sprintf(sdata,"%09.6f\n%s\n",Opp_radio_freq,(const char *) CMode);
	FamOutFile.WriteString(sdata);
    }


if(FamOutFile.m_pStream!=NULL) FamOutFile.Flush();
if(FamOutFile.m_pStream!=NULL) FamOutFile.Close();
}


void CMainWin::CheckASCIIDataFile()
{
char* pFileName = "Pegasus.in";
char modestr[8];
char freqstr[16];
char tstring[32];
CString CMode;
if( !FamInFile.Open( pFileName,CFile::modeRead | CFile::typeText ) ) 
{
	return;
}
KillTimer(ID_ASCIIDATA_CHECK);
	

    if(FamInFile.ReadString(freqstr,15)!=NULL)
	{
	radio_freq=atof(freqstr);	
	}
    
    if(FamInFile.ReadString(modestr,7)!=NULL)
    {
    CMode=(const char*) modestr;
	Mode=CW_MODE;
    if(CMode.Find("CW")>=0) Mode=CW_MODE;
    if(CMode.Find("AM")>=0) Mode=AM_MODE;
    if(CMode.Find("LSB")>=0) Mode=LSB_MODE;
    if(CMode.Find("USB")>=0) Mode=USB_MODE;
    if(CMode.Find("FM")>=0) Mode=FM_MODE;
    }

    if(FamInFile.ReadString(freqstr,15)!=NULL)
	{
	Opp_radio_freq=atof(freqstr);	
	}
    else
    {
	SplitMode=FALSE;
	SwlPanel.SPLITbutton.SetSelected(FALSE);
	SwlPanel.bSplitState=FALSE;
    }


    if(FamInFile.ReadString(modestr,7)!=NULL)
    {
    CMode=(const char*) modestr;
	OppMode=CW_MODE;
    if(CMode.Find("CW")>=0) OppMode=CW_MODE;
    if(CMode.Find("AM")>=0) OppMode=AM_MODE;
    if(CMode.Find("LSB")>=0) OppMode=LSB_MODE;
    if(CMode.Find("USB")>=0) OppMode=USB_MODE;
    if(CMode.Find("FM")>=0) OppMode=FM_MODE;
	SplitMode=TRUE;
	SwlPanel.SPLITbutton.SetSelected(TRUE);
	SwlPanel.bSplitState=TRUE;	
    }
	else
	{
	SwlPanel.SPLITbutton.SetSelected(FALSE);
	SwlPanel.bSplitState=FALSE;	
	}

sprintf(tstring,"(%f) (%s)",radio_freq,(const char*) CMode);

m_bNoFocus=TRUE;
SwlPanel.UpdatePanelData(radio_freq,Mode,TuneStep,m_FilterNumber,Opp_radio_freq,OppMode);
SetMode(Mode,(SplitMode==TRUE)? OppMode : Mode);
SetRadioFrequencies();

m_bNoFocus=FALSE;
FamInFile.Close();
remove(pFileName);
SetTimer(ID_ASCIIDATA_CHECK,ASCIIDATA_CHECK_INTERVAL,NULL);
}

 