// ttrcx.H  contains ID's for application
#ifndef _TTTRX_H_
#define _TTTRX_H_

#define CR	0x0d
#define ETX	0x03
#define STX 0x02
#define TX_MIC_SELECT 0x00
#define TX_AUX_SELECT 0x01	


#define BAND160METERS 	0
#define BAND80METERS	1
#define BAND40METERS	2
#define BAND30METERS	3
#define BAND20METERS	4
#define BAND17METERS	5
#define BAND15METERS	6
#define BAND12METERS	7
#define BAND10METERS	8


#define AGC_FAST	0x33
#define AGC_MEDIUM	0x32
#define AGC_SLOW	0x31

#define RIT_ENCODER 0x00
#define XIT_ENCODER 0x01
#define PBT_ENCODER 0x02

#define LSB_MODE    0x32
#define USB_MODE    0x31
#define AM_MODE 	0x30
#define FM_MODE 	0x34
#define CW_MODE 	0x33
#define FSK_MODE	0x35
#define CW1_MODE    4
#define ISB_MODE    5
#define ID_AM   		100		// Mode buton designators
#define ID_USB			101
#define ID_LSB   		102
#define ID_CW   		103
#define	ID_CW1			104
#define	ID_FM			105
#define ID_RTTY			106
#define ID_LOCK 		107
#define ID_REVERSE 		108
#define ID_SPEAKERPLUS 	110
#define ID_SPEAKERMINUS 111
#define ID_PHONEPLUS    112
#define ID_PHONEMINUS   113
#define ID_MUTE         114
#define ID_DONE         115
#define ID_UP           150
#define ID_LOCK_BOX		116
#define ID_DOWN         117
#define ID_BFO          118
#define ID_AGC          119
#define ID_FILTERS      120
#define ID_OPTIONS      121

#define ID_SPLIT		122
#define ID_MEMTOVFO		123
#define ID_VFOTOMEM		124

#define ID_STEP_LABEL 	125
#define ID_ATTN			126
#define ID_STEP_BOX 	231

#define ID_STEPRIGHT  	127
#define ID_STEPLEFT  	128
#define ID_SMETERBUTTON 129
#define ID_SMETERBOX 	130
#define ID_POWER		131
#define ID_MAINENCODER 	132
#define ID_VOLUME_LABEL 133
#define ID_VOLUMESCROLL 134
#define ID_FILTERSCROLL	135
#define ID_BRAND_BUTTON	136
#define ID_SIGNALMETER	137
#define IDLB_FILTERS	140
#define ID_VOLUMEROTARY 141
#define ID_TESTROTARY	142
#define ID_LINE_LABEL 	143
#define ID_MODE_LABEL 	144
#define ID_MODE_GROUP 	145
#define ID_OFFSETENCODER 149

#define ID_AUXCLR 		150
#define ID_AUXON		151
#define ID_AUXOFF		152




#define ID_RIT	164
#define ID_XIT	165


#define ID_FILTERPIC_BOX	166
#define ID_RITDATA_BOX		167
#define ID_SQL 				168
#define ID_PBT 				169
#define ID_XITDATA_BOX 		170


#define ID_TIMER1			1
#define ID_SMETERTIMER  	2    
#define ID_SMETERBARGRAPH 	3      
#define ID_FREQUENCY_BOX	200
#define ID_FREQUENCY_BOX2	220

#define ID_BFO_BOX			201
#define ID_MODE_BOX			202
#define ID_MUTE_BOX			203
#define ID_WORLDTIME_BOX	204
#define ID_LOCALTIME_BOX	205
#define ID_TIMER_CLOCK		206
#define ID_WORLDTIME_LABEL	207
#define ID_LOCALTIME_LABEL	208
#define ID_BANDWIDTH_BOX	209	
#define ID_STATUSBAR		210
#define ID_OPPMODE_BOX		211
#define ID_TUNE_BOX			212
#define ID_MON_BOX			213
#define ID_MON				214
#define ID_SIDETONE			215
#define ID_ATTN_BOX			216
#define ID_VOLLEFT         	222
#define ID_VOLRIGHT        	223
#define ID_BFO_LABEL 		224
#define ID_AEQB				225
 
#define ID_SWR_BOX 		226
#define ID_REF_BOX 		227
#define ID_FWD_BOX 		228
#define ID_SWAPAB		229
#define ID_MANUAL_PTT 	230
#define ID_AGCMODE_BOX	232 


#define ID_REMOTENEXTSTEP 		233
#define ID_REMOTENEXTTUNE 		234
#define ID_REMOTENEXTMODE 		235
#define ID_REMOTESPLITREVERSE 	236
#define ID_REMOTESWAPAB 		237

#define REMOTE_VFO_TUNE 0x01
#define REMOTE_PBT_TUNE 0x02
#define REMOTE_RIT_TUNE 0x03
#define REMOTE_XIT_TUNE 0x04

 
#define ID_TEST				350
#define IDM_STEPREQUEST		365
#define ID_SPEAKERSLIDER	360
#define ID_TIME_BOX			363
#define ID_LINESLIDER		361
#define ID_POWERSLIDER		362
#define ID_MEMORY_BOX		353
#define ID_RFGAIN_SLIDER	359


#define ID_SPECIAL1			354
#define ID_SPECIAL2			355
#define ID_SPECIAL3			356
#define ID_SPECIAL4			357

#define ID_FREQSCALE		358
#define ID_NOISE_REDUCTION	364
#define ID_AUTO_NOTCH		365

#define ID_SIDETONE_ENCODER 366
#define ID_TXOPS_PANEL		367
#define ID_STVOLUME_SLIDER 	368
#define ID_OPSEL_STF_BOX 	369
#define ID_SECTIONLIST_BOX 	370
#define ID_OPSEL_UTCH_BOX 	371
#define ID_OPSEL_UTCM_BOX 	372
#define ID_OPSEL_MUTE_LIST 	373
#define ID_MONVOLUME_SLIDER 374
#define ID_MICGAIN_SLIDER 	375
#define ID_MUTELIST_BOX 	376
#define ID_VOXDELAY_SLIDER 	377
#define ID_ANTIVOX_SLIDER 	378                           
#define ID_VOXGAIN_SLIDER 	379                           
#define ID_OPSEL_TXLOOP		380
#define ID_OPSEL_TXENABLE	381
#define ID_RITDATA_DRAGIT	382
#define ID_TXFILTERLIST_BOX 383
#define ID_HAMBANDS_BUTTON	384
#define ID_MASTER_FILTER_PANEL 385
#define ID_PBTDATA_DRAGIT	386
#define ID_SQUELCH_SLIDER	387
#define ID_XITDATA_DRAGIT	400
#define ID_CWSPEED_SLIDER	388
#define ID_CALLLOOKUPPANEL	389
#define ID_OPSEL_SWEEPMUTE  390
#define ID_OPSEL_HAMCALLPATH  391
#define ID_CWSPOT_SLIDER	392
#define ID_CWWEIGHT_SLIDER	393
#define ID_CWQSK_SLIDER		394
#define ID_FILTER1 401
#define ID_FILTER2 402
#define ID_FILTER3 403
#define ID_FILTER4 404
#define ID_FILTER5 405
#define ID_FILTER6 406
#define ID_FILTER7 407
#define ID_FILTER8 408
#define ID_FILTER9 409
#define ID_FILTER10 410
#define ID_FILTER11 411
#define ID_FILTER12 412
#define ID_FILTER13 413
#define ID_FILTER14 414
#define ID_FILTER15 415

#define ID_SPIN_FREQUENCY 	416
#define ID_STEPSCROLL 		417
#define ID_BFOSCROLL 		418

#define ID_MEMSTORE 	419
#define ID_MEMRECALL 	420
#define ID_MEMEDIT		421
#define ID_MEMSCAN		422
#define ID_MEMOPTIONS	423
#define ID_MEMTIME		424
#define ID_MESSAGETIMER 425
#define ID_SETLINEAR    426
#define ID_SETLOG    	427
#define ID_SETBAR    	428
#define ID_SETDOT    	429
#define ID_TUNE        	430
#define ID_FWDMETER		431
#define ID_REFMETER		432
#define ID_SWRMETER		433
#define ID_SWEEPDELAYTIMER 	434
#define ID_FWDPWRMETER		435
#define ID_AGC_MED		437

#define ID_SPINUP 			300
#define ID_SPINDN   		301
#define ID_FREQSCROLLCOURSE	302
#define ID_FREQSCROLLFINE 	303

#define IDACC_RADIO_PANEL   601     // Accelerator table
#define ID_OWNER_TEST 		600
#define ID_SWEEPFILTERCOMBO 602
#define ID_SWEEPAUTOCENTER 	603
#define ID_SWEEPMANUALCENTER 604
#define ID_SWEEPWIDTHCOMBO 	605
#define ID_SWEEPFORMATCOMBO 606
#define ID_SWEEPSTYLECOMBO 	607
#define ID_SWEEPCENTERCOMBO 608


#define IDM_FILEOPEN  	500
#define IDM_FILECLOSE 	501
#define IDM_FILESAVE   	502
#define IDM_FILESAVEAS	503
#define IDM_HELP        504
#define IDM_QUIT        505
#define ID_DFE1        	506
#define ID_EDITOK       507
#define IDH_RECEIVERCONTROLS 508
#define IDH_DATAFILES	509
#define IDH_TROUBLESHOOTING 510
#define IDM_ABOUT		511
#define IDM_SETUP		512
#define IDM_USEROPT		513
#define ID_EGRIDTEST	514
#define IDB_SPLASH		515
#define ID_XITBOX		516
#define ID_RITBOX		517
#define ID_PBTBOX		518
#define ID_SQLBOX		519

#define ID_OPSEL_MICAUDIO 	550
#define	ID_OPSEL_AUXAUDIO	551	
#define	ID_OPSEL_ENABLEKEYER	552
#define ID_OPSEL_POWERTUNE	553
#define ID_OPSEL_FORWARDPOWER 554

#define IDC_AUXAUDIOTEST	1206
#define ID_TREP				1300
#define ID_RB_FAST_UP		1301
#define ID_RB_UP			1302
#define ID_RB_FAST_DOWN		1303
#define ID_RB_DOWN			1304
#define MSG_RB_FREQ			1305		// Message Code for Repeating Buttons

#define ID_PAD0 	1200
#define ID_STEP1 	1201
#define ID_STEP2 	1202
#define ID_STEP3 	1203
#define ID_STEP4 	1204
#define ID_STEP5	1205
#define ID_PAD6 	1206
#define ID_PAD7 	1207
#define ID_PAD8 	1208
#define ID_PAD9 	1209
#define ID_PADUP 	1210
#define ID_STEPGROUP 1211
#define ID_PADENTER 1212
#define ID_SWLPANEL 1213
#define ID_TIMEFREQTUNE 1214
#define ID_SWEEPPANEL 	1220
#define ID_SWEEPSTART 	1221
#define ID_SWEEPWINDOW 	1222
#define ID_CONTROLBAR1 	1223
#define ID_STARTSWEEP 	1224
#define ID_SWEEPSTOP	1225

#define IDC_STATIONSORT 1300
#define IDC_FREQUENCYSORT 1301
#define IDC_COUNTRYSORT 1302
#define IDC_AUTOTUNE 	1303
#define IDC_STATIONLIST 1304
#define IDNEW 			1305
#define IDDELETE 		1306
#define IDFIND 			1307
#define IDEDIT 			1308
#define IDCLOSE 		1309
#define IDTUNE			1310
#define IDC_SWEEPSTARTFREQ 1311
#define IDC_SWEEPSPREAD 1312
#define IDC_OPT_COM1	1313
#define IDC_OPT_COM2	1314
#define IDC_OPT_COM3	1315
#define IDC_OPT_COM4	1316
#define ID_COMMPORTLIST_BOX 1317
#define ID_CALLTEXT_BOX 1318
#define ID_FINDCALL		1319 
#define ID_STATIONPANEL 1400
#define ID_SWEEPCLICKFREQ 1401 
#define ID_VOXONOFF 	1402 
#define ID_FUNCTIONKEY1_BOX 1403
#define ID_TXHANGSLIDER 1404
#define ID_PHBUTTON_DOWN 1405
#define ID_PHBUTTON_UP 	1406
#define ID_SPOTONOFF 	1407

#define ID_ASCIIDATA_SAVE 1450
#define ID_ASCIIDATA_CHECK 1451

#define ID_LOOKUPCALL 42000

#define DISPLAY_BORDER_COLOR RGB(255,255,255)
#define DISPLAY_HIGHLIGHT_COLOR RGB(192,192,192)

#define FREQUENCY_DISPLAY_TEXT_COLOR RGB(0,255,0)
#define DISPLAY_BACKGROUND_COLOR RGB(0,0,0)
#define DISPLAY_TEXT_COLOR RGB(0,192,0)
#define LEGEND_TEXT_COLOR RGB(200,200,200)
#define EDIT_BLOCK_TEXT_COLOR RGB(0,0,250)


#define OPTION_DIM_COLOR RGB(0,96,0)
#define OPTION_HIGHLIGHT_COLOR RGB(0,255,0)
#define OPTION_WARNING_COLOR RGB(255,0,0)

	// Filter Data Structure
struct filter
	{
		char name[10];
		int bfo;
		char dspfilter;
	};	


struct Bands
	{
		char name[32];				// band name
		double LowerLimit;			// band lower limit
		double UpperLimit;			// band upper limit
		double LastFreq;			// last freq accessed on this band
		char LastMode;
		int LastFilter;
	};		


#endif

