s        \{   D Ng                                        wtk1395     Wavetek 1395 Arbitrary Waveform Synth.        M     Instrument Name: Wavetek 1395 Arbitrary Waveform
                  Synthesizer

 Description:     This instrument module provides
                  programming support for the
                  Wavetek 1395.  The module
                  is divided into the following
                  functions:

 Functions/Classes:

 (1) Initialize:
     Initializes the instrument and sets it to a
     default configuration.

 (2) Configure: Class
     A class of functions for configuring the
     frequency, waveform(trace), trigger,
     markers, phase, output, and voltage level
     subsystems.

 (3) Arbitrary Waveform: Class
     A class of functions to create and edit
     traces and sequences to be used for arbitrary
     waveform generation.

 (4) Accessories: Class
     A class of functions for reading the
     instrument error queue, and performing
     tests and calibrations on the instrument.

 (5) Low Level Functions: Class
     A class of lower level functions to
     communicate with the instrument, and change
     instrument parameters.

 (6) Close:
     Takes the instrument offline.    j     Function:    Initialize

 Description:   This routine performs the
                following initialization actions:

                -  Opens the instrument by
                   storing information about the
                   instrument in the Instrument
                   Table.

                -  Initializes the VXI interface
                   (NI-VXI or NI-GPIB)
                   accordingly.

                -  Performs an identification
                   query on the Instrument.

                -  Sends initialization commands
                   to the instrument.

                -  Returns an Instrument ID which
                   is used to differentiate
                   between instruments of the same
                   model type.  This value will be
                   used to identify the instrument
                   in subsequent calls.    	     Class Name:    Configure

 Description:   This class contains functions for
                configuring the source, frequency,
                waveform(trace), trigger, marker,
                phase, voltage level, and output
                subsystems for subsequent
                operation.

 Functions/Classes:

 (1) Frequency: Class
     A class of functions for configuring the
     output frequency of the source waveform.

 (2) Waveform Type: Class
     A class of functions for configuring the type
     of output function.

 (3) Trigger: Class
     A class of functions for enabling the
     triggered mode of operation, sending and
     recieving instrument trigger signals.

 (4) Markers:
     Configures the marker output of the
     instrument.

 (5) Voltage: Class
     A class of functions for configuring the
     amplitude and offset of the output voltage.

 (6) Phase: Class
     A class of functions for changing the phase
     of the output signal or locking phase with
     another 1395 in the chassis.

 (7) Output: Class
     A class of functions for configuring the
     main, sumbus, clock, filter, and trigger
     outputs of the instrument.

 (8) Sumbus Input:
     Configures the instrument to receive sumbus
     inputs.

 (9) Modulation:
     Configures the instrument for amplitude
     modulation of the output signal.

(10) Reference Oscillator:
     Sets the period for the reference oscillator.

(11) Trace Playback Mode:
     Selects the trace playback mode for either
     raster or continuous playback.         Class Name:    Frequency

 Description:   This class contains functions for
                configuring the frequency of the
                output signal.

 Functions:

 (1) Continuous:
     Configures the frequency mode for continuous
     wave operation and sets the frequency value
     for continuous trace mode.

 (2) Raster:
     Configures the frequency mode for continuous
     wave operation and sets the trace scan rate
     for raster trace mode.

 (3) Sweep:
     Configures the source function mode for sweep
     operation and sets the parameters for a
     sweep to be executed by the instrument.

 (4) List:
     Configures the source function mode for list
     operation and defines the list of
     frequencies for the instrument to sweep.
    8     Function:      Continuous

 Description:   This routine performs the
                following operations:

                - Configures the frequency mode
                  for continuous wave
                  operation.

                - Sets the frequency value for
                  continuous trace mode.

 Note:  The default trace mode for standard
        waveforms is continuous and the default
        trace mode for arbitrary waveforms is
        raster.  An error will be generated if the
        instrument is not in the continuous trace
        mode.    +     Function:      Raster

 Description:   This routine performs the
                following operations:

                - Configures the frequency mode
                  for continuous wave
                  operation.

                - Sets the trace scan rate
                  for raster trace mode

 Note:  The default trace mode for standard
        waveforms is continuous and the default
        trace mode for arbitrary waveforms is
        raster.  An error will be generated if the
        instrument is not in the raster trace
        mode.         Function:      Sweep

 Description:   This routine performs the
                following operations:

                - Configures the source function
                  mode for sweep operation.

                - Sets the number of sweeps
                  enabled by each triggering
                  event.

                - Selects sweep direction.

                - Selects the sweep mode.

                - Sets the duration of the sweeps.

                - Selects a linear or logarithmic
                  scale for sweeping.    %     Function:      List

 Description:   This routine performs the
                following operations:

                - Configures the source function
                  mode for list operation.

                - Defines the list of frequencies
                  for the instrument to sweep         Class Name:    Waveform Type

 Description:   This class contains functions for
                configuring the type of waveform
                to be used as the source of the
                frequency synthesizer.

 Functions:

 (1) Standard:
     Specifies one of the nine onboard waveforms
     as the source function.

 (2) Trace:
     Specifies a trace in instrument trace memory
     as the source function.

 (3) Get Trace A24 from A24 Memory:
     Reads a trace from the VXI A24 memory space
     and specifies the trace as the source
     function.

 (4) Sequence:
     Selects the currently defined sequence stored
     in memory to be output by the instrument         Function:      Standard Waveform

 Description:   This routine performs the
                following operations:

                - Configures the function mode as
                  SHAPE, to use standard waveforms
                  as the source.

                - Disables the USER function mode.

                - Selects the standard waveform to
                  use as the source.

                - Sets the trace mode to
                  continuous wave.

                - Sets the source marker to
                  SYNchronized, triggering off the
                  output waveforms zero-crossing.

                - Enables the elliptic output
                  filter.         Function:      Trace

 Description:   This function performs the
                following operations:

                - Configures the source function
                  mode as USER, selecting user
                  defined traces as source.

                - Disables the SHAPE mode.

                - Sets trace mode to RASTER.

                - Sets source marker to
                  SYNchronized and bit-marker
                  trigger qualification.

                - Disables the output filter.         Function:      Get A24 Memory Data

 Description:   This function performs the
                following operations:

                _ Returns the data located in the
                  first 8 KBytes of the VXIbus A24
                  shared memory and selects this
                  waveform as the current output
                  function.

                - Configures the function mode as
                  SHAPE.

                - Disables the USER function mode.

                - Sets the trace mode to
                  continuous wave.

                - Sets the source marker to
                  SYNchronized, triggering off the
                  output waveforms zero-crossing.

                - Enables the elliptic output
                  filter.         Function:      Sequence

 Description:   This function performs the
                following operations:

                - Configures the source function
                  mode as USER, selecting user
                  defined traces as source.

                - Disables the SHAPE mode.

                - Selects the currently defined
                  sequence stored in memory         Class Name:    Trigger

 Description:   This class contains functions for
                enabling, sending, and receiving
                instrument trigger signals.

 Functions:

 (1) Trigger Enable:
     Configures the instrument for triggered
     operation.

 (2) Start Trigger:
     Configures the instrument to accept a trigger
     signal to begin an operation.

 (3) Advance Trigger:
     Configures the instrument to accept trigger
     signals to advance to the next element in a
     sequence table.

 (4) Software Trigger:
     Sends a software trigger to the instrument
     as either a start or advance trigger.

 (5) Set Internal Trigger Rate:
     Sets the period for generating trigger
     signals.          Function:      Trigger Enable

 Description:   This routine selects between a
                continuous or triggered mode of
                operation.    7     Function:      Start Trigger

 Description:   This routine performs the
                following operations

                - Configures the instrument for
                  triggered operation.

                - Selects the polarity of the
                  start trigger.

                - Specifies the number (count) of
                  event repetitions initiated by
                  the start trigger.

                - Selects the source of the start
                  trigger.

                - Enables/disables the gate mode
                  of operation.

                - Selects synchronous or
                  asynchronous gate mode.

 NOTE:  The start trigger initiates an operation,
        while the advance trigger advances to
        subsequent functions within a sequence
        structure.    @     Function:      Advance Trigger

 Description:   This routine performs the
                following operations:

                - Configures the instrument for
                  triggered operation.

                - Selects the polarity of the
                  advance trigger.

                - Specifies the number(count) of
                  event repetitions initiated by
                  the advance trigger.

                - Selects the source of the
                  advance trigger.

                - Enables/disables the gated mode
                  of operation.

                - Selects synchronous or
                  asynchronous gate mode.

 NOTE:  The start trigger initiates an operation,
        while the advance trigger advances to
        subsequent functions within a sequence
        structure.         Function:      Software Trigger

 Description:   This routine initiates an
                immediate trigger signal
                synchronized with next clock
                pulse.

 NOTES: The trigger clock can be adjusted by the
        Set Trigger Rate function.

        The trigger mode must be enabled
        separately with the Enable Trigger
        function before this function will
        operate.         Function:      Set Internal Trigger Rate

 Description:   This function sets the period of
                an internal signal source. The
                timer signal acts as a trigger
                when it is the selected trigger
                source.     x     Function Name: Markers

 Description:   This function configures the
                marker output of the instrument.    =     Class Name:    Voltage

 Description:   This class contains functions to
                configure the output voltage
                amplitude and offset.

 Functions:

 (1) Set DC Offset:
     Specifies a DC offset for the output voltage.

 (2) Set Maximum Amplitude:
     Specifies the maximum output amplitude.    B     Function:      Set DC Offset

 Description:   This function generates a DC
                offset of a specified magnitude.

 NOTE:  Unless a 50 ohm terminator (50 ohms in
        parallel with the load and a 50 ohm cable
        resistance in series) is used, the offset
        voltage may be twice the entered value.    _     Function:      Set Maximum Amplitude

 Description:   This function configures the
                optimum output resolution
                of user-defined traces by
                scaling the maximum amplitude to
                the maximum memory value and the
                negative amplitude to the minimum
                memory value. Refer to operation
                manual for further details.

 NOTE:  Unless a 50 ohm terminator (50 ohms in
        parallel with the load and a 50 ohm cable
        resistance in series) is used, the offset
        voltage will be twice the entered value.    C     Class Name:    Phase

 Description:   This class contains functions to
                configure the phase of the output
                signal.

 Functions:

 (1) Lock:
     Synchronizes the phase of the output signal
     with other 1395's in the VXI chassis.

 (2) Adjust:
     Changes the phase of the output signal.    :     Function:      Phase Lock

 Description:   This function matches phase with
                another Wavetek 1395 on the
                VXIbus.

 NOTE:  This function can be used in conjunction
        with the Phase Adjust function to create a
        precise phase offset between two Wavetek
        1395's.

          Function:      Phase Adjust

 Description:   This function specifies the phase
                delay for the output waveform.
    &     Class Name:    Output

 Description:   This class contains functions to
                configure the clock, sumbus,
                trigger, and main outputs.

 Functions:

 (1) Enable:
     Enables the main signal output.

 (2) Filter:
     Enables/disables the bessel or elliptic
     output filter.

 (3) Sumbus Out:
     Enables the sourcing of a sumbus output.

 (4) Output Trigger:
     Sends an ECL or TTL trigger signal over the
     selected VXIbus trigger lines.

 (5) Clock:
     Configures the CLK IN/OUT BNC for input or
     output.     q     Function:      Output Enable

 Description:   This function enables/disables
                the MAIN OUT BNC.         Function:      Filter

 Description:   This function performs the
                following operations

                - Enables/disables the 20 MHz low
                  pass filter between the output
                  of the waveform DAC and the
                  pre-amplifier.

                - Selects either a 4-pole Bessel
                  filter (flattest response with
                  constant group delay) or a
                  7-pole, 6-zero Elliptic
                  (steepest cutoff.)          Function:      Sumbus Out

 Description:   This function configures the
                instrument to source sumbus
                signals to the backplane.    +     Function:      Output Trigger

 Description:   This function performs the
                following operations

                - Selects a target for the output
                  trigger, either ECL or TTL
                  trigger lines on the VXIbus.

                - Selects the source of the
                  trigger from bit markers or
                  sequence complete qualifiers

 NOTE:  The ECL trigger lines can be separately
        enabled/disabled with multiple function
        calls. Only one TTL trigger line may be
        active.         Function:      Output Clock

 Description:   This function performs the
                following operations:

                - Specifies if the CLK IN/OUT BNC
                  is to be used for input or
                  output

                - Specifies the output mode for
                  the CLK IN/OUT BNC

                - Specifies the output frequency
                  of the CLK IN/OUT BNC    1     Function:      Sumbus Input

 Description:   This function perform the
                following operations:

                - Enables the sumbus input
                  terminals.

                - Sets an attenuation value for
                  the sumbus inputs on the
                  backplane.    E     Function:      Modulation

 Description:   This function performs the
                following operations

                - Enables/disables the amplitude
                  modulation input(AM IN BNC).

                - Selects either amplitude
                  modulation or suppressed carrier
                  mode.          Function:      Reference Oscillator

 Description:   This function selects the source
                for the reference oscillator.          Function:      Trace Playback Mode

 Description:   Selects the trace playback mode
                for either raster or continuous
                playback.         Class Name:    Arbitrary Waveform

 Description:   This class contains a set of
                functions to create and edit
                traces and sequences to be used
                for arbitrary waveform generation.

 Classes:

 (1) Trace: Class
     This class contains functions that create,
     copy, delete, edit, and transfer traces
     to/from DOS files, VXI A24 memory, and trace
     memory.

 (2) Sequence: Class
     This class contains functions for defining
     and adding elements to the current sequence
     table.         Class Name:    Trace

 Description:   This class contains functions that
                create, copy, delete, edit, and
                transfer traces to/from DOS files,
                VXI A24 memory, and trace memory.

 Functions/Classes:

 (1) Create:
     Initializes space in instrument trace memory
     for a trace with the specified name.

 (2) Copy:
     Copies a trace or standard waveform into
     another memory space specified by a trace
     name.

 (3) Delete:
     Removes a trace from instrument trace memory.

 (4) List Directory:
     Returns the names and sizes of all traces in
     instrument trace memory.

 (5) Available Trace Memory:
     Returns the number of data points in trace
     memory that are available and the number in
     use.

 (6) File/Memory Transfer: Class
     A class of functions for transferring trace
     data to/from DOS files, VXI A24 memory, and
     trace memory.

 (7) Edit: Class
     A class of functions for editing traces.          Function:      Create Trace

 Description:   This function creates a user
                waveform in trace memory called
                by the trace name with the
                specified number of points.          Function:      Copy Trace

 Description:   This function copies either a
                standard or user-defined trace
                (source trace) to a new location
                in trace memory, callable by
                the target trace name.          Function:      Delete Trace

 Description:   This function deletes all traces
                or a single, specified trace from
                trace memory.          Function:      List Directory

 Description:   This function returns a string
                containing the names, sizes, and
                limits of all defined traces.          Function:      Available Trace Memory

 Description:   This function returns a string
                specifying the number of data
                points available and the number of
                data points in use.         Class Name:    File/Memory Transfer

 Description:   This class contains functions for
                transfering trace data to/from DOS
                files, VXI A24 memory, and trace
                memory.

 Functions/Classes:

 (1) Write Trace to File:
     Reads a trace from trace memory and writes it
     to a DOS file.

 (2) Write File to Trace Memory:
     Reads trace data from a DOS file and writes
     it into trace memory.

 (3) Write File to A24 Memory:
     Reads trace data from a DOS file and writes
     it to the VXI A24 memory space.

 (4) Write A24 to Trace Memory:
     Reads trace data from the VXI A24 memry and
     writes it to a specified trace in trace
     memory.          Function:      Write Trace to File

 Description:   This function writes a single
                trace to a file. If the file does
                not exist, it is created.
    ;     Function:      Write File to Trace Memory

 Description:   This function writes the contents
                of a file (trace data previously
                stored) into trace memory.

                This function operates for AT-MXI,
                embedded VXI, or GPIB-VXI. For
                embedded VXI and AT-MXI, a
                word-serial write is performed,
                bypassing the A24 memory space.
                For large volumes of data, the
                functions Write Data to A24 and
                Write A24 to Trace should be used.         Function:      Write File to A24 Memory

 Description:   This function writes the contents
                of a file (trace data) to the A24
                shared memory space in the VXI
                chassis. The data can be
                downloaded into an instrument on
                the chassis with the Write A24 to
                Trace Memory or Get A24 Shared
                Data functions.

 Note:          This function does not work for
                GPIB-VXI; use Write File to Trace.    l     Function:      Function

 Description:   This function reads the specified
                number of bytes from the A24
                memory space and writes into the
                trace memory.

 Note:          This function does not operate
                under the GPIB_VXI platform,
                use the Write File to Trace
                function.    B     Class Name:    Edit

 Description:   This class contains functions to
                edit traces in trace memory.

 Functions/Classes:

 (1) Draw Line:
     Connects two points in a specified trace in
     trace memory.

 (2) Define Points:
     Defines the point values for a specified
     trace using an array of integers.

 (3) Change Point:
     Sets the value of a point in the specified
     trace.

 (4) Re-Scale:
     Copies a specified trace into a new location
     in trace memory and horizontally scales the
     trace to fit the new location.

 (5) Get Limits:
     Returns the start and stop indexes of the
     specified trace in trace memory.

 (6) Get Point Value:
     Returns the value from a point in a specified
     trace.

 (7) Get Trace Size:
     Returns the number of points in the specified
     trace.         Function:      Draw Line

 Description:   This function performs the
                following operations

                - Draws a line between two
                  specified points in a trace.

                - Erases previous values between
                  the two indices.          Function:      Define Points

 Description:   This function defines the point
                values for a specified trace using
                an array of integers.          Function:      Change Point

 Description:   This function changes the voltage
                value of a single point specified
                by a trace name and an index
                number.
    b     Function:      Re-Scale

 Description:   This function performs the
                following operations

                - Copies the contents of the
                  specified trace into a new
                  location.

                - Horizontally scales the trace
                  indices to the specified number
                  of points.    j     Function:      Get Limits

 Description:   This function returns the playback
                limits specified by the trace
                name.

 NOTE:  The playback limits may be different from
        the actual trace size. Only the portion of
        the specified trace, partitioned by the
        trace limits are available as an output
        source.          Function:      Get Point Value

 Description:   This function returns the value of
                a single point in trace memory,
                specified by a trace name and an
                index.    |     Function:      Get Trace Size

 Description:   This function returns the size
                (number of indexed data points) of
                a specified trace.

 NOTE:  The playback limits may be different from
        the actual trace size. Only the portion of
        the specified trace partitioned by the
        trace limits are available as an output
        source.
         Class Name:    Sequence

 Description:   This class contains functions for
                defining and adding elements to
                the current sequence table.

 Functions:

 (1) Define Sequence:
     Defines the number of elements in the
     sequence table and the type of element
     advancing.

 (2) Add Element to Sequence Table:
     Adds a single element, function and
     frequency, to the sequence table.
         Function:      Define Sequence

 Description:   This function performs the
                following functions:

                - Configures the instrument for
                  the sequence mode.

                - Disables the fixed mode.

                - Sets up a sequence table of
                  length specified by the user
                  (up to 4 elements.)

Note:   The elements in the sequence table must be
        created and linked together using the Link
        Sequence function.          Function:      Add Sequence Element

 Description:   This function creates one element
                in a sequence table, and links the
                element with others using the
                sequence index.         Class Name:    Accessories

 Description:   This class contains functions for
                reading the instrument error
                queue, and performing tests and
                calibrations on the instrument.
 Functions:

 (1) Read Error Queue:
     Reads all errors from the error queue
     and returns the code for the last error.

 (2) Test:
     Performs a self-test on the instrument.

 (3) Calibrate:
     Performs an interanl self-calibration on the
     instrument.          Function:      Read Error Queue

 Description:   This function reads all errors
                from the error queue and returns
                the code for the last error.

         Function:    Test

 Description:   This routine performs the
                following actions:

                - Instructs the instrument to
                  perform either a destructive
                  test on trace memory(RAM) or a
                  non-destructive test of its
                  hardware systems.

                - Returns a two-byte, bit-weighted
                  error code in hexadecimal
                  format. (Detailed descriptions
                  of the error codes may be found
                  in the instrument's operation
                  manual.) A zero indicates that
                  no error occurred.
         Function:   Calibrate

 Description:  This routine performs the
               following actions:

               - Instructs the instrument to
                 perform an internal self
                 calibration.

               - Returns a two-byte, bit weighted
                 error code in hexadecimal format.
                 (Detailed descriptions of the
                 error codes may be found in the
                 instrument's operation manual.)
                 A zero indicates that no error
                 occurred.         Class Name:    Low Level Functions

 Description:   Provides lower level functions to
                communicate with the instrument,
                and change instrument parameters.

 Functions:

 (1) Reset:
     Reconfigures all parameters to their default 
     state.

 (2) Write To Instrument:
     Writes commands and queries to the instrument
     to modify parameters and query device
     settings.

 (3) Read Instrument Data:
     Reads data from instrument buffer and returns
     it to the specified variable in memory.     z     Function:      Reset

 Description:   This function reconfigures all
                parameters to their default state.          Panel Name:    Write To Instrument

 Description:   Writes commands and queries to the
                instrument to modify parameters
                and query device settings.         Panel Name:    Read Instrument Data

 Description:   Reads data from instrument buffer
                and returns it to the specified
                variable in memory.

 NOTES: (1) Because the instrument may return both
            numeric and text data in response to
            queries this function returns the data
            in string format.

        (2) If valid data is not available at the
            instrument's output buffer when this
            function is called the instrument will
            hang up and the function will not
            return until it times out.  If the
            time-out is disabled this function
            will hang indefinitely and it may be
            necessary to reboot the computer to
            break out.          Function:     Close

 Description:    The close routine performs the
                 following operations:

                 -  removes the entry for the
                    instrument from the Instrument
                    Table.    ;     Control Name:  Logical Address

 Description:   Specifies the Logical Address of
                the VXI instrument.  This value
                must correspond to the current
                internal setting of the
                instrument.

 Variable Type: Integer

 Valid Range:   0 - 255

 Default Value: 1         Control Name:  Interface

 Description:   Specifies which protocol is used
                to communicate with the VXI
                mainframe.

                NI-VXI should be selected for
                MC-MXI, AT-MXI, or VXIpc-386.

                NI-GPIB should be selected for the
                GPIB-VXI.

 Variable Type: Integer

 Valid Range:   1 - NI-VXI
                2 - NI-GPIB

 Default Value: 1 - NI-VXI    0     Control Name:  Instrument ID

 Description:   Returns an Instrument ID that is
                used in all subsequent function
                calls to select the instrument at
                the address specified.

                If more than one instrument of the
                same model type is used, this ID
                will be used to differentiate
                between them. The first instrument
                of this model type initialized
                will be assigned an Instrument ID
                of 1.

 Variable Type: Integer         Control Name:  ID Query

 Description:   Specifies if an ID Query is sent
                to the instrument during the
                initialization procedure.

 Variable Type: Integer

 Valid Range:   1 = Yes
                0 = No

 Default Value: 1 - Yes

 NOTE:  Under normal circumstances the ID Query
        insures that the instrument initialized
        over the GPIB is the type supported by
        this driver. However circumstances may
        arise where it is undesirable to send an
        ID Query to the instrument. In those
        cases; set this control to Skip Query
        and this function will initialize the
        GPIB and the Command arrays in the driver,
        without doing an ID Query.         Control Name:  Reset

 Description:   Specifies if the instrument is to
                be reset to its power-on settings
                during the initialization
                procedure.

 Variable Type: Integer

 Valid Range:   1 = Yes
                0 = No

 Default Value: 1 - Yes

 NOTE: If you do not want the instrument reset.
       Set this control to No while initializing
       the instrument.    
     Control Name:  Error

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Logical Address out of range
       -2   Interface out of range
       -3   ID Query out of range
       -4   Reset Device out of range

      220   Unable to open instrument
      221   Unable to close instrument
      222   Unable to initialize VXI library
      223   Instrument identification query failed
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      239   Error setting time out
      241   Error configuring repeat addressing    y M =           Logical Address                   z` M           Select Interface                  | Mj          Instrument ID                     ~L  ?          ID Query                          (            Reset Device                                Error                             6                                            64   NI-VXI 1 NI-GPIB 2    	           Do Query 1 Skip Query 0   Reset Device 1 Don't Reset 0    	            GCopyright 1993 National Instruments Corporation.  All Rights Reserved.   -     Control Name:  Frequency

 Description:   Sets the output frequency for the
                waveform when the trace output
                is in raster mode. Floating point
                notation (e.g. 12E3) is required.

 Variable Type: Double

 Valid Range:   1E-6 to 2.5E6

 Default Value: 1E3    G     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                       this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.    z     Control Name:  Error

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range
       -2   Frequency out of range

       10   Instrument not in continuous
            trace mode

      226   Error polling instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response

      300   Instrument Dependent Error - Execute
            the Read Error Queue function for 
            more information    
 =          Frequency                         ?             Instrument ID                               Error                              1e3    1    	                Control Name:  Scan Rate

 Description:   Specifies the scan rate for the
                waveform when the trace output
                is in raster mode.  The actual
                frequency output is calculated as
                follows:

                Freq = Rate * #Cycles / Length
                 where Rate    = Scan Rate
                       #Cycles = # of wave cycles
                       Length  = points in wave

 Variable Type: Double

 Valid Range:   1E-1 to 5E7

 Default Value: 5E7    G     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                       this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.    j     Control Name:  Error

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range
       -2   Scan Rate out of range

       10   Instrument not in raster trace mode

      226   Error polling instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response

      300   Instrument Dependent Error - Execute
            the Read Error Queue function for 
            more information     =          Scan Rate                                      Instrument ID                               Error                              1E3    1    	                 Control Name:  Count

 Description:   This control sets the number of
                sweeps enabled by a triggering
                event.

 Variable Type: Double

 Valid Range:   1 to 1e6

 Default Value: 1.0          Control Name:  Direction

Description:    This control selects the direction
                the sweep traverses from the start
                and stop frequencies.

 Variable Type: Integer

 Valid Range:   0 - Down
                1 - Up (default)
    d     Control Name:  Mode

 Description:   This control selects the sweep
                characteristics - reset, reverse,
                and trigger. See NOTE for further
                details.

 Variable Type: Integer

 Valid Range:   Cont Reset - 0
                Trig Reset - 1
                Half Reset - 2
                Cont Reverse - 3
                Trig Reverse - 4
                Half Reverse - 5

 NOTE:  The following is a detailed description
        of each sweep mode:

          Cont Reset - Sweeps from the start
          frequency to the stop frequency and
          then returns to the start frequency
          in a continuous loop.

          Trig Reset - Waits for a trigger signal,
          sweeps from the start frequency to the
          stop frequency, and then resets to the
          start frequency.

          Half Reset - Waits for a trigger signal,
          sweeps from the start frequency to
          the stop frequency, and then waits for
          another trigger before returning to the
          start frequency.

          Cont Reverse - Sweeps from the start
          frequency to the stop frequency and then
          sweeps back to the start frequency in a
          continuous loop.

          Trig Reverse - Waits for a trigger,
          sweeps from the start frequency to the
          stop frequency, and then sweeps back
          to the start frequency.

          Half Reverse - Waits for a trigger,
          sweeps from the start frequency to
          the stop frequency, and then waits for
          another trigger before sweeping back to
          the start frequency.
          Control Name:  Start Frequency

 Description:   This control selects the frequency
                at which the sweep operation
                begins.

 Variable Type: Double

 Valid Range:   1E-3 to 50E6

 Default Value: 1E3          Control Name:  Sweep Time

 Description:   This control selects the duration
                of a single sweep (in seconds).

 Variable Type: Double

 Valid Range:   30e-3 to 1e3

 Default Value: 1.0    	     Control Name:  Sweep Spacing

 Description:   This control selects the time vs.
                frequency characteristic, either
                logarithmic or linear.

 Variable Type: Integer

 Valid Range:   0 - Logarithmic
                1 - Linear (default)          Control Name:  Stop Frequency

 Description:   This control selects the frequency
                at which the sweep operation
                ends.

 Variable Type: Double

 Valid Range:   1E-3 to 50E6

 Default Value: 1E3    G     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                       this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.         Control Name:  Error

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range
       -2   Count out of range
       -3   Direction out of range
       -4   Mode out of range
       -5   Sweep Time out of range
       -6   Spacing out of range
       -7   Start Frequency out of range
       -8   Stop Frequency out of range

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response

      300   Instrument Dependent Error - Execute
            the Read Error Queue function for 
            more information
    C -          Count                               -           Direction                         % -o          Mode                               -         Start Frequency                   ~           Sweep Time                        P            Spacing                           a          Stop Frequency                    K             Instrument ID                               Error                              1.0   Up 1 Down 0               TCont Reset 0 Trig Reset 1 Half Reset 2 Cont Reverse 3 Trig Reverse 4 Half Reverse 5    1E3    1.0   Linear 1 Logarithmic 0    1E5    1    	                Control Name:  Frequency List

 Description:   An array containing the list of
                sample rates or frequencies to be
                generated.  For example, if you
                want to sweep a list of three
                frequencies you would have

                    freq_arr[0] = freq #1
                    freq_arr[1] = freq #2
                    freq_arr[2] = freq #3

                where freq_arr = your array
                      freq #n  = desired freq

 Variable Type: Double Array

 Valid Range:   Each element of the array is
                bounded by the following
                restrictions:

                - Frequency values may range from
                  1e-3 to 2e7 Hz

                - List elements not specified will
                  have a default value of 1e3 Hz

                - No more than 1024 list elements
                  can be specified         Control Name:  List Length

 Description:   Specifies the number of
                frequencies or array elements to
                be written to the instrument.  For
                example, if you have defined your
                frequency array as follows:

                    freq_arr[0] = 10e3
                    freq_arr[1] = 20e3
                    freq_arr[2] = 30e3

                you would enter 3 into this
                control to sweep these
                frequencies.

 Variable Type: Integer

 Valid Range:   1 to 1024 (bounded by # of
                           array elements)

 Note:  Make sure that you do not specify a length
        that is longer than the number of elements
        you have in the array.    G     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                       this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.         Control Name:  Error

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range
       -3   List Length out of range

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response

      300   Instrument Dependent Error - Execute
            the Read Error Queue function for 
            more information
      =          Frequency List                     =@          List Length                                    Instrument ID                               Error                                      1    	                Control Name:  Waveform Type

 Description:   This control selects the waveform
                to used as the source function.
                For a more detailed explanation of
                each waveform, see NOTE.

 Variable Type: Integer

 Valid Range:   0 - DC
                1 - Square Wave
                2 - HF Square
                3 - Sinusoid
                4 - Pos Haversine
                5 - Neg Haversine
                6 - Pos Ramp
                7 - Neg Ramp
                8 - Rand Noise
                9 - Triangle
               10 - Test

 NOTE:  The following is a more detailed
        description of the standard waveform
        types.

        DC - An unvarying signal with respect to
        time with an amplitude of 0.

        Square Wave - A square wave signal.

        HF Square -  High frequency square wave.
        This square wave has faster rise and
        fall times than the standard square wave.
        Its maximum frequency is 25MHz.

        Sinusoid - A sinusoidal signal.

        Pos Haversine - A positive haversine
        signal.

        Neg Haversine - A negative haversine
        signal.

        Pos Ramp - A positive ramp signal.

        Neg Ramp - A negative ramp signal.

        Rand Noise - Periodic random noise.

        Triangle - A triangle wave signal.

        Test - An alternating pattern of high and
        low values. The values 4095 and 1 are
        alternately written to every point in the
        trace. This pattern is useful for testing
        very low frequencies.    G     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                       this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.         Control Name:  Error

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range
       -2   Waveform Type out of range

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response

      300   Instrument Dependent Error - Execute
            the Read Error Queue function for 
            more information
     -!          Waveform Type                                  Instrument ID                     h          Error                                         zDC 0 Square Wave 1 HF Square 2 Sinusoid 3 + Haversine 4 - Haversine 5 + Ramp 6 - Ramp 7 Random Noise 8 Triangle 9 Test 10    1    	           #     Control Name:  Trace Name

 Description:   This control specifies the name of
                the trace used as the source
                function, and must be a
                pre-defined trace residing in
                trace memory.

 Variable Type: String

 Default Value: "trace1"    G     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                       this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.         Control Name:  Error

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response

      300   Instrument Dependent Error - Execute
            the Read Error Queue function for 
            more information
     =          Trace Name                                     Instrument ID                     <          Error                              	"trace1"    1    	           G     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                       this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.         Control Name:  Error

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response

      300   Instrument Dependent Error - Execute
            the Read Error Queue function for 
            more information
                 Instrument ID                     A          Error                              1    	           G     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                       this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.         Control Name:  Error

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response

      300   Instrument Dependent Error - Execute
            the Read Error Queue function for 
            more information
    ̶             Instrument ID                               Error                              1    	           8     Control Name:  Trigger Mode

 Description:   This control enables or disables
                triggering. Disabling triggering
                configures the instrument for
                continuous mode of operation.

 Variable Type: Integer

 Valid Range:   0 - Disable (default)
                1 - Enable    G     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                       this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.         Control Name:  Error

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range
       -2   Trigger Mode out of range

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response

      300   Instrument Dependent Error - Execute
            the Read Error Queue function for 
            more information
    z =           Trigger Mode                      Һ             Instrument ID                     	          Error                              Enable 1 Disable 0    1    	                Control Name:  Trigger Polarity

 Description:   This control selects either the
                positive or negative slope for
                start triggering.

 Variable Type: Integer

 Valid Range:   0 - Negative Slope
                1 - Positive Slope (default)    Z     Control Name:  Trigger Source

 Description:   This control selects the source of
                the start trigger.

 Variable Type: Integer

 Valid Range:   0 - Internal (default)
                1 - External
                2 - Chain
                3 - EChain
                4 - VXIbus Trigger Line 0
                5 - VXIbus Trigger Line 1
                6 - VXIbus Trigger Line 2
                7 - VXIbus Trigger Line 3
                8 - VXIbus Trigger Line 4
                9 - VXIbus Trigger Line 5
               10 - VXIbus Trigger Line 6
               11 - VXIbus Trigger Line 7          Control Name:  Gate State

 Description:   This control enables or disables
                gated trigger operation.

 Variable Type: Integer

 Valid Range:   0 - Disable (default)
                1 - Enable    K     Control Name:  Count

 Description:   This control specifies the number
                of times to cycle through a trace
                after a trigger signal is
                received.

 Variable Type: Long

 Valid Range:   1 to 1,048,575 (non-seq waveforms)
                1 to 524,288 (seq waveforms)

 Default Value: 1
          Control Name:  Gate Mode

 Description:   This control selects synchronous
                or asynchronous gate operation.

 Variable Type: Integer

 Valid Range:   0 - Asynchronous
                1 - Synchronous (default)    G     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                       this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.         Control Name:  Error

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range
       -2   Source out of range
       -3   Polarity out of range
       -4   Gate out of range
       -5   Count Cycles out of range
       -6   Gate Mode out of range

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response

      300   Instrument Dependent Error - Execute
            the Read Error Queue function for 
            more information
     - D          Polarity                           -,          Source                            g -          Gate                              A  6         Count Cycles                      ݔ           Gate Mode                         ~             Instrument ID                               Error                             Positive 1 Negative 0               Internal 0 External 1 VXIbus Trg0 2 VXIbus Trg1 3 VXIbus Trg2 4 VXIbus Trg3 5 VXIbus Trg4 6 VXIbus Trg5 7 VXIbus Trg6 8 VXIbus Trg7 9 Chain 10 EChain 11    Enabled 1 Disabled 0    1   Synchronous 1 Asynchronous 0    1    	                Control Name:  Trigger Polarity

 Description:   This control selects either the
                positive or negative slope for
                advance triggering.

 Variable Type: Integer

 Valid Range:   0 - Negative Slope
                1 - Positive Slope (default)    
     Control Name:  Trigger Source

 Description:   This control selects the source of
                the start trigger.

 Variable Type: Integer

 Valid Range:   0 - Internal (default)
                1 - External
                2 - Chain
                3 - EChain          Control Name:  Gate State

 Description:   This control enables or disables
                gated trigger operation.

 Variable Type: Integer

 Valid Range:   0 - Disable (default)
                1 - Enable    K     Control Name:  Count

 Description:   This control specifies the number
                of times to cycle through a trace
                after a trigger signal is
                received.

 Variable Type: Long

 Valid Range:   1 to 1,048,575 (non-seq waveforms)
                1 to 524,288 (seq waveforms)

 Default Value: 1
          Control Name:  Gate Mode

 Description:   This control selects synchronous
                or asynchronous gate operation.

 Variable Type: Integer

 Valid Range:   0 - Asynchronous
                1 - Synchronous (default)    G     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                       this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.         Control Name:  Error

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range
       -2   Source out of range
       -3   Polarity out of range
       -4   Gate out of range
       -5   Count Cycles out of range
       -6   Gate Mode out of range

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response

      300   Instrument Dependent Error - Execute
            the Read Error Queue function for 
            more information
     - D          Polarity                          
 -          Source                             -          Gate                                         Count Cycles                      I 9          Gate Mode                         3             Instrument ID                               Error                             Positive 1 Negative 0               'Internal 0 External 1 Chain 2 EChain 3    Enabled 1 Disabled 0    1   Synchronous 1 Asynchronous 0    1    	           G     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                       this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.         Control Name:  Error

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response

      300   Instrument Dependent Error - Execute
            the Read Error Queue function for 
            more information
    5             Instrument ID                               Error                              1    	                 Control Name:  Period

 Description:   This control specifies the period
                of the internal trigger signal.

 Variable Type: Double

 Valid Range:   2E-7 to 1E4

 Default Value: 1E-3    G     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                       this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.         Control Name:  Error

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range
       -2   Period out of range

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response

      300   Instrument Dependent Error - Execute
            the Read Error Queue function for 
            more information
     =          Period                                         Instrument ID                               Error                              1E-3    1    	                 Control Name:  Trace Name

 Description:   This control specifies the trace
                for which the trigger and position
                markers will be set.

 Variable Type: String

 Default Value: "trace1"         Control Name:  Sync Marker

 Description:   This control enables or disables
                sync marker output for the
                instrument.

 Variable Type: Integer

 Valid Range:   0 = Disable
                1 = Enable

 Default Value: 0 - Disable         Control Name:  Sync Type

 Description:   Selects the type of sync marker to
                be output by the instrument.

 Variable Type: Integer

 Valid Range:   0 = BBits
                1 = ZCross
                (See descriptions below)

 Default Value: 1 - ZCross

 Sync Marker Descriptions:

    BBits - Marker signal is driven from a bit in
            Trace RAM.  The bit is set so the
            marker is active for the first several
            points of the trace.

    ZCross - Selects the output of a comparator.
             The comparator output is high if the
             output signal amplitude is above zero
             volts and low if the output signal
             amplitude is below zero volts.         Control Name:  Trigger Marker

 Description:   This control enables or disables
                the trigger marker for the
                specified trace.

 Variable Type: Integer

 Valid Range:   0 = Disable
                1 = Enable

 Default Value: 0 - Disable         Control Name:  Position Marker

 Description:   Determines if all marker points
                are to be turned off for the
                specified trace, or the points
                specified in Marker Point Array
                are to be turned on.

 Variable Type: Integer

 Valid Range:   0 = All Off
                1 = Use Array
                (See descriptions below)

 Default Value: 0 - All Off

 Position Marker Descriptions:

    All Off - turn all the marker points off for
              the specified trace

    Use Array - the marker points specified in
                Point Array will be turned on for
                the specified trace    #     Control Name:  # of Points

 Description:   Specifies the number of points to
                be turned on for the designated
                trace.  This value corresponds to
                the number of elements in Marker
                Point Array that will be turned
                on.

 Variable Type: Integer

 Valid Range:   Bounded by number of elements in
                Marker Point Array.

 Default Value: 1

 Note:  Specifying a value larger than the number
        of elements in Marker Point Array will
        cause an error.         Control Name:  Marker Point Array

 Description:   Array that defines the points
                which are to have markers set high
                for the specified waveform.  For
                example, if you have a waveform
                with 1000 points and want to turn
                on the marker for the first and
                last point, you would enter 2 into
                the # of Points control and define
                your array as follows:

                    Arr[0] = 1;
                    Arr[1] = 1000;

                    where Arr = array you create

 Variable Type: Integer Array

 Valid Range:   Valid values for each element of
                the array are bounded by the
                number of points in the specified
                waveform.    G     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                       this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.    !     Control Name:  Error

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range
       -3   Point Index parameter out of range

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response

      300   Instrument Dependent Error - Execute
            the Read Error Queue function for 
            more information
     - (         Trace Name                         -           Sync Marker                        -2          Sync Type                         -          Trigger Marker                     Y          Position Marker                  c            # of Points                                Marker Point Array               
             Instrument ID                              Error                              	"trace1"    Enable 1 Disable 0   ZCross 1 BBits 0    Enable 1 Disable 0    Use Array 1 All Off 0    1        1    	                 Control Name:  Offset Voltage

 Description:   This control specifies the DC
                offset voltage generated at the
                main output.

 Variable Type: Double

 Valid Range:   -7.5 to 7.5

 Default Value:  0.0    G     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                       this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.         Control Name:  Error

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range
       -2   Offset Voltage out of range

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response

      300   Instrument Dependent Error - Execute
            the Read Error Queue function for 
            more information
    =          Offset Voltage                   o             Instrument ID                              Error                              0.0    1    	                 Control Name:  Maximum Amplitude

 Description:   This control specifies the maximum
                amplitude for optimum scaling.

 Variable Type: Double

 Valid Range:   0 to 7.5

 Default Value: 1.0    G     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                       this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.         Control Name:  Error

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range
       -2   Maximum Amplitude out of range

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response

      300   Instrument Dependent Error - Execute
            the Read Error Queue function for 
            more information
    =          Maximum Amplitude                l             Instrument ID                              Error                              1.0    1    	                 Control Name:  Lock

 Description:   This control locks phase with
                another Wavetek 1395 on the
                VXIbus.

 Variable Type: Integer

 Valid Range:   0 - Phase Lock Off (default)
                1 - Phase Lock On    G     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                       this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.         Control Name:  Error

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range
       -2   Lock out of range

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response

      300   Instrument Dependent Error - Execute
            the Read Error Queue function for 
            more information
    =	          Lock                                          Instrument ID                               Error                              On 1 Off 0    1    	                 Control Name:  Phase Value

 Description:   This control specifies the phase
                delay for the output waveform in
                degrees.

 Variable Type: Integer

 Valid Range:   -180 to 180

 Default Value:  0    G     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                       this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.         Control Name:  Error

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range
       -2   Phase Value out of range

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response

      300   Instrument Dependent Error - Execute
            the Read Error Queue function for 
            more information
   # =           Phase Value                      $             Instrument ID                    &          Error                              0    1    	                 Control Name:  Output State

 Description:   This control enables/disables the
                MAIN OUT BNC.

 Variable Type: Integer

 Valid Range:   0 - Disable
                1 - Enable (default)    G     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                       this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.         Control Name:  Error

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range
       -2   Output State out of range

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response

      300   Instrument Dependent Error - Execute
            the Read Error Queue function for 
            more information
   ) =           Output State                     *             Instrument ID                    ,          Error                             Enable 1 Disable 0    1    	           &     Control Name:  Filter State

 Description:   This control enables/disables the
                20 MHz filter between output of
                the waveform DAC and the
                pre-amplifier.

 Variable Type: Integer

 Valid Range:   0 - Disabled
                1 - Enabled (default)         Control Name:  Filter Type

 Description:   This control selects the type of
                filter enabled between the
                waveform DAC and the
                pre-amplifier (in the output
                section.)

 Variable Type: Integer

 Valid Range:   0 - 7 pole, 6 zero Elliptic Filter
                    for flattest response with
                    constant group delay.(default)

                1 - 4 pole Bessel Filter for
                    steepest response.    G     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                       this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.    6     Control Name:  Error

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range
       -2   Filter State out of range
       -3   Type out of range

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response

      300   Instrument Dependent Error - Execute
            the Read Error Queue function for 
            more information
   / =           Filter State                     0 =2          Type                             2             Instrument ID                    5:          Error                             Enabled 1 Disabled 0    Bessel 1 Elliptic 0    1    	                 Control Name:  Sumbus Out State

 Description:   This control enables/disables
                the analog sumbus output.

 Variable Type: Integer

 Valid Range:   0 - Disabled (default)
                1 - Enabled    G     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                       this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.         Control Name:  Error

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range
       -2   Sumbus-Out out of range

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response

      300   Instrument Dependent Error - Execute
            the Read Error Queue function for 
            more information
   8 =           Sumbus Out                       9l             Instrument ID                    ;          Error                              Enable 1 Disable 0    1    	                Control Name:  Trigger Type

 Description:   This control selects either the
                ECL or TTL trigger lines on the
                VXIbus for targets.

 Variable Type: Integer

 Valid Range:   0 - TTL Lines  (default)
                1 - ECL Lines
         Control Name:  Trigger Line Number

 Description:   This control specifies the trigger
                line number for either ECL or TTL
                triggering.

 Variable Type: Integer

 Valid Range:   0 - Line 0  (ECL or TTL)
                1 - Line 1  (ECL or TTL)
                2 - Line 2  (TTL only)
                3 - Line 3  (TTL only)
                4 - Line 4  (TTL only)
                5 - Line 5  (TTL only)
                6 - Line 6  (TTL only)
                7 - Line 7  (TTL only)         Control Name:  Qualifier

 Description:   This control selects the source of
                the trigger qualifier marker. The
                trigger qualifier marker is used
                to condition the selected trigger
                to be output by the module.

 Variable Type: Integer

 Valid Range:   0 - Trigger Marker Bit
                1 - Position Marker Bit
                2 - Burst Complete
                3 - Loop Complete
                4 - Internal         Control Name:  Line State

 Description:   This control enables/disables the
                output trigger line selected by
                the Trigger Line Number control.

 Variable Type: Integer

 Valid Range:   0 - Line disabled (default)
                1 - Line enabled
    G     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                       this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.         Control Name:  Error

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range
       -2   Type out of range
       -3   Trigger Line Number out of range
       -4   Qualifier out of range
       -5   Line State out of range

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response

      300   Instrument Dependent Error - Execute
            the Read Error Queue function for 
            more information
   > - \          Type                             ? -          Trigger Line Number              A -          Qualifier                        C  W          Line State                       D             Instrument ID                    G          Error                              ECL 1 TTL 0                0 0 1 1 2 2 3 3 4 4 5 5 6 6 7 7               ?Trig Marker 0 Pos Marker 1 Burst Comp 2 Loop Comp 3 Internal 4   Enabled 1 Disabled 0    1    	                 Control Name:  Configuration

 Description:   Specifies if the CLK IN/OUT BNC is
                to be used for input or output.

 Variable Type: Integer

 Valid Range:   0 = Output
                1 = Input (Default)
         Control Name:  Output Mode

 Description:   Selects the output mode for the
                CLK IN/OUT BNC when the clock
                configuration is set for output.
                User Frequency mode disables all
                other output modes and sources a
                clock signal at the specified
                frequency. Raster and synthesizer
                modes do not disable other output
                sources and use the raster and
                synthesizer frequencies,
                respectively, as source
                frequencies.

 Variable Type: Integer

 Valid Range:   0 - User Frequency (default)
                1 - Raster
                2 - Synthesizer    C     Control Name:  User Frequency

 Description:   Specifies the frequency of the
                output clock when the clock
                configuration is set for output
                and the clock mode is set to User
                Frequency.

 Variable Type: Double

 Valid Range:   1E-1 to 1E8

 Default Value: 1E3    G     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                       this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.    f     Control Name:  Error

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range
       -2   Configuration out of range
       -3   Output Mode out of range
       -4   User Frequency out of range

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response

      300   Instrument Dependent Error - Execute
            the Read Error Queue function for 
            more information
   K = K          Configuration                    Lg =$          Output Mode                      O/ =         User Frequency                   Pz             Instrument ID                    R          Error                             Input 1 Output 0               #User Freq 0 Raster 1 Synthesizer 2    1e3    1    	                 Control Name:  Sumbus Input

 Description:   This control enables/disables the
                sumbus inputs on the backplane.

 Variable Type: Integer

 Valid Range:   0 - disable (default)
                1 - enable
    x     Control Name:  Attenuation

 Description:   This control selects an
                attenuation factor for the sumbus
                inputs.

 Variable Type: Integer

 Valid Range:   0 - 0 dB
                1 - 6 dB
                2 - 12 dB
                3 - 18 dB
                4 - 24 dB
                5 - 30 dB
                6 - 36 dB
                7 - 42 dB    G     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                       this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.    B     Control Name:  Error

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range
       -2   Sumbus Input out of range
       -3   Attenuation (dB) out of range

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response

      300   Instrument Dependent Error - Execute
            the Read Error Queue function for 
            more information
   V =           Sumbus Input                     W =~          Attenuation (dB)                 Y             Instrument ID                    [R          Error                              Enable 1 Disable 0               30 0 -6 6 -12 12 -18 18 -24 24 -30 30 -36 36 -42 42    1    	                 Control Name:  Modulation State

 Description:   This control enables/disables the
                modulation input.

 Variable Type: Integer

 Valid Range:   0 - disable (default)
                1 - enable    }     Control Name:  Modulation Mode

 Description:   This control selects the type of
                modulation, either the standard
                0 to 100% amplitude modulation
                or double-sideband suppressed
                carrier modulation.

 Variable Type: Integer

 Valid Range:   0 - Suppressed carrier mode
                1 - Amplitude Modulation (default)    G     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                       this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.    E     Control Name:  Error

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range
       -2   Modulation State out of range
       -3   Modulation Mode out of range

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response

      300   Instrument Dependent Error - Execute
            the Read Error Queue function for 
            more information
   ^ =           Modulation State                 _ =?          Modulation Mode                  a8             Instrument ID                    c          Error                              Enable 1 Disable 0   Amplitude 1 Supp Carrier 0    1    	                Control Name:  Source

 Description:   This control selects a source for
                the reference oscillator.

 Variable Type: Integer

 Valid Range:   0 - Internal (default)
                1 - External (TRIG IN BNC)
                2 - ECL Trig 0
                3 - ECL Trig 1    G     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                       this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.         Control Name:  Error

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range
       -2   Source out of range

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response

      300   Instrument Dependent Error - Execute
            the Read Error Queue function for 
            more information
   f -          Source                           h             Instrument ID                    jc          Error                                         0Internal 0 External 1 ECL Trig 0 2 ECL Trig 1 3    1    	           Y     Control Name:  Playback Mode

 Description:   Specifies the trace playback mode
                for the instrument.

 Variable Type: Integer

 Valid Range:   0 - Raster
                1 - Continuous Wave (default)
                    (See descriptions below)

 Playback Mode Descriptions:

    Continuous Wave:  a fixed 50 MHz scan rate is
                      used and phase accumulation
                      is used for frequency
                      control; useful primarily
                      for playing back standard
                      functions like sinusoid,
                      triangle, and square

    Raster:  scan rate can be adjusted by the
             selected reference oscillator; used
             to play back arbitrary waveforms
             which typically define a complex
             pattern of amplitude versus time    G     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                       this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.         Control Name:  Error

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range
       -2   Playback Mode out of range

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response

      300   Instrument Dependent Error - Execute
            the Read Error Queue function for 
            more information
   ml =           Playback Mode                    p             Instrument ID                    s          Error                             CW 1 Raster 0    1    	                 Control Name:  Trace Name

 Description:   This control specifies the name of
                the trace to be created.

 Variable Type: String

         Control Name:  Point Count

 Description:   This control specifies the number
                of data points to be allocated for
                the new trace in trace memory.

 Variable Type: Integer

 Valid Range:   0 to 32767

 Default:       4096

 NOTE:  While a single trace may have up to 32767
        points, it is recommended to use traces of
        only 4096 to maintain compatibility with
        other source modes.    G     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                       this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.         Control Name:  Error

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range
       -3   Point Count out of range

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response

      300   Instrument Dependent Error - Execute
            the Read Error Queue function for 
            more information
   u =          New Trace Name                   v =N          Point Count                      xQ             Instrument ID                    z          Error                              	"trace1"    4096    1    	                 Control Name:  Source Trace Name

 Description:   This control specifies the name of
                the standard or user-defined
                trace to be copied.

 Variable Type: String

          Control Name:  Target Trace Name

 Description:   This control specifies the name of
                the trace to which the source is
                copied.

 Variable Type: String

    G     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                       this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.         Control Name:  Error

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response

      300   Instrument Dependent Error - Execute
            the Read Error Queue function for 
            more information
   } =          Source                           ~ =N         Target Trace                     D             Instrument ID                              Error                              	"trace1"    	"trace2"    1    	           :     Control Name:  Function

 Description:   This control selects either to
                delete all traces or a single
                trace. Trace name is disregarded
                if Delete All is selected.

 Variable Type: Integer

 Valid Range:   0 - Single Trace (default)
                1 - All Traces

          Control Name:  Trace Name

 Description:   This control specifies the name of
                the trace to be deleted.

 Variable Type: String

    G     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                       this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.         Control Name:  Error

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range
       -2   Function out of range

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response

      300   Instrument Dependent Error - Execute
            the Read Error Queue function for 
            more information
    =           Function                          =N         Trace Name                       g             Instrument ID                              Error                              All Traces 1 Single Trace 0    	"trace1"    1    	                Control Name:  Function

 Description:   This control selects the output of
                the Directory function as either
                the names of the traces in trace
                memory; or the names, sizes, and
                start and stop frequencies.

 Variable Type: Integer

 Valid Range:   0 - Names only (default)
                1 - All Info (names, sizes, start
                             and stop frequencies)    
     Control Name:  Directory

 Description:   This control stores a string
                containing the names, sizes, and
                limits of all defined traces in
                the format

                <name1, size1, start1, stop1;
                name2, size2, start2, stop2 ...
                stopn>

                If the function is set to Names
                Only, then the format of the
                output string is as follows

                <name1, name2, name3,...namen>

 Variable Type: String    G     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                       this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.    9     Control Name:  Error

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range
       -2   Function out of range

      226   Error polling instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response

      300   Instrument Dependent Error - Execute
            the Read Error Queue function for 
            more information
    =           Function                          =N         Directory                                     Instrument ID                              Error                              Names Only 1 All Info 0    	            1    	                 Control Name:  Points Available

 Description:   Returns the number of points
                available in the instrument's
                memory.

 Variable Type: Long          Control Name:  Points In Use

 Description:   Returns the number of points
                already used in the instrument's
                memory.

 Variable Type: Long    G     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                       this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.         Control Name:  Error

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range

      226   Error polling instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response

      300   Instrument Dependent Error - Execute
            the Read Error Queue function for 
            more information
   P =          Points Available                  =N         Points In Use                                 Instrument ID                              Error                              	            	            1    	                 Control Name:  Trace Name

 Description:   The name of the trace in trace
                memory to be written.

 Variable Type: String

 Default Value: "trace1"          Control Name:  File Name

 Description:   The name of the file into which
                the trace is written.

 Variable Type: String

 Default Value: "trace1"    G     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                       this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.    I     Control Name:  Error

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range

      226   Error polling instrument
      229   Error reading from instrument to file
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response

      300   Instrument Dependent Error - Execute
            the Read Error Queue function for 
            more information
   # =          Trace Name                        =N         File Name                        {             Instrument ID                              Error                              	"trace1"    	"trace1"    1    	                 Control Name:  File Name

 Description:   The name of the file into which
                the trace is written.

 Variable Type: String

 Default Value: "trace1"          Control Name:  Trace Name

 Description:   The name of the trace in trace
                memory to be written.

 Variable Type: String

 Default Value: "trace1"    G     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                       this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.         Control Name:  Error

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range

      226   Error polling instrument
      228   Error writing to instrument from file
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response

      300   Instrument Dependent Error - Execute
            the Read Error Queue function for 
            more information
      305   No room in trace memory
      320   Error reading file from disk
    =          File Name                         =N         Trace Name                       p             Instrument ID                              Error                              	"trace1"    	"trace1"    1    	                 Control Name:  File Name

 Description:   The name of the file into which
                the trace is written.

 Variable Type: String

 Default Value: "trace1"    G     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                       this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.         Control Name:  Error

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range

      101   Device not found
      102   File not present in specified path
      103   Error opening specified file
      105   Function not valid for GPIB Interface

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      235   Error writing to A24 Address Space
      236   Error interpreting instrument response

      300   Instrument Dependent Error - Execute
            the Read Error Queue function for 
            more information
   Z =          File Name                                     Instrument ID                    U          Error                              	"trace1"    1    	                 Control Name:  Trace Name

 Description:   The name of the trace into which
                the data is written.

 Variable Type: String

 Default Value: "trace1"          Control Name:  Existing Trace?

 Description:   Specifies whether the trace to be
                written exists in trace memory or
                must be created.

 Variable Type: Integer

 Valid Range:   0 = No (default)
                1 = Yes          Control Name:  Trace Size

 Description:   Specifies the number of points to
                be written to the trace.

 Variable Type: Integer

 Valid Range:   1 to 32767

 Default Value: 4096
    G     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                       this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.    >     Control Name:  Error

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range
       -3   Existing Trace out of range
       -4   Trace Size out of range

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response

      300   Instrument Dependent Error - Execute
            the Read Error Queue function for 
            more information
    = Y         Trace Name                        =          Existing Trace?                   =          Trace Size                       ]             Instrument ID                              Error                              	"trace1"    Yes 1 No 0    4096    1    	                Control Name:  Point 1 Index

 Description:   This control specifies the index
                of the beginning point of the line
                to be drawn.

 Variable Type: Integer

 Valid Range:   0 to 32,767 (4095)

 NOTES: The maximum size of a waveform is
        (32,767 - Available Memory (Points In
        Use)).

        Waveforms should be limited to 4095 data
        points to maintain compatibility with
        all output modes.         Control Name:  Point 1 Value

 Description:   This control specifies the voltage
                value of the first point of the
                line to be drawn.

 Variable Type: Integer

 Valid Range:   0 to 4095

 NOTE:  If the Set Maximum Amplitude function is
        performed, then the maximum amplitude is
        scaled to the value 4095 and the negative
        maximum amplitude is scaled to 0.          Control Name:  Trace Name

 Description:   This control specifies the name of
                the trace in which the line is
                drawn.

 Variable Type: String

         Control Name:  Point 2 Index

 Description:   This control specifies the index
                of the ending point of the line
                to be drawn.

 Variable Type: Integer

 Valid Range:   0 to 32,767 (4095)

 NOTES: The maximum size of a waveform is
        (32,767 - Available Memory (Points In
        Use)).

        Waveforms should be limited to 4095 data
        points to maintain compatibility with
        all output modes.         Control Name:  Point 2 Value

 Description:   This control specifies the voltage
                value of the second point of the
                line to be drawn.

 Variable Type: Integer

 Valid Range:   0 to 4095

 NOTE:  If the Set Maximum Amplitude function is
        performed, then the maximum amplitude is
        scaled to the value 4095 and the negative
        maximum amplitude is scaled to 0.    G     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                       this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.         Control Name:  Error

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range
       -3   Point 1 Index out of range
       -4   Point 1 Value out of range
       -5   Point 2 Index out of range
       -6   Point 2 Value out of range

      226   Error polling instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response

      300   Instrument Dependent Error - Execute
            the Read Error Queue function for 
            more information
   . =           Point 1 Index                     =x          Point 1 Value                     ] (         Trace Name                       N            Point 2 Index                     x          Point 2 Value                                 Instrument ID                              Error                              0    0    	"trace1"    0    0    1    	                 Control Name:  Trace Name

 Description:   This control specifies the name of
                the trace in which the points will
                be defined.

 Variable Type: String

 Default Value: "trace1"    S     Control Name:  # of Points

 Description:   Specifies the number of points
                that will be defined for the given
                trace (i.e. the number of elements
                in Point Array)

 Variable Type: Integer

 Valid Range:   0 to 32,767 (4096)
                (this value is bounded by the
                number of elements in Point Array)

 NOTES: The maximum size of a waveform is
        (32,767 - Available Memory (Points In
        Use)).

        Waveforms should be limited to 4096 data
        points to maintain compatibility with
        all output modes.          Control Name:  Point Array

 Description:   This control specifies the new
                voltage value of the point to be
                changed.

 Variable Type: Short Array

 Valid Range:   Each element of the array is
                bounded by the following criteria:

                  If the Set Maximum Amplitude
                  function is performed, then the
                  maximum amplitude is scaled to
                  the value 4095 and the negative
                  maximum amplitude is scaled
                  to 0.    G     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                       this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.         Control Name:  Error

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response

      300   Instrument Dependent Error - Execute
            the Read Error Queue function for 
            more information
   b = `         Trace Name                       ; =           # of Points                      ʖ =  
       Point Array                      ̾             Instrument ID                    
          Error                              	"trace1"    0    0    1    	                Control Name:  Point Index

 Description:   This control specifies the index
                of the point to be changed.

 Variable Type: Integer

 Valid Range:   0 to 32,767 (4095)

 NOTES: The maximum size of a waveform is
        (32,767 - Available Memory (Points In
        Use)).

        Waveforms should be limited to 4095 data
        points to maintain compatibility with
        all output modes.          Control Name:  Trace Name

 Description:   This control specifies the name of
                the trace in which the point is to
                be changed.

 Variable Type: String

         Control Name:  Point Value

 Description:   This control specifies the new
                voltage value of the point to be
                changed.

 Variable Type: Integer

 Valid Range:   0 to 4095

 NOTE:  If the Set Maximum Amplitude function is
        performed, then the maximum amplitude is
        scaled to the value 4095 and the negative
        maximum amplitude is scaled to 0.    G     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                       this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.    a     Control Name:  Error

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range
       -3   Point Index out of range
       -4   Point Value out of range

      226   Error polling instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response

      300   Instrument Dependent Error - Execute
            the Read Error Queue function for 
            more information
   7 =2          Point Index                       ] n         Trace Name                       Ԛ 2          Point Value                      ,             Instrument ID                    {          Error                              0    	"trace1"    0    1    	                 Control Name:  Trace Name

 Description:   This control specifies the name of
                the trace to be re-scaled.

 Variable Type: String

         Control Name:  New Size

 Description:   This control specifies the number
                of points in the re-scaled trace.

 Variable Type: 0 to 32,767 (4095)

 NOTES: The maximum size of a waveform is
        (32,767 - Available Memory (Points In
        Use)).

        Waveforms should be limited to 4095 data
        points to maintain compatibility with
        all output modes.
    G     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                       this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.         Control Name:  Error

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range
       -3   New Size parameter out of range

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response

      300   Instrument Dependent Error - Execute
            the Read Error Queue function for 
            more information
    =          Trace Name                       ܱ =G          New Size                         ?             Instrument ID                              Error                              	"trace1"    4096    1    	                 Control Name:  Trace Name

 Description:   This control specifies the trace
                name from which limits are
                returned.

 Variable Type: String

          Control Name:  Start

 Description:   Returns the starting playback
                limit of the specified trace.

 Variable Type: Integer          Control Name:  Stop

 Description:   Returns the stopping playback
                limit of the specified trace.

 Variable Type: Integer    G     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                       this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.         Control Name:  Error

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range

      226   Error polling instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response

      300   Instrument Dependent Error - Execute
            the Read Error Queue function for 
            more information
    = R         Trace Name                       b =           Start                             =          Stop                                          Instrument ID                              Error                              	"trace1"    	            	            1    	                 Control Name:  Trace Name

 Description:   This control specifies the name of
                the trace in which the point is
                found.

 Variable Type: String

         Control Name:  Point Index

 Description:   This control selects the point
                index of the specified trace.

 Variable Type: Integer

 Valid Range:   0 to 32,767 (4095)

 NOTES: The maximum size of a waveform is
        (32,767 - Available Memory (Points In
        Use)).

        Waveforms should be limited to 4095 data
        points to maintain compatibility with
        all output modes.

          Control Name:  Point Value

 Description:   This control stores the point
                (voltage) value from the specified
                trace.

 Variable Type: Integer

 Valid Range:   0 to 4095    G     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                       this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.    <     Control Name:  Error

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range
       -3   Point Index out of range

      226   Error polling instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response

      300   Instrument Dependent Error - Execute
            the Read Error Queue function for 
            more information
   7 = D         Trace Name                        =           Point Index                       =q          Point Value                      f             Instrument ID                              Error                              	"trace1"    0    	            1    	                 Control Name:  Trace Name

 Description:   This control specifies the name of
                the trace for which the size is
                found.

 Variable Type: String

    6     Control Name:  Trace Size

 Description:   This control returns the size
                of the specified trace. If trace
                limits have been set, then the
                number of points between the
                limits will be returned.

 Variable Type: Integer

 Valid Range:   0 to 32767    G     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                       this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.         Control Name:  Error

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range

      226   Error polling instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response

      300   Instrument Dependent Error - Execute
            the Read Error Queue function for 
            more information
   0 = |         Trace Name                        =+          Trace Size                       '             Instrument ID                    v          Error                              	"trace1"    	            1    	                 Control Name:  Sequence Length

 Description:   Sets the number of traces in the
                sequence table.

 Variable Type: Integer

 Valid Range:   2 to 4         Control Name:  Trigger Sense

 Description:   This control selects the
                active portion of the advance
                trigger signal. Edge selects the
                rising edge of the trigger signal
                to initiate an advance. Level
                selects the trigger signal level
                to initiate an advance.

                When the current function element
                is configured for Triggered
                Advance and an advance is
                generated, the next function in
                the sequence list is output.

 Variable Type: Integer

 Valid Range:   0 - Level
                1 - Edge  (default)
    L     Control Name:  Trigger Mode

 Description:   Defines the transition mode
                between the current function and
                the next function in the
                sequence table.  Synchronous mode
                waits until the end of the current
                function before moving to the
                next. Asynchronous mode selects
                the next function immediately,
                even if the current function is
                not completed.

 Variable Type: Integer

 Valid Range:   0 - Asynchronous
                1 - Synchronous  (default)    G     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                       this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.    h     Control Name:  Error

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range
       -2   Sequence length out of range
       -3   Trigger sense out of range
       -4   Trigger mode out of range

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response

      300   Instrument Dependent Error - Execute
            the Read Error Queue function for 
            more information
    = 6          Sequence Length                  > =           Trigger Sense                     =j          Trigger Mode                     :             Instrument ID                              Error                              2   Edge 1 Level 0   Synchronous 1 Asynchronous 0    1    	           A     Control Name:  Sequence Index

 Description:   This control specifies the index
                number of the sequence table
                element to be added. Do not skip
                an index number when creating a
                sequence table.

 Variable Type: Integer

 Valid Range:   0 - First element in sequence
                    table.
                1 - Second element in sequence
                    table.
                2 - Third element in sequence
                    table.
                3 - Fourth element in sequence
                    table.
         Control Name:  Trace Name

 Description:   This control specifies the name
                of a trace in instrument trace
                memory or a standard waveform from
                the list of onboard waveforms
                (1 cycle, 4 KBytes each.) This
                waveform will be ordered by
                the sequence index number assigned
                by Sequence Index.

 Variable Type: String

 NOTE:  Sweep mode is compatible with sequence
        mode only when the waveforms selected by
        trace name are standard waveforms, or are
        user-defined functions of length 4 KBytes
        (4096 Bytes.)

    F     Control Name:  Dwell

 Description:   This control sets the number of
                times to cycle through this
                function in the sequence table. A
                zero will cause the function to be
                repeated indefinitely.

 Variable Type: Long

 Valid Range:   0 to 65535

 Default:       1
         Control Name:  Advance Mode

 Description:   This control selects the
                conditions under which the
                sequence advances to the next
                function in the sequence table.
                Automatic advances immediately
                after the current index number is
                called, triggered mode requires an
                Advance Trigger to proceed to the
                next function in the sequence
                table.

                The advance trigger is configured
                in the Define Sequence function.

 Variable Type: Integer

 Valid Range:   0 - Triggered
                1 - Automatic (default)    G     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                       this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.    o     Control Name:  Error

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range
       -2   Index parameter out of range
       -4   Dwell parameter out of range
       -5   Advance parameter out of range

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response

      300   Instrument Dependent Error - Execute
            the Read Error Queue function for 
            more information
   J = u          Sequence Index                   	 =2         Trace Name                         u         Dwell                            
l ?          Advance                                       Instrument ID                    c          Error                              0    	"trace1"    1   Auto 1 Triggered 0    1    	                Control Name:  Instrument Error Code

 Description:   This output returns the error code
                read from the instrument error
                queue.

                To convert  this value to a
                Wavetek Error code, subtract 200
                and then multiply it by -1.
                Then look in appendix D of the
                Wavetek 1395 Operator's Manual.

 Variable Type: Integer    G     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                       this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.         Control Name:  Error

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response

      300   Instrument Dependent Error - Execute
            the Read Error Queue function for 
            more information
   U =           Instr. Error Code                              Instrument ID                    O          Error                              	            1    	           _     Control Name:  Function

 Description:   Chooses either a non-destructive
                hardware systems test, or a
                destructive trace memory(RAM) test

 Variable Type: Integer

 Valid Range:   0 -  RAM Test
                1 -  System  (default)

 NOTE: All contents of trace memory will be erased
       if RAM test is performed.         Control Name:  Self-Test Result

 Description:   Displays the bit-weighted error
                code from the instrument hardware
                test in hexadecimal format. A
                zero indicates that no error
                occurred. Error codes can be found
                in the instrument operation
                manual.

 Variable Type: Integer

 Valid Range:   -32768 to 32767
    G     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                       this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.    C     Control Name:  Error

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range
       -2   Function parameter out of range

      226   Error polling instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response

      300   Instrument Dependent Error - Execute
            the Read Error Queue function for 
            more information
    =           Function                         l =7          Test Result                                    Instrument ID                    "U          Error                              RAM Test 1 System 0    	           1    	                Control Name:  Calibration Result

 Description:   Displays the bit-weighted error
                code from the instrument hardware
                calibration in hexadecimal format.
                A zero indicates that no
                calibration errors occurred. Error
                codes are listed in the instrument
                operation manual.

 Variable Type: Integer

 Valid Range:   -32767 to 32768    G     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                       this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.         Control Name:  Error

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range

      226   Error polling instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response

      300   Instrument Dependent Error - Execute
            the Read Error Queue function for 
            more information
   % =           Calibration Result               'U             Instrument ID                    )          Error                              	            1    	           G     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                       this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.         Control Name:  Error

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response

      300   Instrument Dependent Error - Execute
            the Read Error Queue function for 
            more information
   ,             Instrument ID                    .          Error                              1    	           R     Control Name:  Write Buffer

 Description:   The user can use this control to
                send common commands and queries
                to the instrument. This control
                can also be used to write any
                valid command to the instrument.

 Variable Type: String

 Default Value: "*RST"

 NOTES: (1) The command or query to be sent to the
            instrument may be a literal enclosed
            in double quotes i.e. "*RST" or may be
            contained in a variable of type
            string.

        (2) If the number of bytes to be written
            is greater than the size of "cmd" in
            the source code then the size of cmd
            must be increased. The original size
            of cmd is 50 bytes (cmd[50]) the
            largest cmd may be declared as is
            32,767 bytes.    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.         Control Name:  Error Code

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Error Codes:

        0   Success

       -1   Instrument ID out of range

      230   Error writing to instrument
      232   Instrument not initialized   1C =          Write Buffer                     4             Instrument ID                    6          Error Code                         "*RST"    1    	                Control Name:  Number of Bytes to Read

 Description:   The number of bytes specified by
                this control should be greater
                than or equal to the number of
                bytes which are to be read from
                the instrument. If the actual
                number of bytes to be read is
                greater than the number this
                control specifies then multiple
                reads will be necessary to empty
                the instrument's output buffer.

                If the instrument's output buffer
                is not emptied the instrument may
                return invalid data when future
                reads are performed.

 Variable Type: Integer

 Default Value: 50 (See NOTE 2)

 NOTES: (1) If NO DATA is available at the
            instrument's output buffer when this
            function is called the instrument will
            hang up and the function will not
            return until it times out.  If the
            time-out is disabled, this function
            will hang indefinitely and it may be
            necessary to reboot the computer.

        (2) If the number of bytes expected is
            greater than 50 the value of this
            control may be increased. If the
            actual number of bytes read is larger
            than the declared size of the read
            buffer a run-time error will be
            generated.         Control Name:  Read Buffer

 Description:   The incoming data from the
                instrument is placed into this
                variable.

 Variable Type: String

 NOTES: (1) Because the Instrument may return both
            numeric and text data in response to
            queries this function returns the data
            in string form.

        (2) This function does not overwrite any
            old data left in the string variable
            from the last time the function was
            called. String data in LabWindows is
            terminated with an ASCII null(Hex 0)
            and string manipulation functions will
            only recognize data before the ASCII
            null.

        (3) The declared size of the string
            variable must be greater than the
            actual number of bytes read from the
            instrument if it is not a run-time
            error will be generated.         Control Name:  Number of Bytes Read

 Description:   This variable contains the actual
                number of bytes read from the
                instrument. This is the value
                which is returned by the read
                function. The global variable
                "ibcnt" holds the result of GPIB
                reads and the global variable
                "bytes" holds the result of VXI
                word serial reads.

 Variable Type: Long

 NOTE: If the actual number of bytes read is less
       than the number of bytes specified in
       number of bytes to read then the output
       buffer is probably empty. If the number of
       bytes read is 0 and the instrument returns
       a 231 error code the read function failed.
       The most probable cause for the read to
       fail is because there was no data available
       at the instrument's output buffer.    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.         Control Name:  Error Code

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Error Codes:

        0   Success

       -1   Instrument ID out of range

      231   Error reading from instrument
      232   Instrument not initialized   8 = K          Number Bytes To Read             > =          Read Buffer                      B7 =x         NumBytes Read                    E             Instrument ID                    H)          Error Code                         50    	            	            1    	           G     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                       this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.    
     Control Name:  Error

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range

      221   Unable to close device
      232   Device not initialized   J             Instrument ID                    L          Error                              1    	                         K.    init                              [              K.    cw                                              K.    raster                                      	    K.    sweep                                           K.    list                                            K.    stand                                      6     K.    trac                                        ;     K.    getdat                            #              K.    sequence                          '         )     K.    trigen                            (         p     K.    starttrig                         +         %     K.    adtrig                            /          ~     K.    softtrig                          0         0     K.    settrig                           1        $ 	    K.    markers                           3             K.    offset                            4             K.    ampl                              8        "     K.    lock                              9        )     K.    adjust                            <        /     K.    outen                             =        7x     K.    filter                            ?	        =     K.    sumout                            ?        I     K.    outtrig                           A        U7     K.    clock                             C        ]     K.    sumin                             D        e     K.    mod                               F        l}     K.    refosc                            F        u=     K.    trace_mode                        MJ        |     K.    create                            N%             K.    copy                              O,             K.    delete                            O        D     K.    tradir                            P        &     K.    free                              T4             K.    writefile                         T        ]     K.    file_to_trace                     W0        &     K.    writeA24                          Y5             K.    writetrace                        ]        ž     K.    line                              _             K.    define_pts                        _             K.    point                             `             K.    rescale                           b             K.    getlim                            cu             K.    getpoint                          dJ             K.    getsize                           g             K.    defseq                            i             K.    linkseq                           lS        I     K.    inst_err                          m
        $     K.    test                              o        +     K.    cal                               s        0     K.    reset                             th        8"     K.    write                             u$        IP     K.    read                              x*        M     K.    close                                                                       DInitialize                          GConfigure                           XFrequency                            DContinuous                           DRaster                               DSweep                                DList                                 Waveform Type                        DStandard                             DTrace                                DGet Trace from A24 Mem               DSequence                            %Trigger                              DTrigger Enable                       DStart Trigger                        DAdvance Trigger                      DSoftware Trigger                     DSet Internal Trig. Rate              DMarkers                             2SVoltage                              DSet DC Offset                        DSet Maximum Amplitude               7IPhase                                DLock                                 DAdjust                              :_Output                               DEnable Main                          DFilter                               DSumbus Out                           DOutput Trigger                       DClock                                DSumbus Input                         DModulation                           DReference Oscillator                 DTrace Playback Mode                 GAArbitrary Waveform                  IhTrace                                DCreate                               DCopy                                 DDelete                               DList Directory                       DAvailable Trace Memory              QpFile/Memory Transfer                 DWrite Trace to File                  DWrite File to Trace Mem              DWrite File to A24 Memory             DWrite A24 to Trace Mem              ZEdit                                 DDraw Line                            DDefine Points                        DChange Point                         DRe-Scale                             DGet Limits                           DGet Point Value                      DGet Trace Size                      eSequence                             DDefine Sequence                      DAdd Sequence Element                jdAccessories                          DRead Error Queue                     DTest                                 DCalibrate                           qLow Level Functions                  DReset                                DWrite To Instrument                  DRead Instrument Data                 DClose                           