#ifndef __wtk1395_HEADER
#define __wtk1395_HEADER

#if defined(__cplusplus) || defined(__cplusplus__)
extern "C" {
#endif

/*= Wavetech 1395 Include File ============================================*/


/*= GLOBAL CONSTANT DECLARATIONS ==========================================*/

/* Replace 10 with the maximum number of devices of this type being used.  */
#define wtk1395_MAX_INSTR        10
#define NI_VXI                   1
#define NI_GPIB                  2

/*= GLOBAL FUNCTION DECLARATIONS ==========================================*/
int wtk1395_init (int logicalAddress, int selectInterface, int IDQuery,
                  int resetDevice, int *instrumentID);
int wtk1395_cw (int instrumentID, double frequency);
int wtk1395_raster (int instrumentID, double scanRate);
int wtk1395_sweep (int instrumentID, double count, int direction, int mode,
                   double sweepTime, int spacing, double startFrequency,
                   double stopFrequency);
int wtk1395_list (int instrumentID, double frequencyList[], int listLength);
int wtk1395_stand (int instrumentID, int waveformType);
int wtk1395_trac (int instrumentID, char traceName[]);
int wtk1395_getdat (int instrumentID);
int wtk1395_sequence (int instrumentID);
int wtk1395_trigen (int instrumentID, int triggerMode);
int wtk1395_starttrig (int instrumentID, int source, int polarity, int gate,
                       long countCycles, int gateMode);
int wtk1395_adtrig (int instrumentID, int source, int polarity, int gate,
                    long countCycles, int gateMode);
int wtk1395_softtrig (int instrumentID);
int wtk1395_settrig (int instrumentID, double period);
int wtk1395_markers (int instrumentID, char traceName[], int syncMarker,
                     int syncType, int triggerMarker, int positionMarker,
                     int ofPoints, int markerPointArray[]);
int wtk1395_offset (int instrumentID, double offsetVoltage);
int wtk1395_ampl (int instrumentID, double maximumAmplitude);
int wtk1395_lock (int instrumentID, int lock);
int wtk1395_adjust (int instrumentID, int phaseValue);
int wtk1395_outen (int instrumentID, int outputState);
int wtk1395_filter (int instrumentID, int filterState, int type);
int wtk1395_sumout (int instrumentID, int sumbusOut);
int wtk1395_outtrig (int instrumentID, int type, int triggerLineNumber,
                     int qualifier, int lineState);
int wtk1395_clock (int instrumentID, int configuration, int outputMode,
                   double userFrequency);
int wtk1395_sumin (int instrumentID, int sumbusInput, int attenuationdB);
int wtk1395_mod (int instrumentID, int modulationState, int modulationMode);
int wtk1395_refosc (int instrumentID, int source);
int wtk1395_trace_mode (int instrumentID, int playbackMode);
int wtk1395_create (int instrumentID, char newTraceName[], int pointCount);
int wtk1395_copy (int instrumentID, char source[], char targetTrace[]);
int wtk1395_delete (int instrumentID, int function, char traceName[]);
int wtk1395_tradir (int instrumentID, int function, char directory[]);
int wtk1395_free (int instrumentID, long *pointsAvailable, long *pointsInUse);
int wtk1395_writefile (int instrumentID, char traceName[], char fileName[]);
int wtk1395_file_to_trace (int instrumentID, char fileName[], char traceName[]);
int wtk1395_writeA24 (int instrumentID, char fileName[]);
int wtk1395_writetrace (int instrumentID, char traceName[], int existingTrace,
                        int traceSize);
int wtk1395_line (int instrumentID, char traceName[], int point1Index,
                  int point1Value, int point2Index, int point2Value);
int wtk1395_define_pts (int instrumentID, char traceName[], int ofPoints,
                        short pointArray[]);
int wtk1395_point (int instrumentID, char traceName[], int pointIndex,
                   int pointValue);
int wtk1395_rescale (int instrumentID, char traceName[], int newSize);
int wtk1395_getlim (int instrumentID, char traceName[], int *start, int *stop);
int wtk1395_getpoint (int instrumentID, char traceName[], int pointIndex,
                      int *pointValue);
int wtk1395_getsize (int instrumentID, char traceName[], int *traceSize);
int wtk1395_defseq (int instrumentID, int sequenceLength, int triggerSense,
                    int triggerMode);
int wtk1395_linkseq (int instrumentID, int sequenceIndex, char traceName[],
                     long dwell, int advance);
int wtk1395_inst_err (int instrumentID, int *instrErrorCode);
int wtk1395_test (int instrumentID, int function, int *testResult);
int wtk1395_cal (int instrumentID, int *calibrationResult);
int wtk1395_reset (int instrumentID);
int wtk1395_write (int instrumentID, char writeBuffer[]);
int wtk1395_read (int instrumentID, int numberBytesToRead, char readBuffer[],
                  long *numBytesRead);
int wtk1395_close (int instrumentID);

#if defined(__cplusplus) || defined(__cplusplus__)
}
#endif

/*****************************************************************************/
/*=== END INCLUDE FILE ======================================================*/
/*****************************************************************************/

#endif

