#!/usr/bin/env python
#RAS_KennKL4.py 
#Hermann Nieder, Version von Juni/Juli 2017,
#Ergaenzungen und Kommentare Dezember 2017
import time
import RPi.GPIO as GPIO
import Tkinter


#GPIO-Festlegungen
GPIO.setmode(GPIO.BCM)
GPIO.setwarnings(False)

out=GPIO.output
inp=GPIO.input
low=GPIO.LOW
hi=GPIO.HIGH

#MAX522
DA_Din=25#
DA_Clk=7#
DA_CS= 8#

GPIO.setup(DA_Din,GPIO.OUT)
GPIO.setup(DA_Clk,GPIO.OUT)
GPIO.setup(DA_CS,GPIO.OUT)


out(DA_CS,hi)#DA_CS 1
DAW_dt=0
Con_dt=0
DA_dt=0

def Byte_aus(DA_dt):
    Din_dt=0
    for i in range(7,-1,-1):  # 7 bis 0
        Din_dt=(DA_dt & 128)/128 
        if Din_dt==0:
            out(DA_Din,low)#DA_Din auf 0
        else:
            out(DA_Din,hi)#DA_Din auf 1
        time.sleep(0.001)
        out(DA_Clk,low)#Clk auf 0
        time.sleep(0.001)
        out(DA_Clk,hi)#Clk auf 1 
        DA_dt=DA_dt<<1 #1 Bit nach links schieben  

def MAX522_a(DAW_dt):
    out(DA_CS,low)#DA_CS auf 0 
    time.sleep(0.001)
    DA_dt=0x22  # Control Byte fuer Kanal A
    Byte_aus(DA_dt)    
    DA_dt=DAW_dt
    Byte_aus(DA_dt)#Ausgabewert    
    out(DA_CS,hi)#DA_Cs auf 1  
    #time.sleep(0.001)

def MAX522_b(DAW_dt):
    out(DA_CS,low)#DA_CS auf 0 
    time.sleep(0.001)
    DA_dt=0x21  # Control Byte fuer Kanal B
    Byte_aus(DA_dt)    
    DA_dt=DAW_dt
    Byte_aus(DA_dt)#Ausgabewert    
    out(DA_CS,hi)#DA_Cs auf 1  
    #time.sleep(0.001)



#GPIO-Pins TLC549_1 
AD_Dat1 = 4 
# Bei Betrieb des A/D-Wandlers mit Vcc= 5V 
# unbedingt eine Reihenschaltung zweier geeigneter Widerstaende 
# zur Begrenzung der Ausgangsspannung auf ca. 3V vorsehen! 
# Vergleichen Sie dazu bitte die Darstellungen im Schaltplan!   
AD_Clk1 = 3
AD_CS1 = 2   
GPIO.setup(AD_CS1,GPIO.OUT)
GPIO.setup(AD_Dat1,GPIO.IN)
GPIO.setup(AD_Clk1,GPIO.OUT)

#GPIO-Pins TLC549_2 
AD_Dat2 =11  
# Bei Betrieb des A/D-Wandlers mit Vcc= 5V 
# unbedingt eine Reihenschaltung zweier geeigneter Widerstaende 
# zur Begrenzung der Ausgangsspannung auf ca. 3V vorsehen! 
# Vergleichen Sie dazu bitte die Darstellungen im Schaltplan!   
AD_Clk2 = 9
AD_CS2 = 10  
GPIO.setup(AD_CS2,GPIO.OUT)
GPIO.setup(AD_Dat2,GPIO.IN)
GPIO.setup(AD_Clk2,GPIO.OUT)

GPIO.setup(8,GPIO.OUT)
GPIO.setup(7,GPIO.OUT)

#ReL1.. ReL5
ReL1=27#Spannungsmessung 5V/10V, Reedrelais K1 in der Schaltung
ReL2=22#Strommessung 5mA/10mA  , Reedrelais K3 in der Schaltung
ReL3=24#Spannung1 5V/10V       ; npn-Transistor, zuvor Relais
ReL4=23#Spannung2 5V/10V       ; npn-Transistor, zuvor Relais
ReL5=18#Strommessung 10mA/20mA ; Reedrelais K2 in der Schaltung

#ReL1...ReL5
GPIO.setup(ReL1,GPIO.OUT)
GPIO.setup(ReL2,GPIO.OUT)
GPIO.setup(ReL3,GPIO.OUT)
GPIO.setup(ReL4,GPIO.OUT)
GPIO.setup(ReL5,GPIO.OUT)

out(ReL1,low)
out(ReL2,low)
out(ReL3,low)#
out(ReL4,low)#
out(ReL5,hi)#MB 20mA ein, zunaechst also groesster Messbereich 

DAW_dt=0
Con_dt=0
DA_dt=0

AD_res1=0
AD_wert1=0
AD_res2=0
AD_wert2=0

def ADein1():#Voltage/Spannung
    GPIO.output(AD_Clk1,GPIO.LOW)# AD_Clk1 auf 0
    AD_res=0
    for n in range(2): 
        time.sleep(0.001)        		
        GPIO.output(AD_CS1,GPIO.HIGH)# AD_CS1 auf 1
        MSB=128
        time.sleep(0.001)
        GPIO.output(AD_CS1,GPIO.LOW)# AD_CS1 auf 0
        time.sleep(0.001)
        AD_Wert=0
        for z in range(8):
            if (GPIO.input(AD_Dat1)):
                AD_Wert=AD_Wert+MSB 
            GPIO.output(AD_Clk1,GPIO.HIGH)# AD_Clk1 auf 1
            time.sleep(0.001)
            GPIO.output(AD_Clk1,GPIO.LOW)# AD_Clk1 auf 0	 
            MSB=MSB>>1
            time.sleep(0.001)
            Ergebnis=AD_Wert
        GPIO.output(AD_CS1,GPIO.HIGH)# AD_CS1 auf 1    
        AD_res=AD_res+AD_Wert
    AD_res=AD_res/2
    Ergebnis=AD_res
    return Ergebnis
	
def ADein2():#Current/Stromstaerke
    GPIO.output(AD_Clk2,GPIO.LOW)# AD_Clk auf 0
    AD_res2=0
    for n in range(2): 
        time.sleep(0.001)        		
        GPIO.output(AD_CS2,GPIO.HIGH)# AD_CS auf 1
        MSB=128
        time.sleep(0.001)
        GPIO.output(AD_CS2,GPIO.LOW)# AD_CS auf 0
        time.sleep(0.001)
        AD_Wert2=0
        for z in range(8):
            if (GPIO.input(AD_Dat2)):
                AD_Wert2=AD_Wert2+MSB 
            GPIO.output(AD_Clk2,GPIO.HIGH)# AD_Clk auf 1
            time.sleep(0.001)
            GPIO.output(AD_Clk2,GPIO.LOW)# AD_Clk auf 0	 
            MSB=MSB>>1
            time.sleep(0.001)
            Ergebnis2=AD_Wert2
        GPIO.output(AD_CS2,GPIO.HIGH)# AD_CS auf 1    
        AD_res2=AD_res2+AD_Wert2
    AD_res2=AD_res2/2
    Ergebnis2=AD_res2    
    return Ergebnis2

#Die beiden seriellen 8-Bit-AD-Wandler TLC549 werden hier mit 5V betrieben.
#Da diese Spannung auch als Referenzspannung verwendet wird, betraegt bei der #Aufloesung in 256 moegliche Spannungswerte der Abstand zwischen den einzelnen #jeweils 5V/255=0.0196V. Der Raspberry Pi liest vom TLC549 jeweils Werte zwischen
#0 und 255 ein, die dann als Spannungen von 0 bis 5 V umzurechnen und auf dem #Bildschirm anzuzeigen sind. In der folgenden Funktion geschieht dies, um mit #ganzen Zahlen rechnen zu koennen, indem der vom AD-Wandler gerade eingelesene
#Wert hier zuerst nicht mit 0.0196, sondern mit 0.0196*100000, also mit 1960 #multipliziert wird.  

   
def Umrechnung(Wert):#Beispiel: Eingelesen wurde 127
    value=Wert
    value=value*1960     #127*1960=248920   
    value=value/1000     #Division durch 1000 = 248. Der Rest 920 wird hier 
                         #nicht beruecksichtigt.          
    pic_value=value/2    #Fuer die grafische Darstellung benoetigter Wert: 124  
    einer=value/100      #Division durch 100: erste Ziffer 2
    rest_z=value % 100   #Rest der Division durch 100: 48 
    zehntL=rest_z/10     #Divison durch 10: zweite Ziffer 4
    hundertL=rest_z%10   #Rest der Division durch 10: dritte Ziffer  8
    return einer, zehntL, hundertL, pic_value,value

#Bezeichnungen/Descriptions links unten
def Description1_L():
    Chan=1 #Kanal1
    Wert1=ADein1()
    einer,zehntL,hundertL,pic_value,value=Umrechnung(Wert1)

def Description2_R():
    Chan=2
    Wert=ADein2()
    einer,zehntL,hundertL,pic_value,value=Umrechnung(Wert)  
    value_tmp=Wert
    y2=pic_value 
   
def Description10V():
    out(ReL1,low) 
    #print"Bereich 10 V"
    
def Description5V():
    out(ReL1,hi)      
    #print"Bereich 5 V"
   
#Strommessbereiche
def Description20mA():
    out(ReL2,low)#
    out(ReL5,hi) 
    #print "Bereich 20 mA"

def Description10mA():
    out(ReL2,low)
    out(ReL5,low) 
    #print "Bereich 10 mA"
 
def Description5mA():
    out(ReL2,hi)#
    out(ReL5,low)  
    #print "Bereich 5 mA"
   
#Beide DAW-Ausgaenge auf 0 V
Description10V()
Description20mA()

Wert1=0
Wert2=0
einer=0
zehntL=0
hundertL=0
daw_max=0
Wert=0

def Nullpunkt():
    x1=35
    y1=285    
    MAX522_a(0)
    #MAX522_b(0)
    # Zunaechst "unsichtbare Linie" zum Nullpunkt zeichnen,
    # also mit der Hintergrundfarbe
    canvas.create_line(x1,y1,x1,y1,fill="white",width=1)
    time.sleep(0.1)  

def KennL_all():
    Nullpunkt()
    time.sleep(0.5)
    Wert=ADein1()
    time.sleep(0.1)
    Wert=ADein2()
    time.sleep(0.1)
 
daw_max=0    
#Funktionen zur Darstellung der farbigen Kennlinien

#fore_col=rot
def KennL1():
    global sw
    label_Current["text"]="           "
    label_Voltage["text"]="           "
    daw_max=int(entr_W.get())#
    daw_max=int(daw_max*255/5000)
    #print "daw_max: ",str(daw_max)
    KennL_all()
    x1=0
    y1=0
    Wert=0
    k=0
    for k in range(0,daw_max+1,sw):# 
        MAX522_a(k) 
        print k, " von ", daw_max #einfache Fortschrittsanzeige
        Description1_L()          #im Terminal
        Wert1=ADein1()            #Spannungswert U (Wert1)
        einer,zehntL,hundertL,pic_value,value=Umrechnung(Wert1)
        x2=pic_value         
        Wert=ADein2()             #Am 1-Ohm-Widerstand bei Stromfluss
                                  #entstehender Spannungabfall,
                                  #wird mithilfe eines LM358
                                  #um den Faktor 1001 bzw. 501 verstaerkt
                                  #und dient im Python-Programm als Wert 
                                  #fuer die Stromstaerke (Wert)     	      
        einer,zehntL,hundertL,pic_value,value=Umrechnung(Wert)
        y2=pic_value
        canvas.create_line(35+x1,285-y1,35+x2,285-y2,fill="red",width=1,tag="L1")
        x1=x2  #neuer x1-Wert = alter x2-Wert  
        y1=y2  #neuer y1-Wert = alter y2-Wert
        Description2_R()    

#fore_col=orange
def KennL2():
    global sw
    label_Current["text"]="           "
    label_Voltage["text"]="           "
    daw_max=int(entr_W.get())#
    daw_max=int(daw_max*255/5000)
    #print "daw_max: ",str(daw_max)
    KennL_all()
    x1=0
    y1=0
    Wert=0
    k=0
    for k in range(0,daw_max+1,sw):# 
        MAX522_a(k) 
        print k, " von ", daw_max
        Description1_L()
        Wert1=ADein1()  
        einer,zehntL,hundertL,pic_value,value=Umrechnung(Wert1)
        x2=pic_value 
        Wert=ADein2()
        einer,zehntL,hundertL,pic_value,value=Umrechnung(Wert)
        y2=pic_value
        canvas.create_line(35+x1,285-y1,35+x2,285-y2,fill="orange",width=1,tag="L2")
        x1=x2  #neuer x1-Wert = alter x2-Wert  
        y1=y2  #neuer y1-Wert = alter y2-Wert
        Description2_R()    
 
#fore_col=d_gruen
def KennL3():
    global sw
    label_Current["text"]="           "
    label_Voltage["text"]="           "
    daw_max=int(entr_W.get())#
    daw_max=int(daw_max*255/5000)
    #print "daw_max: ",str(daw_max)
    KennL_all()
    x1=0
    y1=0
    Wert=0
    k=0
    for k in range(0,daw_max+1,sw):# 
        MAX522_a(k) 
        print k, " von ", daw_max
        Description1_L()
        Wert1=ADein1()  
        einer,zehntL,hundertL,pic_value,value=Umrechnung(Wert1)
        x2=pic_value 
        Wert=ADein2()
        einer,zehntL,hundertL,pic_value,value=Umrechnung(Wert)
        y2=pic_value
        canvas.create_line(35+x1,285-y1,35+x2,285-y2,fill="#00C000",width=1,tag="L3")
        x1=x2  #neuer x1-Wert = alter x2-Wert  
        y1=y2  #neuer y1-Wert = alter y2-Wert
        Description2_R()    
#fore_col=(0,96,255)#m_blau
def KennL4():
    global sw
    label_Current["text"]="           "
    label_Voltage["text"]="           "
    daw_max=int(entr_W.get())#
    daw_max=int(daw_max*255/5000)
    #print "daw_max: ",str(daw_max)
    KennL_all()
    x1=0
    y1=0
    Wert=0
    k=0
    for k in range(0,daw_max+1,sw):# 
        MAX522_a(k) 
        print k, " von ", daw_max
        Description1_L()
        Wert1=ADein1()  
        einer,zehntL,hundertL,pic_value,value=Umrechnung(Wert1)
        x2=pic_value 
        Wert=ADein2()
        einer,zehntL,hundertL,pic_value,value=Umrechnung(Wert)
        y2=pic_value
        canvas.create_line(35+x1,285-y1,35+x2,285-y2,fill="blue",width=1,tag="L4")
        x1=x2  #neuer x1-Wert = alter x2-Wert  
        y1=y2  #neuer y1-Wert = alter y2-Wert
        Description2_R()    


#fore_col=magenta
def KennL5():
    global sw
    label_Current["text"]="           "
    label_Voltage["text"]="           "
    daw_max=int(entr_W.get())#
    daw_max=int(daw_max*255/5000)
    #print "daw_max: ",str(daw_max)
    KennL_all()
    x1=0
    y1=0
    Wert=0
    k=0
    for k in range(0,daw_max+1,sw):# 
        MAX522_a(k) 
        print k, " von ", daw_max
        Description1_L()
        Wert1=ADein1()  
        einer,zehntL,hundertL,pic_value,value=Umrechnung(Wert1)
        x2=pic_value 
        Wert=ADein2()
        einer,zehntL,hundertL,pic_value,value=Umrechnung(Wert)
        y2=pic_value
        canvas.create_line(35+x1,285-y1,35+x2,285-y2,fill="magenta",width=1,tag="L5")
        x1=x2  #neuer x1-Wert = alter x2-Wert  
        y1=y2  #neuer y1-Wert = alter y2-Wert
        Description2_R()    

#fore_col=cyan
def KennL6():
    global sw
    label_Current["text"]="           "
    label_Voltage["text"]="           "
    daw_max=int(entr_W.get())#
    daw_max=int(daw_max*255/5000)
    #print "daw_max: ",str(daw_max)
    KennL_all()
    x1=0
    y1=0
    Wert=0
    k=0
    for k in range(0,daw_max+1,sw):# 
        MAX522_a(k) 
        print k, " von ", daw_max
        Description1_L()
        Wert1=ADein1()  
        einer,zehntL,hundertL,pic_value,value=Umrechnung(Wert1)
        x2=pic_value 
        Wert=ADein2()
        einer,zehntL,hundertL,pic_value,value=Umrechnung(Wert)
        y2=pic_value
        canvas.create_line(35+x1,285-y1,35+x2,285-y2,fill="cyan",width=1,tag="L6")
        x1=x2  #neuer x1-Wert = alter x2-Wert  
        y1=y2  #neuer y1-Wert = alter y2-Wert
        Description2_R()    

   
def ende():
    MAX522_a(0)
    MAX522_b(0)
    window.destroy()

#Hauptfenster
window=Tkinter.Tk()
window.title('Der Raspberry Pi als einfacher Kennlinienschreiber ')

#Die verwendeten Steuerelemente(Widgets), wie Buttons, Schieberegler usw., sind #jeweils innerhalb von Frames angeordnet. Es wird dabei die Methode pack()
#verwendet. 

#Frame fuer den Bereich mit dem Zeichenfeld und den Steuerelemenen darunter
frameA=Tkinter.Frame(window,width=150,height=30)
frameA.pack(side="left")
#FrameA ist an der linken Seite des Hauptfensters window angeordnet.

#Frame fuer den gesamten Bereich rechts
frameB=Tkinter.Frame(window,width=150,height=30)
frameB.pack(side="left")
#FrameB ist auf der rechten Seite des Hauptfensters window angeordnet.

#************************************************************************

#Zeichenfeld fuer Darstellungen der Kennlinien
canvas = Tkinter.Canvas(frameA, width=325, height=325, bg = 'white')
canvas.pack(side="top",pady=12)

#vertikale Linien im Zeichenfeld
canvas.create_line(35,285,35,35,  width=1)

for i in range(11):
    canvas.create_line(35+i*25,285,35+i*25,35,fill="grey",width=1)

for i in range(26):
    x = 285 - (i * 10)
    canvas.create_line(35,x,30,x, width=1)

for i in range(6):
    x = 285 - (i * 50)
    canvas.create_line(35,x,25,x, width=1)
    canvas.create_text(20,x, text='%d'% (i), anchor="e")

canvas.create_text(25,15,text="mA")   

#horizontale Linien im Zeichenfeld
canvas.create_line(35,285,285,285, width=1)

for i in range(11):
    canvas.create_line(35,285-i*25,285,285-i*25,fill="grey",width=1)

for i in range(26):
    x = 35 + (i * 10)
    canvas.create_line(x,285,x,290, width=1)

for i in range(6):
    x = 35 + (i * 50)
    canvas.create_line(x,285,x,295, width=1)
    canvas.create_text(x,305, text='%d'% (i), anchor="n")

canvas.create_text(310,310,text="V")

#************************************************************************

#Frame fuer Spannungs- und Stromanzeigen
frame_VC=Tkinter.Frame(frameA,width=150,height=30,relief="sunken",bd=1)
frame_VC.pack(side="top")

counter1=0
counter2=0

#Fortwaehrende Spannungs- und Strommessungen

def counter1_label(label_Voltage):
    
    def count1():
        global counter1
        counter1 +=1
        Wert1 = ADein1()
        Wert1_tmp=Wert1
        einer,zehntL,hundertL,pic_value,value=Umrechnung(Wert1) 
        label_Voltage.config(text="          " )
        label_Voltage.config(text="U: "+str(einer)+"."+str(zehntL)+str(hundertL)+" V" ) 
        label_Voltage.after(100, count1)#
    count1()

def counter2_label(label_Current):
    def count2():
        global counter2
        counter2 +=1
        Wert2 = ADein2()
        Wert2_tmp=Wert2
        einer,zehntL,hundertL,pic_value,value=Umrechnung(Wert2) 
        #Umrechnungen2(ADWert2)
        label_Current["text"]="          " 
        label_Current["text"]="I: "+str(einer)+"."+str(zehntL)+str(hundertL)+" mA"
        label_Current.after(100, count2)#
    count2() 

label_Voltage=Tkinter.Label(frame_VC,text="U=0.00 V",width=10,anchor="center")
label_Voltage.pack(side="left",pady=5)
counter1_label(label_Voltage)

label_Current=Tkinter.Label(frame_VC,text="I=0.00 mA",width=10,anchor="center")
label_Current.pack(side="left",pady=5)
counter2_label(label_Current)

#Frame fuer Faktor Spannungsanzeige und Stromstaerkeanzeige
frame_VC_F=Tkinter.Frame(frameA,width=150,height=30,bd=1)
frame_VC_F.pack(side="top")

#Faktor unter Spannungsanzeige
label_Voltage_F=Tkinter.Label(frame_VC_F,text="",width=10,anchor="center")
label_Voltage_F.pack(side="left",pady=10)

#Faktor unter Stromstaerkeanzeige
label_Current_F=Tkinter.Label(frame_VC_F,text="",width=10,anchor="center")
label_Current_F.pack(side="left",pady=10)

#****************************************************************************

#Callbacks, Kommandofunktionen 
def bt_KL_rot_on():
    ADein1() # wichtig, sonst Stoereffekte
             #beim Einlesen moeglich
    time.sleep(0.1)
    KennL1() 

def bt_KL_rot_res():    
    MAX522_a(0)

def bt_KL_rot_off():
    MAX522_a(0)
    canvas.delete("L1")
    lab_red["text"]="          "
    label_Current["text"]="I=0.00 mA"
    label_Voltage["text"]="U=0.00 V" 
    Nullpunkt()    

def bt_KL_orange_on():
    ADein1() # s. o.
    time.sleep(0.1)
    KennL2() 

def bt_KL_orange_res():
    MAX522_a(0)

def bt_KL_orange_off():
    MAX522_a(0)
    canvas.delete("L2")
    lab_orange["text"]="          "
    label_Current["text"]="I=0.00 mA"
    label_Voltage["text"]="U=0.00 V"
    Nullpunkt()                  

def bt_KL_gruen_on():
    ADein1() # s. o.
    time.sleep(0.1)
    KennL3() 

def bt_KL_gruen_res():
    MAX522_a(0)

def bt_KL_gruen_off():
    MAX522_a(0)
    canvas.delete("L3")
    lab_green["text"]="          "
    label_Current["text"]="I=0.00 mA"
    label_Voltage["text"]="U=0.00 V"
    Nullpunkt()   

def bt_KL_blau_on():
    ADein1() # s. o.
    time.sleep(0.1)
    KennL4() 

def bt_KL_blau_res():
    MAX522_a(0)

def bt_KL_blau_off():
    MAX522_a(0)
    canvas.delete("L4")
    lab_blue["text"]="          " 
    label_Current["text"]="I=0.00 mA"
    label_Voltage["text"]="U=0.00 V"
    Nullpunkt() 

def bt_KL_magenta_on():
    ADein1() # s. o.
    time.sleep(0.1)
    KennL5() 

def bt_KL_magenta_res():
    MAX522_a(0)

def bt_KL_magenta_off():
    MAX522_a(0)
    canvas.delete("L5")
    lab_magenta["text"]="          "
    label_Current["text"]="I=0.00 mA"
    label_Voltage["text"]="U=0.00 V"
    Nullpunkt() 


def bt_KL_cyan_on():
    ADein1() # s. o.
    time.sleep(0.1)
    KennL6() 

def bt_KL_cyan_res():
    MAX522_a(0)

def bt_KL_cyan_off():
    MAX522_a(0)
    canvas.delete("L6")
    lab_cyan["text"]="          "
    label_Current["text"]="I=0.00 mA"
    label_Voltage["text"]="U=0.00 V"
    Nullpunkt()

def KL_text_rot():
    #Description_rot()
    lab_red["text"]=entr_C.get()#Textfeld ueber 6
                                #Beschriftungs-Labels

def KL_text_orange():
    #Description_orange()
    lab_orange["text"]=entr_C.get()

def KL_text_gruen():
    #Description_gruen()
    lab_green["text"]=entr_C.get()    

def KL_text_blau():
    lab_blue["text"]=entr_C.get() 
    #Description_blau()

def KL_text_cyan():
    lab_cyan["text"]=entr_C.get() 
    #Description_cyan()

def KL_text_magenta():
    lab_magenta["text"]=entr_C.get() 
    #Description_magenta()

def grafik_Description():
     Description_Typ()

def MB_10Vein():
    Description10V()
    label_Voltage_F["text"]="x 2"

def MB_5Vein():
    Description5V()
    label_Voltage_F["text"]="x 1"

def MB_20mAein():
    Description20mA()
    label_Current_F["text"]="x 4"

def MB_10mAein():
    Description10mA()
    label_Current_F["text"]="x 2"

def MB_5mAein():
    Description5mA()
    label_Current_F["text"]="x 1"


#Anzeigen ueber den Schiebereglern/Scales
def U1_anzeigen(self):
    DAW_dt1=int(Schieb_Ube_val1.get())   
    MAX522_a(DAW_dt1)
    Wt1=DAW_dt1*1960#war 1960fuer 5V
    Wt1=Wt1/1000
    Wt1_einer=Wt1/100
    Wt1_rest_z=Wt1 % 100
    Wt1_zehntL=Wt1_rest_z/10
    Wt1_hundertL=Wt1_rest_z%10 
    lab_Val1.config(text="          " )
    lab_Val1.config(text="U1: "+str(Wt1_einer)+"."+str(Wt1_zehntL)+str(Wt1_hundertL)+" V")
 

def U2_anzeigen(self):
    DAW_dt2=int(Schieb_Ube_val.get())   
    MAX522_b(DAW_dt2)#
    Wt=DAW_dt2*1960#
    Wt=Wt/1000
    Wt_einer=Wt/100
    Wt_rest_z=Wt % 100
    Wt_zehntL=Wt_rest_z/10
    Wt_hundertL=Wt_rest_z%10 
    label8.config(text="          " )
    label8.config(text="U2: "+str(Wt_einer)+"."+str(Wt_zehntL)+str(Wt_hundertL)+" V")


          
def U4_anzeigen(self):
    global sw
    sw=int(Schieb_Ube_val3.get()) 
    label10.config(text="Aufloesung:")

#Voltage1/Spannung1
def V1_10_ein():
    Description10V()
    Description20mA()
    Spannung.set("10")
    Strom.set("20")
    MB_10Vein()
    out(ReL4,hi)
    lab_entr_F.config(text="     x 2")
    lab_Val01.config(text="x 2")

def V1_5_ein():
    out(ReL4,low)
    MB_5Vein()
    lab_entr_F.config(text="     x 1")
    lab_Val01.config(text="x 1") 

#Voltage2/Spannung2

def V2_10_ein():
    out(ReL3,hi)
    label8_F.config(text="x 2")

def V2_5_ein():
    out(ReL3,low) 
    label8_F.config(text="x 1")

#Variablen
Spannung=Tkinter.StringVar()
Spannung.set("10")
Strom=Tkinter.StringVar()
Strom.set("20")
daw_max_s=Tkinter.StringVar()
daw_max_s.set("10")
label_Voltage_F["text"]="x 2"
label_Current_F["text"]="x 4"
Schieb_Ube_val=Tkinter.IntVar()
Schieb_Ube_val.set(0)
Schieb_Ube_val3=Tkinter.IntVar()
Schieb_Ube_val3.set(5)
Schieb_Ube_val1=Tkinter.IntVar()
Schieb_Ube_val1.set(0)
Voltage=Tkinter.StringVar()
Voltage.set("5000")
Voltage2=Tkinter.StringVar()
Voltage2.set("25")

def grafik_loeschen():
    entr_C.delete(0,30)	#Textfeld ueber 6 Labels
    canvas.delete("L1")
    lab_red["text"]="          "
    canvas.delete("L2")
    lab_orange["text"]="          "
    canvas.delete("L3")
    lab_green["text"]="          "
    canvas.delete("L4")
    lab_blue["text"]="          "
    canvas.delete("L5")
    lab_cyan["text"]="          "
    canvas.delete("L6")
    lab_magenta["text"]="          "
    Nullpunkt() 
    Description10V()
    Description20mA()
    Spannung.set("10")
    Strom.set("20")
    Voltage.set("5000")
    entr_W.config(text="0000")
    label_Current["text"]="I=0.00 mA"
    label_Voltage["text"]="U=0.00 V"
    label_Voltage_F["text"]="x 2"
    label_Current_F["text"]="x 4"
    lab_entr_F.config(text="     x 1") 
   
#********************************************************************

#Frames zur Aufnahme der Labels, Buttons, Radiobuttons, 
#Schieberegler und des Textfeldes unter dem Zeichenfeld 

#Frame5
frame5=Tkinter.Frame(frameA,width=150,height=30,bd=1)
frame5.pack(side="top")

#Frame5a
frame5a=Tkinter.Frame(frame5,width=150,height=30,bd=1)
frame5a.pack(side="left")

#Frame5b
frame5b=Tkinter.Frame(frame5,width=150,height=30,bd=1)
frame5b.pack(side="left")

#Frame5b_o
frame5b_o=Tkinter.Frame(frame5b,width=150,height=30,bd=1)
frame5b_o.pack(side="top")

#Frame5b_u
frame5b_u=Tkinter.Frame(frame5b,width=150,height=30,bd=1)
frame5b_u.pack(side="top")

#Frame5b1
frame5b1=Tkinter.Frame(frame5b_o,width=150,height=30,bd=1)
frame5b1.pack(side="top")

#Frame5b2
frame5b2=Tkinter.Frame(frame5b_o,width=150,height=30,bd=1)
frame5b2.pack(side="top")

#Frame5c
frame5c=Tkinter.Frame(frame5,width=150,height=30,bd=1)
frame5c.pack(side="left")

#*******************************************************************

#Radiobuttons zum Umschalten der Spannung1 von 5V max. auf 10 V max. 
rbt_10V=Tkinter.Radiobutton(frame5a,text=" U1 10V ",variable=Voltage,
value="10000",anchor="center",command=V1_10_ein)
rbt_10V.pack(side="top",pady=12)

rbt_5V=Tkinter.Radiobutton(frame5a,text=" U1  5V ",variable=Voltage,
value="5000",anchor="center",command=V1_5_ein)
rbt_5V.pack(side="top",pady=12)

#*******************************************************************

#Scalev10 Steps DAW_out(sw), Aufloesung 0..10

label10=Tkinter.Label(frame5c,text="Steps Volt.1:")
label10.pack(side="top",pady=2,padx=2)

Schieb_rg1b=Tkinter.Scale(frame5c,width=20,length=60,
orient="horizontal",from_=1,to=10,command=U4_anzeigen,
variable=Schieb_Ube_val3)
Schieb_rg1b.pack(side="top",pady=10,padx=15)


lab_entr_txt=Tkinter.Label(master=frame5b1,text="V1_max")
lab_entr_txt.pack(side="left")

entr_W=Tkinter.Entry(master=frame5b1,text="5000",width=6)
entr_W.pack(side="left")

lab_entr_W=Tkinter.Label(master=frame5b1,text="mV")
lab_entr_W.pack(side="left")

lab_entr_F=Tkinter.Label(master=frame5b2,text="     x 1")
lab_entr_F.pack(side="top")

#*********************************************************************

#Schieberegler Schieb_rg1 zum Einstellen der Spannung1 in 255 Schritten
#in Abhaengigkeit von der Einstellung der Radiobuttons/Optionsfelder
# U1 5V bzw. U1 10V 
lab_Val1=Tkinter.Label(frame5b_u,text="   ")
lab_Val1.pack(side="top")

lab_Val01=Tkinter.Label(frame5b_u,text="x 1")
lab_Val01.pack(side="top")

Schieb_rg1a=Tkinter.Scale(frame5b_u,width=20,length=128,
orient="horizontal",from_=0,to=255,command=U1_anzeigen,
variable=Schieb_Ube_val1)
Schieb_rg1a.pack(side="top",padx=15,pady=18)

#*******************************************************************
#Frames fuer das Textfeld fuer die Bezeichnung des Bauteils, dessen 
#Kennlinien dargestellt wurden, owie fuer die Labels mit den
#Beschreibungen zu den  einzelnen Kennlinien

frame1=Tkinter.Frame(frameB,width=150,height=30)
frame1.pack(side="top")

frame6=Tkinter.Frame(frameB,width=250,height=30,bg="white")
frame6.pack(side="top",pady=10)

#Textfeld zum Eintragen der einzelnen Beschreibungen
entr_C=Tkinter.Entry(frame6, width=25)
entr_C.pack(side="top")

frame7=Tkinter.Frame(frameB,width=150,height=30,bd=1)
frame7.pack(side="top")

frame7a=Tkinter.Frame(frame7,width=150,height=30,bd=1)
frame7a.pack(side="left")

frame7b=Tkinter.Frame(frame7,width=150,height=30,bd=1)
frame7b.pack(side="left")

#*******************************************************************

#6 Labels zur Beschreibung der einzelnen Kennlinien
lab_red=Tkinter.Label(frame7a,text="",fg="red",bg="white",width=25)
lab_red.pack(side="top",pady=4,padx=8)

lab_orange=Tkinter.Label(frame7a,text="",fg="orange",bg="white",width=25)
lab_orange.pack(side="top",pady=4,padx=8)

lab_green=Tkinter.Label(frame7a,text="          ",fg="green",bg="white",width=25)
lab_green.pack(side="top",pady=4,padx=8)

lab_blue=Tkinter.Label(frame7b,text="          ",fg="blue",bg="white",width=25)
lab_blue.pack(side="top",pady=4,padx=8)

lab_magenta=Tkinter.Label(frame7b,text="          ",fg="magenta",bg="white",width=25)
lab_magenta.pack(side="top",pady=4,padx=8)

lab_cyan=Tkinter.Label(frame7b,text="          ",fg="cyan",bg="white",width=25)
lab_cyan.pack(side="top",pady=4,padx=8)

#*******************************************************************
#Frames fuer die Buttons START, das farbige Label, die Buttons
#RESET, DELETE und Beschreibung

frame2=Tkinter.Frame(frameB,width=250,height=30)
frame2.pack(side="top",pady=10)

frame1a_b=Tkinter.Frame(frame1,width=150,height=30)
frame1a_b.pack(side="left",padx=2)

frame1a=Tkinter.Frame(frame1a_b,width=150,height=30)
frame1a.pack(side="left")

frame1b=Tkinter.Frame(frame1a_b,width=150,height=30)
frame1b.pack(side="left")

frame1c_e=Tkinter.Frame(frame1,width=150,height=30)
frame1c_e.pack(side="left")

frame1c=Tkinter.Frame(frame1c_e,width=150,height=30)
frame1c.pack(side="left")

frame1d=Tkinter.Frame(frame1c_e,width=150,height=30)
frame1d.pack(side="left")

frame1e=Tkinter.Frame(frame1c_e,width=150,height=30)
frame1e.pack(side="left")

#**************************************************************

#Buttons Label Kennl. rot ...
button_KL_rot_on=Tkinter.Button(frame1a,text="START",
command=bt_KL_rot_on)
button_KL_rot_on.pack(side="top")
        
label1=Tkinter.Label(frame1b,text="Kennl.  rot",bg="red",width=12,anchor="center")
label1.pack(side="top",pady=5)

button_KL_rot_res=Tkinter.Button(frame1c,text="RESET",
command=bt_KL_rot_res)
button_KL_rot_res.pack(side="top")

button_KL_rot_off=Tkinter.Button(frame1d,text="DELETE",
command=bt_KL_rot_off)
button_KL_rot_off.pack(side="top")

button_KL_text_rot=Tkinter.Button(frame1e,text="Beschreibung",
command=KL_text_rot)
button_KL_text_rot.pack(side="top")
#**************************************************************

#Buttons Label Kennl. orange ...
button_KL_orange_on=Tkinter.Button(frame1a,text="START",
command=bt_KL_orange_on)
button_KL_orange_on.pack(side="top")

label2=Tkinter.Label(frame1b,text="Kennl.orange",bg="orange",width=12,anchor="center")
label2.pack(side="top",pady=5)

button_KL_orange_res=Tkinter.Button(frame1c,text="RESET",
command=bt_KL_orange_res)
button_KL_orange_res.pack(side="top")

button_KL_orange_off=Tkinter.Button(frame1d,text="DELETE",
command=bt_KL_orange_off)
button_KL_orange_off.pack(side="top")

button_KL_text_orange=Tkinter.Button(frame1e,text="Beschreibung",
command=KL_text_orange)
button_KL_text_orange.pack(side="top")

#**************************************************************

#Buttons, Label Kennl. gruen ...
button_KL_gruen_on=Tkinter.Button(frame1a,text="START",
command=bt_KL_gruen_on)
button_KL_gruen_on.pack(side="top")

label3=Tkinter.Label(frame1b,text="Kennl gruen",bg="#00C000",width=12,anchor="center")
label3.pack(side="top",pady=5)

button_KL_gruen_res=Tkinter.Button(frame1c,text="RESET",
command=bt_KL_gruen_res)
button_KL_gruen_res.pack(side="top")

button_KL_gruen_off=Tkinter.Button(frame1d,text="DELETE",
command=bt_KL_gruen_off)
button_KL_gruen_off.pack(side="top")

button_KL_text_gruen=Tkinter.Button(frame1e,text="Beschreibung",
command=KL_text_gruen)
button_KL_text_gruen.pack(side="top")
#**************************************************************

#Buttons, Label Kennl. blau ...
button_KL_blau_on=Tkinter.Button(frame1a,text="START",
command=bt_KL_blau_on)
button_KL_blau_on.pack(side="top")

label4=Tkinter.Label(frame1b,text="Kennl. blau",bg="#0060FF",width=12,anchor="center")
label4.pack(side="top",pady=5)

button_KL_blau_res=Tkinter.Button(frame1c,text="RESET",
command=bt_KL_blau_res)
button_KL_blau_res.pack(side="top")

button_KL_blau_off=Tkinter.Button(frame1d,text="DELETE",
command=bt_KL_blau_off)
button_KL_blau_off.pack(side="top")

button_KL_text_blau=Tkinter.Button(frame1e,text="Beschreibung",
command=KL_text_blau)
button_KL_text_blau.pack(side="top")
#**************************************************************

#Buttons, Label Kennl. magenta ...
button_KL_magenta_on=Tkinter.Button(frame1a,text="START",
command=bt_KL_magenta_on)
button_KL_magenta_on.pack(side="top")

label6=Tkinter.Label(frame1b,text="Kennl. magenta",bg="magenta",width=12,anchor="center")
label6.pack(side="top",pady=5) 

button_KL_magenta_res=Tkinter.Button(frame1c,text="RESET",
command=bt_KL_magenta_res)
button_KL_magenta_res.pack(side="top")               

button_KL_magenta_off=Tkinter.Button(frame1d,text="DELETE",
command=bt_KL_magenta_off)
button_KL_magenta_off.pack(side="top")

button_KL_text_magenta=Tkinter.Button(frame1e,text="Beschreibung",
command=KL_text_magenta)
button_KL_text_magenta.pack(side="top")

#**************************************************************

#Buttons, Label Kennl. cyan ...
button_KL_cyan_on=Tkinter.Button(frame1a,text="START",
command=bt_KL_cyan_on)
button_KL_cyan_on.pack(side="top")

label5=Tkinter.Label(frame1b,text="Kennl. cyan",bg="cyan",width=12,anchor="center")
label5.pack(side="top",pady=5) 

button_KL_cyan_res=Tkinter.Button(frame1c,text="RESET",
command=bt_KL_cyan_res)
button_KL_cyan_res.pack(side="top")               

button_KL_cyan_off=Tkinter.Button(frame1d,text="DELETE",
command=bt_KL_cyan_off)
button_KL_cyan_off.pack(side="top")

button_KL_text_cyan=Tkinter.Button(frame1e,text="Beschreibung",
command=KL_text_cyan)
button_KL_text_cyan.pack(side="top")

#********************************************************************


#Frame2 enthaelt Label Spannungsmessung sowie 2 Radiobuttons
#fuer Messbereichswahl
#sowie Label Strommessung sowie 3 Radiobuttons
#fuer Messbereichswahl

frame2a=Tkinter.Frame(frame2,width=150,height=30)
frame2a.pack(side="left",padx=40)

frame2b=Tkinter.Frame(frame2,width=150,height=30)
frame2b.pack(side="left",padx=40)

label6=Tkinter.Label(frame2a,text=" Spannungsmessung ",anchor="center")
label6.pack(side="top")

rb_10V=Tkinter.Radiobutton(frame2a,text=" MB  10V ",variable=Spannung,
value="10",anchor="center",command=MB_10Vein)
rb_10V.pack(side="top",pady=5)

rb_5V=Tkinter.Radiobutton(frame2a,text=" MB    5V ",variable=Spannung,
value="5",anchor="center",command=MB_5Vein)
rb_5V.pack(side="top",pady=5)


label7=Tkinter.Label(frame2b,text=" Strommessung ",anchor="center")
label7.pack(side="top",pady=5)

rb_20mA=Tkinter.Radiobutton(frame2b,text="MB  20mA ",variable=Strom,
value="20",command=MB_20mAein)
rb_20mA.pack(side="top")

rb_10mA=Tkinter.Radiobutton(frame2b,text="MB  10mA ",variable=Strom,
value="10",command=MB_10mAein)
rb_10mA.pack(side="top")

rb_5mA=Tkinter.Radiobutton(frame2b,text="MB    5mA ",variable=Strom,
value="5",command=MB_5mAein)
rb_5mA.pack(side="top")

#**********************************************************************
#Frame mit den Buttons zum Loeschen aller Kennlinien und zum Beenden
#des Programms 

frameL_E=Tkinter.Frame(frameB,width=150,height=30,bd=1)
frameL_E.pack(side="top")

button_grafik_off=Tkinter.Button(frameL_E,text="   Kennlinien alle loeschen  ",command=grafik_loeschen)
button_grafik_off.pack(side="left",padx=15,pady=5)

bt_ende=Tkinter.Button(frameL_E,text="         Programmende          ",command=ende)
bt_ende.pack(side="left",padx=15,pady=5)#

#**********************************************************************

frame8=Tkinter.Frame(frameB,width=150,height=30,bd=1)
frame8.pack(side="top")

frame8a=Tkinter.Frame(frame8,width=150,height=30,bd=1)
frame8a.pack(side="left")#

frame8b=Tkinter.Frame(frame8,width=150,height=30,bd=1)
frame8b.pack(side="left")

#frame8c=Tkinter.Frame(frame8,width=150,height=30,bd=1)
#frame8c.pack(side="left")

#*******************************************************************

rbt_5v0=Tkinter.Radiobutton(frame8a,text="U2 10 V ",variable=Voltage2,
value="50",anchor="center",command=V2_10_ein)
rbt_5v0.pack(side="top",pady=10,padx=10)#

rbt_2v5=Tkinter.Radiobutton(frame8a,text="U2   5 V ",variable=Voltage2,
value="25",anchor="center",command=V2_5_ein)
rbt_2v5.pack(side="top",pady=10,padx=10)#

#*******************************************************************

#Schieberegler Schieb_rg2 zum Einstellen der Spannung2 in 255 Schritten
#in Abhaengigkeit von der Einstellung der Radiobuttons/Optionsfelder
# U2 5V bzw. U2 10V 

#label8
label8=Tkinter.Label(frame8b,text="U2")
label8.pack(side="top",padx=10,pady=10)

label8_F=Tkinter.Label(frame8b,text="x 1")
label8_F.pack(side="top",padx=10)

Schieb_rg2=Tkinter.Scale(frame8b,width=20,length=128,
orient="horizontal",from_=0,to=255,command=U2_anzeigen,
variable=Schieb_Ube_val)
Schieb_rg2.pack(side="bottom",padx=10)

#******************************************************************


#Endlosschleife
window.mainloop()


      
