/*
Automatische Akku-Umschaltung
Frank Sommer, DC8FG
Oktober 2017
Diese Schaltung Schaltung zwischen zwei angeschlossenen Akkus um.
Bei Unterspannung eines Akkus wird auf den anderen umgeschaltet.
*/

int Akku1_Relais_Pin = PB4;
int Akku2_Relais_Pin = PB0;
int Reserve_Pin = PB1;
int Stat_Reserve_Pin;
int UBatt_Pin = 7; //PB2;
int Beeper_Pin = PB3;
int Voltage_raw; // evtl. als float deklarieren
int Stat_Akku1_Relais_Pin;
int Stat_Akku2_Relais_Pin;
int beeper_counter = 0;
int beeper_cutoff_counter = 0;
float Voltage_R2;
float Uref = 5.0;
float Voltage_in;

void setup()
{
	pinMode(Akku1_Relais_Pin, OUTPUT);
	pinMode(Akku2_Relais_Pin, OUTPUT);
	pinMode(Beeper_Pin, OUTPUT);
	pinMode(Reserve_Pin, INPUT);
	digitalWrite(Akku1_Relais_Pin, HIGH);//Relais 1 einschalten bei Start des Geraetes
	digitalWrite(Akku2_Relais_Pin, LOW);//Relais 2  ausschalten bei Start des Geraetes
}

void loop()
{	
	//Erste Pruefung ob Unterspannung wenn Akku an Relais 1 durchgeschaltet
	read_voltage_level();
	Stat_Akku1_Relais_Pin = digitalRead(Akku1_Relais_Pin);//PB4
	Stat_Akku2_Relais_Pin = digitalRead(Akku2_Relais_Pin);//PB0
		
	if (Voltage_in < 10.8 && Stat_Akku1_Relais_Pin == HIGH)
		{	
			while (beeper_counter < 4)
			{
				notice();
			}
			beeper_counter = 0;
			digitalWrite(Akku2_Relais_Pin, HIGH);
			delay(100);
			digitalWrite(Akku1_Relais_Pin, LOW);
							
			read_voltage_level();
			Stat_Reserve_Pin = digitalRead(Reserve_Pin);//PB1
			
			if (Voltage_in < 10.8 && Stat_Reserve_Pin == HIGH )
			{	
				while (beeper_cutoff_counter < 60)
				{
					cutoff_notice();
				}
				beeper_cutoff_counter = 0;
				digitalWrite(Akku2_Relais_Pin, LOW);
			}
			
		}
		
	read_voltage_level();
	Stat_Akku1_Relais_Pin = digitalRead(Akku1_Relais_Pin);//PB4
	Stat_Akku2_Relais_Pin = digitalRead(Akku2_Relais_Pin);//PB0
		
	if (Voltage_in < 10.8 && Stat_Akku2_Relais_Pin == HIGH)
		{			
			while (beeper_counter < 4)
			{
				notice();
			}
			beeper_counter = 0;
			digitalWrite(Akku1_Relais_Pin, HIGH);
			delay(100);
			digitalWrite(Akku2_Relais_Pin, LOW);
			
			read_voltage_level();
			Stat_Reserve_Pin = digitalRead(Reserve_Pin);//PB1
			
			if (Voltage_in < 10.8 && Stat_Reserve_Pin == HIGH)
			{
				while (beeper_cutoff_counter < 60)
				{
					cutoff_notice();
				}
				beeper_cutoff_counter = 0;
				digitalWrite(Akku1_Relais_Pin, LOW);
			}
						
		}
	delay(10);
	
}

void read_voltage_level() {
	Voltage_raw = analogRead(UBatt_Pin);
	Voltage_R2 = ((Voltage_raw * Uref)/1024);	
	Voltage_in = Voltage_R2*6; //Teilverhaeltnis des Spannungsteiler: 10k + 49,9k = 59,9k / R2 (10k) = 6
}

void notice() {
	digitalWrite(Beeper_Pin, HIGH);
	delay(50);
	digitalWrite(Beeper_Pin, LOW);
	delay(50);
	beeper_counter++;
}

void cutoff_notice() {
	digitalWrite(Beeper_Pin, HIGH);
	delay(10);
	digitalWrite(Beeper_Pin, LOW);
	delay(10);
	beeper_cutoff_counter++;
}