

/*************************************************************************************

  Mark Bramwell, July 2010 for the LCD shield program
  Connection: Plug the LCD Keypad to the UNO(or other controllers)
  Joel Bartlett SparkFun Electronics Sept. 11, 2014 for the MCP4725 part

  PE3ES de Erwin Serlé - for the integration and use to generate waveforms and 
  create the Red Pitaya multiband WSPR amplifier control signal - February 2018

  For testing purposes this same programm can be used with the separate MCP4725 breakout board
  Be sure to change the I2C Bus Address to the breakout board adress

  Works with Arduino IDE 1.6.11
**************************************************************************************/

#include <LiquidCrystal.h>
LiquidCrystal lcd(8, 9, 4, 5, 6, 7);   // select the pins used on the LCD panel DF Robot LCD Keypad shield

#include <Wire.h>                       //Include the Wire library to talk I2C
//#define MCP4725_ADDR 0x63             //For devices with A0 pulled LOW, use 0x62 there are also version with 60 and 61
#define MCP4725_ADDR 0x60               //Address for the FA - Breitband Verstarker kann auch mit 0x61 über jumper
// define some values used by the panel and buttons
int lcd_key     = 0;
int adc_key_in  = 0;

#define btnRIGHT  0
#define btnUP     1
#define btnDOWN   2
#define btnLEFT   3
#define btnSELECT 4
#define btnNONE   5

int read_LCD_buttons(){               // read the buttons
    adc_key_in = analogRead(0);       // read the value from the sensor 

    if (adc_key_in > 1000) return btnNONE; 

     // changed values when using in combination with MCP
     if (adc_key_in < 70)   return btnRIGHT;  
     if (adc_key_in < 200)  return btnUP; 
     if (adc_key_in < 350)  return btnDOWN; 
     if (adc_key_in < 500)  return btnLEFT; 
     if (adc_key_in < 750)  return btnSELECT;   
   
    return btnNONE;      //when all others fail, return this.
}

    int val = 1048;       //variable for setting output of DAC
    int delta = 100;      //increment or decrement value of val, can be 10 or 100
    int sign = -1;        //+1 increment -1 decrement val
    int min = 0;          //lowest val
    int max = 4095;       //highest val
    
void setup(){
   lcd.begin(16, 2);                //start the library
   lcd.setCursor(0,0);              //set the LCD cursor position 
   lcd.print("Set MCP");            //print a simple message on the LCD

   lcd.setCursor(8,0);              //set the LCD cursor position 
   lcd.print("Delta");              //print a simple message on the LCD
   lcd.print(delta);
   
   lcd.setCursor(0,1);              //set the LCD cursor position 
   lcd.print("Value");              //print a simple message on the LCD
   lcd.print(val);
   
   lcd.setCursor(10,1);              //set the LCD cursor position 
   lcd.print("Sign");               //print a simple message on the LCD
   lcd.print(sign);
   
   Wire.begin();
   Wire.beginTransmission(MCP4725_ADDR);
   Wire.write(64);                      // cmd to update the DAC
   Wire.write(val >> 4);                // the 8 most significant bits...
   Wire.write((val & 15) << 4);         // the 4 least significant bits...
   Wire.endTransmission();

   delay(200);
}
  
void loop(){

   lcd.setCursor(0,0);
   lcd_key = read_LCD_buttons();   //read the buttons
   //lcd.print(adc_key_in);
   
   switch (lcd_key){               //depending on which button was pushed, we perform an action

       /*case btnRIGHT:{
            delta = 10;
            lcd.setCursor(8,0);              //set the LCD cursor position 
            lcd.print("Delta ");             //print delta on the LCD
            lcd.print(delta);
            break;
       }    
       RIGHT button is not very stable*/
       
       case btnLEFT:{             //push button "LEFT" and show the word on the screen
            lcd.setCursor(0,0);
            lcd.print("Commit");
            if ((val < max-100) && (val > min+100)){
              val = val + (sign*delta);}
            else{
              val = 2048;}
            
            lcd.setCursor(0,1);              //set the LCD cursor position 
            lcd.print(val);
            lcd.print(" Value");             //print val on the LCD
            delay(300);
            break;
            }
       case btnUP:{
            lcd.setCursor(0,0);              //set the LCD cursor position 
            lcd.print("UP  ");               //  push button "UP" and show the word on the screen
            sign = 1;
            lcd.setCursor(10,1);             //set the LCD cursor position 
            lcd.print("Sign ");              //print sign on the LCD
            lcd.print(sign);
            break;
       }
       case btnDOWN:{
            lcd.setCursor(0,0);               //set the LCD cursor position 
            lcd.print("DOWN");                //  push button "DOWN" and show the word on the screen
            sign = -1;
            lcd.setCursor(10,1);              //set the LCD cursor position 
            lcd.print("Sign");                //print sign on the LCD
            lcd.print(sign);
            break;
       }
       case btnSELECT:{
            if (delta == 100){
              delta=10;}
            else{
              delta=100;}
            lcd.setCursor(8,0);               //set the LCD cursor position 
            lcd.print(delta);
            lcd.print(" Delta");              //print delta on the LCD
            break;
       }
       case btnNONE:{
            lcd.setCursor(0,0);               //set the LCD cursor position 
            lcd.print(sign*delta);            //No action  will show delta value on the screen
            break;
       }
   }
    
    Wire.beginTransmission(MCP4725_ADDR);
            Wire.write(64);                     // cmd to update the DAC
            Wire.write(val >> 4);               // the 8 most significant bits...
            Wire.write((val & 15) << 4);        // the 4 least significant bits...
            Wire.endTransmission();
}
