// was EFRrxCtoSerLcdv01.c


#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/pgmspace.h>


#define F_CPU 20000000
#include <util/delay.h>






// Frontend parameters
//
// Md   number of input-sequence samples used until one I/Q-integration output 
//      value is generated by the ISR and put into the FIFO
//      values go at half-rate into downsampling two-stage CIC filters
//
// Ns   number of clock cycles between ADC sampling
//
// Mc   order of the smoothing CIC filter behind the downsampling
//
// P    the ouput of doIQsample routine from the FIFO is divided by P before
//      it enters the second CIC-Filter. This is used to prevent overflow
//      in the second CIC filter and in the CORDIC subroutine.
//
//      for scaling of frontend for correct uMean computation:
//      use :     (Mc/P) * (Md^2/2^2) == 32
//      for fast division P should be a power of 2
//
// (Mc/P) * (Md^2/2^2) = (4/2)*(8^2/2^2)=2*64/4=32



//#define Md  4
//#define Mc  4 
//#define P   2    

//DCF77
//#define Md  4
//#define Mc  64 
//#define P   32   

#define Md  4
#define Mc  16
#define P   8   


#define HEADLINE "EFR receiver Variant C MCP2306rxEFR1v01"

//----------------------------------------------------------------------------------------

#define modeMCP2306 4
uint8_t theMode=modeMCP2306  ;


//----------------------------------------------------------------------------------------

void delay_ms(uint16_t x){
  uint16_t k ;
  for (k=0 ; k<x ; k++ ) { _delay_loop_2(4000) ; }
  }

//----------------------------------------------------------------------------------------  

volatile int8_t DAC1,DAC2 ;

//----------------------------------------------------------------------------------------

uint8_t Clip ;
uint8_t ClipCount ;



void doClipCheck(){
  if (Clip) { 
//    redLedPort &= ~ _BV(redLedPin) ; 
	} 
   else { 
//    redLedPort |=  _BV(redLedPin) ; 
	}
  ClipCount++ ;
  ClipCount &= 0x0F ;
  // reset CLIP-FLAG all 16 steps
  if (ClipCount==0){ 
    Clip=0 ; 
	}
  }

//----------------------------------------------------------------------------------------
// signal stuff

uint16_t sampleTime ;
int16_t ADCv ;

//----------------------------------------------------------------------------------------
//----------------------------------------------------------------------------------------  


// generated by scaling with 65536.0 :: CORDIC1.PAS
int32_t iCordicSinTab[5]={25080L,12785L,6424L,3216L,1608L} ;
int32_t iCordicCosTab[5]={60547L,64277L,65220L,65457L,65516L} ;


int16_t Amplitude,LogAmplitude ;

uint8_t iCordic(int32_t x, int32_t y) {
// compute angle and radius of point (x,y)
// angle is valid from 0 to 255 (256 would mean 2*Pi )
// angle is stored in phi and returned via function
// radius is stored in Amplitude and mus be lower than 2^15-1
// warning, if x near 2^15 and y near 2^15 than radius is too big !

  int32_t s,c,x0,y0,x1,y1,tmp ;
  uint8_t sign,phi,phi1,phiTest,k_cordic ;

// first rotate until x0,y0 are in octant 0    
// 
  x0=x ; y0=y ;
  phi=0 ;
  if ( y0<0 ) { x0=-x0 ; y0=-y0 ; phi=128 ; }
  if ( x0<0 ) { tmp=x0 ; x0=y0 ; y0=-tmp ; phi +=  64 ; }
  sign=0 ;
  if (y0>x0) { sign=1 ; phi += 64 ; tmp=x0 ; x0=y0 ; y0=tmp ; }
  // now x0 >= y0 >=0
 
 // warning: this scales amplitude !! so leave out
 // while (x0>0x7fff) { x0=x0 >> 1 ; y0=y0 >> 1 ; }
 // now rotate in 4 SAR steps with phiTest=16,8,4,2,1
 // and check that x0,y0 stays in octant 0

  phiTest=16 ;
  phi1=0 ;
  k_cordic=0 ;
  while (k_cordic<=4){
    // get cosine(phiTest)=c and sine(phiTest)=ss from table
    c=iCordicCosTab[k_cordic] ;
    s=iCordicSinTab[k_cordic] ;
    // rotate (x0,y0) by phi into (x1,y1)
    x1=( c*x0+s*y0) / 65536L ;
    y1=(-s*x0+c*y0) / 65536L ;
    // change x0,y0 if valid rotation step meaning that we stay in octant 0
    if (y1>=0) { x0=x1 ; y0=y1 ; phi1 += phiTest; }
    phiTest = phiTest >> 1 ;
	k_cordic++ ;
    }
  Amplitude=x0 ;
  if (sign) { phi -= phi1 ; } else { phi += phi1 ; }
  return phi ;
  }

//----------------------------------------------------------------------------------------  
//

uint8_t LogTab[16]={ 0,9,17,25,32,39,46,52,58,64,70,75,81,86,91,95 } ;


uint16_t Log2(uint32_t x){
// compute 100*ld(x) , so Log2(1024) = 1000
  uint16_t v ;
  v=3100 ;
  // shift until a bit in MSB-byte is set, each byte shift reults in log += 800
  while ( (x&0xff000000L )==0 ) { x=x<<8 ; v -= 800 ; }
  // shift until most significant bit is set, each bit-shift results in log += 100
  while ( (x&0x80000000L )==0 ) { x=x<<1 ; v -= 100 ; }
  // x has now form 1iii ixxx xxxx xxxx xxxx xxxx xxxx xxxx
  // get the next 4 bits =iiii and address table with it
  uint8_t i=(x>>27) & 0xf ;
  v += LogTab[i] ;
  return v ;

}


//----------------------------------------------------------------------------------------

typedef int32_t CICtype  ;

volatile CICtype IIintegrator1 ;
volatile CICtype QQintegrator1 ;

volatile CICtype IIintegrator2 ;
volatile CICtype QQintegrator2 ;

volatile CICtype  IIsample ;
volatile CICtype  QQsample ;

#define IntFifoSize 8
#define IntFifoMask 0x07

volatile uint8_t IntFifoInPtr ;
volatile uint8_t IntFifoOutPtr ;
volatile CICtype  IntFifoII[IntFifoSize] ;
volatile CICtype  IntFifoQQ[IntFifoSize] ;

//----------------------------------------------------------------------------------------


void timer1Init(int Ns){
  TCCR1A=0b00000010 ; // fast pwm no output
  TCCR1B=0b00011001	; // ck=XTAL
  // Interupt enable for Timer1-Overflow
  TIMSK1=0b00000001 ;
  OCR1A=1000 ;
  ICR1=Ns-1 ; // sample period predivider

  IntFifoInPtr=0 ;
  IntFifoOutPtr=0 ;
  
  IIintegrator1=0 ;
  QQintegrator1=0 ;
  IIintegrator2=0 ;
  QQintegrator2=0 ;

  sampleTime=0 ;
  }

/*
ISR(TIMER1_OVF_vect) {
//   IO4port |=  _BV(IO4pin) ;
// get sample from input and convert to signed value
  ADCv=( (int16_t)ADC-512) ; 
// clip ADC value in order to detect ADC overflow
#define ADCMAX 500 
  if (ADCv > ADCMAX) { ADCv=ADCMAX ; Clip=1 ; }
  if (ADCv <-ADCMAX) { ADCv=-ADCMAX ;  Clip=1 ; }
// ADCv now is in -ADCMAX..ADCMAX
// multiply and sum samples with sequence 1  0  -1  0  1  0  -1  0  1  0 ... for I channel
// multiply and sum samples with sequence 0  1  0  -1  0  1  0  -1  0  1 ... for Q channel
// the summing directly is done as two stage intergration of a CIC filter.
// The CIC integration outputs are in IcicInt2 and QcicInt2
  if (sampleTime & 1) {
    if (sampleTime & 0b10) { IIintegrator1 += ADCv ; } else { IIintegrator1 -= ADCv ; }
    }
   else {
    if (sampleTime & 0b10) { QQintegrator1 += ADCv ; } else { QQintegrator1 -= ADCv ; }
	}
  sampleTime++ ;
// after 16 samples output I/Q values to DAC
  if (sampleTime==8) {
    sampleTime=0 ;
	OCR2A =128+ IIintegrator1/8 ;
    OCR2B =128+ QQintegrator1/8 ;
	IIintegrator1=0 ;
	QQintegrator1=0 ;

    }

//  IO4port &= ~ _BV(IO4pin) ;
  }
*/


ISR(TIMER1_OVF_vect) {
//   IO4port |=  _BV(IO4pin) ;
// get sample from input and convert to signed value
  ADCv=( (int16_t)ADC-512) ; 
// clip ADC value in order to detect ADC overflow
#define ADCMAX 500 
  if (ADCv > ADCMAX) { ADCv=ADCMAX ; Clip=1 ; }
  if (ADCv <-ADCMAX) { ADCv=-ADCMAX ;  Clip=1 ; }
// ADCv now is in -ADCMAX..ADCMAX
// multiply and sum samples with sequence 1  0  -1  0  1  0  -1  0  1  0 ... for I channel
// multiply and sum samples with sequence 0  1  0  -1  0  1  0  -1  0  1 ... for Q channel
// the summing directly is done as two stage intergration of a CIC filter.
// The CIC integration outputs are in IcicInt2 and QcicInt2
  if (sampleTime & 1) {
    if (sampleTime & 0b10) { IIintegrator1 += ADCv ; } else { IIintegrator1 -= ADCv ; }
	IIintegrator2 += IIintegrator1 ;
    }
   else {
    if (sampleTime & 0b10) { QQintegrator1 += ADCv ; } else { QQintegrator1 -= ADCv ; }
	QQintegrator2 += QQintegrator1 ; 
	}
  sampleTime++ ;

  OCR2A = DAC1 ;
  OCR2B = DAC2 ;
//  OCR2A = 128 ;
//  OCR2B = 128 ;

// after Md samples output I/Q values to FIFO 
  if (sampleTime==Md) {
    sampleTime=0 ;
// put CIC integration values downsampled by Md into FIFOs
    IntFifoII[IntFifoInPtr]=IIintegrator2 ;
	IntFifoQQ[IntFifoInPtr]=QQintegrator2 ;
	IntFifoInPtr=(IntFifoInPtr+1) & IntFifoMask ;
    }

//  IO4port &= ~ _BV(IO4pin) ;
  }




//----------------------------------------------------------------------------------------

CICtype IIcomb1store,IIcomb1out ;
CICtype IIcomb2store,IIcomb2out ;
CICtype QQcomb1store,QQcomb1out ;
CICtype QQcomb2store,QQcomb2out ;

int32_t IIfifo[Mc] ;
int32_t IIintegrator3 ;
int32_t IIcic3out ;

int32_t QQfifo[Mc] ;
int32_t QQintegrator3 ;
int32_t QQcic3out ;

uint8_t CICfifoPTR ;

#define SQlength 500
//#define SQlength 10
 
int32_t SQresultBuffer ;
int32_t SQresult ;
int32_t SQsum ;
int16_t	SQcount ;
uint8_t SQready ;

int32_t SQmax ;
int32_t SQmaxResult ;
int32_t SQiirFilter ;

void CICfifoINIT(){
  for ( CICfifoPTR=0 ; CICfifoPTR<Mc ; CICfifoPTR++){
    QQfifo[CICfifoPTR]=0 ;
    IIfifo[CICfifoPTR]=0 ;
    }
  CICfifoPTR=0 ;
  IIintegrator3=0 ;
  QQintegrator3=0 ;

  SQsum=0 ;
  SQcount=0 ;
  SQready=0 ;

  SQiirFilter=0 ;
  }


// doIQsample() fetches data from the I and Q FIFO
// these data are feed to the 2 stage COMB section of the CIC downsampling filter
// Phase and amplitude are then computed via a CORDIC-like rotation method
uint8_t CordicPhase ;

void doIQsample(){
// fetch data from FIFO
  IIsample=IntFifoII[IntFifoOutPtr] ;
  QQsample=IntFifoQQ[IntFifoOutPtr] ;
  IntFifoOutPtr=(IntFifoOutPtr+1) & IntFifoMask ;
// do 1.st comb-step of two stage downsampling CIC filter
  IIcomb1out=IIcomb1store-IIsample ; IIcomb1store=IIsample ; 
  QQcomb1out=QQcomb1store-QQsample ; QQcomb1store=QQsample ; 
// do 2.nd comb-step of two stage downampling CIC filter
  IIcomb2out=IIcomb2store-IIcomb1out ; IIcomb2store=IIcomb1out ; 
  QQcomb2out=QQcomb2store-QQcomb1out ; QQcomb2store=QQcomb1out ; 
// IcombOutb and QcombOutb are now the downsampled filtered I and Q channel values.
// these go now to a further 1-stage smoothing CIC filter of order Mc,
// but no further downsampling occurs

// integration step of smoothing CIC filter I-channel
  IIintegrator3 += IIcomb2out / P ;
// comb staep of smoothing CIC filter
  IIcic3out = IIintegrator3 - IIfifo[CICfifoPTR] ;
// FIFO update of smoothing CIC filter
  IIfifo[CICfifoPTR] =  IIintegrator3 ;
// same for I-channel
  QQintegrator3 += QQcomb2out / P ;
  QQcic3out = QQintegrator3 - QQfifo[CICfifoPTR] ;
  QQfifo[CICfifoPTR] =  QQintegrator3 ;
// advance pointer and bump around
  CICfifoPTR++ ; if ( CICfifoPTR==Mc ) { CICfifoPTR=0 ; }
// CICfifoIout and CICfifoQout are now the triple filtered I and Q channel values
// these are used to compute phase and amplitude using a CORDIC method
  CordicPhase=iCordic( IIcic3out , QQcic3out ) ;
   LogAmplitude=Log2(Amplitude+1) ; 
 // DAC1 = 128+IIcic3out/4 ;
 // DAC2 = 128+QQcic3out/4 ;

  int16_t x1=(LogAmplitude-390)/4 ;
  if (x1<0) { x1=0 ; }
  if (x1>255) { x1=255 ; }

  DAC1 = x1 ;
  DAC2 = CordicPhase ;

  //DAC1 = 128 ;
  //DAC2 = 128 ;

//  IO2port |=  _BV(IO2pin) ;

  uint32_t tmp=(IIcic3out*IIcic3out+QQcic3out*QQcic3out)/16 ;
  if (tmp>SQmax){ SQmax=tmp ; }
  SQsum += tmp ;
  SQcount += 1 ;
  if ( SQcount==SQlength){
    SQresultBuffer=SQsum ;
    SQsum=0 ;
	SQcount=0 ;
	SQready=1 ;
	SQmaxResult=SQmax ;
	SQmax=0 ;
    }

  }

//----------------------------------------------------------------------------------------

void timer2Init(){
  // Timer 2 BitClk
  TCCR2A=0b10100011 ; // fast pwm top=0xFF OC2A=pin 17/28 OC2B=pin 5/28
  //TCCR2B=0b00000010 ; // prescale by 8 
   TCCR2B=0b00000001 ; // prescale by 1 
  OCR2A=50; 
  OCR2B=150 ; 
  }



//----------------------------------------------------------------------------------------  


void switchRefTo1V1(){
  ADMUX =0b11000000 ; // Vref=1.1V
  }







//----------------------------------------------------------------------------------------


void timer0Init(){

  TCCR0A=0b00100011 ; // fast pwm  output OCR0B OC0B=PD5 pin 11of28
  TCCR0B=0b00001001	; // ck=XTAL
// 77.5 kHz
  OCR0B=126 ;
  OCR0A=254-1 ; // sample period predivider 

// 162 kHz
//  OCR0B=62 ;
//  OCR0A=125-1 ; 
// 147.3 kHz
//  OCR0B=67 ;
//  OCR0A=134-1 ;


  }

//----------------------------------------------------------------------------------------

uint16_t getNsfromMode(){
  return 4032-1  ; // DCF
 // return 2500+1  ; // TDF
  //return 2559  ; // TDF
  }

//----------------------------------------------------------------------------------------



void doRXoperation(){
   
  if ( IntFifoInPtr!=IntFifoOutPtr ) { 
    doIQsample() ; 
    doClipCheck() ;
    }
  if (SQready){
	cli() ;
	SQresult= SQresultBuffer ;
	//SQresult=SQmaxResult ;
	sei() ;
	SQready=0 ;
	//SQresult=SQresult/SQlength ;
	//SQresult=(147UL*SQresult)/5 ;
	#ifdef withRSSI
    SQiirFilter=(800*SQiirFilter+200*SQresult)/1000 ;
    uartPutc(13) ;	uartPutc(':') ;	uartDecOut32(SQresult) ; uartPutc(';') ;
	//uint16_t display=Log2(SQiirFilter) ;
	uartPutc(13) ;
	//uartCrlf() ;
	//uartPutc(':') ;	uartDecOut(display ) ; uartPutc(';') ;
	crWasThere=0 ;
    #endif
	}
  }

void doNormalOperation(){
  while (1){ 
   
	  ICR1=getNsfromMode()-1 ;
	  doRXoperation() ;

    }
  }

//----------------------------------------------------------------------------------------  

int main(){

  DDRD =0b11111111 ; // enable outputs , bit 0,1=input
  PORTD=0b11111111 ; // pullups on on input pins
  
  DDRB =0b11111111 ; // enable outputs 
  PORTB=0b11111111 ; // pullups on on input pins
  
  //DDRC =0b11001110 ; // enable outputs , bit 0=input
  //PORTC=0b11111110 ; // pullups off on ADC pins

  DDRC =0b11001110 ; // enable outputs , bit 0=input
  PORTC=0b11111110 ; // pullups off on ADC pin

  ADMUX =0b11000000 ; // Vref=1.1V
  ADCSRA=0b10100111 ; // 20MHz/128=156.25kHz    /13=12.019kHz = max sample frequency
  ADCSRB=0b00000110 ; // timer/counter1 overflow is trigger
 
// 20.00MHz/19200/16=65 use 19200 bit/sec UBRRL=64
// 20.00MHz/57600/16=22 use 57600 bit/sec UBRRL=21 gives 56818...= 0.9864*57600
  UCSR0B |= ( 1 << TXEN0 );					// UART TX einschalten
  // UCSR0C |= ( 1 << URSEL )|( 3<<UCSZ0 );	    // Asynchron 8N1
  UBRR0H  = 0;                               // Highbyte ist 0
  //UBRR0L  = 22-1 ;                             // 57600 Bit/sec
  UBRR0L  = 65-1 ;                             // 19200 Bit/sec

// UBRR0L  = 11-1 ;                             // 115200 Bit/sec

//  uartSnd2(' ') ;
//  uartSnd2(0x80+0x40) ;
//  uartPutsPgm2(PSTR(HEADLINE)) ;
//  uartCrlf() ;

/*
timer0Init() ;
timer1Init(getNsfromMode()) ;
timer2Init() ;
sei() ;
  while(1){} ;
*/




//  while(1){} ;

  timer0Init() ;

  
  timer1Init(getNsfromMode() ) ;
  timer2Init() ;
  CICfifoINIT() ;
  //softUartInit() ;
  //msgFSMreset1() ;
 //  sei() ;
 // while(1){
    
   // delay_ms(200) ;
//	}




 

/*
  while(1){
    flushUartFifo() ; // no interrupts here so far!
	delay_ms(500) ;
uartCrlf() ;
	if (JP1Pinp & _BV(JP1Pin)) { uartPutc('H') ; } else { uartPutc('L') ; } ;
	if (JP2Pinp & _BV(JP2Pin)) { uartPutc('H') ; } else { uartPutc('L') ; } ;
	uartPutc(' ') ;
    getModeFromswitch() ;
	showMode() ;
	
	}

  while(1){} ;
*/

  //redLedPort &= ~ _BV(redLedPin) ; while(1){} ;

  sei() ;
  doNormalOperation() ;
  return(0) ;
  }
