#include <avr/io.h>
#include <avr/pgmspace.h>


// generated by scaling with 65536.0 :: CORDIC1.PAS
int32_t iCordicSinTab[5]={25080L,12785L,6424L,3216L,1608L} ;
int32_t iCordicCosTab[5]={60547L,64277L,65220L,65457L,65516L} ;


int16_t CordicAmplitude ;

int16_t GetCordicAmplitude(){
  return CordicAmplitude  ;
  }

uint8_t iCordic(int32_t x, int32_t y) {
// compute angle and radius of point (x,y)
// angle is valid from 0 to 255 (256 would mean 2*Pi )
// angle is stored in phi and returned via function
// radius is stored in Amplitude and mus be lower than 2^15-1
// warning, if x near 2^15 and y near 2^15 than radius is too big !

  int32_t s,c,x0,y0,x1,y1,tmp ;
  uint8_t sign,phi,phi1,phiTest,k_cordic ;

// first rotate until x0,y0 are in octant 0    
// 
  x0=x ; y0=y ;
  phi=0 ;
  if ( y0<0 ) { x0=-x0 ; y0=-y0 ; phi=128 ; }
  if ( x0<0 ) { tmp=x0 ; x0=y0 ; y0=-tmp ; phi +=  64 ; }
  sign=0 ;
  if (y0>x0) { sign=1 ; phi += 64 ; tmp=x0 ; x0=y0 ; y0=tmp ; }
  // now x0 >= y0 >=0
 
 // warning: this scales amplitude !! so leave out
 // while (x0>0x7fff) { x0=x0 >> 1 ; y0=y0 >> 1 ; }
 // now rotate in 4 SAR steps with phiTest=16,8,4,2,1
 // and check that x0,y0 stays in octant 0

  phiTest=16 ;
  phi1=0 ;
  k_cordic=0 ;
  while (k_cordic<=4){
    // get cosine(phiTest)=c and sine(phiTest)=ss from table
    c=iCordicCosTab[k_cordic] ;
    s=iCordicSinTab[k_cordic] ;
    // rotate (x0,y0) by phi into (x1,y1)
    x1=( c*x0+s*y0) / 65536L ;
    y1=(-s*x0+c*y0) / 65536L ;
    // change x0,y0 if valid rotation step meaning that we stay in octant 0
    if (y1>=0) { x0=x1 ; y0=y1 ; phi1 += phiTest; }
    phiTest = phiTest >> 1 ;
	k_cordic++ ;
    }
  CordicAmplitude=x0 ;
  if (sign) { phi -= phi1 ; } else { phi += phi1 ; }
  return phi ;
  }

//
//----------------------------------------------------------------------------------------  
//

uint8_t LogTab[16]={ 0,9,17,25,32,39,46,52,58,64,70,75,81,86,91,95 } ;


uint16_t Log2(uint32_t x){
// compute 100*ld(x) , so Log2(1024) = 1000
  uint16_t v ;
  v=3100 ;
  // shift until a bit in MSB-byte is set, each byte shift reults in log += 800
  while ( (x&0xff000000L )==0 ) { x=x<<8 ; v -= 800 ; }
  // shift until most significant bit is set, each bit-shift results in log += 100
  while ( (x&0x80000000L )==0 ) { x=x<<1 ; v -= 100 ; }
  // x has now form 1iii ixxx xxxx xxxx xxxx xxxx xxxx xxxx
  // get the next 4 bits =iiii and address table with it
  uint8_t i=(x>>27) & 0xf ;
  v += LogTab[i] ;
  return v ;
  }


//----------------------------------------------------------------------------------------
