#include <avr/io.h>
#include <avr/pgmspace.h>

#include "RS232LIB.h"
#include "LCDLIB.h"
#include "FORMATLIB.h"


//----------------------------------------------------------------------------------------  

uint8_t TheBits[60] ;

void putDCFbit(uint8_t TheSecond , uint8_t TheBit){
  if (TheSecond<60) { TheBits[TheSecond]=TheBit ; }
  }

uint8_t ParityBit,P1,P2,P3 ;

uint8_t getBCD(uint8_t BitPos , uint8_t BitCount){
  uint8_t value ;
  uint8_t k,q ;
  value=0 ;
  q=1 ;
  for (k=0 ; k<BitCount ; k++ ) { 
    if ( TheBits[BitPos++] ) { value += q ; ParityBit ^= 1 ; }
	q=2*q ;
	}
  return value ;
  }


void DisplayTime(){
  uint8_t min1 ;
  uint8_t min10 ;
  uint8_t hrs1 ;
  uint8_t hrs10 ;
  uint8_t day1 ;
  uint8_t day10 ;
  uint8_t month1 ;
  uint8_t month10 ;
  uint8_t weekday ;
  uint8_t year1 ;
  uint8_t year10 ;

 
  ParityBit=0 ;
  min1=getBCD(21,4) ;
  min10=getBCD(25,3) ;
  P1=ParityBit ^ TheBits[28] ;

  ParityBit=0 ;       
  hrs1=getBCD(29,4) ;
  hrs10=getBCD(33,2) ;
  P2=ParityBit ^ TheBits[35] ;
           
  ParityBit=0 ;     
  day1=getBCD(36,4) ;
  day10=getBCD(40,2) ;
  weekday=getBCD(42,3) ;
  month1=getBCD(45,4) ;
  month10=getBCD(49,1) ;
  year1=getBCD(50,4) ;
  year10=getBCD(54,4) ;
  P3=ParityBit ^ TheBits[58] ;

  uartPutc(':') ;  
  uartPutc(' ') ;  
 
  uartPutc('0'+hrs10) ;
  uartPutc('0'+hrs1) ;
  uartPutc(':') ;
  uartPutc('0'+min10) ;
  uartPutc('0'+min1) ;
  uartBlank() ;
  uartPutc('0'+day10) ;
  uartPutc('0'+day1) ;
  uartPutc('.') ;

  uartPutc('0'+month10) ;
  uartPutc('0'+month1) ;
  uartPutc(' ') ;
	
  if ( weekday==1) {  uartPutsPgm(PSTR("MONDAY   ")) ; }  
  if ( weekday==2) {  uartPutsPgm(PSTR("TUESDAY  ")) ; }
  if ( weekday==3) {  uartPutsPgm(PSTR("WEDNESDAY")) ; }
  if ( weekday==4) {  uartPutsPgm(PSTR("THURSDAY ")) ; }
  if ( weekday==5) {  uartPutsPgm(PSTR("FRIDAY   ")) ; }
  if ( weekday==6) {  uartPutsPgm(PSTR("SATURDAY ")) ; }
  if ( weekday==7) {  uartPutsPgm(PSTR("SUNDAY   ")) ; }
  uartBlank() ;
  uartPutc('2') ;
  uartPutc('0') ;
  uartPutc('0'+year10) ;
  uartPutc('0'+year1) ;
  uartBlank() ;
  uartPutc('p') ;
  uartPutc('0'+P1) ;
  uartPutc('0'+P2) ;
  uartPutc('0'+P3) ;

  uartCrlf() ; 
  }

//----------------------------------------------------------------------------------------
