
#include <avr/io.h>
#include <avr/pgmspace.h>


#include "RS232LIB.h"

//
// RS232 TX routines


volatile uint8_t uartFIFO[UARTSIZE] ;
// for atomic read/write the following must be 1-Byte variables
volatile uint8_t uartPUTidx ;
volatile uint8_t uartGETidx ;

void uartFIFOinit(){
// uartPutidx==uartGETidx signals FIFO is empty
  uartPUTidx=0 ;
  uartGETidx=0 ;
  }

void uartPutc(char c){
// put char into FIFO and output later via doIQsample()
  uartFIFO[uartPUTidx]=c ;
// the following write to uartPUTidx is atomic, so even an interrupt in
// between may happen without fault
  uartPUTidx=(uartPUTidx+1) & UARTMASK ;
  }


// serve UART from uartFIFO in between if data is in FIFO and uart-reg empty
void uartServe(){
  uint8_t c ;
  if ( (uartPUTidx != uartGETidx) & ((UCSR0A & (1<<UDRE0))!=0) ) {
    c=uartFIFO[uartGETidx] ;
	uartGETidx=(uartGETidx+1) & UARTMASK ;
	UDR0 = c;  
    }
  }



// direct output
int uartSend(unsigned char c){
   while (!(UCSR0A & (1<<UDRE0))); 
   UDR0 = c;                      
   return 0;
   }

void uartPutsPgm(const char *progmem_s){
  register char c;
  while ( (c = pgm_read_byte(progmem_s++)) ) { 
    uartPutc(c); 
	}
  }

void uartBlank(){
  uartPutc(' ') ; 
  }

void uartCrlf(){
  uartPutc(13) ; 
  uartPutc(10) ;
  }

void uartLf(){
  uartPutc(13) ; 
  }

void uartHex(uint8_t v){
  v &=0b00001111 ;
  if (v<=9) { uartPutc('0'+v) ; } 
       else { uartPutc(v+'A'-10) ; } ;
  }

void uartByte(uint8_t v){
  uartHex(v>>4) ; 
  uartHex(v) ; 
  }

void uartWord(uint16_t v){
  uartByte(v>>8) ; 
  uartByte(v) ; 
  }

void uartUint32(uint32_t v){
  uartWord(v>>16) ; 
  uartWord(v) ; 
  }
