#include <avr/io.h>
#include <avr/pgmspace.h>


#include "RS232LIB.h"
#include "LCDLIB.h"
#include "FORMATLIB.h"

char NumBuffer[NumBufferLength] ;

void NumberFormat(long x , int8_t DPpos , uint8_t Signed ){
 // 2^32=4294967296 = 10 digits ;
  int8_t k,k1,SignPos ;
  uint8_t d ;
  char SignChar ;
  SignChar=' ' ;
  if ( Signed ){
    SignChar='+' ;
	if ( x<0 ) { x=-x ; SignChar='-' ; }
	}

  for (k=0 ; k<NumBufferLength ; k++ ) {
    NumBuffer[k]='0' ;
    }
  for (k=0 ; k<10 ; k++ ) {
    d=x % 10 ;
	x=x/10 ;
	if (k>=DPpos) { k1=k+1 ; } else {k1=k ; }
	NumBuffer[k1]=d+'0' ;
	}
  if ( (DPpos>=0) & ( DPpos<NumBufferLength) ) {
    NumBuffer[DPpos]='.' ;
	}
  

  k=NumBufferLength ;
  while(1){
    k-- ; // advance to next position
	if ( k<1 ) { SignPos=k+1 ;  break ; }
	if( NumBuffer[k] != '0' ) { SignPos=k+1 ; break ; }
    if ( NumBuffer[k-1]=='.') { SignPos=k+1 ; break ; }
    NumBuffer[k]=' ' ;
    }
  NumBuffer[SignPos]=SignChar ;
}


void uartNumOut(long x , int8_t DPpos , uint8_t Signed ,uint8_t Digits ){
  int8_t k ;
  NumberFormat( x , DPpos , Signed ) ;
  if ( Digits>NumBufferLength ) { Digits=NumBufferLength ; }
    for (k=Digits-1 ; k>=0 ; k--){ 
    uartPutc(NumBuffer[k]);
	}
  }



/*
void check() {

  #define Xtrue 1
  #define Digits 7
  NumOut(1234567891L,3,Xtrue,Digits) ;
  NumOut(1234567891L,0,Xtrue,Digits) ;
  NumOut(1234567891L,20,Xtrue,Digits) ;
  NumOut(0L,3,Xtrue,Digits) ;
  NumOut(0L,0,Xtrue,Digits) ;
  NumOut(0L,20,Xtrue,Digits) ;
  NumOut(123L,3,Xtrue,Digits) ;
  NumOut(123L,0,Xtrue,Digits) ;
  NumOut(123L,20,Xtrue,Digits) ;
  NumOut(-123L,3,Xtrue,Digits) ;
  NumOut(-123L,0,Xtrue,Digits) ;
  NumOut(-123L,20,Xtrue,Digits) ;
  }
*/
