// was EFRrxCtoSerLcdv01.c


#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/pgmspace.h>


#define F_CPU 20000000
#include <util/delay.h>

#include "RS232com1.h" 
#include "CP56messageDecode.h"
#include "EFRframeDecode.h"
#include "InternalUart.h"
#include "options.h"
#include "main.h"

// Use compiler option -O1

// port b0 pin14 = clipled

// PORTD.4 pin 6 show ISR1 timing
// PORTD.3 pin 5 show doIQsample timing
// PORTB.7 pin 10 

// D.3 is also OC2B
// use here for f output


// Frontend parameters
//
// Md   number of input-sequence samples used until one I/Q-integration output 
//      value is generated by the ISR and put into the FIFO
//      values go at half-rate into downsampling two-stage CIC filters
//
// Ns   number of clock cycles between ADC sampling
//
// Mc   order of the smoothing CIC filter behind the downsampling
//
// P    the ouput of doIQsample routine from the FIFO is divided by P before
//      it enters the second CIC-Filter. This is used to prevent overflow
//      in the second CIC filter and in the CORDIC subroutine.
//
//      for scaling of frontend for correct uMean computation:
//      use :     (Mc/P) * (Md^2/2^2) == 32
//      for fast division P should be a power of 2
//
// (Mc/P) * (Md^2/2^2) = (4/2)*(8^2/2^2)=2*64/4=32



#define Md  4
#define Mc  4 
#define P   2    
#define FRQlength 8
#define HEADLINE "EFR receiver Variant C MCP2306rxEFR1v01"

#define Ns 2921  
//----------------------------------------------------------------------------------------


//----------------------------------------------------------------------------------------  
extern volatile uint8_t uartFIFO[256] ;
extern volatile uint8_t uartPUTidx ;
extern volatile uint8_t uartGETidx ;

extern uint8_t crWasThere ;
//----------------------------------------------------------------------------------------
uint8_t LogTab[16]={ 0,9,17,25,32,39,46,52,58,64,70,75,81,86,91,95 } ;


uint16_t Log2(uint32_t x){
// compute 100*ld(x) , so Log2(1024) = 1000
  uint16_t v ;
  v=3100 ;
  // shift until a bit in MSB-byte is set, each byte shift reults in log += 800
  while ( (x&0xff000000L )==0 ) { x=x<<8 ; v -= 800 ; }
  // shift until most significant bit is set, each bit-shift results in log += 100
  while ( (x&0x80000000L )==0 ) { x=x<<1 ; v -= 100 ; }
  // x has now form 1iii ixxx xxxx xxxx xxxx xxxx xxxx xxxx
  // get the next 4 bits =iiii and address table with it
  uint8_t i=(x>>27) & 0xf ;
  v += LogTab[i] ;
  return v ;
  }


//----------------------------------------------------------------------------------------



void delay_ms(uint16_t x){
  uint16_t k ;
  for (k=0 ; k<x ; k++ ) { _delay_loop_2(4000) ; }
  }


//----------------------------------------------------------------------------------------  

volatile int8_t DAC1,DAC2 ;

//----------------------------------------------------------------------------------------

uint8_t Clip ;
uint8_t ClipCount ;



void doClipCheck(){
  if (Clip) { 
//    redLedPort &= ~ _BV(redLedPin) ; 
	} 
   else { 
//    redLedPort |=  _BV(redLedPin) ; 
	}
  ClipCount++ ;
  ClipCount &= 0x0F ;
  // reset CLIP-FLAG all 16 steps
  if (ClipCount==0){ 
    Clip=0 ; 
	}
  }

//----------------------------------------------------------------------------------------
// signal stuff

uint16_t sampleTime ;
int16_t ADCv ;

//----------------------------------------------------------------------------------------

typedef int32_t CICtype  ;

volatile CICtype IIintegrator1 ;
volatile CICtype QQintegrator1 ;

volatile CICtype IIintegrator2 ;
volatile CICtype QQintegrator2 ;

volatile CICtype  IIsample ;
volatile CICtype  QQsample ;

#define IntFifoSize 8
#define IntFifoMask 0x07

volatile uint8_t IntFifoInPtr ;
volatile uint8_t IntFifoOutPtr ;
volatile CICtype  IntFifoII[IntFifoSize] ;
volatile CICtype  IntFifoQQ[IntFifoSize] ;

//----------------------------------------------------------------------------------------


void timer1Init(){
  TCCR1A=0b00000010 ; // fast pwm no output
  TCCR1B=0b00011001	; // ck=XTAL
  // Interupt enable for Timer1-Overflow
  TIMSK1=0b00000001 ;
  OCR1A=1000 ;
  ICR1=Ns-1 ; // sample period predivider

  IntFifoInPtr=0 ;
  IntFifoOutPtr=0 ;
  
  IIintegrator1=0 ;
  QQintegrator1=0 ;
  IIintegrator2=0 ;
  QQintegrator2=0 ;

  sampleTime=0 ;
  }

/*
ISR(TIMER1_OVF_vect) {
//   IO4port |=  _BV(IO4pin) ;
// get sample from input and convert to signed value
  ADCv=( (int16_t)ADC-512) ; 
// clip ADC value in order to detect ADC overflow
#define ADCMAX 500 
  if (ADCv > ADCMAX) { ADCv=ADCMAX ; Clip=1 ; }
  if (ADCv <-ADCMAX) { ADCv=-ADCMAX ;  Clip=1 ; }
// ADCv now is in -ADCMAX..ADCMAX
// multiply and sum samples with sequence 1  0  -1  0  1  0  -1  0  1  0 ... for I channel
// multiply and sum samples with sequence 0  1  0  -1  0  1  0  -1  0  1 ... for Q channel
// the summing directly is done as two stage intergration of a CIC filter.
// The CIC integration outputs are in IcicInt2 and QcicInt2
  if (sampleTime & 1) {
    if (sampleTime & 0b10) { IIintegrator1 += ADCv ; } else { IIintegrator1 -= ADCv ; }
    }
   else {
    if (sampleTime & 0b10) { QQintegrator1 += ADCv ; } else { QQintegrator1 -= ADCv ; }
	}
  sampleTime++ ;
// after 16 samples output I/Q values to DAC
  if (sampleTime==8) {
    sampleTime=0 ;
	OCR2A =128+ IIintegrator1 ;
    OCR2B =128+ QQintegrator1 ;
	IIintegrator1=0 ;
	QQintegrator1=0 ;

    }

//  IO4port &= ~ _BV(IO4pin) ;
  }
*/
// for 500Hz sample generation
volatile uint8_t ClkMail1000 ;
#define TTT 20000
uint16_t Ticks1000 ;
 

ISR(TIMER1_OVF_vect) {
//   IO4port |=  _BV(IO4pin) ;
// get sample from input and convert to signed value
  ADCv=( (int16_t)ADC-512) ; 
// clip ADC value in order to detect ADC overflow
#define ADCMAX 500 
  if (ADCv > ADCMAX) { ADCv=ADCMAX ; Clip=1 ; }
  if (ADCv <-ADCMAX) { ADCv=-ADCMAX ;  Clip=1 ; }
// ADCv now is in -ADCMAX..ADCMAX
// multiply and sum samples with sequence 1  0  -1  0  1  0  -1  0  1  0 ... for I channel
// multiply and sum samples with sequence 0  1  0  -1  0  1  0  -1  0  1 ... for Q channel
// the summing directly is done as two stage intergration of a CIC filter.
// The CIC integration outputs are in IcicInt2 and QcicInt2
  if (sampleTime & 1) {
    if (sampleTime & 0b10) { IIintegrator1 += ADCv ; } else { IIintegrator1 -= ADCv ; }
	IIintegrator2 += IIintegrator1 ;
    }
   else {
    if (sampleTime & 0b10) { QQintegrator1 += ADCv ; } else { QQintegrator1 -= ADCv ; }
	QQintegrator2 += QQintegrator1 ; 
	}
  sampleTime++ ;
// serve UART from uartFIFO in between if data is in FIFO and uart-reg empty
  if ( (uartPUTidx != uartGETidx) & ((UCSR0A & (1<<UDRE0))!=0) ) {
    uint8_t c=uartFIFO[uartGETidx] ;
	uartGETidx=(uartGETidx+1) & UARTMASK ;
	UDR0 = c;  
    }
  OCR2A = DAC1 ;
  OCR2B = DAC2 ;
//  OCR2A = 128 ;
//  OCR2B = 128 ;

// after Md samples output I/Q values to FIFO 
  if (sampleTime==Md) {
    sampleTime=0 ;
// put CIC integration values downsampled by Md into FIFOs
    IntFifoII[IntFifoInPtr]=IIintegrator2 ;
	IntFifoQQ[IntFifoInPtr]=QQintegrator2 ;
	IntFifoInPtr=(IntFifoInPtr+1) & IntFifoMask ;
    }
  PORTD &= ~ _BV(2) ;  

  Ticks1000 += Ns ;
  if(Ticks1000>=TTT) {
 	ClkMail1000=1 ;  
//	 ticks1000++ ;
	Ticks1000 -= TTT ;
	PORTD |= _BV(2) ;
    } 

//  IO4port &= ~ _BV(IO4pin) ;
  }




//----------------------------------------------------------------------------------------

int32_t FRQfifo[FRQlength] ;
int32_t FRQintegrator ;
int32_t FRQcicout ;
uint8_t FRQfifoPTR ;

void FRQfilterInit(){
  for ( FRQfifoPTR=0 ; FRQfifoPTR<FRQlength ; FRQfifoPTR++){
    FRQfifo[FRQfifoPTR]=0 ;
    }
  FRQfifoPTR=0 ;
  FRQintegrator=0 ;
  }

CICtype IIcomb1store,IIcomb1out ;
CICtype IIcomb2store,IIcomb2out ;
CICtype QQcomb1store,QQcomb1out ;
CICtype QQcomb2store,QQcomb2out ;

int32_t IIfifo[Mc] ;
int32_t IIintegrator3 ;
int32_t IIcic3out ;

int32_t QQfifo[Mc] ;
int32_t QQintegrator3 ;
int32_t QQcic3out ;

uint8_t CICfifoPTR ;

#define SQlength 500
//#define SQlength 10
 
int32_t SQresultBuffer ;
int32_t SQresult ;
int32_t SQsum ;
int16_t	SQcount ;
uint8_t SQready ;

int32_t SQmax ;
int32_t SQmaxResult ;
int32_t SQiirFilter ;

void CICfifoINIT(){
  for ( CICfifoPTR=0 ; CICfifoPTR<Mc ; CICfifoPTR++){
    QQfifo[CICfifoPTR]=0 ;
    IIfifo[CICfifoPTR]=0 ;
    }
  CICfifoPTR=0 ;
  IIintegrator3=0 ;
  QQintegrator3=0 ;

  SQsum=0 ;
  SQcount=0 ;
  SQready=0 ;

  SQiirFilter=0 ;
  }


// Generated by:  SINtable-V01.lua
prog_int16_t SinTab []={ 
      0,    804,   1608,   2410,   3212,   4011,   4808,   5602,
   6393,   7179,   7962,   8739,   9512,  10278,  11039,  11793,
  12539,  13279,  14010,  14732,  15446,  16151,  16846,  17530,
  18204,  18868,  19519,  20159,  20787,  21403,  22005,  22594,
  23170,  23731,  24279,  24811,  25329,  25832,  26319,  26790,
  27245,  27683,  28105,  28510,  28898,  29268,  29621,  29956,
  30273,  30571,  30852,  31113,  31356,  31580,  31785,  31971,
  32137,  32285,  32412,  32521,  32609,  32678,  32728,  32757,
  32767,  32757,  32728,  32678,  32609,  32521,  32412,  32285,
  32137,  31971,  31785,  31580,  31356,  31113,  30852,  30571,
  30273,  29956,  29621,  29268,  28898,  28510,  28105,  27683,
  27245,  26790,  26319,  25832,  25329,  24811,  24279,  23731,
  23170,  22594,  22005,  21403,  20787,  20159,  19519,  18868,
  18204,  17530,  16846,  16151,  15446,  14732,  14010,  13279,
  12539,  11793,  11039,  10278,   9512,   8739,   7962,   7179,
   6393,   5602,   4808,   4011,   3212,   2410,   1608,    804,
      0,   -804,  -1608,  -2410,  -3212,  -4011,  -4808,  -5602,
  -6393,  -7179,  -7962,  -8739,  -9512, -10278, -11039, -11793,
 -12539, -13279, -14010, -14732, -15446, -16151, -16846, -17530,
 -18204, -18868, -19519, -20159, -20787, -21403, -22005, -22594,
 -23170, -23731, -24279, -24811, -25329, -25832, -26319, -26790,
 -27245, -27683, -28105, -28510, -28898, -29268, -29621, -29956,
 -30273, -30571, -30852, -31113, -31356, -31580, -31785, -31971,
 -32137, -32285, -32412, -32521, -32609, -32678, -32728, -32757,
 -32767, -32757, -32728, -32678, -32609, -32521, -32412, -32285,
 -32137, -31971, -31785, -31580, -31356, -31113, -30852, -30571,
 -30273, -29956, -29621, -29268, -28898, -28510, -28105, -27683,
 -27245, -26790, -26319, -25832, -25329, -24811, -24279, -23731,
 -23170, -22594, -22005, -21403, -20787, -20159, -19519, -18868,
 -18204, -17530, -16846, -16151, -15446, -14732, -14010, -13279,
 -12539, -11793, -11039, -10278,  -9512,  -8739,  -7962,  -7179,
  -6393,  -5602,  -4808,  -4011,  -3212,  -2410,  -1608,   -804
  } ;

uint8_t actualPhi ;
uint8_t phi ;
int16_t sinVal ;
int16_t cosVal ;
//int8_t PhaseDifference ;
int16_t dPhi ;


int16_t demodValue ;

int32_t minTest ;
int32_t test ;

int32_t testVal(int8_t Delta){  
	phi=actualPhi+Delta ;
    sinVal=pgm_read_word( SinTab+phi ) ;
    phi=phi+64 ;
    cosVal=pgm_read_word( SinTab+phi ) ;
    int32_t test1=(int32_t)IIcic3out*(int32_t)sinVal+(int32_t)QQcic3out*(int32_t)cosVal ;
	return test1 ;  
    }

// doIQsample() fetches data from the I and Q FIFO
// these data are feed to the 2 stage COMB section of the CIC downsampling filter
// Phase and amplitude are then computed via a CORDIC-like rotation method

void doIQsample(){
// fetch data from FIFO
  IIsample=IntFifoII[IntFifoOutPtr] ;
  QQsample=IntFifoQQ[IntFifoOutPtr] ;
  IntFifoOutPtr=(IntFifoOutPtr+1) & IntFifoMask ;
// do 1.st comb-step of two stage downsampling CIC filter
  IIcomb1out=IIcomb1store-IIsample ; IIcomb1store=IIsample ; 
  QQcomb1out=QQcomb1store-QQsample ; QQcomb1store=QQsample ; 
// do 2.nd comb-step of two stage downampling CIC filter
  IIcomb2out=IIcomb2store-IIcomb1out ; IIcomb2store=IIcomb1out ; 
  QQcomb2out=QQcomb2store-QQcomb1out ; QQcomb2store=QQcomb1out ; 
// IcombOutb and QcombOutb are now the downsampled filtered I and Q channel values.
// these go now to a further 1-stage smoothing CIC filter of order Mc,
// but no further downsampling occurs

// integration step of smoothing CIC filter I-channel
  IIintegrator3 += IIcomb2out / P ;
// comb staep of smoothing CIC filter
  IIcic3out = IIintegrator3 - IIfifo[CICfifoPTR] ;
// FIFO update of smoothing CIC filter
  IIfifo[CICfifoPTR] =  IIintegrator3 ;
// same for I-channel
  QQintegrator3 += QQcomb2out / P ;
  QQcic3out = QQintegrator3 - QQfifo[CICfifoPTR] ;
  QQfifo[CICfifoPTR] =  QQintegrator3 ;
// advance pointer and bump around
  CICfifoPTR++ ; if ( CICfifoPTR==Mc ) { CICfifoPTR=0 ; }
// CICfifoIout and CICfifoQout are now the triple filtered I and Q channel values
// these are used to compute phase and amplitude using a CORDIC method
#ifdef DACoption4
  DAC1 = 128+IIcic3out/4 ;
  DAC2 = 128+QQcic3out/4 ;
  //DAC1 = 128 ;
  //DAC2 = 128 ;
#endif
//  IO2port |=  _BV(IO2pin) ;

#define v2 27
  minTest=testVal(0) ;  dPhi=0 ;
  test=testVal(v2) ; if (test<minTest ) { dPhi= v2 ; minTest=test ; }
  test=testVal(-v2) ; if (test<minTest ) { dPhi=-v2 ; minTest=test ; }
  actualPhi=actualPhi+dPhi ;


#ifdef DACoption3
  DAC1=128+dPhi ;
 // DAC1=actualPhi ;
#endif


  FRQintegrator += dPhi ;
  FRQcicout = FRQintegrator - FRQfifo[FRQfifoPTR] ;
  FRQfifo[FRQfifoPTR] =  FRQintegrator ;
// advance pointer and bump around
  FRQfifoPTR++ ; if ( FRQfifoPTR==FRQlength ) { FRQfifoPTR=0 ; }
// normalize
  FRQcicout= FRQcicout / FRQlength ;

  
#ifdef DACoption1
  DAC2=128+FRQcicout ;
#endif
#ifdef DACoption2
  DAC2=128+FRQcicout ;
#endif
#ifdef DACoption3
  DAC2=128+FRQcicout ;
#endif


  demodValue =  - FRQcicout ; 
  uint32_t tmp=(IIcic3out*IIcic3out+QQcic3out*QQcic3out)/16 ;
  if (tmp>SQmax){ SQmax=tmp ; }
  SQsum += tmp ;
  SQcount += 1 ;
  if ( SQcount==SQlength){
    SQresultBuffer=SQsum ;
    SQsum=0 ;
	SQcount=0 ;
	SQready=1 ;
	SQmaxResult=SQmax ;
	SQmax=0 ;
    }

  }

//----------------------------------------------------------------------------------------




void timer2Init(){
  // Timer 2 BitClk
  TCCR2A=0b10100011 ; // fast pwm top=0xFF OC2A=pin 17/28 OC2B=pin 5/28
  //TCCR2B=0b00000010 ; // prescale by 8 
   TCCR2B=0b00000001 ; // prescale by 1 
  OCR2A=50; 
  OCR2B=150 ; 
// Interupt enable for Timer2-overflow
//  TIMSK2=0b00000001 ; // TOIE2

  ClkMail1000=0 ;
 
  }

// 20000000/32/125/5 = 1000 clkMail/sec
// timer 2 rate : 20MHz/8/256=9765.625 interrupts/sec

/*
int T2ticks ;
ISR(TIMER2_OVF_vect) {
 // PORTD &= ~ _BV(2) ;  
  T2ticks+=256 ;
  if(T2ticks>20000) {
 	ClkMail1000=1 ;  
	T2ticks -= 20000 ;
//	PORTD |= _BV(2) ;
    } 
  }
*/
//----------------------------------------------------------------------------------------  

uint16_t errorLedTimer ;


void errorLedInit() {
  errorLedTimer=0 ;
  }

void errorLedDo(){
  if( errorLedTimer==0 ){
//    yellowLedPort |=  _BV(yellowLedPin) ; 
    }
  else {
 //   yellowLedPort &= ~ _BV(yellowLedPin) ; 
	errorLedTimer-- ;
	} 
  }  
//----------------------------------------------------------------------------------------  

int8_t BitLine ;
int16_t v ;


void uartDecOut2(int k){
  if(k<0){ k=-k ; uartPutc('-') ; } else { uartPutc('+') ;}
  uartPutc( ((k/10) % 10)+48 ) ;
  uartPutc( (k % 10)+48 ) ;
  uartPutc(32) ;
  }

int16_t errorLevel ;

void errorDisplayInit(){
   errorLevel=0 ;
   }

void errorDisplay(int16_t v){
  #ifdef DACoption2
  DAC1=128+errorLevel ;
  #endif
 // if((v>-20)&(v<-5)) {  errorLevel += 20 ; }
  if((v>-18)&(v<-5)) {  errorLevel += 20 ; }
  if ( errorLevel<0) { errorLevel++ ; }
  if ( errorLevel>0) { errorLevel-- ; }
  if( (v>0) ){ errorLevel =-50 ;  }
  if( errorLevel>40 ) { yellowLedPort &= ~ _BV(yellowLedPin) ; }
    else { yellowLedPort |=  _BV(yellowLedPin) ; }
  }

#define threshold 10

void FMdemod(){
// get frequency in atomic way
  cli() ;
  v=demodValue ;
  sei() ;

  errorDisplay(v) ;
  
  if (v >  threshold) { BitLine=1 ; }
  if (v < -threshold) { BitLine=0 ; } 
//  DAC2=128  +(FMcicout) ;
//  if (uartStart) { DAC1=60 ; uartStart=0 ; } else { DAC1=uartTimer*4 ; }
//  DAC1=64*BitLine ;
  uartSample(BitLine) ;
  if (BitLine==0){ 
    uart2Txport |= _BV(uart2TxPin) ; 
	} 
   else { 
    uart2Txport &= ~_BV(uart2TxPin) ; 
	}
  }

//----------------------------------------------------------------------------------------
/*
http://en.wikipedia.org/wiki/Linear_feedback_shift_register

unsigned short lfsr = 0xACE1u;
unsigned int period = 0; 
do {
  lfsr = (lfsr >> 1) ^ (-(short)(lfsr & 1u) & 0xB400u); 
  ++period;
} while(lfsr != 0xACE1u);

*/

uint16_t LFSR16reg ;

void LFSRinit(){
  LFSR16reg=0xACE1 ;
  }

uint8_t LFSRshift(){
  uint8_t theBit ;
  theBit=LFSR16reg & 1 ;
  if ( theBit ) { 
    LFSR16reg = (LFSR16reg >> 1) ^ 0xB400 ; 
	} 
   else { 
    LFSR16reg = (LFSR16reg >> 1) ; 
	}
  return theBit ;
  }

//----------------------------------------------------------------------------------------



int32_t RMSsum ;
int32_t RMS ;
int32_t x,y ;

int32_t Usum ;
int32_t Umean ;

void switchRefTo1V1(){
  ADMUX =0b11000000 ; // Vref=1.1V
  }


int16_t OneConversion(){
  int16_t ADCv ;
//  IO3port |=  _BV(IO3pin) ;
  ADCSRA |= (1<<ADSC) ; // start conversion
  while(  (ADCSRA & (1<<ADIF)) == 0) { } ;
  ADCSRA |= (1<<ADIF) ; // reset conversionInterrupt Flag
//  IO3port &= ~ _BV(IO3pin) ;
  ADCv=( (int16_t)ADC-512) ; 
  // clip ADC value in order to detect ADC overflow
  #define ADCMAX 500 
  if (ADCv > ADCMAX) { ADCv=ADCMAX ; Clip=1 ; ClipCount++ ;  }
  if (ADCv <-ADCMAX) { ADCv=-ADCMAX ;  Clip=1 ; ClipCount++ ; }
  // ADCv now is in -ADCMAX..ADCMAX
  return ADCv ;
  }


#define RMSlength 2048

uint32_t MeasureOneBucket(){
  int16_t k ;
  RMSsum=0 ;
  Usum=0 ;
  ClipCount=0 ;
  for (k=0 ; k<RMSlength ; k++){
    x=OneConversion() ;
	Usum += x ;
	y=x*x ;
	RMSsum += y ;
    _delay_loop_2(LFSR16reg & 0x3ff) ;
	LFSRshift() ;
    doClipCheck() ;
	}
  return RMSsum ;
  }




void OneMeasurement(){
 
  RMSsum=MeasureOneBucket() ;
  Umean = Usum ;

  SQresult=RMSsum/RMSlength ;
  SQresult=(SQresult*100UL)/105 ;
  SQresult=SQresult*1000 ;
  uartPutc(':') ;
  uartDecOut32(SQresult) ;	 ;
  uartPutc(';') ;
  uartPutc('+') ;
  uartCrlf() ;
  }

//----------------------------------------------------------------------------------------
/*
void timer0Init(){
#ifdef pwmOut  
  TCCR0A=0b10100011 ; // mode 3 , fast pwm TOP=255 out OC0A and OC0B
  TCCR0B=0b00000001	; // ck=XTAL , 78.125kHz
  OCR0A = 50 ;
  OCR0B = 100 ;
#endif
  }
*/

void timer0Init(){
// 129.1 kHz
  TCCR0A=0b00100011 ; // fast pwm  output OCR0B OC0B=PD5 pin 11of28
  TCCR0B=0b00001001	; // ck=XTAL
  OCR0B=78 ;
  OCR0A=157-1 ; // sample period predivider 


  }

//----------------------------------------------------------------------------------------



void showMode(){

  uartPutsPgm(PSTR("Frequency= 129.1 kHz MCPmix")) ;

  }




//----------------------------------------------------------------------------------------
void doRmsMeter(){
   }


void doRXoperation(){
   

  if ( IntFifoInPtr!=IntFifoOutPtr ) { 
    doIQsample() ; 
    doClipCheck() ;
    }
  if ( ClkMail1000 ) { 
    ClkMail1000=0 ; 
	errorLedDo() ;
    FMdemod() ;
    } 
  if (SQready){
	cli() ;
	SQresult= SQresultBuffer ;
	//SQresult=SQmaxResult ;
	sei() ;
	SQready=0 ;
	//SQresult=SQresult/SQlength ;
	//SQresult=(147UL*SQresult)/5 ;
	#ifdef withRSSI
    SQiirFilter=(800*SQiirFilter+200*SQresult)/1000 ;
    uartPutc(13) ;	uartPutc(':') ;	uartDecOut32(SQresult) ; uartPutc(';') ;
	//uint16_t display=Log2(SQiirFilter) ;
	uartPutc(13) ;
	//uartCrlf() ;
	//uartPutc(':') ;	uartDecOut(display ) ; uartPutc(';') ;
	crWasThere=0 ;
    #endif
	}
  }

void doNormalOperation(){
  while (1){ 
    ICR1=Ns-1 ;
	doRXoperation() ;
    }
  }

//----------------------------------------------------------------------------------------  

int uartSnd2(unsigned char c){
   while (!(UCSR0A & (1<<UDRE0))); 
   UDR0 = c;                      
   return 0;
   }

void uartPutsPgm2(const char *progmem_s){
  register char c;
  while ( (c = pgm_read_byte(progmem_s++)) ) { 
     uartSnd2(c); 
	 //delay_ms(1) ;
	}
  }
void out1(){
  uartCrlf() ;
  flushUartFifo() ;

  }

int main(){

  DDRD =0b11111111 ; // enable outputs , bit 0,1=input
  PORTD=0b11111111 ; // pullups on on input pins
  
  DDRB =0b11111111 ; // enable outputs 
  PORTB=0b11111111 ; // pullups on on input pins
  
  //DDRC =0b11001110 ; // enable outputs , bit 0=input
  //PORTC=0b11111110 ; // pullups off on ADC pins

  DDRC =0b11001110 ; // enable outputs , bit 0=input
  PORTC=0b11111110 ; // pullups off on ADC pin

  ADMUX =0b11000000 ; // Vref=1.1V
  ADCSRA=0b10100111 ; // 20MHz/128=156.25kHz    /13=12.019kHz = max sample frequency
  ADCSRB=0b00000110 ; // timer/counter1 overflow is trigger
 
// 20.00MHz/19200/16=65 use 19200 bit/sec UBRRL=64
// 20.00MHz/57600/16=22 use 57600 bit/sec UBRRL=21 gives 56818...= 0.9864*57600
  UCSR0B |= ( 1 << TXEN0 );					// UART TX einschalten
  // UCSR0C |= ( 1 << URSEL )|( 3<<UCSZ0 );	    // Asynchron 8N1
  UBRR0H  = 0;                               // Highbyte ist 0
  //UBRR0L  = 22-1 ;                             // 57600 Bit/sec
  UBRR0L  = 65-1 ;                             // 19200 Bit/sec

// UBRR0L  = 11-1 ;                             // 115200 Bit/sec

//  uartSnd2(' ') ;
//  uartSnd2(0x80+0x40) ;
//  uartPutsPgm2(PSTR(HEADLINE)) ;
//  uartCrlf() ;

/*
timer0Init() ;
timer1Init(getNsfromMode()) ;
timer2Init() ;
sei() ;
  while(1){} ;
*/

  uartFIFOinit() ;

//  uartCrlf() ;
  //uartPutc(0x80+0) ; LCD
   uartCrlf() ;
    uartCrlf() ;
	 uartCrlf() ;
  uartPutsPgm(PSTR(HEADLINE)) ;
  //uartPutsPgm(PSTR("            ")) ;
  //uartPutc(0x80+0x40) ;
  //  uartPutsPgm(PSTR("         ")) ;

  uartCrlf() ;
//  while(1){} ;

  FRQfilterInit() ;
  timer0Init() ;

  uartCrlf() ;
  
  timer1Init(Ns) ;
  timer2Init() ;
  CICfifoINIT() ;
  //softUartInit() ;
  //msgFSMreset1() ;
  errorDisplayInit() ;
 //  sei() ;
 // while(1){
    
   // delay_ms(200) ;
//	}

  msgFSMinit() ;
  softUartInit() ;
  errorLedInit() ;

#ifdef debugOut
  uartPutsPgm(PSTR("debugOut is on!")) ;  out1() ;
#else
  uartPutsPgm(PSTR("debugOut is off!")) ;  out1() ;
#endif

#ifdef withCP56
  uartPutsPgm(PSTR("CP56 decoding is on!")) ; out1() ;
#else
  uartPutsPgm(PSTR("CP56 decoding is off!")) ; out1() ;
#endif

#ifdef pwmOut
  uartPutsPgm(PSTR("pwmOut is on!")) ; out1() ;
#else
  uartPutsPgm(PSTR("pwmOut is off!")) ; out1() ;
#endif

#ifdef  withRSSI
  uartPutsPgm(PSTR("withRSSI is on!")) ; out1() ;
#else
  uartPutsPgm(PSTR("withRSSI is off!")) ; out1() ;
#endif

#ifdef   DACoption1
  uartPutsPgm(PSTR("DACoption1 is on!")) ; out1() ;
#endif


#ifdef   DACoption2
  uartPutsPgm(PSTR("DACoption2 is on!")) ; out1() ;
#endif

#ifdef   DACoption3
  uartPutsPgm(PSTR("DACoption3 is on!")) ; out1() ;
#endif

#ifdef   DACoption4
  uartPutsPgm(PSTR("DACoption4 is on!")) ; out1() ;
#endif


  flushUartFifo() ; // no interrupts here so far!
 

/*
  while(1){
    flushUartFifo() ; // no interrupts here so far!
	delay_ms(500) ;
uartCrlf() ;
	if (JP1Pinp & _BV(JP1Pin)) { uartPutc('H') ; } else { uartPutc('L') ; } ;
	if (JP2Pinp & _BV(JP2Pin)) { uartPutc('H') ; } else { uartPutc('L') ; } ;
	uartPutc(' ') ;
    getModeFromswitch() ;
	showMode() ;
	
	}

  while(1){} ;
*/

  //redLedPort &= ~ _BV(redLedPin) ; while(1){} ;

  sei() ;
  doNormalOperation() ;
  return(0) ;
  }
