#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/pgmspace.h>


#include "RS232com1.h"
#include "options.h" 

//----------------------------------------------------------------------------------------
//
// RS232 TX routines

// define length of FIFO: UARTMASK+1 , UARTMASK must be of form 2^n-1 (all binary ones)
//


volatile uint8_t uartFIFO[256] ;
// for atomic read/write the following must be 1-Byte variables
volatile uint8_t uartPUTidx ;
volatile uint8_t uartGETidx ;

void uartFIFOinit(){
// uartPutidx==uartGETidx signals FIFO is empty
  uartPUTidx=0 ;
  uartGETidx=0 ;
  }

void uartPutc(char c){
// put char into FIFO and output later via doIQsample()
  uartFIFO[uartPUTidx]=c ;
// the following write to uartPUTidx is atomic, so even an interrupt in
// between may happen without fault
  uartPUTidx=(uartPUTidx+1) & UARTMASK ;
  }

// direct output
int uartSnd(unsigned char c){
   while (!(UCSR0A & (1<<UDRE0))); 
   UDR0 = c;                      
   return 0;
   }

void uartPutsPgm(const char *progmem_s){
  register char c;
  while ( (c = pgm_read_byte(progmem_s++)) ) { 
    uartPutc(c); 
	}
  }

void uartBlank(){
  uartPutc(' ') ; 
  }

void uartCrlf(){
  uartPutc(13) ; 
  uartPutc(10) ;
  }

void uartHex(uint8_t v){
  v &=0b00001111 ;
  if (v<=9) { uartPutc('0'+v) ; } 
       else { uartPutc(v+'A'-10) ; } ;
  }

void uartByte(uint8_t v){
  uartHex(v>>4) ; 
  uartHex(v) ; 
  }


void uartDecOut(int k){
   uartPutc( ((k/10000) % 10)+48 ) ;
   uartPutc( ((k/1000) % 10)+48 ) ;
   uartPutc( ((k/100) % 10)+48 ) ;
   uartPutc( ((k/10) % 10)+48 ) ;
   uartPutc( (k % 10)+48 ) ;
   uartPutc(32) ;
   }

void uartDecOut32(uint32_t k){
   uartPutc( ((k/1000000000UL) % 10)+48 ) ;
   uartPutc( ((k/100000000UL) % 10)+48 ) ;
   uartPutc( ((k/10000000UL) % 10)+48 ) ;
   uartPutc( ((k/1000000UL) % 10)+48 ) ;
   uartPutc( ((k/100000UL) % 10)+48 ) ;
   uartPutc( ((k/10000) % 10)+48 ) ;
   uartPutc( ((k/1000) % 10)+48 ) ;
   uartPutc( ((k/100) % 10)+48 ) ;
   uartPutc( ((k/10) % 10)+48 ) ;
   uartPutc( (k % 10)+48 ) ;
   //uartPutc(32) ;
   }





//----------------------------------------------------------------------------------------  


void flushUartFifo(){
  while (uartPUTidx != uartGETidx){
    if  ((UCSR0A & (1<<UDRE0))!=0)  {
      uint8_t c=uartFIFO[uartGETidx] ;
	  uartGETidx=(uartGETidx+1) & UARTMASK ;
	  UDR0 = c;  
      }
    }
  }

//----------------------------------------------------------------------------------------  
