#include "SensorKey.h"

unsigned int ee_sense EEMEM = 30;
//unsigned int ee_wpm EEMEM = 25;
unsigned char ee_keyer EEMEM = FALSE;
unsigned char ee_beep_on EEMEM = FALSE;
unsigned char ee_keyline_rev EEMEM = FALSE;

int main(void)
{
	IO_DDR |= (1<<KEYLINE0)|(1<<KEYLINE1)|(1<<BEEP);
	IO_DDR &= ~((1<<KEY1)|(1<<KEY2)|(1<<MODE));
	IO_PORT &= ~((1<<KEYLINE0)|(1<<KEYLINE1)|(1<<BEEP)|(1<<MODE));
	IO_PORT |= (1<<KEY1)|(1<<KEY2);

	SENSOR_PORT |= (1<<SENSOR_LED0)|(1<<SENSOR_COLL0)|(1<<SENSOR_LED1)|(1<<SENSOR_COLL1);
	SENSOR_DDR |= (1<<SENSOR_LED0)|(1<<SENSOR_LED1);
	SENSOR_DDR &= ~((1<<SENSOR_COLL0)|(1<<SENSOR_COLL1));

	watchdog = 0;
	timeout_cnt = 0;

	eeprom_read_block(&sense,&ee_sense,2);
	OCR1A = sense;
	OCR1B = 7500;

	wpm = 25;
//	eeprom_read_block(&wpm,&ee_wpm,2);

	eeprom_read_block(&keyer,&ee_keyer,1);
	eeprom_read_block(&beep_on,&ee_beep_on,1);
	eeprom_read_block(&keyline_rev,&ee_keyline_rev,1);
	
	sensor0_pressed = FALSE;
	sensor1_pressed = FALSE;

	TIFR |= (1 << TOV0);
	TIMSK |= (1<<TOIE0)|(1<<TOIE1)|(1<<OCIE1A)|(1<<OCIE1B);	//enable CompareA and CompareB interrupt
	TCCR1B |= (1<<CS10)|(1<<CS00); 				//start Timer1 without prescaler
	
	sei();

	if(!(IO_PIN&(1<<KEY1)))
	{
		keyer = TRUE;
		eeprom_write_block(&keyer,&ee_keyer,1);
	}
	if(!(IO_PIN&(1<<KEY2)))
	{
		keyer = FALSE;
		eeprom_write_block(&keyer,&ee_keyer,1);
	}

	if(keyer == FALSE)
	{
		// "p"
		beep_dits(1);
		beep_dahs(2);
		beep_dits(1);
	}

	if(keyer == TRUE)
	{
		// "k"
		beep_dahs(1);
		beep_dits(1);
		beep_dahs(1);
	}

	while(!(IO_PIN&(1<<KEY1)) || !(IO_PIN&(1<<KEY2)));


//paddle mode *************************************************************************
	while(keyer == FALSE)
	{	
		watchdog++;
		if (watchdog == 0) timeout_cnt++;
		
		if (timeout_cnt == TIMEOUT) 
		{
			save_batt();
		}

		if(!(IO_PIN&(1<<KEY1)))
		{
			key_long = 0;
			while (!(IO_PIN&(1<<KEY1)) & (key_long<KEY_LONG_CNT))
			{
				key_long++;
				if(!(IO_PIN&(1<<KEY2))) sense_adjust();
			}

			//if(key_long == KEY_LONG_CNT)
		}


		if(!(IO_PIN&(1<<KEY2)))
		{
			key_long = 0;
			while (!(IO_PIN&(1<<KEY2)) & (key_long<KEY_LONG_CNT)) key_long++;

			if(key_long == KEY_LONG_CNT)
			{
				if(keyline_rev == TRUE) keyline_rev = FALSE;
					else keyline_rev = TRUE;
					eeprom_write_block(&keyline_rev,&ee_keyline_rev,1);
				roger();
			}
		}
		else
		{		
			if (sensor0_pressed == TRUE)
			{
				IO_PORT |= (1<<KEYLINE0);
				timeout_cnt = 0;
			}
			else IO_PORT &= ~(1<<KEYLINE0);
		
			if (sensor1_pressed == TRUE)
			{
				IO_PORT |= (1<<KEYLINE1);
				timeout_cnt = 0;
			}
			else IO_PORT &= ~(1<<KEYLINE1);
		}
	}
	

//keyer mode *************************************************************************
	while(keyer == TRUE)
	{
		watchdog++;
		if (watchdog == 0) timeout_cnt++;
		
		if (timeout_cnt == TIMEOUT) 
		{
			save_batt();
		}

		if(!(IO_PIN&(1<<KEY1)))
		{
			key_long = 0;
			while (!(IO_PIN&(1<<KEY1)) & (key_long<KEY_LONG_CNT))
			{
				key_long++;
				if(!(IO_PIN&(1<<KEY2))) sense_adjust();
			}

			if(key_long == KEY_LONG_CNT)
			{
				if(beep_on == TRUE) beep_on = FALSE;
					else beep_on = TRUE;
					eeprom_write_block(&beep_on,&ee_beep_on,1);
				roger();
			}
			else
			{
				if(wpm>10) wpm--;
				beep_dahs(1);
				wait_dah();
			}
		}

		if(!(IO_PIN&(1<<KEY2)))
		{
			key_long = 0;
			while (!(IO_PIN&(1<<KEY2)) & (key_long<KEY_LONG_CNT)) key_long++;
			if(key_long == KEY_LONG_CNT)
			{
				if(keyline_rev == TRUE) keyline_rev = FALSE;
					else keyline_rev = TRUE;
					eeprom_write_block(&keyline_rev,&ee_keyline_rev,1);
				roger();
			}
			else
			{
				if(wpm<40) wpm++;
				beep_dits(1);
				wait_dah();
			}
		}

		if (sensor0_pressed == TRUE)
		{
			sensor0_pressed = FALSE;
			timeout_cnt = 0;			

			IO_PORT |= (1<<KEYLINE0)|(1<<KEYLINE1);
	
			if(beep_on == TRUE) IO_PORT |= (1<<BEEP);
				else IO_PORT &= ~(1<<BEEP);
		
			wait_dit();
		
			IO_PORT &= ~((1<<BEEP)|(1<<KEYLINE0)|(1<<KEYLINE1));

			wait_dit();
		}

		if (sensor1_pressed == TRUE) 
		{	
			sensor1_pressed = FALSE;
			timeout_cnt = 0;
			
			IO_PORT |= (1<<KEYLINE0)|(1<<KEYLINE1);
	
			if(beep_on == TRUE) IO_PORT |= (1<<BEEP);
				else IO_PORT &= ~(1<<BEEP);
		
			wait_dah();
		
			IO_PORT &= ~((1<<BEEP)|(1<<KEYLINE0)|(1<<KEYLINE1));

			wait_dit();
		}
	}
	return(0);
}
void save_batt(void)
{
	//+
	beep_dits(1);
	beep_dahs(1);
	beep_dits(1);
	beep_dahs(1);
	beep_dits(1);

	GIMSK |= (1<<INT0)|(1<<INT1);
	set_sleep_mode(SLEEP_MODE_PWR_DOWN);
	sleep_mode();

}
void beep_dits(unsigned char dits)
{
	while (dits > 0)
	{
		IO_PORT |= (1<<BEEP);
		wait_dit();
		IO_PORT &= ~(1<<BEEP);
		wait_dit();

		dits--;
	}
}

void beep_dahs(unsigned char dahs)
{
	while (dahs > 0)
	{
		IO_PORT |= (1<<BEEP);
		wait_dah();
		IO_PORT &= ~(1<<BEEP);
		wait_dit();

		dahs--;
	}
}

void sense_adjust(void)
{	
	unsigned char sense_okay = FALSE;

	//s
	beep_dits(3);
	wait_dah();
/*
	//e
	beep_dits(1);
	wait_dah();

	//n
	beep_dahs(1);
	beep_dits(1);
	wait_dah();

	//s
	beep_dits(3);
	wait_dah();

	//e
	beep_dits(1);
	wait_dah();
*/
	while( sense_okay == FALSE )
	{
		if(!(IO_PIN&(1<<KEY1)))
		{
			if (sense >= (SENSE_MIN+SENSE_STEP))
			{
				sense = sense - SENSE_STEP;
				OCR1A = sense;
				beep_dahs(1);
				wait_dah();
			}
		}
		
		if(!(IO_PIN&(1<<KEY2)))
		{ 
			key_long = 0;
			while (!(IO_PIN&(1<<KEY2)) & (key_long<KEY_LONG_CNT)) key_long++;
			if(key_long == KEY_LONG_CNT)
			{
				sense_okay = TRUE;
				roger();
			}
			else if (sense <= (SENSE_MAX-SENSE_STEP))
			{
				sense = sense + SENSE_STEP;
				OCR1A = sense;
				beep_dits(1);
				wait_dah();
			}		
		}
				
		if (sensor0_pressed == TRUE || sensor1_pressed == TRUE) IO_PORT |= (1<<BEEP);
			else IO_PORT &= ~(1<<BEEP);
	}
	
	eeprom_write_block(&sense,&ee_sense,2);

	key_long = 0;
}

void roger(void)
{
	//r
	beep_dits(1);
	beep_dahs(1);
	beep_dits(1);
	wait_dah();
}

void wait_dit(void)
{
	wait = TRUE;

	TCNT0 = 255-2344/wpm;
	TCCR0B |= (1<<CS02);		//start Timer0 with prescaler = 256
	while (wait == TRUE);
	TCCR0B &= ~(1<<CS02);	//stop Timer0
}

void wait_dah(void)
{
	wait = TRUE;

	TCNT0 = 255-1758/wpm;
	TCCR0B |= (1<<CS00)|(1<<CS02);		//start Timer0 with prescaler = 1024
	while (wait == TRUE);
	TCCR0B &= ~(1<<CS00)|(1<<CS02);		//stop Timer0
}

SIGNAL(SIG_TIMER0_OVF)
{
	wait = FALSE;
}

SIGNAL(SIG_TIMER1_COMPA)
{

	if(keyline_rev == TRUE)
	{
/*		if(SENSOR_PIN&(1<<SENSOR_COLL0)) sensor1_pressed = FALSE;
			else sensor1_pressed = TRUE;

		if(SENSOR_PIN&(1<<SENSOR_COLL1)) sensor0_pressed = FALSE;
			else sensor0_pressed = TRUE;*/

		if(!(SENSOR_PIN&(1<<SENSOR_COLL0))) sensor1_pressed = TRUE;
			else sensor1_pressed = FALSE;
	
		if(!(SENSOR_PIN&(1<<SENSOR_COLL1))) sensor0_pressed = TRUE;
			else sensor0_pressed = FALSE;

	}
	else
	{			
		if(!(SENSOR_PIN&(1<<SENSOR_COLL0))) sensor0_pressed = TRUE;
		else sensor0_pressed = FALSE;
		if(!(SENSOR_PIN&(1<<SENSOR_COLL1))) sensor1_pressed = TRUE;
			else sensor1_pressed = FALSE;
	}

	SENSOR_PORT &= ~((1<<SENSOR_LED0)|(1<<SENSOR_LED1));
}

SIGNAL(SIG_TIMER1_COMPB)
{	
	SENSOR_PORT |= (1<<SENSOR_LED0)|(1<<SENSOR_LED1);
	TCNT1 = 0;
}
