#ifndef _SENSORKEY_H
#define _SENSORKEY_H

#include "avr/io.h"
#include "avr/interrupt.h"
#include "avr/eeprom.h"
#include "avr/sleep.h"

#define FOSC 500000 //int RC Osc. 4MHz + CKDIV8

#define TIMEOUT				100		//TIMEOUT * 6sec (watchdog_overflow) = 600 sec = 10 min to power down 		

#define KEY_LONG_CNT		40000

#define SENSOR_PORT			PORTB
#define SENSOR_DDR			DDRB
#define SENSOR_PIN			PINB
#define SENSOR_COLL0		0
#define SENSOR_LED0			1
#define SENSOR_LED1			2
#define SENSOR_COLL1		4

#define IO_PORT				PORTD
#define IO_DDR				DDRD
#define IO_PIN				PIND
#define KEYLINE0			0
#define KEYLINE1			1
#define KEY1				3
#define KEY2				2
#define BEEP				4
#define MODE				5

#define SENSE_MIN			10
#define SENSE_MAX			210
#define SENSE_STEP			20

#define WPM_MAX				40
#define WPM_MIN				10

#define TRUE				1
#define FALSE				0

volatile unsigned char wait;
volatile unsigned char sensor0_pressed;
volatile unsigned char sensor1_pressed;
volatile unsigned int key_long;

volatile unsigned int sense;
volatile unsigned int watchdog; //overflow every about 6 sec
volatile unsigned char timeout_cnt;
volatile unsigned int wpm;
volatile unsigned char keyer;
volatile unsigned char beep_on;
volatile unsigned char keyline_rev;

void beep_dits(unsigned char dits);
void beep_dahs(unsigned char dahs);
void wait_dit(void);
void wait_dah(void);
void roger(void);
void sense_adjust(void);
void save_batt(void);

#endif
