﻿'Stand: 24. Mai 2017 / F.P. Zantis
Option Strict On
Option Explicit On
Module Bitmanipulation

    Public Function SetBit(ByVal InByte As Byte, ByVal n As Byte) As Byte
        'set the n-th Bit (0…7) of InByte
        SetBit = InByte Or CByte(2 ^ n)
    End Function

    Public Function ClearBit(ByVal InByte As Byte, ByVal n As Byte) As Byte
        'Rücksetzen des n-ten Bits von InByte
        ClearBit = InByte And Not CByte(2 ^ n)
    End Function

    Public Function IsBitSet(ByVal InByte As Byte, ByVal n As Byte) As Boolean
        'Abfrage ob das n-te Bit von InByte gesetzt ist oder nicht; Bitnum = 0…7
        If ((InByte And (CType(2 ^ n, Byte))) > 0) Then
            IsBitSet = True
        Else
            IsBitSet = False
        End If
    End Function

    Public Function ToggleBit(InByte As Byte, n As Byte) As Byte
        'Toggeln des n-ten Bits von InByte
        ToggleBit = InByte Xor CByte(2 ^ n)
    End Function

    Public Function SeparateHiByteLoByte(ByVal Int16value As UInt16) As Byte()
        'separation of HighByte and LowByte
        'the used proceeder is only for unsigned integers
        Dim lHighbyte As Byte
        Dim lLowbyte As Byte
        Dim lzwischen As UInt16
        Dim lByteres(1) As Byte
        lHighbyte = CByte(Int16value >> 8) 'isolate HighByte
        lzwischen = Int16value << 8         'erase Highbyte
        lLowbyte = CByte(lzwischen >> 8) 'shift to right side to get the LowByte
        lByteres(1) = lHighbyte
        lByteres(0) = lLowbyte
        Return lByteres
    End Function
End Module
