import ddf.minim.*;
import ddf.minim.spi.AudioStream;
 
float fSample=44100 ;
float tSample=1.0/fSample ;
float IFfrq=1000-1.8 ;

float IFgain=6 ;

float AGCgain=1 ;
float AGCamplitudeEstimate=0 ;
int AGCcount=0 ;


float amplitudeGain=40*2 ;
boolean stop=false ;
boolean withPLL=true ;

Minim minim;

AudioStream input ;
MultiChannelBuffer buffer; 

int scopeXsize = 1700;
float scopeX=0 ;
int dspXsize=500 ;
int dspYsize=900 ;

LpIIRfilter1 filterII=new LpIIRfilter1() ;
LpIIRfilter1 filterQQ=new LpIIRfilter1() ;
LpIIRfilter1 demodFil=new LpIIRfilter1() ;
   
int prnReg ;
int newBit ;
int prnSequenceLength=512 ;
int prnBuffer[]=new int[prnSequenceLength] ;
   
float ChipRate=77500.0/120.0 ;
int mm=3 ;
float RXsampleRate=mm*ChipRate ;   
float RXsamplePeriod=1.0/RXsampleRate ;

float RXbuffer[]=new float[mm*prnSequenceLength] ;
int RXbufferPtr=0 ;

float RXsampleTimer=0 ;
   

void settings(){
  size(scopeXsize, dspYsize, P3D);
  }
   
void setup(){
  minim = new Minim(this);
  input=minim.getInputStream(Minim.STEREO,2048,fSample,16) ; // 
  input.open() ;
  buffer= new MultiChannelBuffer(1024, input.getFormat().getChannels());
  println("buffer.getChannelCount()="+buffer.getChannelCount()) ;
  println("buffer.getBufferSize()="+buffer.getBufferSize() ) ;
  filterII.butter(2,500.0/fSample ) ;
  filterQQ.butter(2,500.0/fSample ) ;
  demodFil.butter(4,5.0/400) ;
  
  OLDgenerateReSampledSequence1() ;
  println() ;
  background(0) ;
  strokeWeight(1) ;
  //exit() ;
  }
 
int iGet=Integer.MAX_VALUE ;
float signal=0 ;
float dummy=0 ;

void getSignal(){
  if(iGet>=buffer.getBufferSize()){ 
    iGet=0 ;
    input.read(buffer) ;
    }
  dummy=buffer.getSample(0,iGet) ;
  signal=buffer.getSample(1,iGet) ;
  iGet++ ;
  }  
  
float ygain=80 ; 

int k=0 ;
 


float IFphi=0 ;
float scopeY1last=0 ;
float scopeY2last=0 ;
float scopeY3last=0 ;


float scopeY4last=0 ;
float scopeY5last=0 ;
float scopeY6last=0 ;
float xxLast=0 ;
float yyLast=0 ;

void doScope(float y1, color c1, float y2, color c2, float y3, color c3, float y4,float y5, float y6, float xx, float yy){
  strokeWeight(2) ;
  if(scopeX>0){
    stroke(c1) ; 
    line(scopeX-1, 400 - scopeY1last*ygain, scopeX, 400 - y1*ygain);
    line(scopeX-1, 400 , scopeX, 400 );
     
    stroke(c2) ;
   line(scopeX-1, 500 - scopeY2last*ygain, scopeX, 500 - y2*ygain);
   
    stroke(c3) ;
    line(scopeX-1, 750 - scopeY3last*ygain, scopeX, 750 - y3*ygain);
    stroke(255,255,255) ;
    
    stroke(255,255,100) ;
    line(scopeX-1, 150 - scopeY4last*ygain, scopeX, 150 - y4*ygain);
    line(scopeX-1, 150 , scopeX, 150 );
   
    stroke(255,100,50) ;
    line(scopeX-1, 100 - scopeY5last*ygain, scopeX, 100 - y5*ygain);
    line(scopeX-1, 100 , scopeX, 100 );
    
    stroke(255,0,0) ;
    line(scopeX-1, 550 - scopeY6last*ygain, scopeX, 550 - y6*ygain);
    line(scopeX-1, 550 , scopeX, 550 );
    
    stroke(255,255,255) ;
    
    line(1550+xxLast*ygain,150-yyLast*ygain,1550+xx*ygain,150-yy*ygain) ;
    line(1550-100,150,1550+100,150) ;
    line(1550,150-100,1550,150+100) ;
    }
  scopeY1last=y1 ;
  scopeY2last=y2 ;
  scopeY3last=y3 ;
  scopeY4last=y4 ;
  scopeY5last=y5 ;
  scopeY6last=y6 ;
  xxLast=xx ; yyLast=yy ;
  
 // scopeX+=1 ;
  scopeX+=0.1 ;
  if(scopeX>=scopeXsize-300){ 
    scopeX=0 ;
    if(mousePressed){ save("pic3.png") ; }
    background(0) ;
    stroke(255,255,255) ; 
    //line(0,200,scopeXsize,200) ;
    }
  }
  
int nSamples ;

float scopeY1=0 ;
float scopeY2=0 ;

float CorelSum=0 ;
//int bitCount=0 ;

void doSample(){
  getSignal() ;
   
  IFphi += IFfrq/fSample*2*PI ;
  while(IFphi>2*PI){ IFphi -= 2*PI ; }
    
  float II=signal*cos(IFphi);
  float QQ=signal*sin(IFphi);
    
  II=AGCgain*IFgain*(float)filterII.runIIR(II) ;
  QQ=AGCgain*IFgain*(float)filterQQ.runIIR(QQ) ;
   
  RXsampleTimer+=tSample ;
  if(RXsampleTimer>RXsamplePeriod){
    RXsampleTimer-=RXsamplePeriod ;
    demod(II,QQ) ; 
    float phaseCorrection=II ;
    if(withPLL){ IFphi -= phaseCorrection ; }  
    }
  }
  




void draw(){
  stroke(255);
  nSamples=0 ;
  while(nSamples<1000  ){
    nSamples++ ;
    doSample() ;
    }
  }


float Phase ;
float LastPhase ;
float PhaseDifference ;
float ExtendedPhase ;  

float amplitude=0 ;

long lastPulseTime=0 ;

void demod(float II, float QQ){
  float phi=-atan2(II,-QQ) ;
  Phase=phi ;
  PhaseDifference=Phase-LastPhase ;
  LastPhase=Phase ;
  ExtendedPhase += PhaseDifference ;
  if(ExtendedPhase> 10*PI){ ExtendedPhase -=20*PI ; }
  if(ExtendedPhase<-10*PI){ ExtendedPhase +=20*PI ; }
    
  RXbuffer[RXbufferPtr]=0.03*Phase ;
  RXbufferPtr++ ;
  if(RXbufferPtr>=mm*prnSequenceLength){
    RXbufferPtr=0 ;
    }
    
  float sum=0 ;
  int sigPtr=RXbufferPtr ;
  for(int prnPtr=0 ; prnPtr<mm*prnSequenceLength ; prnPtr++){
    sum-=prnBuffer[prnPtr/mm]*RXbuffer[sigPtr] ;
    sigPtr++ ;
    if(sigPtr>=mm*prnSequenceLength) { sigPtr=0 ; }
  //  println("prnBuffer[k]="+prnBuffer[k]+" RXbuffer[k+d]="+RXbuffer[k+d]) ;
    }
  CorelSum=sum/mm ;  
  color cc=color(255,255,255) ;
  if(abs(CorelSum)>2){ 
    cc=color(255,255,0) ;
    if(CorelSum>2){ cc=color(255,255,0) ;}
    long time=millis() ;
    long dTime=time-lastPulseTime ;
    //println(" dt=",dTime) ;
    if((900<dTime)&(dTime<1100)){
      if(CorelSum<0){   putPRNbit(1) ; } else {  putPRNbit(0) ;  }
     // bitCount++ ;
      }
    lastPulseTime=time ;  
    }
       
  
  amplitude=sqrt(II*II+QQ*QQ) ;
  //amplitude=sqrt(LL*LL+RR*RR) ;
  amplitude=(float)demodFil.runIIR(amplitude) ;
  
  AGCamplitudeEstimate=0.9999*AGCamplitudeEstimate+0.0001*amplitude ;
  AGCcount++ ;
  if(AGCcount>=1000){
    //println("AGCgain="+AGCgain+"  AGCamplitudeEstimate="+AGCamplitudeEstimate) ;
    float wantedGain=0.025 ;
    if(AGCamplitudeEstimate>1.2* wantedGain){ AGCgain*=0.95 ; }
    if(AGCamplitudeEstimate<0.8* wantedGain){ AGCgain*=1.05 ; }
    AGCcount=0 ;
    }
  
  color ca=color(255,0,0) ;
  if(amplitude<0.015) { ca=color(0,255,0) ; dcfSample(0) ; } else { dcfSample(1) ; }
  ca=color(0,255,0) ;
  doScope(amplitude*amplitudeGain,ca, dcfSilenceTimer/2000.0,color(0,55,255),0.3*CorelSum,cc,
  II*10,-QQ*10,
  1*Phase,
  II*30,QQ*30 ) ;
  //doScope(II*10,ca, Phase*0.1,color(0,255,0),-2+0.2*CorelSum,cc) ;
  }
  
int dcfLevel=0 ;
int dcfSilenceTimer=0 ;
int dcfPulseTime=0 ;
int dcfTheSecond=0 ;

/*
void dcfCheckForGap(){
  dcfSilenceTimer++ ;
  if (dcfLevel==0 )  { 
    dcfSilenceTimer=0 ;
    }
  if ( dcfSilenceTimer*RXsamplePeriod>1.5 ) {
    print(" AM-GAP ") ; 
    dcfSilenceTimer=0 ;
    DisplayTime("AM",TheAMbits) ;
    dcfTheSecond=0 ;
    }
  }
  */
  
void dcfCheckForGap(){
  if (dcfLevel==1 )  {
    dcfSilenceTimer++ ;
    if ( dcfSilenceTimer*RXsamplePeriod>1.5 ) {
      print(" AM-GAP ") ; 
      dcfSilenceTimer=0 ;
      DisplayTime("AM",TheAMbits) ;
      dcfTheSecond=0 ;
      }
    }
   else{ 
    dcfSilenceTimer=0 ;
    }
  }  

int PRNbit=0 ;
int AMbit ;

void putPRNbit(int PRNbit1){
  dcfPRNBit(PRNbit1) ;
  PRNbit=PRNbit1 ;
  // print(AMbit) ; print(PRNbit) ; print(" ") ;
  if((AMbit==0)&(PRNbit==0)){ print("A") ; }
  if((AMbit==1)&(PRNbit==1)){ print("B") ; }
  if((AMbit==0)&(PRNbit==1)){ print("a") ; }
  if((AMbit==1)&(PRNbit==0)){ print("b") ; }
  }
  
void putAMbit(int AMbit1){
  AMbit=AMbit1 ;
  }

void dcfEmitBit(int TheBit){
  if (dcfTheSecond<60) { TheAMbits[dcfTheSecond]=TheBit ;} 
  putAMbit(TheBit) ;
  if (dcfTheSecond<58) { dcfTheSecond++ ; }
  }  

void dcfCheckPulse(){
  if ( dcfLevel==1 ){ 
    if( dcfPulseTime*RXsamplePeriod>0.12) { dcfEmitBit(1) ; }
      else if (dcfPulseTime*RXsamplePeriod>0.05 ) { dcfEmitBit(0) ; }
      dcfPulseTime=0 ;
      }
   else {
    if ( dcfPulseTime*RXsamplePeriod<0.25 ) { dcfPulseTime++ ; }
    }
  }

void dcfSample(int signal){
  dcfLevel=signal ; 
  dcfCheckForGap() ;
  dcfCheckPulse() ;
  }  
  
  
  
  

int onesCount=0 ;
int bitPos=0 ;
int ThePRNbits[]=new int[60] ;
int TheAMbits[]=new int[60] ;

void dcfPRNBit(int theBit){
  if(theBit==0){ 
    onesCount=0 ; 
    }
   else  {
    onesCount++ ;
    if(onesCount>=10){
      print("+") ;
      bitPos=9 ;
      onesCount=0 ;
      }
    }
  ThePRNbits[bitPos]=theBit ;
  bitPos++ ;
  if(bitPos>=60){
    bitPos=0 ;
    DisplayTime("PRN",ThePRNbits) ;
    println() ;
    }
  }

void OLDgenerateReSampledSequence1(){
  for(int k=0 ; k<prnSequenceLength ; k++){
    prnBuffer[k]=0 ; 
    }
  prnReg=1 ;
  for(int k=0 ; k<prnSequenceLength ; k++){
    newBit=0 ; 
    if( (prnReg & 0x010)!=0 ){ newBit = newBit ^ 1 ; }
    if( (prnReg & 0x100)!=0 ){ newBit = newBit ^ 1 ; }
    prnReg= ( prnReg<<1)  ^ newBit ;
    if((k%64)==0){ println() ; }
    if(newBit!=0){ prnBuffer[k]=-1 ; } else { prnBuffer[k]=1 ; }
    print(newBit ^ 1 ) ;
    }
  println() ; 
  }

void generateReSampledSequence1(){
  for(int k=0 ; k<prnSequenceLength ; k++){
    prnBuffer[k]=0 ; 
    }
  int p1=1 ;
  int p2=0 ;
  int p3=0 ;
  int p4=0 ;
  int p5=0 ;
  int p6=0 ;
  int p7=0 ;
  int p8=0 ;
  int p9=0 ;  
  for(int k=0 ; k<prnSequenceLength ; k++){
    int newBit=p5 ^ p9 ;
    print(newBit) ;
    if(newBit!=0){ prnBuffer[k]=-1 ; } else { prnBuffer[k]=1 ; }
    p9=p8 ;
    p8=p7 ;
    p7=p6 ;
    p6=p5 ;
    p5=p4 ;
    p4=p3 ;
    p3=p2 ;
    p2=p1 ;
    p1=newBit ;    
    }
  
  
  }
  

//----------------------------------------------------------------------------------------  

void outPutc(char c){
  print(c) ;
  }

void outPutc(int d){
  print((char) d) ;
  }


void outPutsPgm( String cp){
  print(cp) ;
  }

void outBlank() {
  print(" ") ;  
  }

void outCrlf() {
  println(" ") ;  
  }  

int ParityBit,P1,P2,P3 ;

int getBCD(int[] TheBits, int BitPos , int BitCount){
  int value ;
  int k,q ;
  value=0 ;
  q=1 ;
  for (k=0 ; k<BitCount ; k++ ) { 
    if ( TheBits[BitPos++]>0 ) { value += q ; ParityBit ^= 1 ; }
    q=2*q ;
    }
  return value ;
  }


void DisplayTime(String s, int[] TheBits){
  int min1 ;
  int min10 ;
  int hrs1 ;
  int hrs10 ;
  int day1 ;
  int day10 ;
  int month1 ;
  int month10 ;
  int weekday ;
  int year1 ;
  int year10 ;

 
  ParityBit=0 ;
  min1=getBCD(TheBits,21,4) ;
  min10=getBCD(TheBits,25,3) ;
  P1=ParityBit ^ TheBits[28] ;

  ParityBit=0 ;       
  hrs1=getBCD(TheBits,29,4) ;
  hrs10=getBCD(TheBits,33,2) ;
  P2=ParityBit ^ TheBits[35] ;
           
  ParityBit=0 ;     
  day1=getBCD(TheBits,36,4) ;
  day10=getBCD(TheBits,40,2) ;
  weekday=getBCD(TheBits,42,3) ;
  month1=getBCD(TheBits,45,4) ;
  month10=getBCD(TheBits,49,1) ;
  year1=getBCD(TheBits,50,4) ;
  year10=getBCD(TheBits,54,4) ;
  P3=ParityBit ^ TheBits[58] ;

  print(" "+s) ;
  outPutc(':') ;  
  outPutc(' ') ;  
 
  outPutc('0'+hrs10) ;
  outPutc('0'+hrs1) ;
  outPutc(':') ;
  outPutc('0'+min10) ;
  outPutc('0'+min1) ;
  outBlank() ;
  outPutc('0'+day10) ;
  outPutc('0'+day1) ;
  outPutc('.') ;

  outPutc('0'+month10) ;
  outPutc('0'+month1) ;
  outPutc(' ') ;
  
  if ( weekday==1) {  outPutsPgm(  "MONDAY   ") ; }  
  if ( weekday==2) {  outPutsPgm(  "TUESDAY  ") ; }
  if ( weekday==3) {  outPutsPgm(  "WEDNESDAY") ; }
  if ( weekday==4) {  outPutsPgm(  "THURSDAY ") ; }
  if ( weekday==5) {  outPutsPgm(  "FRIDAY   ") ; }
  if ( weekday==6) {  outPutsPgm(  "SATURDAY ") ; }
  if ( weekday==7) {  outPutsPgm(  "SUNDAY   ") ; }
  outBlank() ;
  outPutc('2') ;
  outPutc('0') ;
  outPutc('0'+year10) ;
  outPutc('0'+year1) ;
  outBlank() ;
  outPutc('p') ;
  outPutc('0'+P1) ;
  outPutc('0'+P2) ;
  outPutc('0'+P3) ;

    
  // outCrlf() ; 
  }

//----------------------------------------------------------------------------------------


void keyPressed() {
  switch(key) {
    case 'x':  break;
    }
  }

void stop(){
  println("stop()...") ; 
  input.close();
  minim.stop();
  super.stop();
}
