public class IIRfilter {
  double sqr(double x){ return x*x ; }
  double abs(double x){ return Math.abs(x) ; }
  double sqrt(double x){ return Math.sqrt(x) ; }
  
  double ln(double x){ return Math.log(x) ; }
  double exp(double x){ return Math.exp(x) ; }
  double sin(double x){ return Math.sin(x) ; }
  double cos(double x){ return Math.cos(x) ; }
  
  double dBfun(double x){ return 20*Math.log10(x) ; }
  double exp10(double x){ return Math.pow(10.0,x) ; }   
  
 public double a0 ;
 public double[]  w1,w2,ca1,ca2,cb1,cb2,s1,s2 ;
 public double[]  ca1save,ca2save,cb1save,cb2save ;
 public int nsec ;
 
 float alphaLP=0.9 ;

  void getArrays(int nsecPar){
  nsec=nsecPar ;
  int nsec1=100 ;
  ca1=new double[nsec1] ;
  ca2=new double[nsec1] ;
  cb1=new double[nsec1] ;
  cb2=new double[nsec1] ;
  ca1save=new double[nsec1] ;
  ca2save=new double[nsec1] ;
  cb1save=new double[nsec1] ;
  cb2save=new double[nsec1] ;    
  
  w1=new double[nsec] ;
  w2=new double[nsec] ;
  s1=new double[nsec] ;
  s2=new double[nsec] ;
  } 
  
  public double secabs(double x,double y,double a1,double a2){
  return sqr(x*x-y*y+a1*x+a2)+sqr(2*x*y+a1*y) ;
  }


float firstOrderGain(float x, float y) {
  float pRe=1-alphaLP ;
  float pIm=0 ;
  float absP=(float) sqrt(sqr(pRe)+sqr(pIm)) ;
  
  float ziRe=x ;
  float ziIm=y ;
  float qRe=1-alphaLP*ziRe ;
  float qIm=-alphaLP*ziIm ;
  float absQ=(float) sqrt(sqr(qRe)+sqr(qIm)) ;
  return absP/absQ ;
  }
  
  
  public double tpabs(double x, double y){
  double hh ;
  hh=1 ;
  for (int  i=0 ; i<nsec ; i++){
    hh=hh*secabs(x,y,cb1[i],cb2[i])/secabs(x,y,ca1[i],ca2[i]) ;
    }
  hh=a0*sqrt(hh) ;
  return hh ;
  }
  
  public void scaleAtFrequency(double omega){
  double hRef=tpabs(cos(omega),sin(omega)) ;  
    a0=a0/hRef ;
    }
  

  
  public void resetIIR() {
  for (int  i=0 ; i<nsec ; i++){
      w1[i]=0 ; 
      w2[i]=0 ;
      s1[i]=0 ; 
      s2[i]=0 ;
      }
    }
    
  public double runIIR(double x){ 
    double w,w11,w22,y ;
    double s1New,s2New ;
    y=0 ;
    for (int  i=0 ; i<nsec ; i++){
/*
    w11=w1[i] ; 
      w22=w2[i] ;
      w=x-ca1[i]*w11-ca2[i]*w22 ;
      y=w+cb1[i]*w11+cb2[i]*w22 ;
      w2[i]=w11 ; 
      w1[i]=w ; 
      x=y ;
     */
      y=x+s1[i] ;
      s1New=-ca1[i]*s1[i]+(cb1[i]-ca1[i])*x+s2[i] ;
      s2New=-ca2[i]*s1[i]+(cb2[i]-ca2[i])*x ;
      s1[i]=s1New ;
      s2[i]=s2New ;
      x=y ;

      }
   return a0*y ;
   }
    
void tpmirror() {
// lowpass to highpass transform 
  System.out.println("tpmirror nsec="+nsec) ;
  for (int  i=0 ; i<nsec ; i++){
    ca1[i]=-ca1[i] ; 
    cb1[i]=-cb1[i] ; 
     }
  }  
    
  
}   
    

public class LpIIRfilter1 extends IIRfilter {
 // double sqr(double x){ return x*x ; }
 // double abs(double x){ return Math.abs(x) ; }
 // double sqrt(double x){ return Math.sqrt(x) ; }
  
 // double ln(double x){ return Math.log(x) ; }
 // double exp(double x){ return Math.exp(x) ; }
 // double sin(double x){ return Math.sin(x) ; }
 // double cos(double x){ return Math.cos(x) ; }
  
 // double dBfun(double x){ return 20*Math.log10(x) ; }
 // double exp10(double x){ return Math.pow(10.0,x) ; }   

  
 
  public void bandpass(double frq,double rho){
    getArrays(1) ;
    ca1[0]=-2*rho*Math.cos(frq*2*Math.PI) ;
    ca2[0]=rho*rho ;
    cb1[0]=0 ;
    cb2[0]=-1 ;
    a0=1 ;
    }

  public void tscheby(int nOrd, double  frq, double rip){
    int i ; 
    double a0x,eps,a,b,s1,s2,t,c1,w,ww,u,v,d ;
    if ((nOrd % 2)!=0) { System.out.println("nord wrong in Tscheby") ; System.exit(1) ; }
    getArrays(nOrd / 2) ;
    a0x=1.0 ;
    eps=sqrt(1/sqr(1-rip)-1) ;
    s1=sqrt(1/sqr(eps)+1)+1/eps ;
    s1=exp(ln(s1)/nOrd) ;
    s2=1/s1 ; 
    a=0.5*(s1-s2) ;
    b=0.5*(s1+s2) ;
    int k=0 ;
    for (i=nOrd ; i<=3*nsec-1 ; i++){
      t=(2*i+1.0)/(2.0*nOrd)*Math.PI ;
      c1=Math.PI*frq ;
      w=sin(c1)/cos(c1) ;
      ww=w*w ;
      u=1-a*w*cos(t) ;
      d=u*u+b*b*ww*sqr(sin(t)) ;
      u=2*u/d-1 ;
      v=2*b*w*sin(t)/d ;
    
      ca1[k]=-2*u ;
      ca2[k]=u*u+v*v ;
      //System.out.println(String.format("ca1=%15.7f ca2=%15.7f",ca1[k],ca2[k])) ;
      cb1[k]=2 ; 
      cb2[k]=1 ;
      k++ ;
      a0x=a0x*(1-2*u+u*u+v*v)/4.0 ;
      //  writeln('1/a0x=',1/a0x) ;}
      }
    //writeln('a0=',a0x) ;}
    a0=a0x ;
    }


public void butter(int nOrd, double  frq) { 
  int i ; 
  double a0x,b,t,c1,w,ww,u,v,d;
  if ((nOrd % 2) != 0){ System.out.println("nord wrong in Butterworth") ; System.exit(1) ; }
  getArrays(nOrd / 2 ) ;
  a0x=1.0 ;
  int k=0 ;
  for( i=nOrd ; i<=3*nsec-1 ; i++){
    t=(2*i+1.0)/(2.0*nOrd)*Math.PI ;
    c1=Math.PI*frq ;
    w=sin(c1)/cos(c1) ;
    ww=w*w ;
    b=2*w ;
    d=1-b*cos(t)+ww ;
    u=(1-ww)/d ;
    v=b*sin(t)/d ;
  
    ca1[k]=-2*u ;
    ca2[k]=u*u+v*v ;
//{  writeln(b1[sectop],b2[sectop]) ;}
    cb1[k]=2 ; 
    cb2[k]=1 ;
    k++ ;
    a0x=a0x*(1-2*u+u*u+v*v)/4 ;
    }
  //{writeln('a0=',a0x) ;}
  a0=a0x ;
  }

//public class EllipticFilter1 extends LpIIRfilter1 {
  
  double sqr(double x){ return x*x ; }
  double abs(double x){ return Math.abs(x) ; }
  double sqrt(double x){ return Math.sqrt(x) ; }
  double ln(double x){ return Math.log(x) ; }
  double exp(double x){ return Math.exp(x) ; }
  double sin(double x){ return Math.sin(x) ; }
  double cos(double x){ return Math.cos(x) ; }
  
  double dBfun(double x){ return 20*Math.log10(x) ; }
  double exp10(double x){ return Math.pow(10.0,x) ; }   
  

//{ construction of elliptic filters }
//{ elliptic filter design }
//{ Martin Ohsmann 12.1.1990 }
//{ following Gold,B.,Rader,C.M.,
//  Digital processing of signals, Mc Graw Hill 1969 }

double tan(double x){
 return sin(x)/cos(x) ;
  }

double K_of_m(double m){
  double a0,b0,a1,b1 ;
  a0=1 ; 
  a1=0 ;
  b0=sqrt(1-m) ;
  // AGM 
  for(int i=1 ; i<=10 ; i++){
    a1=0.5*(a0+b0) ; 
    b1=sqrt(a0*b0) ; 
    a0=a1 ; 
    b0=b1 ;
    }
  return Math.PI/(2*a1) ; // {K(m)}
  }

double Ks_of_m(double m){
  return   K_of_m(1-m) ; 
  }


double r_sn(double u,double m){
  // Abramowitz 16.12 pp573 and 16.13.1 pp 573 
  double m1,my,v,sn1;
  //System.out.println("sn("+u+" , "+m+")") ;
  //System.exit(1) ;
  if (m<1.0e-10){   
    return sin(u)-0.25*m*(u-sin(u)*cos(u))*cos(u) ;
    }
   else{
    m1=1-m ;
    my=sqr((1-sqrt(m1))/(1+sqrt(m1))) ;
    v=u/(1+sqrt(my)) ;
    sn1=r_sn(v,my) ;
    return (1+sqrt(my))*sn1/(1+sqrt(my)*sqr(sn1)) ;
    }
  }

double VARsn,VARcn,VARdn ;

void get_sn_cn_dn(double u,double m){
  VARsn=r_sn(u,m) ; 
  VARcn=sqrt(1-sqr(VARsn)) ; 
  VARdn=sqrt(1-m*sqr(VARsn)) ;
  }

double sc(double u,double m){
  get_sn_cn_dn(u,m) ; 
  return VARsn/VARcn ;
  }

double VARu335,VARv335;
void map335(double x, double y) {
  VARu335=(1-sqr(x)-sqr(y))/(sqr(1-x)+sqr(y)) ;
  VARv335=2*y/(sqr(1-x)+sqr(y)) ;
  //write('u,v=',u:12:8,' ',v:12:8) ;
  }

double  VARsigma,VARomega ;

void get_sigma_omega(double q, double r,double k) {
  double sn,cn,dn,sns,cns,dns,ks ;
  ks=sqrt(1-sqr(k)) ;
  get_sn_cn_dn(r,sqr(k)) ; sn=VARsn ; cn=VARcn ; dn=VARdn ;
  get_sn_cn_dn(q,sqr(ks)) ; sns=VARsn ; cns=VARcn ; dns=VARdn ;
  VARsigma=(sns*cns*cn*dn)/(1-sqr(sns*dn)) ;
  VARomega=(sn*dns)/(1-sqr(sns*dn)) ;
  }



double zre[],zim[],pre[],pim[] ; 

int nz,np ;

public  double get_hsqr(double phi) {
  double x,y,t ;
  double hsqr=1 ;
  x=cos(phi) ; y=sin(phi) ;
  for (int i=1 ; i<=np ; i++){
  t=sqr(pre[i]-x)+sqr(pim[i]-y) ;
  hsqr=hsqr/t ;
  }
  for (int i=1 ; i<=nz ; i++){
  t=sqr(zre[i]-x)+sqr(zim[i]-y) ; 
  hsqr=hsqr*t ; 
  }
  return hsqr ;
  }

public void ellfil1(double omegac,double omegar,double biga,double eps,double bigt){

double k1,k,K_of_k,K_of_k1,Ks_of_k,Ks_of_k1 ;
double u0,bign,q,r ;
double t,omegac1 ;
double h0,u,v,sigma,omega ;
int i,intn,l ;



/*
procedure plot_hsqr ;
var phi,dphi,h,h0:rtyp ; first:boolean ;
begin
{
grsetup ;
move(0,1) ; draw(pi,1) ;
move(0,1/(1+sqr(eps))) ; draw(pi,1/(1+sqr(eps))) ;
move(0,1/sqr(biga)) ; draw(pi,1/sqr(biga)) ;
move(omegac*bigt,10) ; draw(omegac*bigt,0.1/sqr(biga)) ;
move(omegar*bigt,10) ; draw(omegar*bigt,0.1/sqr(biga)) ;

get_hsqr(0,h0) ;
if not odd(np) then h0:=h0*(1+sqr(eps)) ;
phi:=0 ; dphi:=pi/500 ; first:=true ;
while phi<pi+dphi do
  begin
  get_hsqr(phi,h) ; h:=h/h0 ;
  if first then move(phi,h) else draw(phi,h) ;
  first:=false ; phi:=phi+dphi ;
  end ;
readln ;
grbye ;
}
end ;
*/

  //System.out.println("elliptic filter design...") ;
  
  zre=new double[100] ;
  zim=new double[100] ;
  pre=new double[100] ;
  pim=new double[100] ; 
      
  k1=eps/sqrt(sqr(biga)-1) ;
  k=tan(omegac*bigt/2)/tan(omegar*bigt/2) ;
 // System.out.println("k1="+k1+" k ="+k) ;
  K_of_k=K_of_m(sqr(k)) ; 
  K_of_k1=K_of_m(sqr(k1)) ;
  Ks_of_k=Ks_of_m(sqr(k)) ; 
  Ks_of_k1=Ks_of_m(sqr(k1)) ;
  //System.out.println("K_of_k  ="+ K_of_k) ;
  //System.out.println("K_of_k1 ="+ K_of_k1) ;
  //System.out.println("Ks_of_k ="+ Ks_of_k) ;
  //System.out.println("Ks_of_k1="+ Ks_of_k1) ;
  
  /* writeln(K_of_k,K_of_k1) ; writeln(Ks_of_k,Ks_of_k1) ; */
  bign=Ks_of_k1*K_of_k/(K_of_k1*Ks_of_k) ;
  System.out.println("N="+bign) ;
  intn=(int)(bign)+1 ;
  if ((intn & 1) !=0) {
    System.out.println("Warning n="+intn+" changed to "+(intn+1)) ;
    intn=intn+1 ;
    System.out.println("Warning n="+intn+" used!") ;
    }
  //System.out.println("int n="+intn) ;
  u0=-Ks_of_k/Ks_of_k1*ln((sqrt(1+sqr(eps))+1)/eps) ;
  System.out.println("u0="+u0) ;
  t=u0 *(-K_of_k1*bign)/K_of_k ;
  //System.out.println(""+(eps*sc(t,1-sqr(k1)))+" =1 is a check computation") ;
  bign=intn ;
  omegac1=tan(omegac*bigt/2) ;
  //System.out.println("use omegac="+omegac1+" in 3.29") ;
  np=0 ; nz=0 ;
  if ((intn & 1) !=0){
    for (l=0 ; l<=intn/2 ; l++){
    r =(2*l)*K_of_k/bign ;
    q =u0 ; 
    System.out.print("pole ") ;
    get_sigma_omega(q,r,k) ;
    sigma=VARsigma ; omega=VARomega ;
    sigma=sigma*omegac1 ; omega=omega*omegac1 ; map335(sigma,omega) ;
    u=VARu335 ; v=VARv335 ;
    pre[np+1]=u ; pim[np+1]=v ;
    System.out.print(String.format(" %10.4f +i %10.4f ",u,v)) ;
    if ( l!=0){
      pre[np+2]=u ; pim[np+2]=-v ;
      System.out.print(String.format(" and  %10.4f +i %10.4f ",u,-v)) ;
      np=np+2 ;
      }
     else{
      np=np+1 ;
      }
    System.out.println();
    System.out.print("zero ") ; 
    q=-Ks_of_k ;
    if ( l != 0){
      get_sigma_omega(q,r+0.000001,k) ;
      sigma=VARsigma ; omega=VARomega ;
      sigma=sigma*omegac1 ; omega=omega*omegac1 ; map335(sigma,omega) ;
      u=VARu335 ; v=VARv335 ;
      zre[nz+1]=u ; zim[nz+1]=v ;
      zre[nz+2]=u ; zim[nz+2]=-v ;
      System.out.print(String.format(" %10.4f +/- i %10.4f ",u,v)) ;
      nz=nz+2 ;
      }
     else{      
      zre[nz+1]=-1 ; zim[nz+1]=0 ;
      System.out.print("re="+(-1)+" im=0") ;
      nz=nz+1 ;
      }
    System.out.println() ;
    }
  }
 else{
  for ( l=0 ; l <= ((int) (bign+0.5) / 2)-1 ; l++){
    r=(1+2*l)*K_of_k/bign ;
    q=u0 ; 
    //System.out.print("pole ") ;
    get_sigma_omega(q,r,k) ;
    sigma=VARsigma ; omega=VARomega ;
    sigma=sigma*omegac1 ; omega=omega*omegac1 ; map335(sigma,omega) ;
    u=VARu335 ; v=VARv335 ;
    pre[np+1]=u ; pim[np+1]=v ;
    pre[np+2]=u ; pim[np+2]=-v ;
    np=np+2 ;
    //System.out.print(" zero ") ; 
    q=-Ks_of_k ;
    get_sigma_omega(q,r,k) ;
    sigma=VARsigma ; omega=VARomega ;
    sigma=sigma*omegac1 ; omega=omega*omegac1 ; map335(sigma,omega) ;
    u=VARu335 ; v=VARv335 ;
    zre[nz+1]=u ; zim[nz+1]=v ;
    zre[nz+2]=u ; zim[nz+2]=-v ;
    nz=nz+2 ;
    //System.out.println() ;
    }
  }

  if (np != nz){ System.out.println("np<>nz") ; System.exit(1) ; }
  if ( (np & 1) != 0){ System.out.println("odd(nz)") ; System.exit(1) ; }
  //System.out.println("filter put into list storage") ;
  getArrays(np/2) ;
  int kSection=0 ;
  for (i=1 ; i<= np/ 2 ; i++){
    u=pre[2*i-1] ; v=pim[2*i-1] ;
    ca1[kSection]=-2*u ; 
    ca2[kSection]=u*u+v*v ;
    u=zre[2*i-1] ; v=zim[2*i-1] ;
    cb1[kSection]=-2*u ; 
    cb2[kSection]=u*u+v*v ;
    //System.out.println(String.format("ca1=%15.7f ca2=%15.7f cb1=%15.7f cb2=%15.7f",ca1[kSection],ca2[kSection],cb1[kSection],cb2[kSection])) ;
    kSection++;
    }
  h0=get_hsqr(0.0) ;
//  if ((intn & 1)==0) { h0=h0*(1+sqr(eps)) ;}
  //h0=h0*sqrt((1+sqr(eps))) ;
  a0=1/sqrt(h0) ;
  //System.out.println("eps="+eps) ;
  }


//}





  
/*
{ LPLIB.PAS Lowpass filter design }

const maxsec=50 ; maxfil=10 ;

var a0:array[1..maxfil] of rtyp ;
    secstart,seccnt:array[1..maxfil] of integer ;
    w1,w2,a1,a2,b1,b2:array[1..maxsec] of rtyp ;
    filtop,sectop:integer ;

function bandpass(frq,rho:rtyp) :integer;
var i,nsec:integer ; a0x,eps,a,b,s1,s2,t,c1,w,ww,u,v,d:rtyp;
begin
filtop:=filtop+1 ;
if filtop>maxfil then writeln('maxfil error') ;
nsec:=1 ;
secstart[filtop]:=sectop+1 ;
seccnt[filtop]:=nsec ;
sectop:=sectop+1 ;
b1[sectop]:=-2*rho*cos(frq*2*pi) ;
b2[sectop]:=rho*rho ;
a1[sectop]:=0 ;
a2[sectop]:=-1 ;
a0[filtop]:=1 ;
bandpass:=filtop ;
end;

function tscheby(nord:integer; frq,rip:rtyp) :integer;
var i,nsec:integer ; a0x,eps,a,b,s1,s2,t,c1,w,ww,u,v,d:rtyp;
begin
{
frq:=0.5*frq ;
writeln('WARNING FROM TSCHEBY...') ;
}
if (nord mod 2)<>0 then writeln('nord wrong in Tscheby') ;
filtop:=filtop+1 ;
if filtop>maxfil then writeln('maxfil error') ;
nsec:=nord div 2 ;
secstart[filtop]:=sectop+1 ;
seccnt[filtop]:=nsec ;
a0x:=1.0 ;
eps:=sqrt(1/sqr(1-rip)-1) ;
s1:=sqrt(1/sqr(eps)+1)+1/eps ;
s1:=exp(ln(s1)/nord) ;
s2:=1/s1 ;
a:=0.5*(s1-s2) ;
b:=0.5*(s1+s2) ;
for i:=nord to 3*nsec-1 do
  begin
  t:=(2*i+1)/(2*nord)*pi ;
  c1:=pi*frq ;
  w:=sin(c1)/cos(c1) ;
  ww:=w*w ;
  u:=1-a*w*cos(t) ;
  d:=u*u+b*b*ww*sqr(sin(t)) ;
  u:=2*u/d-1 ;
  v:=2*b*w*sin(t)/d ;
  sectop:=sectop+1 ;
  b1[sectop]:=-2*u ;
  b2[sectop]:=u*u+v*v ;
{  writeln(b1[sectop],b2[sectop]) ;}
  a1[sectop]:=2 ; a2[sectop]:=1 ;
  a0x:=a0x*(1-2*u+u*u+v*v)/4 ;
{  writeln('1/a0x=',1/a0x) ;}
  end ;
{writeln('a0=',a0x) ;}
a0[filtop]:=a0x ;
tscheby:=filtop ;
end;


function butter(nord:integer; frq:rtyp):integer ;
var i,nsec:integer ; a0x,eps,a,b,s1,s2,t,c1,w,ww,u,v,d:rtyp;
begin
if (nord mod 2)<>0 then writeln('nord wrong in Tscheby') ;
filtop:=filtop+1 ;
if filtop>maxfil then writeln('maxfil error') ;
nsec:=nord div 2 ;
secstart[filtop]:=sectop+1 ;
seccnt[filtop]:=nsec ;
a0x:=1.0 ;
for i:=nord to 3*nsec-1 do
  begin
  t:=(2*i+1)/(2*nord)*pi ;
  c1:=pi*frq ;
  w:=sin(c1)/cos(c1) ;
  ww:=w*w ;
  b:=2*w ;
  d:=1-b*cos(t)+ww ;
  u:=(1-ww)/d ;
  v:=b*sin(t)/d ;
  sectop:=sectop+1 ;
  b1[sectop]:=-2*u ;
  b2[sectop]:=u*u+v*v ;
{  writeln(b1[sectop],b2[sectop]) ;}
  a1[sectop]:=2 ; a2[sectop]:=1 ;
  a0x:=a0x*(1-2*u+u*u+v*v)/4 ;
  end ;
{writeln('a0=',a0x) ;}
a0[filtop]:=a0x ;
butter:=filtop ;
end;



procedure tpreset(filno:integer) ;
var i:integer ;
begin
for i:=secstart[filno] to secstart[filno]+seccnt[filno]-1 do
  begin w1[i]:=0 ; w2[i]:=0 ; end ;
end ;

procedure tpmirror(filno:integer) ;
{ lowpass to highpass transform }
var i:integer ;
begin
for i:=secstart[filno] to secstart[filno]+seccnt[filno]-1 do
  begin a1[i]:=-a1[i] ; b1[i]:=-b1[i] ; end ;
end ;

function tprun(filno:integer; x:rtyp) :rtyp;
var i:integer ; w,w11,w22,y:rtyp ;
begin
for i:=secstart[filno] to secstart[filno]+seccnt[filno]-1 do
  begin
  w11:=w1[i] ; w22:=w2[i] ;
  w:=x-b1[i]*w11-b2[i]*w22 ;
  y:=w+a1[i]*w11+a2[i]*w22 ;
  w2[i]:=w11 ; w1[i]:=w ; x:=y ;
  end ;
tprun:=a0[filno]*y ;
end ;

function secabs(x,y,a1,a2:rtyp):rtyp ;
begin
secabs:=sqr(x*x-y*y+a1*x+a2)+sqr(2*x*y+a1*y) ;
end ;

function tpabs(filno:integer; x,y:rtyp) :rtyp;
var i:integer ; hh:rtyp ;
begin
hh:=1 ;
for i:=secstart[filno] to secstart[filno]+seccnt[filno]-1 do
  begin
  hh:=hh*secabs(x,y,a1[i],a2[i])/secabs(x,y,b1[i],b2[i]) ;
  end ;
hh:=a0[filno]*sqrt(hh) ;
tpabs:=hh ;
end ;

procedure tpinit ;
begin
filtop:=0 ; sectop:=0 ;
end ;
*/
}
