import ddf.minim.*;
import ddf.minim.spi.AudioStream;
 
float fSample=44100 ;
float tSample=1.0/fSample ;
float IFfrq=1000 ;
int LOsign=1 ;
int sigSign=1 ;

float time500=0 ;

boolean stop=false ;


//---------------------------------------------------------------------------------------   

Minim minim;

AudioStream input ;
MultiChannelBuffer buffer; 


int scopeXsize = 800;
int scopeX=0 ;
int dspXsize=500 ;

LpIIRfilter1 filterII=new LpIIRfilter1() ;
LpIIRfilter1 filterQQ=new LpIIRfilter1() ;
LpIIRfilter1 demodFil=new LpIIRfilter1() ;

   
void settings(){
  size(scopeXsize, 400, P3D);
  }
  
  
void setup(){
  println("setup()...") ;
  minim = new Minim(this);
  input=minim.getInputStream(Minim.STEREO,2048,fSample,16) ; // 
  input.open() ;
  buffer= new MultiChannelBuffer(1024, input.getFormat().getChannels());
  println("buffer.getChannelCount()="+buffer.getChannelCount()) ;
  println("buffer.getBufferSize()="+buffer.getBufferSize() ) ;
 
  filterII.butter(2,25.0/fSample ) ;
  filterQQ.butter(2,25.0/fSample ) ;
  demodFil.butter(4,25.0/fSample) ;
  
  TDFinit() ;
  background(0) ;
 strokeWeight(2) ;
  }
 

int iGet=Integer.MAX_VALUE ;
float signal=0 ;
float dummy=0 ;

void getSignal(){
  if(iGet>=buffer.getBufferSize()){ 
    iGet=0 ;
    input.read(buffer) ;
    }
  dummy=buffer.getSample(0,iGet) ;
  signal=buffer.getSample(1,iGet) ;
  iGet++ ;
  }  
  
float gain=50 ; 

int k=0 ;
 
float phi=0 ;
float phiLast=0 ;
float diff=0 ;
float extendedPhi=0 ;

float IFphi=0 ;
float scopeY1last=0 ;
float scopeY2last=0 ;

void doScope(float y1, color c1, float y2, color c2){
 // strokeWeight(2) ;
  if(scopeX>0){
    stroke(c1) ; 
    line(scopeX-1, 200 - scopeY1last*gain, scopeX, 200 - y1*gain);
    stroke(c2) ;
    line(scopeX-1, 200 - scopeY2last*gain, scopeX, 200 - y2*gain);
    }
  scopeY1last=y1 ;
  scopeY2last=y2 ;
  scopeX++ ;
  if(scopeX>=scopeXsize){ 
    scopeX=0 ;
    background(0) ;
    stroke(0,0,255) ; line(0,200,scopeXsize,200) ;
    }
  }
  
int nSamples ;

//float threshold=0.1 ;
float scopeY1=0 ;
float scopeY2=0 ;
//float THRESHOLD1=600 ;
float THRESHOLD1=500 ;

void draw(){
  stroke(255);
  if(mousePressed){ save("tdfPic1.png") ; }
  nSamples=0 ;
  while(nSamples<1000  ){
    nSamples++ ;
    getSignal() ;
   
    IFphi += IFfrq/fSample*2*PI ;
    while(IFphi>2*PI){ IFphi -= 2*PI ; }
       
    float II=signal*cos(IFphi) ;
    float QQ=signal*sin(LOsign*IFphi) ;
    
    II=(float)filterII.runIIR(II) ;
    QQ=(float)filterQQ.runIIR(QQ) ;
   
    time500 +=tSample ;
    if(time500>(1.0/500.0)){
      time500 -= 1.0/500.0 ;
      FMdemod(II,QQ) ;
      }
      
    }
  
  }

int TDFlength=50 ;
int TDFbuffer[]=new int[TDFlength] ;
int TDFintegrator ;

int TDFptr ;
int ptr ;

int TheSecond ;
int TheBit ;


void TDFinit(){
  TDFptr=0 ;
  TheSecond=0 ;
  TDFintegrator=0 ;
  ptr=0 ;
  }

void advance(int d){  
  ptr += d ;
  if ( ptr >= TDFlength ) { ptr -= TDFlength ; }
  }

int MatchedFilter(int Frequency){
  int sum ;
  // CIC implementation of matched filter
  ptr=TDFptr ;
  // ptr points to oldest sample in TDFbuffer
  sum=-TDFbuffer[ptr] ;
  advance(12) ;
  sum += 2*TDFbuffer[ptr] ;
  advance(25) ;
  sum -= 2*TDFbuffer[ptr] ;
  advance(12) ;
  sum +=   TDFbuffer[ptr] ;

  TDFintegrator += Frequency ;
  // replace oldest sample in buffer
  TDFbuffer[TDFptr]=TDFintegrator ;
  TDFptr++ ;
  if ( TDFptr==TDFlength) {
    TDFptr=0 ;
    }
  return sum ;
  }

int SilenceTimer ;
float SecondTimer ;
int x0,x1,x2,Frequency ;

void searchForPeak(){
  if ( ( x1>=x0 ) && (x1>x2) && (x1>THRESHOLD1) ) {
    println("peak found!") ;
    SecondTimer=0 ; 
    SilenceTimer=0 ;
    TheSecond=0 ;
    DisplayTime() ;
    }
  }

void checkForGap(){
  SilenceTimer++ ;
  if ( ( x1>THRESHOLD1 ) & ( SilenceTimer<390) )  { 
    SilenceTimer=0 ; }
  if ( SilenceTimer>400 ) {
    SilenceTimer=400 ;
    // print("gap ") ;
    searchForPeak() ;
    }
  }
  
void exeSecondTimer(){
  SecondTimer += (1.00-0.0002) ;
  if (SecondTimer>=500.0) {
    SecondTimer-=500.0 ; 
    }
  if (((int)SecondTimer)==50){
    if ( x1>THRESHOLD1 ) { 
      TheBit=1 ; 
      }
     else {
      TheBit=0 ;
      }
    print(TheBit) ;
  /*  String txt1=String.format("%2d,",TheSecond) ;
    text(txt1, 10+20*TheSecond, 30);
    String txt2=String.format("%1d,",TheBit) ;
    text(txt2, 10+20*TheSecond, 50);
  */  
    if(TheSecond>61){
      print(" gap error!") ;
      TheSecond=0 ;
      }
    if (TheSecond<60) { 
      TheBits[TheSecond]=TheBit ; 
      }
    TheSecond++ ;
    }
  }
  
byte Phase ;
byte LastPhase ;
byte PhaseDifference ;
byte FrequencyEstimate ;
short ExtendedPhase ;  

int FRQlength=8 ;
int FRQdivider=1 ;

int FRQfifo[]=new int[FRQlength] ;
int FRQintegrator=0 ;
int FRQcicout=0 ;
int FRQfifoPTR=0 ;

int xx=0 ;
int xxLast=0 ;
int yy=0 ;
int yyLast=0 ;
color yyColor ;
  
//int cnt3=0 ;
int cnt2 ;

void FMdemod(float II, float QQ){
 
  float phi=-sigSign*atan2(II,QQ) ;
  Phase=(byte)( (phi+PI)/PI*128) ;
  PhaseDifference=byte(Phase-LastPhase) ;
  LastPhase=Phase ;
  ExtendedPhase += PhaseDifference ;

  FrequencyEstimate = PhaseDifference ;
  // cic lowpass
  FRQintegrator += FrequencyEstimate ;
  FRQcicout = FRQintegrator - FRQfifo[FRQfifoPTR] ;
  FRQfifo[FRQfifoPTR] =  FRQintegrator ;
// advance pointer and bump around
  FRQfifoPTR++ ; if ( FRQfifoPTR==FRQlength ) { FRQfifoPTR=0 ; }

  Frequency=FRQcicout ;
  x2=x1 ; x1=x0 ; x0=MatchedFilter(-Frequency) ;
  if(x0> THRESHOLD1){ yyColor=color(255,0,0) ; } else { yyColor=color(0,255,255) ; }
  if(x0<-THRESHOLD1){ yyColor=color(0,255,100) ; } 
  checkForGap() ;
  exeSecondTimer() ;

  if( ((int)SecondTimer)==450){ xx=0 ; xxLast=0 ; yy=(int)(180-0.05*x0) ; yyLast=yy ; }
  yy=int(200-0.05*x0) ;
  if(xx<dspXsize){ 
    stroke(yyColor) ;
    line(2*xxLast, yyLast, 2*xx,yy) ;
    }
    yyLast=yy ;
    xxLast=xx ;
    xx++ ;
  if(((int)SecondTimer)==0){  line(2*xx,100,2*xx,180) ; } 
  if(((int)SecondTimer)==50){ line(2*xx,100,2*xx,180) ; }
  cnt2++ ;
  if(cnt2>=2){
    if(!stop) { doScope(-2+0.0005*x0,yyColor,-3+SilenceTimer/400.0,yyColor  ) ; }
    cnt2=0 ;
    }  
  }


//----------------------------------------------------------------------------------------  

void outPutc(char c){
  print(c) ;
  }

void outPutc(int d){
  print((char) d) ;
  }


void outPutsPgm( String cp){
  print(cp) ;
  }

void outBlank() {
  print(" ") ;  
  }

void outCrlf() {
  println(" ") ;  
  }  

int TheBits[]=new int [60] ;



int ParityBit,P1,P2,P3 ;

int getBCD(int BitPos , int BitCount){
  int value ;
  int k,q ;
  value=0 ;
  q=1 ;
  for (k=0 ; k<BitCount ; k++ ) { 
    if ( TheBits[BitPos++]>0 ) { value += q ; ParityBit ^= 1 ; }
    q=2*q ;
    }
  return value ;
  }


void DisplayTime(){
  int min1 ;
  int min10 ;
  int hrs1 ;
  int hrs10 ;
  int day1 ;
  int day10 ;
  int month1 ;
  int month10 ;
  int weekday ;
  int year1 ;
  int year10 ;

 
  ParityBit=0 ;
  min1=getBCD(21,4) ;
  min10=getBCD(25,3) ;
  P1=ParityBit ^ TheBits[28] ;

  ParityBit=0 ;       
  hrs1=getBCD(29,4) ;
  hrs10=getBCD(33,2) ;
  P2=ParityBit ^ TheBits[35] ;
           
  ParityBit=0 ;     
  day1=getBCD(36,4) ;
  day10=getBCD(40,2) ;
  weekday=getBCD(42,3) ;
  month1=getBCD(45,4) ;
  month10=getBCD(49,1) ;
  year1=getBCD(50,4) ;
  year10=getBCD(54,4) ;
  P3=ParityBit ^ TheBits[58] ;


  outPutc('#') ; for(int k=50 ; k<58 ; k++){ outPutc('0'+TheBits[k]) ; }
  outPutc(':') ;  
  outPutc(' ') ;  
 
  outPutc('0'+hrs10) ;
  outPutc('0'+hrs1) ;
  outPutc(':') ;
  outPutc('0'+min10) ;
  outPutc('0'+min1) ;
  outBlank() ;
  outPutc('0'+day10) ;
  outPutc('0'+day1) ;
  outPutc('.') ;

  outPutc('0'+month10) ;
  outPutc('0'+month1) ;
  outPutc(' ') ;
  
  if ( weekday==1) {  outPutsPgm(  "MONDAY   ") ; }  
  if ( weekday==2) {  outPutsPgm(  "TUESDAY  ") ; }
  if ( weekday==3) {  outPutsPgm(  "WEDNESDAY") ; }
  if ( weekday==4) {  outPutsPgm(  "THURSDAY ") ; }
  if ( weekday==5) {  outPutsPgm(  "FRIDAY   ") ; }
  if ( weekday==6) {  outPutsPgm(  "SATURDAY ") ; }
  if ( weekday==7) {  outPutsPgm(  "SUNDAY   ") ; }
  outBlank() ;
  outPutc('2') ;
  outPutc('0') ;
  outPutc('0'+year10) ;
  outPutc('0'+year1) ;
  outBlank() ;
  outPutc('p') ;
  outPutc('0'+P1) ;
  outPutc('0'+P2) ;
  outPutc('0'+P3) ;

    
  outCrlf() ; 
  }

//----------------------------------------------------------------------------------------


void keyPressed() {
  switch(key) {
    case 's': stop=!stop ; break;
    }
  }

void stop(){
  println("stop()...") ; 
  input.close();
  minim.stop();
  super.stop();
}
