import ddf.minim.*;
import ddf.minim.spi.AudioStream;

boolean withMax=true ;
double MHz=1e6 ;
double kHz=1e3 ;

double Ohm=1 ;
double mW=1e-3 ;
double pi=Math.PI ;

int nPoints=8192*4 ;
double fSample=44100.0 ;
double dfFFT=fSample/nPoints ;

double fMeasureStart=950+0 ;
double fMeasureStop=1050+0 ;
String aMax ;

Minim minim;
AudioStream input ;
MultiChannelBuffer buffer; 
int iGet=Integer.MAX_VALUE ;
float LL=0 ;
float RR=0 ;

double trace1II[]=new double[nPoints] ;
double trace1QQ[]=new double[nPoints] ;

double[] spec=new double[nPoints] ;
double[] specShow=new double[nPoints] ;
double[] maxShow=new double[nPoints] ;


int xMin=0 ; int xMax=nPoints ;

// double dBmin=-50 ; double dBmax=100 ;
//double dBmin=-120-100 ; double dBmax=60 ;
double dBmin=-140 ; double dBmax=-20 ;

double yMin=-21050-100 ;
double yMax= 21050+100 ;

int  displaySizeX=1200 ;
int  displaySizeY=900 ;
  
int ykFrameX0=10 ;
int ykFrameX1=displaySizeX-10 ;
int ykFrameY0=displaySizeY-10 ;
int ykFrameY1=displaySizeY-200 ;

int dftFrameX0=10 ;
int dftFrameX1=displaySizeX-10 ;
int dftFrameY0=displaySizeY-210 ;
int dftFrameY1=displaySizeY-810 ;

double fStart=0 ;
double fStop =2000 ;

//double fStart=1000-200 ;
//double fStop =1000+200 ;

double fCursor=21000+50 ;

int Start=(int)(fStart/dfFFT) ;
int Stop=(int)(fStop/dfFFT) ;



double sqr(double x){ return x*x ; } 

double UdBref= Math.sqrt((1*mW)*(50*Ohm))  ;
float log10(float x) { return log(x)/log(10) ; }
double log10(double x) { return Math.log(x)/Math.log(10.0) ; }    
double dBfun(double y, double ref) { return 20*log10(y/ref) ; }

double UdBm(double u){
  return 20*log10((float)(u/UdBref)) ;
  }
  
double dB(double x){
  return 20*Math.log10(x) ;
  }  
double power(double x, double y) {
  return Math.exp(y*Math.log(x)) ;
  }

double linMap(double x1, double x2, double y1, double y2, double x) {
  return(y1+(x-x1)/(x2-x1)*(y2-y1)) ;
  }
  
double logMap(double x1, double x2, double y1, double y2, double x) {
 // println("xMap("+x1+" "+x2+" "+y1+" "+y2+" "+x) ;
 // print("log10(x2)-log10(x1)="+(log10(x2)-log10(x1)));
  return(y1+(log10(x)-log10(x1))/(log10(x2)-log10(x1))*(y2-y1)) ;
  }
  
double xMap(double x1, double x2, double y1, double y2, double x) {
  return linMap(x1, x2, y1, y2, x) ;
  //return logMap(x1, x2, y1, y2, x) ;
  }
  
//---------------------------------------------------------------------------------------   


  
void setup(){
  size(1200, 900);
   minim = new Minim(this);
  input=minim.getInputStream(Minim.STEREO,2048,44100,16) ; // 
  input.open() ;
  buffer= new MultiChannelBuffer(1024, input.getFormat().getChannels());
  //println("buffer.getChannelCount()="+buffer.getChannelCount()) ;
  println("buffer.getBufferSize()="+buffer.getBufferSize() ) ;
  for(int k=0 ; k<nPoints ; k++){ maxShow[k]=-1e10 ; }
  clear() ;
  }
  
FFThelper FFThelp=new FFThelper() ;


int nn=0 ;  

void readTrace(){
  //print("readTrace()...") ;
  stroke(225,25,0) ;
  if(mousePressed){ save("specPic1.png") ; }
  background(251);
  iGet=Integer.MAX_VALUE ;
  for(int k=0 ; k<nPoints ; k++){ 
    if(iGet>=buffer.getBufferSize()){ 
      iGet=0 ;
      input.read(buffer) ;
      }
    RR=buffer.getSample(0,iGet) ;
    LL=buffer.getSample(1,iGet) ;
    iGet++ ;
    trace1II[k]=RR ;
    trace1QQ[k]=LL ;
    }
  double re[]=new double[nPoints] ;
  double im[]=new double[nPoints] ;
  double inputSqSum=0.0 ;
  for (int k=0; k<nPoints; k++) {
    re[k]=trace1II[k] ;
    im[k]=trace1QQ[k] ;
    inputSqSum+=sqr(re[k])+sqr(im[k]) ;
    }
  inputSqSum=Math.sqrt(inputSqSum/nPoints) ;
  //println(String.format(" inputRMS= %8.5f = %8.3f dBm",inputSqSum,UdBm(inputSqSum))) ;
  
 
  
  
  
   double scale1=Math.sqrt(1.0/nPoints) ;
  FFThelp.windowed(nPoints, 1, scale1 , re, im) ;
 // FFThelp.fft(nPoints, 1, scale1 , re, im) ;
  double sc=sqrt(2)*scale1/0.522*0.0353*0.13 ;
  
   double amplitude=0 ;
  for (int k=0; k<nPoints ; k++) {
    amplitude=Math.sqrt(sqr(re[k])+sqr(im[k])) ;
    spec[k]=sc*amplitude ;
   // trace2[k]=amplitude ;
    }
    
  int kStart=(int)(fMeasureStart/44100*nPoints) ;
  int kStop=(int)(fMeasureStop/44100*nPoints) ;
  //println("kStart=",kStart," kStop=",kStop) ;
  double Amax=0.0 ;
  for(int k=kStart ; k<kStop ; k++){
    double a=Math.sqrt(sqr(re[k])+sqr(im[k])) ;
    a=sc*a ;
    if(a>Amax){ Amax=a ; }
    }       
//  print("Amax=",Amax) ; 
  print("Amax@f0= ", nf( (float)UdBm(Amax),3,3)," dBm  ") ;
  aMax="Amax@f0= "+nf( (float)UdBm(Amax),3,3)+" dBm  " ;
  
  kStart=0 ;
  kStop=nPoints ;
  int kMax=0 ;
  Amax=0.0 ;
  for(int k=kStart ; k<kStop ; k++){
    double a=Math.sqrt(sqr(re[k])+sqr(im[k])) ;
    a=sc*a ;
    if(a>Amax){ Amax=a ; kMax=k ; }
    }       
 // print(" total Amax=",Amax) ; 
  print("total Amax= ",nf((float)UdBm(Amax),3,3)," dBm") ;
  println("  kMax=",kMax,"  fmax=",kMax*44100/nPoints) ;
  
    
  
  }

int scaleTrace1(double y) {
  if( y<yMin ) { y=yMin ; }
  if (y>yMax ) { y=yMax ; }
  return (int) linMap(yMin, yMax, ykFrameY0, ykFrameY1, y) ;  
  }  

void brokenLine(int x0, int y0, int x1, int y1){
  double length=Math.sqrt(sqr(x1-x0)+sqr(y1-y0)) ;
  int nSegments=(int)(length/20.0) ;
  for(int k=0 ; k<nSegments ; k++){
    int xA=(int)linMap((double)0,(double)nSegments,(double)x0,(double)x1,k) ;
    int yA=(int)linMap((double)0,(double)nSegments,(double)y0,(double)y1,k) ;
    int xB=(int)linMap((double)0,(double)nSegments,(double)x0,(double)x1,k+0.2) ;
    int yB=(int)linMap((double)0,(double)nSegments,(double)y0,(double)y1,k+0.2) ;
    line(xA,yA,xB,yB) ;
    }
  }
  
void showTimeSignal(double[] trace1,double[] trace2, double scale, double dy, double uValue){
 text(String.format(" uValue= %8.5f mV eff = %10.5f dBm",uValue*1000,UdBm(uValue) ),100,15) ;
 text(String.format("%s",aMax),500,15) ;
 text(String.format(" df= %8.5f Hz",fSample/nPoints),100,30) ;
 strokeWeight(1) ;
  for(int k=0 ; k<=5 ; k++){
    int a=(int)dy+(int) scaleTrace1(scale*0.84*k/5.0) ;
     line(xMin, a, xMax, a) ;
     a=(int)dy+(int) scaleTrace1(-scale*0.84*k/5.0) ;
     line(xMin, a, xMax, a) ;
     }
     
  strokeWeight(1) ;
  for (int xk=xMin+1 ; xk<xMax ; xk++) {
    int x1=(int)(linMap(xMin, xMax ,  ykFrameX0,  ykFrameX1, xk-1)) ;
    int x2=(int)(linMap(xMin, xMax ,  ykFrameX0,  ykFrameX1, xk)) ;
    int a1=(int)dy+(int) scaleTrace1(scale*trace1[xk-1]) ;
    int a2=(int)dy+(int) scaleTrace1(scale*trace1[xk]) ;
   // println("k="+xk+" trace="+trace[xk]) ;
   // println("line("+x1+","+a1+","+x2+","+a2+")") ;
    line(x1, a1, x2, a2) ;
    
    a1=(int)dy+(int) scaleTrace1(scale*trace2[xk-1]) ;
    a2=(int)dy+(int) scaleTrace1(scale*trace2[xk]) ;
   // println("k="+xk+" trace="+trace[xk]) ;
   // println("line("+x1+","+a1+","+x2+","+a2+")") ;
    line(x1, a1, x2, a2) ;
    }
  }      
  
  
int scaledBmTrace(double y) {
  double y1=dBfun(y, 1.0) ;
  if( y1<dBmin ) { y1=dBmin ; }
  if( y1>dBmax) { y1=dBmax ; }
  return (int) linMap(dBmin, dBmax, dftFrameY0, dftFrameY1, y1) ;
  }
  
void draw(){
  int x1,x2,y1,y2,k1,k2 ;
//  print("draw()...") ;
  readTrace() ;
  nn++ ;
  double sqSum=0 ;
  for(int k=0 ; k<nPoints ; k++){
    sqSum += sqr(trace1II[k]) ;
    sqSum += sqr(trace1QQ[k]) ;
    }
  sqSum=Math.sqrt(sqSum/nPoints/2) ;
  sqSum=0.017*sqSum ;
    showTimeSignal(trace1II,trace1QQ,1250.0,0.0,sqSum) ;
  for(int k=0 ; k<nPoints ; k++){
    specShow[k]=spec[k] ;
    if(spec[k]>maxShow[k]){ maxShow[k]=spec[k] ; }
    //if(k>200){ specShow[k]=1.0 ; }
    //specMean[k]=specMean[k]+spec[k] ;
    //specShow[k]=specMean[k]/meanCount ;
    }
    
  double ss=1/0.233*1.2;
 // println("Start=",Start," Stop=",Stop) ;
  
  int mkStart=(int)(fMeasureStart/44100*nPoints) ;
  int mkStop=(int)(fMeasureStop/44100*nPoints) ;
  stroke(225,0,0) ;
   
  for (int k=Start+1; k<Stop ; k++) {    
    x1=(int)xMap(fStart,fStop,dftFrameX0,dftFrameX1,(k-1)*dfFFT) ;
    x2=(int)xMap(fStart,fStop,dftFrameX0,dftFrameX1,k*dfFFT) ;
    //y1=(int)(scaledBmTrace(specScale*specShow[k-1]*ss/UdBref)) ;
    //y2=(int)(scaledBmTrace(specScale*specShow[k]*ss/UdBref)) ;
    k1=k-1 ;
    k2=k ;
    if(k1<0){k1 += nPoints ; } 
    if(k2<0){k2 += nPoints ; } 
    y1=(int)(scaledBmTrace(specShow[k1]*ss)) ;
    y2=(int)(scaledBmTrace(specShow[k2]*ss)) ;
     
    if(k==mkStart){ stroke(100,0,255) ; }
    if(k==mkStop){ stroke(255,0,0) ; }
    
    line(x1, y1, x2, y2) ;
    }
   if(withMax){ 
     stroke(0,0,0) ; 
     for (int k=Start+1; k<Stop ; k++) {    
       x1=(int)xMap(fStart,fStop,dftFrameX0,dftFrameX1,(k-1)*dfFFT) ;
       x2=(int)xMap(fStart,fStop,dftFrameX0,dftFrameX1,k*dfFFT) ;
       k1=k-1 ;
       k2=k ;
       if(k1<0){k1 += nPoints ; } 
       if(k2<0){k2 += nPoints ; } 
       y1=(int)(scaledBmTrace(maxShow[k1]*ss)) ;
       y2=(int)(scaledBmTrace(maxShow[k2]*ss)) ;
       if(k==mkStart){ stroke(100,0,255) ; }
       if(k==mkStop){ stroke(0,0,0) ; }
       line(x1, y1, x2, y2) ;
       }
     }  
    
    
  strokeWeight(2) ;
  double fm ; int xm ;
  //fm=fTX-fShift/2 ; int xm=(int)xMap(fStart,fStop,dftFrameX0,dftFrameX1,fm) ; brokenLine(xm,dftFrameY0 ,xm,dftFrameY1) ;
  //fm=fTX+fShift/2 ; xm=(int)xMap(fStart,fStop,dftFrameX0,dftFrameX1,fm) ; brokenLine(xm,dftFrameY0 ,xm,dftFrameY1) ;
  stroke(0,0,255) ;
  fm=fCursor ; xm=(int)xMap(fStart,fStop,dftFrameX0,dftFrameX1,fm) ; line(xm,dftFrameY0 ,xm,dftFrameY1) ; 
   
  fill(0, 0, 0);
  stroke(150);
 // int  y=(int)(scaledBmTrace(100)) ;   line(dftFrameX0, y, dftFrameX1, y) ; text("+40dB",dftFrameX0,y-5) ;
 //  y=(int)(scaledBmTrace(10)) ;   line(dftFrameX0, y, dftFrameX1, y) ; text("+20dB",dftFrameX0,y-5) ;
// int  y=(int)(scaledBmTrace(1)) ;  line(dftFrameX0, y, dftFrameX1, y) ; text("  0dB",dftFrameX0,y-5) ;
int  y=(int)(scaledBmTrace(1.0/10)) ;   line(dftFrameX0, y, dftFrameX1, y) ; text("-20dBm",dftFrameX0,y-5) ;
  y=(int)(scaledBmTrace(1.0/100)) ;  line(dftFrameX0, y, dftFrameX1, y) ; text("-40dBm",dftFrameX0,y-5) ;
  y=(int)(scaledBmTrace(1.0/1000)) ; line(dftFrameX0, y, dftFrameX1, y) ; text("-60dBm",dftFrameX0,y-5) ;
  y=(int)(scaledBmTrace(1.0/10000)) ; line(dftFrameX0, y, dftFrameX1, y) ; text("-80dBm",dftFrameX0,y-5) ;
  y=(int)(scaledBmTrace(1.0/100000)) ; line(dftFrameX0, y, dftFrameX1, y) ; text("-90dBm",dftFrameX0,y-5) ;
  y=(int)(scaledBmTrace(1.0/1000000)) ; line(dftFrameX0, y, dftFrameX1, y) ; text("-100dBm",dftFrameX0,y-5) ;
    int xx ;  
    int rr=2 ;
 /*
  xx=(int)xMap(fStart,fStop,dftFrameX0,dftFrameX1,5e6) ; brokenLine(xx,dftFrameY0 ,xx,dftFrameY1) ;
  text("     5M",xx-60,dftFrameY1-10) ;
     
  xx=(int)xMap(fStart,fStop,dftFrameX0,dftFrameX1,2e6) ; brokenLine(xx,dftFrameY0 ,xx,dftFrameY1) ;
  text("     2M",xx-60,dftFrameY1-10) ;
     
  xx=(int)xMap(fStart,fStop,dftFrameX0,dftFrameX1,1e6) ; brokenLine(xx,dftFrameY0 ,xx,dftFrameY1) ;
  text("     1M",xx-60,dftFrameY1-10) ;
     
  xx=(int)xMap(fStart,fStop,dftFrameX0,dftFrameX1,500e3) ; brokenLine(xx,dftFrameY0 ,xx,dftFrameY1) ;
  text("  500k",xx-60,dftFrameY1-10) ;
     
  xx=(int)xMap(fStart,fStop,dftFrameX0,dftFrameX1,200e3) ; brokenLine(xx,dftFrameY0 ,xx,dftFrameY1) ;
  text(" 200k",xx-30,dftFrameY1-10) ;
     
  xx=(int)xMap(fStart,fStop,dftFrameX0,dftFrameX1,100e3) ; brokenLine(xx,dftFrameY0 ,xx,dftFrameY1) ;  
  text(" 100k",xx-30,dftFrameY1-10) ;
      
  xx=(int)xMap(fStart,fStop,dftFrameX0,dftFrameX1,50e3) ; brokenLine(xx,dftFrameY0 ,xx,dftFrameY1) ;
  text(" 50k",xx-30,dftFrameY1-10) ;
   */  
  xx=(int)xMap(fStart,fStop,dftFrameX0,dftFrameX1,20e3) ; brokenLine(xx,dftFrameY0 ,xx,dftFrameY1-50) ;
  text(" 20k",xx-rr,dftFrameY1-10) ;
     
  xx=(int)xMap(fStart,fStop,dftFrameX0,dftFrameX1,10e3) ; brokenLine(xx,dftFrameY0 ,xx,dftFrameY1-50) ;  
  text(" 10k",xx-rr,dftFrameY1-10) ;
      
  xx=(int)xMap(fStart,fStop,dftFrameX0,dftFrameX1,5e3) ; brokenLine(xx,dftFrameY0 ,xx,dftFrameY1-50) ;
  text(" 5k",xx-rr,dftFrameY1-10) ;
     
  xx=(int)xMap(fStart,fStop,dftFrameX0,dftFrameX1,2e3) ; brokenLine(xx,dftFrameY0 ,xx,dftFrameY1-50) ;
  text(" 2k",xx-rr,dftFrameY1-10) ;
    
  xx=(int)xMap(fStart,fStop,dftFrameX0,dftFrameX1,1e3) ; brokenLine(xx,dftFrameY0 ,xx,dftFrameY1-50) ;  
  text(" 1k",xx-rr,dftFrameY1-10) ;
       /*     
  xx=(int)xMap(fStart,fStop,dftFrameX0,dftFrameX1,500) ; brokenLine(xx,dftFrameY0 ,xx,dftFrameY1) ;
  text("500Hz",xx-rr,dftFrameY1-10) ;
     
  xx=(int)xMap(fStart,fStop,dftFrameX0,dftFrameX1,200) ; brokenLine(xx,dftFrameY0 ,xx,dftFrameY1) ;
  text("200Hz",xx-rr,dftFrameY1-10) ;
   
  xx=(int)xMap(fStart,fStop,dftFrameX0,dftFrameX1,100) ; brokenLine(xx,dftFrameY0 ,xx,dftFrameY1) ;  
  text("100Hz",xx-rr,dftFrameY1-10) ;
          
  xx=(int)xMap(fStart,fStop,dftFrameX0,dftFrameX1,50) ; brokenLine(xx,dftFrameY0 ,xx,dftFrameY1) ;
  text(" 50Hz",xx-30,dftFrameY1-10) ;
    
  xx=(int)xMap(fStart,fStop,dftFrameX0,dftFrameX1,20) ; brokenLine(xx,dftFrameY0 ,xx,dftFrameY1) ;
  text(" 20Hz",xx-30,dftFrameY1-10) ;
     
  xx=(int)xMap(fStart,fStop,dftFrameX0,dftFrameX1,10) ; brokenLine(xx,dftFrameY0 ,xx,dftFrameY1) ;  
  text(" 10Hz",xx-30,dftFrameY1-10) ;
  */         
    
  xx=(int)xMap(fStart,fStop,dftFrameX0,dftFrameX1,0) ; brokenLine(xx,dftFrameY0 ,xx,dftFrameY1-50) ;  
  text("0",xx-rr,dftFrameY1-10) ;  
    
  xx=(int)xMap(fStart,fStop,dftFrameX0,dftFrameX1,-1e3) ; brokenLine(xx,dftFrameY0 ,xx,dftFrameY1-50) ;  
  text("-1k",xx-rr,dftFrameY1-10) ;
  
 xx=(int)xMap(fStart,fStop,dftFrameX0,dftFrameX1,-2e3) ; brokenLine(xx,dftFrameY0 ,xx,dftFrameY1-50) ;  
  text("-2k",xx-rr,dftFrameY1-10) ;
  
  xx=(int)xMap(fStart,fStop,dftFrameX0,dftFrameX1,-4e3) ; brokenLine(xx,dftFrameY0 ,xx,dftFrameY1-50) ;  
  text("-4k",xx-rr,dftFrameY1-10) ;
  
  xx=(int)xMap(fStart,fStop,dftFrameX0,dftFrameX1,4e3) ; brokenLine(xx,dftFrameY0 ,xx,dftFrameY1-50) ;  
  text("4k",xx-rr,dftFrameY1-10) ;
    
    
 
  }
  
  
  
  
  
  
  
  
  
double M_PI=Math.PI ;   
  
class FFThelper{
   
  void error(String s){
  System.out.println() ;
  System.out.println("Error:"+s) ;
  System.exit(1) ;
  }


  double pi=Math.PI ;
  
  double sqr(double x){
    return x*x ;  
    }
  double ln(double x){
    return Math.log(x) ;  
    }
    
  double log10(double x){
    return Math.log(x)/Math.log(10.0) ;  
    }    
    
  double dBfun(double y, double ref){
    return 20*log10(y/ref) ;
    }
  
  int round(double x){
    return (int)(x+0.5) ;  
    }
  
  double frac(double x){
    return x-round(x) ;
    }    
    
  void windowed(int n, int flag , double scale , double[]tor, double[] toi){
     for(int k=0 ; k<n ; k++){
      //double w=0.54-0.46*Math.cos(2*Math.PI*k/(n-1)) ;
      //double w=0.5-0.5*Math.cos(2*Math.PI*k/(n-1)) ;
      double w=1.0 ;
      
      
      double alpha=0.16 ;
      double a0=(1-alpha)/2 ;
      double a1=0.5 ;
      double a2=alpha/2 ;
      w=a0-a1*Math.cos(2*Math.PI*k/(n-1))+a2*Math.cos(4*Math.PI*k/(n-1)) ;
      
      tor[k]=tor[k]*w/0.01*0.023;
     }
    
    fft(n,flag ,scale ,tor,toi) ;
    }
  



  
  
  void fft(int n, int flag , double scale , double[]tor, double[] toi) {
    //{ switch to DFT procedure if N not power of 2 }
  //for(int k=0 ; k<n ; k++) {
  //  System.out.println(String.format(" input re/im = %10.5f +im %10.5f",tor[k],toi[k])) ;
  //  }    
    int j,k,l,m,m1,n1,r,r1,r2 ;
    double re,im,a,b,ru,rv,iu,iv,rs ;
    double check ;
    check=frac(ln(n)/ln(2)+1.0e-5) ;
    //System.out.println("check="+check) ;
    if ( Math.abs(check)>1.0e-4 ){
      // write('SWITCHED to DFT') ;}
      // writeln('check=',check,' n=',n) ; readln ; halt ;
      error("cant switch to dft n="+n);
      System.exit(1) ;
      //dft(n,flag,scale,tor,toi) ;
      }
     else{
     m1=n / 2 ;
     n1=round(ln(n)/ln(2)) ;
     
     //System.out.println(" n="+n+" n1="+n1) ;
     
     l=0 ;
     for ( k=0 ; k<n ; k++){
       if ( k>l ) { 
         re=tor[l] ; 
         im=toi[l] ; 
         tor[l]=tor[k] ; 
         toi[l]=toi[k] ;
         tor[k]=re ; 
         toi[k]=im ;
         }
       j=m1 ;
       while( (j<=l) & (j>0) ){  l=l-j ; j=j / 2 ; }
       l=l+j ;
       }
     m1=1 ;
     for ( m=1 ; m<=n1 ; m++){
       a=Math.cos(pi/m1) ; 
       b=flag*Math.sin(pi/m1) ; 
       re=1 ; 
       im=0 ;
       for ( j=0 ; j<m1 ; j++){
       r=0 ;
        while ( r<=n-1 ){ 
        r1=r+j ; r2=r1+m1 ;
        ru=tor[r1] ; iu=toi[r1] ;
        rv=tor[r2]*re-toi[r2]*im ;
        iv=tor[r2]*im+toi[r2]*re ;
        tor[r1]=ru+rv ; toi[r1]=iu+iv ;
        tor[r2]=ru-rv ; toi[r2]=iu-iv ;
        r=r+2*m1 ;
        }
      rs=a*re-b*im ; 
      im=a*im+b*re ;
      re=rs ;
      }
    m1=2*m1 ;
    }
    for( k=0 ; k<n ; k++) {
      tor[k]=scale*tor[k] ; 
      toi[k]=scale*toi[k] ;
      //System.out.println(String.format(" re/im = %10.5f +im %10.5f",tor[k],toi[k])) ;
      }
    }
  }
}      
