//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "ActivePage.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
// BeginExample: ActivePage
// Property: ComCtrls.TPageControl.ActivePage
// Property: ComCtrls.TPageControl.PageCount
// Event: StdCtrls.TCustomCombo.OnChange
// Method: Classes.TStrings.AddObject

// BeginCode
/*
This example requires a TPageControl already on the form.
Also, you must add pages to the TPageControl by right
clicking and selecting New Page.
The example code will allow the user to select the
ActivePage property through selection of a ComboBox item.
During the form create, the Combo Box control is loaded with
the names of each of the tabs, as well as the instance
pointers to the corresponding tab.  When the user selects
the Combo Box item, the associated TTabSheet object
contained in the Combo Box Objects array is used to set the
ActivePage property.  Select the Lines property of the 
TRichEdit to enter a string.  Select the string before 
justifying.
*/
void __fastcall TForm1::ComboBox1Change(TObject *Sender)
{
  TComboBox *pCB = dynamic_cast<TComboBox *>(Sender);
  if (pCB)
	PageControl1->ActivePage = dynamic_cast<TTabSheet *>(pCB->Items->Objects[pCB->ItemIndex]);
}

void __fastcall TForm1::FormCreate(TObject *Sender)
{
  const TColor colorPalette[12] = {
	clRed, clGreen, clYellow, clBlue, clWhite, clFuchsia,
	clTeal, clNavy, clMaroon, clLime, clOlive, clPurple};
  for (int i = 0; i < PageControl1->PageCount; i++)
  {
	PageControl1->Pages[i]->Brush->Color = colorPalette[i];
	ComboBox1->Items->AddObject(PageControl1->Pages[i]->Name, PageControl1->Pages[i]);
  }
  ComboBox1->ItemIndex = 0;
  PageControl1->ActivePage = dynamic_cast<TTabSheet *>(ComboBox1->Items->Objects[ComboBox1->ItemIndex]);
}
// EndCode
// EndExample: ActivePage
//---------------------------------------------------------------------------

