//---------------------------------------------------------------------------
// Borland C++Builder
// Copyright (c) 2000-2002 Borland Corporation. All Rights Reserved.
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "main.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TAppEventForm *AppEventForm;
//---------------------------------------------------------------------------

// BeginExample: OnActionExecute
// Event: AppEvnts.TCustomApplicationEvents.OnActionExecute
// Event: Classes.TBasicAction.OnExecute

// BeginCode
/*
This example requires a TApplicationEvents, a TActionList
and a TListBox in the form.  Select the TApplicationEvents,
double click on the OnActionExecute event and add the
following code to the handler.  Create an TAction named
MyAction in a TActionList.  The TActionList must have no
OnExecute event handler, and the TAction has an OnExecute
event handler called MyActionExecute.  Then set an object's
(such as a button) Action to MyAction.  The Handled
parameter of the event handler returns false by default. If
the handler handles the event, it should change Handled to
true, thereby preventing further attempts to handle the
action.
*/
void __fastcall TAppEventForm::ApplicationEventsActionExecute(
      TBasicAction *Action, bool &Handled)
{
    lbOther->Items->Add("Event OnActionExecute");
}

void __fastcall TAppEventForm::ActionExecute(TObject *Sender)
{
	ShowMessage("Action executed");
}
// EndCode
// EndExample: OnActionExecute
//---------------------------------------------------------------------------

// BeginExample: OnActionUpdate
// Event: AppEvnts.TCustomApplicationEvents.OnActionUpdate

// BeginCode
/*
This example requires a TApplicationEvents and a TListBox
in the form.  Select the TApplicationEvents, double click
on the OnActionUpdate event and add the following code to
the handler.  Create other TApplicationEvents the same way.
When these events update this event is triggered.  The
Handled parameter of the event handler returns false by
default. If the handler handles the event, it should change
Handled to true, thereby preventing further attempts to
*/
void __fastcall TAppEventForm::ApplicationEventsActionUpdate(
      TBasicAction *Action, bool &Handled)
{
     lbActionUpdate->Items->Add("Event OnActionUpdate");
}
// EndCode
// EndExample: OnActionUpdate
//---------------------------------------------------------------------------

// BeginExample: OnActivate
// Event: AppEvnts.TCustomApplicationEvents.OnActivate
// Event: AppEvnts.TCustomApplicationEvents.OnDeactivate

// BeginCode
/*
This example requires a TApplicationEvents and a TListBox
in the form.  Select the TApplicationEvents, double click
on the OnActivate event and add the following code
to the handler.  These events occur when the form gains
or loses focus.
*/
void __fastcall TAppEventForm::ApplicationEventsActivate(TObject *Sender)
{
     lbOther->Items->Add("Event OnActivate");
}

void __fastcall TAppEventForm::ApplicationEventsDeactivate(TObject *Sender)
{
    lbOther->Items->Add("Event OnDeactivate");
}
// EndCode
// EndExample: OnActivate
//---------------------------------------------------------------------------

// BeginExample: OnException
// Event: AppEvnts.TCustomApplicationEvents.OnException

// BeginCode
/*
This example requires a TApplicationEvents and a TListBox
in the form.  Select the TApplicationEvents, double click
on the OnException event and add the following code
to the handler.  Trigger this event by calling the
Exception Create constructor.
*/
void __fastcall TAppEventForm::ApplicationEventsException(TObject *Sender,
      Exception *E)
{
    lbOther->Items->Add("Event OnException: " + E->Message);
}

void __fastcall TAppEventForm::MenuExceptionClick(TObject *Sender)
{
	char *sExceptionRaised = "This is an exception";
	throw Exception(sExceptionRaised);
}
// EndCode
// EndExample: OnException
//---------------------------------------------------------------------------

// BeginExample: OnHelp
// Event: AppEvnts.TCustomApplicationEvents.OnHelp

// BeginCode
/*
This example requires a TApplicationEvents and a TListBox
in the form.  Select the TApplicationEvents, double click
on the OnHelp event and add the following code to the
handler.  Trigger this event by pressing the F1 key or
call the HelpContext method.  Set CallHelp to true if the
application should still invoke the help system after the
event.
*/
bool __fastcall TAppEventForm::ApplicationEventsHelp(WORD Command, int Data,
      bool &CallHelp)
{
    lbOther->Items->Add("Event OnHelp");
    return false;
}
// EndCode
// EndExample: OnHelp
//---------------------------------------------------------------------------

// BeginExample: TAppEventsOnHint
// Event: AppEvnts.TCustomApplicationEvents.OnHint
// Event: AppEvnts.TCustomApplicationEvents.OnShowHint

// BeginCode
/*
This example requires a TApplicationEvents and a TListBox
in the form.  Select the TApplicationEvents, double click
on the OnHint event and the OnShowHint event and add the
following code to the handlers.  OnHint is triggered when
the mouse passes over the control. OnShowHint is triggered
when the mouse passes over the control and the application
is about to display the hint window for a Help Hint
*/
void __fastcall TAppEventForm::ApplicationEventsHint(TObject *Sender)
{
    lbOther->Items->Add("Event OnHint");
}

void __fastcall TAppEventForm::ApplicationEventsShowHint(AnsiString &HintStr,
	  bool &CanShow, Forms::THintInfo &HintInfo)
{
	lbOther->Items->Add("Event OnShowHint");
}
// EndCode
// EndExample: TAppEventsOnHint
//---------------------------------------------------------------------------

// BeginExample: TAppEventsOnIdle
// Event: AppEvnts.TCustomApplicationEvents.OnIdle

// BeginCode
/*
This example requires a TApplicationEvents and a TListBox
in the form.  Select the TApplicationEvents, double click
on the OnIdle event and add the following code to the
handler.  The OnIdle event handler is used to perform
special processing when an application is idle. An
application is idle when it is not processing code.
*/
void __fastcall TAppEventForm::ApplicationEventsIdle(TObject *Sender,
      bool &Done)
{
    lbIdle->Items->Add("Event OnIdle");
}
// EndCode
// EndExample: TAppEventsOnIdle
//---------------------------------------------------------------------------

// BeginExample: TAppEventsOnMessage
// Event: AppEvnts.TCustomApplicationEvents.OnMessage

// BeginCode
/*
This example requires a TApplicationEvents and a TListBox
in the form.  Select the TApplicationEvents, double click
on the OnMessage event and add the following code to the
handler.  OnMessage is triggered when the application
receives a Windows message.
*/
void __fastcall TAppEventForm::ApplicationEventsMessage(tagMSG &Msg,
      bool &Handled)
{
    lbOnMessage->Items->Add("X:=" + IntToStr(int(Msg.pt.x)) + "|Y:=" + IntToStr(int(Msg.pt.y)));
}
// EndCode
// EndExample: TAppEventsOnMessage
//---------------------------------------------------------------------------

// BeginExample: TAppEventsOnMinimize
// Event: AppEvnts.TCustomApplicationEvents.OnMinimize

// BeginCode
/*
This example requires a TApplicationEvents and a TListBox
in the form.  Select the TApplicationEvents, double click
on the OnMinimize event and add the following code to the
handler.  OnMinimize is triggered when the form is
minimized.
*/
void __fastcall TAppEventForm::ApplicationEventsMinimize(TObject *Sender)
{
  lbOther->Items->Add("Event OnMinimize");
}
// EndCode
// EndExample: TAppEventsOnMinimize
//---------------------------------------------------------------------------

// BeginExample: OnShortCut
// Event: AppEvnts.TCustomApplicationEvents.OnShortCut

// BeginCode
/*
This example requires a TApplicationEvents and a TListBox
in the form.  Select the TApplicationEvents, double click
on the OnShortCut event and add the following code to the
handler.  Trigger this event by pressing the CTRL key or
any function key.
*/
void __fastcall TAppEventForm::ApplicationEventsShortCut(TWMKey &Msg,
      bool &Handled)
{
  lbOther->Items->Add("Event OnShortCut");
}
// EndCode
// EndExample: OnShortCut
//---------------------------------------------------------------------------

// BeginExample: TAppEventsOnRestore
// Event: AppEvnts.TCustomApplicationEvents.OnRestore

// BeginCode
/*
This example requires a TApplicationEvents and a TListBox
in the form.  Select the TApplicationEvents, double click
on the OnRestore event and add the following code to the
handler.  OnRestore is triggered when a minimized
application is restored.
*/
void __fastcall TAppEventForm::ApplicationEventsRestore(TObject *Sender)
{

  lbOther->Items->Add("Event OnRestore");
}
// EndCode
// EndExample: TAppEventsOnRestore
//---------------------------------------------------------------------------
__fastcall TAppEventForm::TAppEventForm( TComponent *Owner) : TForm(Owner)
{

}


