/*
BeginUpdate, EndUpdate, Add, Count, Items example
The following example adds a panel to the status bar control when the user clicks the button and adds a caption to the panel. The code uses BeginUpdate and EndUpdate to prevent repaints until the operation is complete.  A try...finally block ensures EndUpdate is called even when an exception occurs.
*/ 
void __fastcall TForm1::Button1Click(TObject *Sender)
{
  int PanelIndex;

  StatusBar1->Panels->BeginUpdate();
  PanelIndex = StatusBar1->Panels->Count - 1;
  try
  {
    StatusBar1->Panels->Add();
    PanelIndex++;
    StatusBar1->Panels->Items[PanelIndex]->Text = "Panel" + IntToStr(PanelIndex);
  }
  __finally
  {
    StatusBar1->Panels->EndUpdate();
  }
} 
