//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "BrushCopy.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
// BeginExample: BrushCopy
// Method: Graphics.TCanvas.BrushCopy
// Method: Graphics.TCanvas.CopyRect

// BeginCode
/*
The following code illustrates the differences between
CopyRect and BrushCopy. The bitmap graphic FACTORY.BMP is
loaded into Bitmap and displayed on the Canvas of Form1. 
BrushCopy replaces the color black in the graphic with the 
brush of the canvas, while CopyRect leaves the colors intact.
*/

#include <memory>       //for STL auto_ptr class

void __fastcall TForm1::Button1Click(TObject *Sender)
{
  TRect MyRect = Rect(10,10,100,100);
  TRect MyOther = Rect(10,111,100, 201);
  std::auto_ptr<Graphics::TBitmap> Bitmap(new Graphics::TBitmap);
  Bitmap->LoadFromFile("c:/Program Files/Common Files/CodeGear Shared/Images/Splash/256color/factory.bmp");
  Form1->Canvas->BrushCopy(MyRect, Bitmap.get(), MyRect, clBlack);
  Form1->Canvas->CopyRect(MyOther, Bitmap->Canvas, MyRect);
}
// EndCode
// EndExample: BrushCopy
//---------------------------------------------------------------------------
