//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "ChDir.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TMyChDir *MyChDir;
//---------------------------------------------------------------------------
__fastcall TMyChDir::TMyChDir(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
// BeginExample: ChDir
// Routine: System.ChDir
// Routine: SysUtils.GetCurrentDir

// BeginCode
/*
This example shows how to change and display the current
directory through text.  This example requires that a drive
combo box, a file list box, and a directory list box are on
a form. Add this code as the OnChange event handler for the
drive combo box and the OnChange event handler for the
directory list box.  When the user changes the drive using
the combo box, the directory list box and file list box will
update to reflect the new drive and the current directory on
that drive.  When the user double clicks on a directory in
the file list box will update to reflect the new directory.
*/
void __fastcall TMyChDir::Button1Click(TObject *Sender)
{
  try
  {
	System::ChDir(Edit1->Text);
  }
  catch (...)
  {
	MessageDlg("Cannot find directory", mtWarning, TMsgDlgButtons() << mbOK, 0);
  }
  Edit2->Text = GetCurrentDir();
  FileListBox1->Directory = GetCurrentDir();
  DirectoryListBox1->Directory = GetCurrentDir();
}

void __fastcall TMyChDir::DirectoryListBox1Change(TObject *Sender)
{
  FileListBox1->Directory = DirectoryListBox1->Directory;
  Edit2->Text = GetCurrentDir();
}

void __fastcall TMyChDir::DriveComboBox1Change(TObject *Sender)
{
  DirectoryListBox1->Drive = DriveComboBox1->Drive;
  FileListBox1->Drive = DriveComboBox1->Drive;
  FileListBox1->Directory = DirectoryListBox1->Directory;
  Edit2->Text = GetCurrentDir();
}
// EndCode
// EndExample: ChDir
//---------------------------------------------------------------------------

