//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "ClassParent.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
// BeginExample: ClassParent
// Method: System.TObject.ClassParent
// Method: System.TObject.ClassType
// Method: System.TObject.ClassName

// BeginCode
/*
This example shows how to obtain the ancestry of a component
using the ClassType and ClassParent properties. It uses a
button and a list box on a form. When the user clicks the
button, the name of the buttons class and the names of its
parent classes are added to the list box.
*/
void __fastcall TForm1::Button1Click(TObject *Sender)
{
  TClass ClassRef;
  ListBox1->Clear();
  ClassRef = Sender->ClassType();
  while (ClassRef != NULL)
  {
	ListBox1->Items->Add(ClassRef->ClassName());
	ClassRef = ClassRef->ClassParent();
  };
}
/*
The list box contains the following strings after the user clicks the button:
	TButton
	TButtonControl
	TWinControl or TWinControl
	TControl
	TComponent
	TPersistent
	TObject 
*/
// EndCode
// EndExample: ClassParent
//---------------------------------------------------------------------------
