//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "ClassesGetClass.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------

// BeginExample: ClassesGetClass
// Method: Classes.TClassFinder.GetClass
// Routine: Classes.GetClass
// Routine: Graphics.GraphicExtension
// Routine: Classes.RegisterClasses
// Type: Graphics.TGraphicClass
// Class: System.TMetaClass

// BeginCode
/*
The following example allows users to type the name of a
graphics class into an edit control and when a button is
pressed, the name of the default extension for that class is
displayed in another edit control.  In the forms OnCreate
event handler (or a similar place) you must register the
graphics classes so that GetClass can find them.
*/
#include <memory>       //for STL auto_ptr class

TMetaClass *MetaClass;

void __fastcall TForm1::Button1Click(TObject *Sender)
{
  std::auto_ptr<TClassFinder> myClassFinder(new TClassFinder(MetaClass, False));
  TGraphicClass mygraphclass = (TGraphicClass) (myClassFinder->GetClass(Edit2->Text));
//  TGraphicClass mygraphclass = (TGraphicClass) GetClass(Edit2->Text);
  Edit1->Text = GraphicExtension(mygraphclass);
}

void __fastcall TForm1::FormCreate(TObject *Sender)
{
  MetaClass = __classid(TIcon); // ico
  RegisterClasses(&MetaClass, 0);
  MetaClass = __classid(Graphics::TBitmap); // bmp
  RegisterClasses(&MetaClass, 0);
  MetaClass = __classid(TMetafile); // emf
  RegisterClasses(&MetaClass, 0);
  MetaClass = __classid(TShape);  // nographic extension
  RegisterClasses(&MetaClass, 0);
  MetaClass = __classid(TImage); // nographic extension
  RegisterClasses(&MetaClass, 0);
}
// EndCode
// EndExample: ClassesGetClass
//---------------------------------------------------------------------------
